<?php 
extract($data); 
$settings_matched = true;
?>
<div class="container">
  <header>
    <div class="row">
      <div class="col-sm-6">
        <h1 class="pull-left">4<small>/5</small></h1>
        <h3><?php echo $heading_step_4; ?><br><small><?php echo $heading_step_4_small; ?></small></h3>
      </div>
      <div class="col-sm-6">
        <div id="logo" class="pull-right hidden-xs">
          <div id="logo" class="pull-right hidden-xs"> <img src="<?=CONF_WEBROOT_URL?>public/install/images/logo.png" width="200px" alt="Yokart" title="Yokart" /> </div>
        </div>
      </div>
    </div>
  </header>
  <?php if ($error_warning) { ?>
  <div class="alert alert-danger"><i class="fa fa-exclamation-circle"></i> <?php echo $error_warning; ?>
    <button type="button" class="close" data-dismiss="alert">&times;</button>
  </div>
  <?php } ?>
  <div class="row">
    <div class="col-sm-9">
       <form method="post" action="" name="frmSettings" id="frmSettings" class="form-horizontal" >	
			<p><?php echo $text_install_mysqli; ?></p>
			<fieldset>
			  <table class="table">
				<thead>
				  <tr>
					<td width="35%"><b><?php echo $text_setting; ?></b></td>
					<td width="25%"><b><?php echo $text_current; ?></b></td>
					<td width="25%"><b><?php echo $text_required; ?></b></td>
					<td width="15%" class="text-center"><b><?php echo $text_status; ?></b></td>
				  </tr>
				</thead>
				<tbody>	
				  <tr>
					<td><?php echo $text_mysqli_version; ?></td>
					<td><?php echo $mysqli_version; ?></td>
					<td>5.1+</td>
					<td class="text-center"><?php if ((float)$mysqli_version >= (float)'5.1') { ?>
					  <span class="text-success"><i class="fa fa-check-circle"></i></span>
					  <?php } else { $settings_matched = false; ?>
					  <span class="text-danger"><i class="fa fa-minus-circle"></i></span>
					  <?php } ?>
					</td>
				  </tr>
				  <tr>
					<td><?php echo $text_sql_mode; ?></td>
					<td><?php echo $sql_mode; ?></td>
					<td>NO_ENGINE_SUBSTITUTION</td>
					<td class="text-center"><?php if( strpos( $sql_mode, 'NO_ENGINE_SUBSTITUTION' ) !== false ){ ?>
					  <span class="text-success"><i class="fa fa-check-circle"></i></span>
					  <?php } else { $settings_matched = false; ?>
					  <span class="text-danger"><i class="fa fa-minus-circle"></i></span>
					  <?php } ?>
					</td>
				  </tr>
				</tbody>
			  </table>
			</fieldset>				  
	   
        <p><?php echo $text_db_administration; ?></p>
        <fieldset>
          <div class="form-group required">
              <label class="col-sm-2 control-label" for="input-name"><?php echo $entry_name; ?></label>
              <div class="col-sm-10"><input name="admin_name" id="admin_name" value="" class="form-control" title="Admin Name" type="text"></div>
          </div>
          <div class="form-group required">
            <label class="col-sm-2 control-label" for="input-username"><?php echo $entry_username; ?></label>
            <div class="col-sm-10"><input name="username" id="username" value="" class="form-control" title="Username" type="text"></div>
          </div>
          <div class="form-group required">
            <label class="col-sm-2 control-label" for="input-password"><?php echo $entry_password; ?></label>
            <div class="col-sm-10"><input name="password" id="password" value="" class="form-control" title="Password" type="password"></div>
          </div>
          <div class="form-group required">
            <label class="col-sm-2 control-label" for="input-email"><?php echo $entry_email; ?></label>
            <div class="col-sm-10"><input name="email" id="email" value="" class="form-control" title="Email" type="text"></div>
          </div>
        </fieldset>
        <p><?php echo $text_store_info; ?></p>
        <fieldset>
          <div class="form-group required">
            <label class="col-sm-2 control-label" for="input-store-name"><?php echo $entry_store_name; ?></label>
            <div class="col-sm-10"><input name="store_name" id="store_name" value="" class="form-control" title="Store Name" type="text"></div>
          </div>
          <div class="form-group required">
            <label class="col-sm-2 control-label" for="input-store-email"><?php echo $entry_store_email; ?></label>
            <div class="col-sm-10"><input name="store_email" id="store_email" value="" class="form-control" title="Store Email" type="text"></div>
          </div>
        </fieldset>
		<?php if ( !$settings_matched ) {	?>
			<div class="alert alert-danger"><i class="fa fa-exclamation-circle"></i> <?php echo $text_installation_warning; ?>
				<button type="button" class="close" data-dismiss="alert">&times;</button>
			</div>			
		<?php }	?>		
        <div class="buttons">
          <div class="pull-left"><a href="<?php echo $back; ?>" class="btn btn-default"><?php echo $button_back; ?></a></div>
          <div class="pull-right">
			<a href="<?php echo $refresh_action; ?>" class="btn btn-default" ><?php echo $button_refresh; ?></a>

			
	        <input name="btn_submit" id="btn_submit" class="btn btn-primary" title="" value="Continue" type="submit">
          </div>
        </div>
         <script type="text/javascript">//&lt;![CDATA[
			frmSettings_validator_requirements={"admin_name":{"required":true},"username":{"required":true},"password":{"required":true},"email":{"required":true,"email":true},"store_name":{"required":true},"store_email":{"required":true,"email":true},"btn_submit":{"required":false}};frmSettings_validator_formatting={"errordisplay":"afterfield","summaryElementId":""};frmSettings_validator=$("#frmSettings").validation(frmSettings_validator_requirements,frmSettings_validator_formatting);
			
			function show_loader(){
				$('.container').append('<div class="loader-layer"><div class="layercontent"><h2><?php echo $loader_content; ?></h2><div class="circularLoader"><svg class="circular" height="30" width="30"><circle class="path" cx="25" cy="25.2" r="19.9" fill="none" stroke-width="6" stroke-miterlimit="10"/></svg></div></div></div>');			
			}			
			
			$('#frmSettings').on('submit', function(){
				frmSettings_validator.validate();
				if (!frmSettings_validator.isValid()){
					return false;
				}
			<?php if ( !$settings_matched ) {	?>
				var r = confirm("<?php echo $text_continue_installation; ?>");
				if (r == true) {
					show_loader();				
					return true;
				} else {
					return false;
				}
			<?php }else{	?>	
					show_loader();
					return true;
			<?php }	?>
			});
			//]]&gt;</script>
      </form>
    </div>
    <div class="col-sm-3">
      <ul class="list-group">
        <li class="list-group-item">Guidelines</li>
        <li class="list-group-item">Pre-Installation</li>		
        <li class="list-group-item">Configuration</li>		
		<li class="list-group-item"><b>Create Admin Account</b></li>		
        <li class="list-group-item">Finished</li>
      </ul>
    </div>
  </div>
</div>