<?php
/**
 * PaymentsApi
 * PHP version 5
 *
 * @category Class
 * @package  Khipu
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */
/**
 *  Copyright 2015 SmartBear Software
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program. 
 * https://github.com/swagger-api/swagger-codegen 
 * Do not edit the class manually.
 */

// namespace Khipu\Client;

// use \Khipu\Configuration;
// use \Khipu\ApiClient;
// use \Khipu\ApiException;
// use \Khipu\ObjectSerializer;

/**
 * PaymentsApi Class Doc Comment
 *
 * @category Class
 * @package  Khipu
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class PaymentsApi
{

    /**
     * API Client
     * @var \Khipu\ApiClient instance of the ApiClient
     */
    protected $apiClient;
  
    /**
     * Constructor
     * @param \Khipu\ApiClient|null $apiClient The api client to use
     */
    function __construct($apiClient = null)
    {
        if ($apiClient == null) {
            $apiClient = new ApiClient();
            $apiClient->getConfig()->setHost('https://khipu.com/api/2.0');
        }
  
        $this->apiClient = $apiClient;
    }
  
    /**
     * Get API client
     * @return \Khipu\ApiClient get the API client
     */
    public function getApiClient()
    {
        return $this->apiClient;
    }
  
    /**
     * Set the API client
     * @param \Khipu\ApiClient $apiClient set the API client
     * @return PaymentsApi
     */
    public function setApiClient(ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }
  
    
    /**
     * paymentsGet
     *
     * Obtener información de un pago
     *
     * @param string $notification_token Token de notifiación recibido usando la API de notificaiones 1.3 o superior. (required)
     * @return \Khipu\Model\PaymentsResponse
     * @throws \Khipu\ApiException on non-2xx response
     */
    public function paymentsGet($notification_token)
    {
        
        // verify the required parameter 'notification_token' is set
        if ($notification_token === null) {
            throw new \InvalidArgumentException('Missing the required parameter $notification_token when calling paymentsGet');
        }
  
        // parse inputs
        $resourcePath = "/payments";
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        $method = "GET";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/x-www-form-urlencoded'));
  
        // query params
        if ($notification_token !== null) {
            $queryParams['notification_token'] = $this->apiClient->getSerializer()->toQueryValue($notification_token);
        }
        
        
        
        
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } else if (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        
        
        
        $encoded = array();

        foreach ($formParams as $key => $value) {
          $encoded[rawurlencode($key)] = rawurlencode($formParams[$key]);
        }
        foreach ($queryParams as $key => $value) {
          $encoded[rawurlencode($key)] = rawurlencode($queryParams[$key]);
        }

        $keys = array_keys($encoded);
        sort($keys);

        $url = $this->apiClient->getConfig()->getHost() . $resourcePath;

        $toSign = "$method&" . rawurlencode($url);
        foreach ($keys as $key) {
          $toSign .= "&$key=" . $encoded[$key];
        }

        $hash = hash_hmac('sha256', $toSign , $this->apiClient->getConfig()->getSecret()); //sha1($concatenated . "&secret=" . $secret) . "\n";

        $headerParams['Authorization'] = $this->apiClient->getConfig()->getReceiverId() . ":" . $hash;

        
        
        // make the API Call
        try
        {
            list($response, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, $method,
                $queryParams, $httpBody,
                $headerParams, '\Khipu\Model\PaymentsResponse'
            );
            
            if (!$response) {
                return null;
            }

            return $this->apiClient->getSerializer()->deserialize($response, '\Khipu\Model\PaymentsResponse', $httpHeader);
            
        } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Khipu\Model\PaymentsResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 400:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Khipu\Model\ValidationError', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 403:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Khipu\Model\AuthorizationError', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 503:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Khipu\Model\ServiceError', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
        
        return null;
        
    }
    
    /**
     * paymentsPost
     *
     * Crear un pago
     *
     * @param string $subject Motivo (required)
     * @param string $currency El código de moneda en formato ISO-4217 (required)
     * @param double $amount El monto del cobro. Sin separador de miles y usando &#39;.&#39; como separador de decimales. Hasta 4 lugares decimales, dependiendo de la moneda (required)
     * @param string $transaction_id Identificador propio de la  transacción. Ej: número de factura u orden de compra (optional)
     * @param string $custom Parámetro para enviar información personalizada de la transacción. Ej: documento XML con el detalle del carro de compra (optional)
     * @param string $body Descripción del cobro (optional)
     * @param string $bank_id Identificador del banco para usar en el pago (optional)
     * @param string $return_url La dirección URL a donde enviar al cliente mientras el pago está siendo verificado (optional)
     * @param string $cancel_url La dirección URL a donde enviar al cliente si decide no hacer hacer la transacción (optional)
     * @param string $picture_url Una dirección URL de una foto de tu producto o servicio (optional)
     * @param string $notify_url La dirección del web-service que utilizará khipu para notificar cuando el pago esté conciliado (optional)
     * @param string $notify_api_version Versión de la API de notifiaciones para recibir avisos por web-service (optional)
     * @param \DateTime $expires_date Fecha de expiración del cobro. Pasada esta fecha el cobro es inválido. Formato ISO-8601. Ej: 2017-03-01T13:00:00Z (optional)
     * @param bool $send_email Si es &#39;true&#39;, se enviará una solicitud de cobro al correo especificado en &#39;payer_email&#39; (optional)
     * @param string $payer_name Nombre del pagador. Es obligatorio cuando send_email es &#39;true&#39; (optional)
     * @param string $payer_email Correo del pagador. Es obligatorio cuando send_email es &#39;true&#39; (optional)
     * @param bool $send_reminders Si es &#39;true&#39;, se enviarán recordatorios de cobro. (optional)
     * @param string $responsible_user_email Correo electrónico del responsable de este cobro, debe corresponder a un usuario khipu con permisos para cobrar usando esta cuenta de cobro (optional)
     * @param string $fixed_payer_personal_identifier Identificador personal. Si se especifica, solo podrá ser pagado usando ese identificador (optional)
     * @param double $integrator_fee Comisión para el integrador. Sólo es válido si la cuenta de cobro tiene una cuenta de integrador asociada (optional)
     * @return \Khipu\Model\PaymentsCreateResponse
     * @throws \Khipu\ApiException on non-2xx response
     */
    public function paymentsPost($subject, $currency, $amount, $transaction_id=null, $custom=null, $body=null, $bank_id=null, $return_url=null, $cancel_url=null, $picture_url=null, $notify_url=null, $notify_api_version=null, $expires_date=null, $send_email=null, $payer_name=null, $payer_email=null, $send_reminders=null, $responsible_user_email=null, $fixed_payer_personal_identifier=null, $integrator_fee=null)
    {
        
        // verify the required parameter 'subject' is set
        if ($subject === null) {
            throw new \InvalidArgumentException('Missing the required parameter $subject when calling paymentsPost');
        }
        // verify the required parameter 'currency' is set
        if ($currency === null) {
            throw new \InvalidArgumentException('Missing the required parameter $currency when calling paymentsPost');
        }
        // verify the required parameter 'amount' is set
        if ($amount === null) {
            throw new \InvalidArgumentException('Missing the required parameter $amount when calling paymentsPost');
        }
  
        // parse inputs
        $resourcePath = "/payments";
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        $method = "POST";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/x-www-form-urlencoded'));
  
        
        
        
        // form params
        if ($subject !== null) {
            $formParams['subject'] = $this->apiClient->getSerializer()->toFormValue($subject);
        }// form params
        if ($currency !== null) {
            $formParams['currency'] = $this->apiClient->getSerializer()->toFormValue($currency);
        }// form params
        if ($amount !== null) {
            $formParams['amount'] = $this->apiClient->getSerializer()->toFormValue($amount);
        }// form params
        if ($transaction_id !== null) {
            $formParams['transaction_id'] = $this->apiClient->getSerializer()->toFormValue($transaction_id);
        }// form params
        if ($custom !== null) {
            $formParams['custom'] = $this->apiClient->getSerializer()->toFormValue($custom);
        }// form params
        if ($body !== null) {
            $formParams['body'] = $this->apiClient->getSerializer()->toFormValue($body);
        }// form params
        if ($bank_id !== null) {
            $formParams['bank_id'] = $this->apiClient->getSerializer()->toFormValue($bank_id);
        }// form params
        if ($return_url !== null) {
            $formParams['return_url'] = $this->apiClient->getSerializer()->toFormValue($return_url);
        }// form params
        if ($cancel_url !== null) {
            $formParams['cancel_url'] = $this->apiClient->getSerializer()->toFormValue($cancel_url);
        }// form params
        if ($picture_url !== null) {
            $formParams['picture_url'] = $this->apiClient->getSerializer()->toFormValue($picture_url);
        }// form params
        if ($notify_url !== null) {
            $formParams['notify_url'] = $this->apiClient->getSerializer()->toFormValue($notify_url);
        }// form params
        if ($notify_api_version !== null) {
            $formParams['notify_api_version'] = $this->apiClient->getSerializer()->toFormValue($notify_api_version);
        }// form params
        if ($expires_date !== null) {
            $formParams['expires_date'] = $this->apiClient->getSerializer()->toFormValue($expires_date);
        }// form params
        if ($send_email !== null) {
            $formParams['send_email'] = $this->apiClient->getSerializer()->toFormValue($send_email);
        }// form params
        if ($payer_name !== null) {
            $formParams['payer_name'] = $this->apiClient->getSerializer()->toFormValue($payer_name);
        }// form params
        if ($payer_email !== null) {
            $formParams['payer_email'] = $this->apiClient->getSerializer()->toFormValue($payer_email);
        }// form params
        if ($send_reminders !== null) {
            $formParams['send_reminders'] = $this->apiClient->getSerializer()->toFormValue($send_reminders);
        }// form params
        if ($responsible_user_email !== null) {
            $formParams['responsible_user_email'] = $this->apiClient->getSerializer()->toFormValue($responsible_user_email);
        }// form params
        if ($fixed_payer_personal_identifier !== null) {
            $formParams['fixed_payer_personal_identifier'] = $this->apiClient->getSerializer()->toFormValue($fixed_payer_personal_identifier);
        }// form params
        if ($integrator_fee !== null) {
            $formParams['integrator_fee'] = $this->apiClient->getSerializer()->toFormValue($integrator_fee);
        }
        
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } else if (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        
        
        
        $encoded = array();

        foreach ($formParams as $key => $value) {
          $encoded[rawurlencode($key)] = rawurlencode($formParams[$key]);
        }
        foreach ($queryParams as $key => $value) {
          $encoded[rawurlencode($key)] = rawurlencode($queryParams[$key]);
        }

        $keys = array_keys($encoded);
        sort($keys);

        $url = $this->apiClient->getConfig()->getHost() . $resourcePath;

        $toSign = "$method&" . rawurlencode($url);
        foreach ($keys as $key) {
          $toSign .= "&$key=" . $encoded[$key];
        }

        $hash = hash_hmac('sha256', $toSign , $this->apiClient->getConfig()->getSecret()); //sha1($concatenated . "&secret=" . $secret) . "\n";

        $headerParams['Authorization'] = $this->apiClient->getConfig()->getReceiverId() . ":" . $hash;

        
        
        // make the API Call
        try
        {
            list($response, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, $method,
                $queryParams, $httpBody,
                $headerParams, '\Khipu\Model\PaymentsCreateResponse'
            );
            
            if (!$response) {
                return null;
            }

            return $this->apiClient->getSerializer()->deserialize($response, '\Khipu\Model\PaymentsCreateResponse', $httpHeader);
            
        } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Khipu\Model\PaymentsCreateResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 400:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Khipu\Model\ValidationError', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 403:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Khipu\Model\AuthorizationError', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 503:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Khipu\Model\ServiceError', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
        
        return null;
        
    }
    
    /**
     * paymentsIdGet
     *
     * Obtener información de un pago
     *
     * @param string $id Identificador del pago (required)
     * @return \Khipu\Model\PaymentsResponse
     * @throws \Khipu\ApiException on non-2xx response
     */
    public function paymentsIdGet($id)
    {
        
        // verify the required parameter 'id' is set
        if ($id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id when calling paymentsIdGet');
        }
  
        // parse inputs
        $resourcePath = "/payments/{id}";
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        $method = "GET";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/x-www-form-urlencoded'));
  
        
        
        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                "{" . "id" . "}",
                $this->apiClient->getSerializer()->toPathValue($id),
                $resourcePath
            );
        }
        
        
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } else if (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        
        
        
        $encoded = array();

        foreach ($formParams as $key => $value) {
          $encoded[rawurlencode($key)] = rawurlencode($formParams[$key]);
        }
        foreach ($queryParams as $key => $value) {
          $encoded[rawurlencode($key)] = rawurlencode($queryParams[$key]);
        }

        $keys = array_keys($encoded);
        sort($keys);

        $url = $this->apiClient->getConfig()->getHost() . $resourcePath;

        $toSign = "$method&" . rawurlencode($url);
        foreach ($keys as $key) {
          $toSign .= "&$key=" . $encoded[$key];
        }

        $hash = hash_hmac('sha256', $toSign , $this->apiClient->getConfig()->getSecret()); //sha1($concatenated . "&secret=" . $secret) . "\n";

        $headerParams['Authorization'] = $this->apiClient->getConfig()->getReceiverId() . ":" . $hash;

        
        
        // make the API Call
        try
        {
            list($response, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, $method,
                $queryParams, $httpBody,
                $headerParams, '\Khipu\Model\PaymentsResponse'
            );
            
            if (!$response) {
                return null;
            }

            return $this->apiClient->getSerializer()->deserialize($response, '\Khipu\Model\PaymentsResponse', $httpHeader);
            
        } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Khipu\Model\PaymentsResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 400:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Khipu\Model\ValidationError', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 403:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Khipu\Model\AuthorizationError', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 503:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Khipu\Model\ServiceError', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
        
        return null;
        
    }
    
    /**
     * paymentsIdDelete
     *
     * Borrar un pago
     *
     * @param string $id Identificador del pago (required)
     * @return \Khipu\Model\SuccessResponse
     * @throws \Khipu\ApiException on non-2xx response
     */
    public function paymentsIdDelete($id)
    {
        
        // verify the required parameter 'id' is set
        if ($id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id when calling paymentsIdDelete');
        }
  
        // parse inputs
        $resourcePath = "/payments/{id}";
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        $method = "DELETE";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/x-www-form-urlencoded'));
  
        
        
        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                "{" . "id" . "}",
                $this->apiClient->getSerializer()->toPathValue($id),
                $resourcePath
            );
        }
        
        
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } else if (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        
        
        
        $encoded = array();

        foreach ($formParams as $key => $value) {
          $encoded[rawurlencode($key)] = rawurlencode($formParams[$key]);
        }
        foreach ($queryParams as $key => $value) {
          $encoded[rawurlencode($key)] = rawurlencode($queryParams[$key]);
        }

        $keys = array_keys($encoded);
        sort($keys);

        $url = $this->apiClient->getConfig()->getHost() . $resourcePath;

        $toSign = "$method&" . rawurlencode($url);
        foreach ($keys as $key) {
          $toSign .= "&$key=" . $encoded[$key];
        }

        $hash = hash_hmac('sha256', $toSign , $this->apiClient->getConfig()->getSecret()); //sha1($concatenated . "&secret=" . $secret) . "\n";

        $headerParams['Authorization'] = $this->apiClient->getConfig()->getReceiverId() . ":" . $hash;

        
        
        // make the API Call
        try
        {
            list($response, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, $method,
                $queryParams, $httpBody,
                $headerParams, '\Khipu\Model\SuccessResponse'
            );
            
            if (!$response) {
                return null;
            }

            return $this->apiClient->getSerializer()->deserialize($response, '\Khipu\Model\SuccessResponse', $httpHeader);
            
        } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Khipu\Model\SuccessResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 400:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Khipu\Model\ValidationError', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 403:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Khipu\Model\AuthorizationError', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 503:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Khipu\Model\ServiceError', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
        
        return null;
        
    }
    
    /**
     * paymentsIdRefundsPost
     *
     * Reembolsar total o parcialmente un pago
     *
     * @param string $id Identificador del pago (required)
     * @param double $amount El monto a devolver. Sin separador de miles y usando &#39;.&#39; como separador de decimales. Hasta 4 lugares decimales, dependiendo de la moneda. Si se omite el reembolso se hará por el total del monto del pago. (optional)
     * @return \Khipu\Model\SuccessResponse
     * @throws \Khipu\ApiException on non-2xx response
     */
    public function paymentsIdRefundsPost($id, $amount=null)
    {
        
        // verify the required parameter 'id' is set
        if ($id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id when calling paymentsIdRefundsPost');
        }
  
        // parse inputs
        $resourcePath = "/payments/{id}/refunds";
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        $method = "POST";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/x-www-form-urlencoded'));
  
        
        
        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                "{" . "id" . "}",
                $this->apiClient->getSerializer()->toPathValue($id),
                $resourcePath
            );
        }
        // form params
        if ($amount !== null) {
            $formParams['amount'] = $this->apiClient->getSerializer()->toFormValue($amount);
        }
        
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } else if (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        
        
        
        $encoded = array();

        foreach ($formParams as $key => $value) {
          $encoded[rawurlencode($key)] = rawurlencode($formParams[$key]);
        }
        foreach ($queryParams as $key => $value) {
          $encoded[rawurlencode($key)] = rawurlencode($queryParams[$key]);
        }

        $keys = array_keys($encoded);
        sort($keys);

        $url = $this->apiClient->getConfig()->getHost() . $resourcePath;

        $toSign = "$method&" . rawurlencode($url);
        foreach ($keys as $key) {
          $toSign .= "&$key=" . $encoded[$key];
        }

        $hash = hash_hmac('sha256', $toSign , $this->apiClient->getConfig()->getSecret()); //sha1($concatenated . "&secret=" . $secret) . "\n";

        $headerParams['Authorization'] = $this->apiClient->getConfig()->getReceiverId() . ":" . $hash;

        
        
        // make the API Call
        try
        {
            list($response, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, $method,
                $queryParams, $httpBody,
                $headerParams, '\Khipu\Model\SuccessResponse'
            );
            
            if (!$response) {
                return null;
            }

            return $this->apiClient->getSerializer()->deserialize($response, '\Khipu\Model\SuccessResponse', $httpHeader);
            
        } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Khipu\Model\SuccessResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 400:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Khipu\Model\ValidationError', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 403:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Khipu\Model\AuthorizationError', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            case 503:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Khipu\Model\ServiceError', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
        
        return null;
        
    }
    
}
