<?php
class CustomRouter
{
    public static function setRoute(&$controller, &$action, &$queryString)
    {
        define('LANG_CODES_ARR', Language::getAllCodesAssoc());
        if (defined('SYSTEM_FRONT') && SYSTEM_FRONT === true && in_array($controller, [API_STRING])) {
            $viewDirectory = 'views/';
            if (API_STRING == $controller) {
                define('API_CALL', true);
                $viewDirectory = API_STRING . 'views/';
            }
            define('SYSTEM_LANG_ID', CommonHelper::getLangId());
            define('API_VERSION', $action);
            define('CONF_THEME_PATH', CONF_APPLICATION_PATH . $viewDirectory . API_VERSION . '/');
            if (!file_exists(CONF_THEME_PATH)) {
                $response['msg'] = Labels::getLabel('APIMSG_Invalid_API_Version_call', 1);
                CommonHelper::dieWithJsonData(AppConstants::FAIL, $response);
                }
            if (empty($queryString)) {
                $queryString = array('home');
            }
            $controller = $queryString[0];
                array_shift($queryString);
            if (empty($queryString)) {
                $queryString = array('index');
            }
            $action = $queryString[0];
            array_shift($queryString);
            return;
        } else {

            /* [ Handled lang code in url */
            if (FatApp::getConfig('CONF_LANG_SPECIFIC_URL', FatUtility::VAR_INT, 0) && in_array(strtoupper($controller), LANG_CODES_ARR)) {
                $langId = FatApp::getConfig('CONF_DEFAULT_SITE_LANG', FatUtility::VAR_INT, 1);
                $langCodes = array_flip(LANG_CODES_ARR);
                if (in_array(strtoupper($controller), LANG_CODES_ARR)) {
                    $langId = $langCodes[strtoupper($controller)];
                }
                $langId = ($langId > 0) ? $langId : CommonHelper::getLangId();
                define('SYSTEM_LANG_ID', $langId);
                setcookie('defaultSiteLang', SYSTEM_LANG_ID, time() + 3600 * 24 * 10, CONF_WEBROOT_URL);

                $controller = ($action == 'index') ? 'Home' : $action;
                if (!array_key_exists(0, $queryString)) {
                    $action = 'index';
                } else {
                    $action = $queryString[0];
                    array_shift($queryString);
                }
            } else {
                define('SYSTEM_LANG_ID', CommonHelper::getLangId());
            }
            /* ] */

        define('API_CALL', false);
        }
        if (!defined('CONF_THEME_PATH')) {
            define('CONF_THEME_PATH', CONF_APPLICATION_PATH . 'views/');
        }
        if (defined('SYSTEM_FRONT') && SYSTEM_FRONT === true/*  && !FatUtility::isAjaxCall() */) {  
            $url = urldecode($_SERVER['REQUEST_URI']);
            
            if (strpos($url, "index.php?url=") !== false || UrlRewrite::staticContentProvider($controller, $action) == true) {
                return ;
            }

            if (strpos($url, "?") !== false && strpos($url, "/?") === false) {
                $url = str_replace('?', '/?', $url);
            }

            $customUrl = substr($url, strlen(CONF_WEBROOT_URL));
            $customUrl = rtrim($customUrl, '/');
            $customUrl = explode('/?', $customUrl);

            /* [ Handled lang code in url */
            if (FatApp::getConfig('CONF_LANG_SPECIFIC_URL', FatUtility::VAR_INT, 0)) {
                $langCustomUrl = explode('/', $customUrl[0]);
                if (isset($langCustomUrl[0]) && $langCustomUrl[0] != '') {
                    if (in_array(strtoupper($langCustomUrl[0]), LANG_CODES_ARR)) {
                        $customUrl[0] = substr($customUrl[0], 3);
                        $customUrl[0] = ltrim($customUrl[0], '/');
                    }
                }
            }
            /* ] */

            /* [ Check url rewritten by the system or system url with query parameter*/
            $row = false;
            if (!empty($customUrl[0])) {
                $srch = UrlRewrite::getSearchObject();
                $srch->doNotCalculateRecords();
                $srch->addMultipleFields(array('urlrewrite_custom','urlrewrite_original'));
                $srch->setPageSize(1);
                $srch->addCondition(UrlRewrite::DB_TBL_PREFIX . 'custom', '=', $customUrl[0]); 
                $rs = $srch->getResultSet();
                $row = FatApp::getDb()->fetch($rs);
            }
            if (!$row && (!isset($customUrl[1]) || (isset($customUrl[1]) && strpos($customUrl[1], 'pagesize') === false))) {
                return;
            }
            /*]*/

            $url = isset($row['urlrewrite_original']) ? $row['urlrewrite_original'] : '';
            if (!$row && isset($customUrl[1])) {
                $url = $customUrl[0];
            }
           
            $arr = explode('/', $url);

            $controller = (isset($arr[0]))?$arr[0]:'';
            array_shift($arr);

            $action = (isset($arr[0]))?$arr[0]:'';
            array_shift($arr);

            $queryString = $arr;
            /* [ used in case of filters when passed through url*/
            //array_shift($customUrl);
            if (isset($customUrl[1]) && !empty($customUrl[1])) {
                $customUrl = explode('&', $customUrl[1]);
                $queryString = array_merge($queryString, $customUrl);
            }
            
            /* ]*/

            if ($controller != '' && $action == '') {
                $action = 'index';
            }

            if ($controller == '') {
                $controller = 'Content';
            }
            
            if ($action == '') {
                $action = 'error404';
            }
        }
    }
}
