<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<?php $this->includeTemplate('_partial/seller/sellerDashboardNavigation.php'); ?>
<main id="main-area" class="main" role="main">
    <div class="content-wrapper content-space">
        <div class="content-header row">
            <div class="col">
                <?php $this->includeTemplate('_partial/dashboardTop.php'); ?>
                <h2 class="content-header-title"><?php echo Labels::getLabel('LBL_Tags', $siteLangId); ?></h2>
            </div>
            <div class="col-auto">
                <div class="btn-group">
                    <a class="btn btn-outline-primary btn--sm" title="<?php echo Labels::getLabel('LBL_Add_New_Tag', $siteLangId); ?>"  href="<?php echo CommonHelper::generateUrl('Tags', 'form'); ?>"><?php echo Labels::getLabel('LBL_Add_New_Tag', $siteLangId); ?></a>
                </div>
            </div>
        </div>
        <div class="content-body">
            <div class="row mb-4">
                <div class="col-lg-12">
                    <div class="cards">
                        <div class="cards-content">
                            <div class="replaced">
                                <?php
                                $searchForm->setFormTagAttribute('id', 'frmSearchTag');
                                $searchForm->setFormTagAttribute('class', 'form');
                                $searchForm->setFormTagAttribute('onsubmit', 'searchTags(this); return(false);');
                                $searchForm->getField('keyword')->addFieldTagAttribute('placeholder', Labels::getLabel('LBL_Search_by_', $siteLangId));
                                $searchForm->developerTags['colClassPrefix'] = 'col-md-';
                                $searchForm->developerTags['fld_default_col'] = 12;

                                $keywordFld = $searchForm->getField('keyword');
                                $keywordFld->setWrapperAttribute('class', 'col-lg-6');
                                $keywordFld->developerTags['col'] = 6;


                                $typeFld = $searchForm->getField('tag_type');
                                $typeFld->setWrapperAttribute('class', 'col-lg-2');
                                $typeFld->developerTags['col'] = 2;

                                $submitFld = $searchForm->getField('btn_submit');
                                $submitFld->setFieldTagAttribute('class', 'btn--block btn btn--primary');
                                $submitFld->setWrapperAttribute('class', 'col-lg-2');
                                $submitFld->developerTags['col'] = 2;

                                $fldClear = $searchForm->getField('btn_clear');
                                $fldClear->setFieldTagAttribute('onclick', 'clearSearch()');
                                $fldClear->setFieldTagAttribute('class', 'btn--block btn btn-outline-primary');
                                $fldClear->setWrapperAttribute('class', 'col-lg-2');
                                $fldClear->developerTags['col'] = 2;

                                echo $searchForm->getFormHtml();
                                ?>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="cards">
                        <div class="cards-content">
                            <div id="tags-listing-js"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>