<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
$form->setFormTagAttribute('onsubmit', 'setupTag(this); return(false);');

$form->setFormTagAttribute('class', 'form');
$form->developerTags['colClassPrefix'] = 'col-md-';
$form->developerTags['fld_default_col'] = 6;

$autoUpdateFld = $form->getField('auto_update_other_langs_data');
$autoUpdateFld->developerTags['cbLabelAttributes'] = array('class' => 'checkbox');
$autoUpdateFld->developerTags['cbHtmlAfterCheckbox'] = '<i class="input-helper"></i>';


$this->includeTemplate('_partial/seller/sellerDashboardNavigation.php');
?>
<main id="main-area" class="main" role="main">
    <div class="content-wrapper content-space">
        <div class="content-header row">
            <div class="col">
                <?php $this->includeTemplate('_partial/dashboardTop.php'); ?>
                <h2 class="content-header-title"><?php echo Labels::getLabel('LBL_Tag_Setup', $siteLangId); ?></h2>
            </div>
            <div class="col-auto">
                <div class="btn-group">
                    <a class="btn btn-outline-primary btn--sm" title="<?php echo Labels::getLabel('LBL_Back_to_Tags', $siteLangId); ?>" href="<?php echo CommonHelper::generateUrl('Tags'); ?>"><?php echo Labels::getLabel('LBL_Back_to_Tags', $siteLangId); ?></a>
                </div>
            </div>
        </div>
        <div class="content-body">
              
            <div class="cards">
                <div class="cards-content">
					<div class="row justify-content-center">
						<div class="col-md-12">
							<?php echo $form->getFormTag(); ?>

							<?php $divLayout = Language::getLayoutDirection($siteDefaultLangId); ?>
							<div class="" dir="<?php echo $divLayout; ?>">
								<div class="row">
									<div class="col-md-6">
										<div class="field-set">
											<div class="caption-wraper">
												<label class="field_label">
													<?php
													$fld = $form->getField('tag_name[' . $siteDefaultLangId . ']');
													echo $fld->getCaption();
													?>
												</label>
												<span class="spn_must_field">*</span>
											</div>
											<div class="field-wraper">
												<div class="field_cover">
													<?php echo $form->getFieldHtml('tag_name[' . $siteDefaultLangId . ']'); ?>
												</div>
											</div>
										</div>
									</div>
								</div>
								
								<div class="row">	
									<div class="col-md-6">
										<div class="field-set">
											<div class="caption-wraper">
												<label class="field_label">
													<?php
													$fld = $form->getField('tag_type');
													echo $fld->getCaption();
													?>
												</label>
												<span class="spn_must_field">*</span>
											</div>
											<div class="field-wraper">
												<div class="field_cover">
													<?php echo $form->getFieldHtml('tag_type'); ?>
												</div>
											</div>
										</div>
									</div>
								</div>
									
								<?php
								$translatorSubscriptionKey = FatApp::getConfig('CONF_TRANSLATOR_SUBSCRIPTION_KEY', FatUtility::VAR_STRING, '');
								if (!empty($translatorSubscriptionKey) && count($otherLanguages) > 0) {
									?>
									<div class="row">
										<div class="col-md-12">
											<div class="field-set mb-0">
												<div class="caption-wraper"></div>
												<div class="field-wraper">
													<div class="field_cover">
														<?php echo $form->getFieldHtml('auto_update_other_langs_data'); ?>
													</div>
												</div>
											</div>
										</div>
									</div>
								<?php } ?>
							</div>            

							<?php
							if (!empty($otherLanguages)) {
								foreach ($otherLanguages as $langId => $data) {
									$layout = Language::getLayoutDirection($langId);
									?>
									<div class="accordion my-4 col-md-6 mb-4" id="specification-accordion-<?php echo $langId; ?>">
										<h6 class="dropdown-toggle" data-toggle="collapse" data-target="#collapse-<?php echo $langId; ?>" aria-expanded="true" aria-controls="collapse-<?php echo $langId; ?>"><span>
												<?php echo $data . " " . Labels::getLabel('LBL_Language_Data', $siteLangId); ?>
											</span>
										</h6>
										<div id="collapse-<?php echo $langId; ?>" class="collapse collapse-js-<?php echo $langId; ?>" aria-labelledby="headingOne" data-parent="#specification-accordion-<?php echo $langId; ?>">
											<div class="p-4 mb-4 bg-gray rounded" dir="<?php echo $layout; ?>">
												<div class="row">
													<div class="col-md-12">
														<div class="field-set">
															<div class="caption-wraper">
																<label class="field_label">
																	<?php
																	$fld = $form->getField('tag_name[' . $langId . ']');
																	echo $fld->getCaption();
																	?>
																</label>
															</div>
															<div class="field-wraper">
																<div class="field_cover">
																	<?php echo $form->getFieldHtml('tag_name[' . $langId . ']'); ?>
																</div>
															</div>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
									<?php
								}
							}
							?>

							<div class="row">
								<div class="col-6">
									<div class="field-set">
										<!--<div class="caption-wraper"><label class="field_label"></label></div>-->
										<div class="field-wraper">
											<div class="field_cover">
												<?php
												echo $form->getFieldHtml('tag_id');
												echo $form->getFieldHtml('btn_submit');
												?>
											</div>
										</div>
									</div>
								</div>
							</div>
							</form>
							<?php echo $form->getExternalJS(); ?>
						</div>
					</div>
				</div>
            </div>
        </div>
    </div>
</main>

<style>
    table{width : 100%;}
    .hide-tab--js{
        display: none !important;
    }
</style>