<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<?php
$faqSearchFrm->setFormTagAttribute('id', 'frmSearchFaqs');
$faqSearchFrm->setFormTagAttribute('onSubmit', 'searchFaqs(this);return false;');
$faqSearchFrm->getField('question')->setFieldTagAttribute('placeholder', Labels::getLabel('Lbl_Search', $siteLangId));
$faqSearchFrm->getField('question')->setFieldTagAttribute('class', "faq-input no-focus");
?>
<div class="after-header"></div>
<div id="body" class="body page-become-seller">
    <?php $haveBgImage = AttachedFile::getAttachment(AttachedFile::FILETYPE_SELLER_PAGE_SLOGAN_BG_IMAGE, $slogan['epage_id'], 0, $siteLangId);
    $bgImageUrl = ($haveBgImage) ? CommonHelper::generateFileUrl('Image', 'cblockBackgroundImage', array($slogan['epage_id'], $siteLangId, 'LARGE', AttachedFile::FILETYPE_SELLER_PAGE_SLOGAN_BG_IMAGE)) :  CONF_WEBROOT_URL . "images/seller-bg.jpg"; ?>
    
	
<section class="section section-seller">

            <div class="seller-banner">
                <img src="<?php echo $bgImageUrl; ?>" alt="">
            </div>

            <div class="container">
				<div class="float-box">
                    <div class="float-box__container">
                        <div class="float-box__head">
                            <?php echo FatUtility::decodeHtmlEntities($slogan['epage_content']); ?>
                        </div>
                        <div class="float-box__body">
							<?php $sellerFrm->developerTags['colClassPrefix'] = 'col-lg-12 col-md-12 col-sm-';
							$sellerFrm->developerTags['fld_default_col'] = 12;
							echo $sellerFrm->getFormHtml(); ?>							
							<p class="text-center help-text"><?php echo FatUtility::decodeHtmlEntities($formText['epage_content']); ?></p>

                        </div>

                    </div>
                </div>


            </div>
        </section>	
	
	
	<?php if (!empty($block1)) { ?>
		<section class="section section-gray">
            <div class="container container--narrow">

                <div class="section-title text-center">
                    <h2><?php echo Labels::getLabel('LBL_Become_a_Seller_on_Yokart-B2B_in_3_easy_steps', $siteLangId) ?></h2>
                </div>
                <div class="section-body">
					<?php echo FatUtility::decodeHtmlEntities($block1['epage_content']); ?>
				</div>
            </div>
        </section>	
	<?php } ?>
	
	<?php if (!empty($block2)) { ?>
		<section class="section">
            <div class="container container--narrow">
				<?php echo FatUtility::decodeHtmlEntities($block2['epage_content']); ?>
			</div>
        </section>	
	<?php } ?>

	<?php if (!empty($testimonial) && is_array($testimonial)) { ?>
	
        <section class="section section-gray">
            <div class="container container--narrow">

                <div class="row flex-sm-row-reverse justify-content-between">


                    <div class="col-lg-6">

                        <div class="quote-outer">

                            <div class="quote-slider">

                                <div class="quote-slideshow-js">

                                    <?php foreach($testimonial as $term){ ?>
									<div>
                                        <div class="quote-slider__item">
                                            <div class="quote-slider__content">
												<?php echo $term['testimonial_text']; ?>
											</div>
                                            <div class="quote-slider__author">
                                                <div class="quote-slider__author-media">
                                                    <span class="avtar avtar--curve"><img src="<?php echo CommonHelper::generateFileUrl('Image', 'testimonial', array($term['testimonial_id'], $siteLangId, "THUMB"), CONF_WEBROOT_URL); ?>" alt=""></span>
                                                </div>
                                                <div class="quote-slider__author-content">
                                                    <h5><?php echo $term['testimonial_user_name']; ?></h5>
                                                    <!--p><?php //echo $term['testimonial_user_name']; ?></p-->
                                                </div>

                                            </div>
                                        </div>
                                    </div>
									<?php } ?>
                                   
                                </div>


                                <span class="quote-slider__icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="100" height="85.714" viewBox="0 0 100 85.714">
                                        <g transform="translate(0 -29.235)">
                                          <path d="M233.882,29.235V72.092h28.571a28.6,28.6,0,0,1-28.571,28.571v14.286a42.9,42.9,0,0,0,42.857-42.857V29.235Z" transform="translate(-176.739)" fill="#333"/>
                                          <path d="M0,72.092H28.571A28.6,28.6,0,0,1,0,100.664v14.286A42.9,42.9,0,0,0,42.857,72.092V29.235H0Z" transform="translate(0 0)" fill="#333"/>
                                        </g>
                                    </svg>                                              
                                </span>



                            </div>

                        </div>

                    </div>

                    <div class="col-lg-5 pt-5">
                        <h2><?php echo Labels::getLabel('LBL_We_have_helped_over', $siteLangId); ?></h2>
                        <p class="p-large mb-5"><?php echo Labels::getLabel('LBL_We_think_Yo-kart_is_pretty_great', $siteLangId); ?></p>
                        <a href="<?php echo CommonHelper::generateUrl('testimonials'); ?>" class="btn btn--bordered-brand btn--lg btn--wide btn--block-sm"><?php echo Labels::getLabel('LBL_More_Stories', $siteLangId); ?></a>
                    </div>


                </div>

            </div>
        </section>	
	
	<?php } ?>	
	
	<?php if (!empty($block3)) { ?>
		<section class="section">
            <div class="container container--small">
				 <?php echo FatUtility::decodeHtmlEntities($block3['epage_content']); ?>
            </div>
        </section>	
	<?php } ?>
	
	<?php if (!empty($block4)) { ?>
		<section class="section p-0">
            <div class="container container--narrow">
				<?php echo FatUtility::decodeHtmlEntities($block4['epage_content']); ?>
            </div>
        </section>	
	<?php } ?>
	
	<?php if(!empty($blogs) && is_array($blogs)) { ?>
		<section class="section">
            <div class="container container--narrow">

                <div class="section-title text-center">
                    <h2><?php echo Labels::getLabel('LBL_Check_out_the_latest_articles_from_our_blog', $siteLangId) ?></h2>
                </div>
                <div class="section-body">

                    <div class="row row-tab-scroll">

					<?php foreach($blogs as $blogPost) { ?>
                        <div class="col-sm-4">
							<div class="blog-tile">
                                <div class="blog-tile__head">
                                    <div class="blog-tile__media ratio ratio--4by3">
                                        <a href="<?php echo CommonHelper::generateUrl('Blog', 'postDetail', array($blogPost['post_id'])); ?>"><img src="<?php echo CommonHelper::generateFileUrl('Image', 'blogPostFront', array($blogPost['post_id'], $siteLangId, "LAYOUT3"), CONF_WEBROOT_URL); ?>" alt="<?php echo $blogPost['post_title'] ?>"></a>
                                    </div>
                                </div>
                                <div class="blog-tile__body">
                                    <div class="blog-tile__meta">
                                        
										<?php $categoryIds = !empty($blogPost['categoryIds']) ? explode(',', $blogPost['categoryIds']) : array();
										$categoryNames = !empty($blogPost['categoryNames']) ? explode('~', $blogPost['categoryNames']) : array();
										$categories = array_combine($categoryIds, $categoryNames);
										foreach ($categories as $id => $name) { ?>
										 <span class="blog-tile__cate"><?php echo $name; ?></span>
										<?php } ?>										
										
                                        <span class="blog-tile__date"><?php echo FatDate::format($blogPost['post_added_on']); ?></span>
                                    </div>
                                    <h5 class="blog-tile__title"><a alt="<?php echo $blogPost['post_title'] ?>" href="<?php echo CommonHelper::generateUrl('Blog', 'postDetail', array($blogPost['post_id'])); ?>"><?php echo $blogPost['post_title'] ?></a></h5>
                                </div>
                            </div>

                        </div>
					<?php } ?>
                      


                    </div>

                    <div class="cta-inline text-center pt-5">
                        <p><?php echo Labels::getLabel('LBL_Get_the_latest_insights_to_power_up_your_business_with_Yokart', $siteLangId) ?> <a href="<?php echo CommonHelper::generateUrl('Blog'); ?>" class="underline color-braand"><?php echo Labels::getLabel('LBL_View_all_blogs', $siteLangId) ?></a></p>
                    </div>

                </div>

            </div>
        </section>	
	<?php } ?>
	
	<?php 
    if ($faqCount > 0) { ?>
		<section class="section section-gray">
            <div class="container container--narrow">

                <div class="section-title text-center">
                    <h2><?php echo Labels::getLabel('LBL_Here_are_some_common_questions_about_selling_on_Yo-Kart', $siteLangId) ?></h2>
                </div>
                <div class="section-body">

                    <div class="row justify-content-center">
                        <div class="col-lg-9">
                            <div class="accordians-group">
								<?php $first=1; foreach($faqListing as $faqlist) { ?>
									
									<div class="accordians accordian-js <?php if($first==1) { echo "is-active"; } ?>">
										<div class="accordians__title accordian__title-js"><?php echo $faqlist['faq_title']; ?></div>
										<div class="accordians__body accordian__body-js" style="">
											<p><?php echo $faqlist['faq_content']; ?></p>
										</div>
									</div>
	
								<?php $first++; } ?>
                            </div>

                            <div class="accordians-cta">
                                <div class="row justify-content-between">
                                    <div class="col-sm-7">
                                        <h5><?php echo Labels::getLabel("LBL_Can't_find_an_answer?", $siteLangId) ?> </h5>
                                        <p><?php echo Labels::getLabel("LBL_Call_us_at", $siteLangId) ?><?php echo FatApp::getConfig('CONF_SITE_PHONE'); ?> <?php echo Labels::getLabel("LBL_or_email", $siteLangId) ?> <?php echo FatApp::getConfig("CONF_SITE_OWNER_EMAIL"); ?></p>
                                    </div>
                                    <div class="col-sm-auto">
                                        <a href="<?php echo CommonHelper::generateUrl('custom', 'contact-us'); ?>" class="btn btn--brand btn--wide btn--block-sm"><?php echo Labels::getLabel('LBL_Contact_Us', $siteLangId) ?> </a>
                                    </div>
                                </div>
                            </div>


                        </div>
                    </div>

                </div>

            </div>
        </section>	
	
	<?php } ?>

  
</div>
<!-- End Document
================================================== -->