<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');



$sellerType = ShopProfile::getSellerTypeArr($siteLangId);
if (!empty($allShops)) {
    $i = 0;
    foreach ($allShops as $shop) {

        $reviews = isset($shop['reviews']) ? $shop['reviews'] : [];
        $totReviews = isset($reviews['totReviews']) ? FatUtility::int($reviews['totReviews']) : 0;
        $avgRating = isset($reviews['avg_seller_rating']) ? FatUtility::convertToType($reviews['avg_seller_rating'], FatUtility::VAR_FLOAT) : 0;
        $rated_1 = isset($reviews['rated_1']) ? FatUtility::int($reviews['rated_1']) : '';
        $rated_2 = isset($reviews['rated_2']) ? FatUtility::int($reviews['rated_2']) : '';
        $rated_3 = isset($reviews['rated_3']) ? FatUtility::int($reviews['rated_3']) : '';
        $rated_4 = isset($reviews['rated_4']) ? FatUtility::int($reviews['rated_4']) : '';
        $rated_5 = isset($reviews['rated_5']) ? FatUtility::int($reviews['rated_5']) : '';

        $pixelToFillRight = $avgRating / 5 * 160;
        $pixelToFillRight = FatUtility::convertToType($pixelToFillRight, FatUtility::VAR_FLOAT);

        $rate_5_width = $rate_4_width = $rate_3_width = $rate_2_width = $rate_1_width = 0;

        if ($totReviews) {
            $rate_5_width = round(FatUtility::convertToType($rated_5 / $totReviews * 100, FatUtility::VAR_FLOAT), 2);
            $rate_4_width = round(FatUtility::convertToType($rated_4 / $totReviews * 100, FatUtility::VAR_FLOAT), 2);
            $rate_3_width = round(FatUtility::convertToType($rated_3 / $totReviews * 100, FatUtility::VAR_FLOAT), 2);
            $rate_2_width = round(FatUtility::convertToType($rated_2 / $totReviews * 100, FatUtility::VAR_FLOAT), 2);
            $rate_1_width = round(FatUtility::convertToType($rated_1 / $totReviews * 100, FatUtility::VAR_FLOAT), 2);
        }

        //echo '<pre>';print_r($shop); 

?>


        <!-- [ ITEM-1 -->
        <div class="seller-result__item">

            <div class="seller-card">

                <div class="seller-card__head">

                    <div class="seller-view">
                        <div class="seller-view__small">
                            <?php
                            $fileData = AttachedFile::getAttachment(AttachedFile::FILETYPE_SHOP_LOGO, $shop['shop_id'], 0, 0, false);
                            $aspectRatioArr = AttachedFile::getRatioTypeArray($siteLangId);
                            ?>
                            <div class="seller-view__logo"><img <?php if (isset($fileData['afile_aspect_ratio']) && $fileData['afile_aspect_ratio'] > 0) { ?> data-ratio="<?php echo $aspectRatioArr[$fileData['afile_aspect_ratio']]; ?>" <?php } ?> src="<?php echo FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'shopLogo', array($shop['shop_id'], $siteLangId, "THUMB", 0, false), CONF_WEBROOT_URL), CONF_IMG_CACHE_TIME, '.jpg'); ?>" alt="<?php echo $shop['shop_name']; ?>"></div>
                        </div>
                        <div class="seller-view__large">

                            <div class="seller-view__meta">

                                <div class="seller-view__meta-l">


                                    <h5 class="mb-0 seller-view__title"><a href="<?php echo CommonHelper::generateUrl('shops', 'view', array($shop['shop_id'])); ?>"><?php echo $shop['shop_name']; ?></a> </h5>

                                    <!-- [ PANEL ACTIONS =========== -->
                                    <div class="panel-list">

                                        <div class="panel-list__item"><?php echo $shop['state_name']; ?>, <?php echo $shop['country_name']; ?></div>

                                        <?php if (!empty($reviews['totReviews']) ||  !empty($reviews['avg_seller_rating'])) { ?>
                                            <div class="panel-list__item">

                                                <div class="ratings ratings--hovered">
                                                    <a href="#ratings" class="ratings__trigger scrolls">
                                                        <span class="ratings__star site-icon site-icon--xsmall">
                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16">
                                                                <path d="M12.943,27.378,8,24.659,3.057,27.378,4,21.618,0,17.539l5.527-.84L8,11.378,10.473,16.7l5.527.84-4,4.079Z" transform="translate(0 -11.378)" fill="#f5961d"></path>
                                                            </svg>

                                                        </span>
                                                        <span class="ratings__value"><?php echo round($reviews['avg_seller_rating'], 1); ?></span>
                                                        <?php if ($reviews['totReviews']) { ?>
                                                            <span class="ratings__count">| <?php echo $reviews['totReviews'] . ' ', Labels::getLabel('Lbl_Reviews', $siteLangId); ?></span>
                                                        <?php } ?>
                                                    </a>


                                                    <div class="ratings__target">
                                                        <div class="ratings-progress p-4">

                                                            <div class="ratings">
                                                                <span class="ratings__value m-0"><?php echo round($reviews['avg_seller_rating'], 1), ' ', Labels::getLabel('Lbl_Out_of', $siteLangId), ' ', '5'; ?></span>
                                                                <?php if ($reviews['totReviews']) { ?>
                                                                    <span class="ratings__count">| <?php echo $reviews['totReviews'] . ' ', Labels::getLabel('Lbl_Reviews_&_Ratings', $siteLangId); ?></span>
                                                                <?php } ?>
                                                            </div>

                                                            <?php if ($reviews['totReviews']) { ?>
                                                                <div class="progress-list">
                                                                    <ul>
                                                                        <li>
                                                                            <span class="progress-list__count">5 <?php echo Labels::getLabel('Lbl_Star', $siteLangId); ?></span>
                                                                            <div class="progress-list__bar">
                                                                                <div title="<?php echo $rate_5_width, '% ', Labels::getLabel('LBL_Number_of_reviews_have_5_stars', $siteLangId); ?>" style="width: <?php echo $rate_5_width; ?>%; clip: rect(0px, 0px, 160px, 0px);" role="progressbar" class="progress-list__bar-fill"></div>
                                                                            </div>
                                                                        </li>
                                                                        <li>
                                                                            <span class="progress-list__count">4 <?php echo Labels::getLabel('Lbl_Star', $siteLangId); ?></span>
                                                                            <div class="progress-list__bar">
                                                                                <div title="<?php echo $rate_4_width, '% ', Labels::getLabel('LBL_Number_of_reviews_have_5_stars', $siteLangId); ?>" style="width: <?php echo $rate_4_width; ?>%; clip: rect(0px, 0px, 160px, 0px);" role="progressbar" class="progress-list__bar-fill"></div>
                                                                            </div>
                                                                        </li>
                                                                        <li>
                                                                            <span class="progress-list__count">3 <?php echo Labels::getLabel('Lbl_Star', $siteLangId); ?></span>
                                                                            <div class="progress-list__bar">
                                                                                <div title="<?php echo $rate_3_width, '% ', Labels::getLabel('LBL_Number_of_reviews_have_5_stars', $siteLangId); ?>" style="width: <?php echo $rate_3_width; ?>%; clip: rect(0px, 0px, 160px, 0px);" role="progressbar" class="progress-list__bar-fill"></div>
                                                                            </div>
                                                                        </li>
                                                                        <li>
                                                                            <span class="progress-list__count">2 <?php echo Labels::getLabel('Lbl_Star', $siteLangId); ?></span>
                                                                            <div class="progress-list__bar">
                                                                                <div title="<?php echo $rate_2_width, '% ', Labels::getLabel('LBL_Number_of_reviews_have_5_stars', $siteLangId); ?>" style="width: <?php echo $rate_2_width; ?>%; clip: rect(0px, 0px, 160px, 0px);" role="progressbar" class="progress-list__bar-fill"></div>
                                                                            </div>
                                                                        </li>
                                                                        <li>
                                                                            <span class="progress-list__count">1 <?php echo Labels::getLabel('Lbl_Star', $siteLangId); ?></span>
                                                                            <div class="progress-list__bar">
                                                                                <div title="<?php echo $rate_1_width, '% ', Labels::getLabel('LBL_Number_of_reviews_have_5_stars', $siteLangId); ?>" style="width: <?php echo $rate_1_width; ?>%; clip: rect(0px, 0px, 160px, 0px);" role="progressbar" class="progress-list__bar-fill"></div>
                                                                            </div>
                                                                        </li>
                                                                    </ul>
                                                                </div>

                                                                <hr>
                                                                <a href="<?php echo CommonHelper::generateUrl('Reviews', 'shop', array($shop['shop_id'])); ?>" class="link scrolls1"><?php echo Labels::getLabel('LBL_See_all_customer_reviews', $siteLangId) ?></a>
                                                            <?php } ?>
                                                        </div>
                                                    </div>

                                                </div>

                                            </div>
                                        <?php } ?>

                                        <?php $showAddToFavorite = true;
                                        if (UserAuthentication::isUserLogged() && (!User::isBuyer())) $showAddToFavorite = false; ?>
                                        <?php if ($showAddToFavorite) { ?>
                                            <div class="panel-list__item">
                                                <!-- <a href="#" class="btn btn--icon btn--fav is-active"> -->
                                                <a href="javascript:void(0)" onclick="toggleShopFavorite(<?php echo $shop['shop_id']; ?>);" id="shop_<?php echo $shop['shop_id']; ?>" class="btn btn--icon btn--fav <?php echo ($shop['is_favorite']) ? 'is-active' : ''; ?>">
                                                    <span class="site-icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 14.8">
                                                            <path d="M13.6,3A4.521,4.521,0,0,1,18,7.8c0,5.6-6,8.8-8,10-2-1.2-8-4.4-8-10A4.54,4.54,0,0,1,6.4,3,5.293,5.293,0,0,1,10,4.6,5.293,5.293,0,0,1,13.6,3Z" transform="translate(-2 -3)"></path>
                                                        </svg>
                                                    </span><?php echo Labels::getLabel('LBL_Favorite', $siteLangId); ?></a>
                                            </div>
                                        <?php }  ?>


                                    </div>
                                    <!-- ] -->

                                    <div class="seller-badges seller-badges--inline">

                                        <?php if ((isset($shop['subscription_package_id']) && ($shop['subscription_package_id'] == SellerPackages::GOLD_PACKAGE)) && $shop['seller_verified'] == AppConstants::YES) { ?>
                                            <div class="seller-badges__grid">
                                                <div class="badge-item">
                                                    <span class="badge-item__media"><img alt="<?php echo Labels::getLabel("LBL_TrustSEAL_Verified", $siteLangId); ?>" src="<?php echo CONF_WEBROOT_URL; ?>images/green-tick.svg"></span>
                                                    <span class="badge-item__label"><?php echo Labels::getLabel("LBL_TrustSEAL_Verified", $siteLangId); ?></span>
                                                </div>
                                            </div>
                                        <?php } ?>

                                        <?php if (isset($shop['sprofile_seller_type']) && !empty($shop['sprofile_seller_type'])) { ?>
                                            <div class="seller-badges__grid">
                                                <div class="badge-item">
                                                    <span class="badge-item__media"><img src="<?php echo CONF_WEBROOT_URL; ?>images/manufacturer.svg" alt="<?php echo isset($sellerType[$shop['sprofile_seller_type']]) ? $sellerType[$shop['sprofile_seller_type']]  : ''; ?>"></span>
                                                    <span class="badge-item__label"><?php echo isset($sellerType[$shop['sprofile_seller_type']]) ? $sellerType[$shop['sprofile_seller_type']]  : ''; ?></span>
                                                </div>
                                            </div>
                                        <?php } ?>

                                        <?php
                                        if(FatApp::getConfig('CONF_ENABLE_SELLER_SUBSCRIPTION_MODULE', FatUtility::VAR_INT, 0)){
                                        if (isset($shop['subscription_package_id']) && ($shop['subscription_package_id'] > 0)) { ?>
                                            <div class="seller-badges__grid">

                                                <?php if ($shop['subscription_package_id'] == SellerPackages::SILVER_PACKAGE) { ?>
                                                    <div class="badge-item">
                                                        <span class="badge-item__media"><img src="<?php echo CONF_WEBROOT_URL; ?>images/dollar.png" class="gray-scale" alt="<?php echo Labels::getLabel('LBL_Silver_Member', $siteLangId); ?>"></span>
                                                        <span class="badge-item__label"><?php echo Labels::getLabel('LBL_Silver_Member', $siteLangId); ?></span>
                                                    </div>
                                                <?php } elseif ($shop['subscription_package_id'] == SellerPackages::GOLD_PACKAGE) { ?>
                                                    <div class="badge-item">
                                                        <span class="badge-item__media"><img src="<?php echo CONF_WEBROOT_URL; ?>images/dollar.png" alt="<?php echo Labels::getLabel('LBL_Gold_Member', $siteLangId); ?>"></span>
                                                        <span class="badge-item__label"><?php echo Labels::getLabel('LBL_Gold_Member', $siteLangId); ?></span>
                                                    </div>
                                                <?php } ?>

                                            </div>
                                        <?php } } ?>

                                        <?php if ($shop['is_founding_member']) { ?>
                                            <div class="seller-badges__grid">
                                                <div class="badge-item">
                                                    <span class="badge-item__media"> <img alt="<?php echo Labels::getLabel('LBL_Founding_Memeber', $siteLangId); ?>" src="<?php echo CONF_WEBROOT_URL; ?>images/crown.png"></span>
                                                    <span class="badge-item__label"><?php echo Labels::getLabel('LBL_Founding_Memeber', $siteLangId); ?></span>
                                                </div>
                                            </div>
                                        <?php } ?>


                                    </div>

                                </div>

                                <div class="seller-view__meta-r">
                                    <a onclick="contactWithSeller('<?php echo $shop['shop_id']; ?>');" title="<?php echo Labels::getLabel('Lbl_Send_Message', $siteLangId); ?>" href="javascript:void(0)" class="btn btn--bordered-brand d-flex align-items-center justify-content-center">
                                        <span class="site-icon site-icon--small mr-2">
                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 14.4">
                                                <path d="M2.8,3H17.2a.8.8,0,0,1,.8.8V16.6a.8.8,0,0,1-.8.8H2.8a.8.8,0,0,1-.8-.8V3.8A.8.8,0,0,1,2.8,3Zm7.248,6.946L4.918,5.59,3.882,6.81l6.176,5.244,6.065-5.248L15.077,5.6,10.049,9.946Z" transform="translate(-2 -3)"></path>
                                            </svg>
                                        </span>
                                        <span> <?php echo Labels::getLabel('LBL_Contact_Seller', $siteLangId); ?></span>
                                    </a>
                                </div>

                            </div>

                        </div>
                    </div>

                </div>

                <div class="seller-card__body">

                    <div class="row">

                        <div class="col-sm-7">

                            <table class="specs-table">
                                <tbody>
                                    <?php if (!empty($shop['founded_year'])) { ?>
                                        <tr>
                                            <th width="40%"><?php echo Labels::getLabel("LBL_Year_Established", $siteLangId); ?></th>
                                            <td><?php echo $shop['founded_year']; ?></td>
                                        </tr>
                                    <?php } ?>
                                    <!-- <tr>
                                            <th>Annual Revenue</th>
                                            <td>US$1 Million - US$2.5 Million</td>
                                        </tr> -->
                                    <?php if (!empty($shop['totalSales']) && isset($shop['totalSales']['totalSoldSales'])) { ?>
                                        <tr>
                                            <th><?php echo Labels::getLabel('LBL_Total_Sales', $siteLangId); ?></th>
                                            <td><?php echo CommonHelper::displayMoneyFormat($shop['totalSales']['totalSoldSales']); ?> </td>
                                        </tr>
                                    <?php  } ?>

                                    <!-- <tr>
                                            <th>Response Time</th>
                                            <td>&gt;5hrs</td>
                                        </tr> -->
                                    <!-- <tr>
                                            <th>On-time delivery rate</th>
                                            <td>95%</td>
                                        </tr> -->
                                    <?php if (isset($shop['products']) && !empty($shop['products'])) { ?>
                                        <tr>
                                            <th><?php echo Labels::getLabel('LBL_Main_Products', $siteLangId); ?></th>
                                            <td>
                                                <?php
                                                $prodCount = count($shop['products']);

                                                $i = 0;
                                                foreach ($shop['products'] as $prodData) {
                                                    echo $prodData['selprod_title'];
                                                    echo ($i < ($prodCount - 1)) ? ', ' : '';
                                                    $i++;
                                                } ?>
                                            </td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>

                        </div>
                        <?php

                        if (isset($shop['products']) && !empty($shop['products'])) {
                        ?>
                            <div class="col-sm-5">

                                <div class="products-container">
                                    <?php foreach ($shop['products'] as $prodData) {

                                    ?>
                                        <div class="products-container__item">

                                            <div class="product-card  ">
                                                <div class="product-card__head">
                                                    <div class="product-media ratio ratio--1by1">
                                                        <?php $uploadedTime = AttachedFile::setTimeParam($prodData['product_updated_on']); ?>
                                                        <a href="<?php echo UrlHelper::generateUrl('products', 'view', array($prodData['selprod_id'])); ?>"><img src="<?php echo UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('image', 'product', array($prodData['product_id'], "THUMB", $prodData['selprod_id'], 0, $siteLangId)) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg'); ?>"></a>

                                                    </div>
                                                </div>
                                                <div class="product-card__body">
                                                    <div class="product-detail">
                                                        <a href="<?php echo UrlHelper::generateUrl('products', 'view', array($prodData['selprod_id'])); ?>" class="product-title"><?php echo $prodData['selprod_title']; ?></a>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>

                                    <?php  } ?>


                                </div>

                            </div>
                        <?php } ?>
                    </div>

                </div>

            </div>

        </div>
        <!-- ] -->




<?php
        $i++;
    }
}

$searchFunction = 'goToShopListingSearchPage';
if (isset($pagingFunc)) {
    $searchFunction = $pagingFunc;
}

$postedData['page'] = (isset($page)) ? $page : 1;
$postedData['recordDisplayCount'] = isset($recordCount) ? $recordCount : 0;
echo FatUtility::createHiddenFormFromData($postedData, array('name' => 'frmShopSearchPaging', 'id' => 'frmShopSearchPaging'));
$pagingArr = array('pageCount' => isset($pageCount) ? $pageCount : 0, 'page' => $postedData['page'], 'recordCount' => isset($recordCount) ? $recordCount : 0, 'callBackJsFunc' => $searchFunction);
$this->includeTemplate('_partial/pagination.php', $pagingArr, false);

/* $postedData['page'] = $page;
echo FatUtility::createHiddenFormFromData($postedData, array('name' => 'frmSearchShopsPaging'));
$pagingArr = array('pageCount' => $pageCount, 'page' => $page, 'recordCount' => $recordCount);
$this->includeTemplate('_partial/pagination.php', $pagingArr, false);
 */
echo $this->includeTemplate('_partial/shareThisScript.php');

if (empty($allShops)) {
    $pSrchFrm = Common::getSiteSearchForm();
    $pSrchFrm->fill(array('btnSiteSrchSubmit' => Labels::getLabel('LBL_Submit', $siteLangId)));
    $pSrchFrm->setFormTagAttribute('onSubmit', 'submitSiteSearch(this); return(false);');
    $this->includeTemplate('_partial/no-record-found.php', array('siteLangId' => $siteLangId));
    return;
}