<?php defined('SYSTEM_INIT') or die('Invalid Usage'); ?>
<?php
	$frm->setFormTagAttribute('class','form form--horizontal');
	$frm->developerTags['colClassPrefix'] = 'col-lg-12 col-md-12 col-sm-';
	$frm->developerTags['fld_default_col'] = 12;
	$frm->setFormTagAttribute('onSubmit', 'setUpSendMessage(this); return false;');
	
	$fromFld = $frm->getField('send_message_from');
	$toFld = $frm->getField('send_message_to');

	$fromFldHtml = new HtmlElement( 'div', array( 'class'=>'field-set' ));
	$fromFldCaptionWrapper = $fromFldHtml->appendElement('div', array('class' => 'caption-wraper'));
	$fromFldCaptionWrapper->appendElement( 'label', array('class'=>'field_label'), Labels::getLabel('LBL_From', $siteLangId) );

	$fromFldFieldWrapper = $fromFldHtml->appendElement('div', array('class' => 'field-wraper'));
	$fromFldData = $loggedUserData['credential_username'].' (<em>'.$loggedUserData['user_name'].'</em>)';
	$fromFldData .= '<br/><span class="form-text text-muted">'.Labels::getLabel('LBL_Contact_info_not_shared', $siteLangId).'</span>';
	$fromFldFieldWrapper->appendElement( 'div', array('class' => 'field_cover'), $fromFldData, true );

	$fromFld->value = $fromFldHtml->getHtml();


	$toFldHtml = new HtmlElement( 'div', array( 'class'=>'field-set' ));
	$toFldCaptionWrapper = $toFldHtml->appendElement('div', array('class' => 'caption-wraper'));
	$toFldCaptionWrapper->appendElement( 'label', array('class'=>'field_label'), Labels::getLabel('LBL_To', $siteLangId) );

	$toFldFieldWrapper = $toFldHtml->appendElement('div', array('class' => 'field-wraper'));
	$toFldFieldWrapper->appendElement( 'div', array('class' => 'field_cover'), $shop['shop_owner_name'].' (<em>'.$shop['shop_name'].'</em>)', true );

	$toFld->value = $toFldHtml->getHtml();


if (isset($product) && !empty($product)) {
	
		$productFld = $frm->getField('about_product');
		$productFldHTML = new HtmlElement( 'div', array( 'class'=>'field-set' ));
		$productFldCaptionWrapper = $productFldHTML->appendElement('div', array('class' => 'caption-wraper'));
		$productFldCaptionWrapper->appendElement( 'label', array('class'=>'field_label'), Labels::getLabel('LBL_About_Product', $siteLangId) );

		$productFldFieldWrapper = $productFldHTML->appendElement('div', array('class' => 'field-wraper'));
		$productFldFieldWrapper->appendElement( 'div', array('class' => 'field_cover'), $product['selprod_title'] , true );

		$productFld->value = $productFldHTML->getHtml();
	}
	
	$fromFld = $frm->getField('btn_submit');
	$fromFld->setFieldTagAttribute('class', 'float-right');	

	$shop_city = $shop['shop_city'];
	$shop_state = ( strlen($shop['shop_city']) > 0 ) ? ', '. $shop['shop_state_name'] : $shop['shop_state_name'];
	$shop_country = ( strlen($shop_state) > 0 ) ? ', '.$shop['shop_country_name'] : $shop['shop_country_name'];
	$shopLocation = $shop_city . $shop_state. $shop_country;
?>

<div id="body" class="body">
 
   <section class="section section-shop shop-section-narrow">
		<div class="container">
			<div class="shop-panel">
					<?php
					$userParentId = (isset($userParentId)) ? $userParentId : 0;
					 $this->includeTemplate('shops/templates/top-header.php', ['shop'=>$shop,'collectionData'=>$collectionData,'action' => $action,'shopTotalReviews' => $shopTotalReviews,'template_id' => $template_id, 'siteLangId'=>$siteLangId, 'shopRating' => $shopRating, 'userParentId' => $userParentId,'reviews'=>$reviews], false);	?>
				
			</div>
		</div>		
   </section> 
  
	<section class="section section-gray shop-section-narrow pt-4">

			<div class="container">
				<!--[ CONTACT-->
				<div class="panel">
					<div class="panel-box p-5">
						<h4 class="mb-3"><?php echo Labels::getLabel('LBL_Send_Message_to_shop_owner', $siteLangId); ?></h4>
						<span class="gap"></span>
						<?php echo $frm->getFormHtml(); ?>
					</div>
				</div>
				<!--]-->

			</div>

	</section>
 
	
</div>
    <?php echo $this->includeTemplate('_partial/shareThisScript.php'); ?>