<?php
defined('SYSTEM_INIT') or die('Invalid Usage');

if (!$isProductDetail) {
    $searchFrm->setFormTagAttribute('onSubmit', 'searchProducts(this); return(false);');
    $keywordFld = $searchFrm->getField('keyword');
    $keywordFld->addFieldTagAttribute('placeholder', Labels::getLabel('LBL_Search', $siteLangId));
    $keywordFld->htmlAfterField = '<input value="" type="submit" class="input-submit">';
    $bgUrl = CommonHelper::generateFullFileUrl('image', 'shopBackgroundImage', array($shop['shop_id'], $siteLangId, 0, 0, $template_id));
    $haveBannerImage = AttachedFile::getMultipleAttachments(AttachedFile::FILETYPE_SHOP_BANNER, $shop['shop_id'], '', $siteLangId);
}

$imageType = array('png', 'jpeg', 'jpg', 'gif', 'bmp', 'ico', 'tiff', 'tif');
$tradeShowDocs = [];
$insReportDocs = [];
$qcCertificates = [];
if (!empty($shopDocuments)) {
    $tradeShowDocs = isset($shopDocuments[ShopDocument::SHOP_DOCUMENT_TYPE_TRADE_SHOW]) ? $shopDocuments[ShopDocument::SHOP_DOCUMENT_TYPE_TRADE_SHOW] : [];
    $insReportDocs = isset($shopDocuments[ShopDocument::SHOP_DOCUMENT_TYPE_INSPECTION_REPORT]) ? $shopDocuments[ShopDocument::SHOP_DOCUMENT_TYPE_INSPECTION_REPORT] : [];
    $qcCertificates = isset($shopDocuments[ShopDocument::SHOP_DOCUMENT_TYPE_QUALITY_CERTIFICATE]) ? $shopDocuments[ShopDocument::SHOP_DOCUMENT_TYPE_QUALITY_CERTIFICATE] : [];
}
$sellerData = [];
if (!empty($sellerProfileData)) {
    $sellerData['sprofile_production_process'] = $sellerProfileData['sprofile_production_process'];
    $sellerData['sprofile_advantages'] = $sellerProfileData['sprofile_advantages'];
    $sellerData['sprofile_production_capacity'] = $sellerProfileData['sprofile_production_capacity'];
    $sellerData['sprofile_shipping_package'] = $sellerProfileData['sprofile_shipping_package'];
    $sellerData['sprofile_quality_control'] = $sellerProfileData['sprofile_quality_control'];
    $sellerData['sprofile_rnd_capacity'] = $sellerProfileData['sprofile_rnd_capacity'];
    $sellerData['sprofile_trade_capacity'] = $sellerProfileData['sprofile_trade_capacity'];
}

$youtube_embed_code = '';
if (!empty($sellerProfileData) && isset($sellerProfileData['sprofile_company_video'])) {
    $youtube_embed_code = CommonHelper::parseYoutubeUrl($sellerProfileData['sprofile_company_video']);
}

?>
<?php if (!$isProductDetail) { ?>
    <div id="body" class="body template-<?php echo $template_id; ?>" role="main">
    <?php
    $variables = array('shop' => $shop, 'siteLangId' => $siteLangId, 'frmProductSearch' => $frmProductSearch, 'template_id' => $template_id, 'collectionData' => $collectionData, 'action' => $action, 'shopId' => $shopId, 'shopTotalReviews' => $shopTotalReviews, 'shopRating' => $shopRating, 'sellerProfilePage' => 1);
    ?>

   <section class="section section-shop shop-section-narrow">
		<div class="container">
			<div class="shop-panel">
					<?php
					$userParentId = (isset($userParentId)) ? $userParentId : 0;
					 $this->includeTemplate('shops/templates/top-header.php', ['shop'=>$shop,'collectionData'=>$collectionData,'action' => $action,'shopTotalReviews' => $shopTotalReviews,'template_id' => $template_id, 'siteLangId'=>$siteLangId, 'shopRating' => $shopRating, 'userParentId' => $userParentId,'reviews'=>$reviews], false);	?>
			</div>
		</div>		
   </section> 	
	
<?php }     ?>
    <!-- [ SELLER PROFILE START -->
	<?php if (!$isProductDetail) { ?>
    <section class="section section-gray shop-section-narrow pt-4">
        <div class="container">
            <div class="panel">
	<?php } ?>		
			
			  <div class="profile-panel">
                <div class="side-nav-seller1 profile-panel__small">
					<nav class="profile-controls vertical-jump-nav-js">  
						<ul>
							<li class="company-info-link"> <a class="is-active scrolls" href="#company-info" ><?php echo Labels::getLabel('LBL_Company_information', $siteLangId); ?></a></li>
							<?php if (!empty($tradeShowDocs)) { ?>
								<li class=""><a href="#trade-show" class="scrolls"><?php echo Labels::getLabel('LBL_Trade_Show', $siteLangId); ?></a></li>
							<?php } ?>
							<?php
							if (!empty($sellerData)) {
								foreach ($sellerData as $key => $val) {
									$key = str_replace('sprofile_', 'LBL_', $key);
									$id = str_replace('LBL_', '', $key);
									if(!empty($val)) { 
									?>
									<li><a href="#<?php echo $id; ?>" class="scrolls" ><?php echo Labels::getLabel($key, $siteLangId); ?></a></li>
								<?php
									} }
								?>

							<?php } ?>
							<?php if (!empty($insReportDocs)) { ?>
								<li><a href="#inspection-reports" class="scrolls" ><?php echo Labels::getLabel('LBL_Factory_inspection_report', $siteLangId); ?></a></li>
							<?php } ?>
							<?php if (!empty($qcCertificates)) { ?>
								<li><a href="#quality-certificates" class="scrolls"><?php echo Labels::getLabel('LBL_Quality_Certificated', $siteLangId); ?></a></li>
							<?php } ?>
							<?php if (!empty($youtube_embed_code)) { ?>
								<li><a href="#company-video" class="scrolls" ><?php echo Labels::getLabel('LBL_Company_Video', $siteLangId); ?></a></li>
							<?php } ?>
							<?php if (!empty($faqs)) { ?>
								<li><a href="#faqs" class="scrolls" ><?php echo Labels::getLabel('LBL_FAQs', $siteLangId); ?></a></li>
							<?php } ?>
						</ul>
					</nav>
                </div>
                <div class="seller-info-tab  profile-panel__large">
                    <div class="content-box" id="company-info">
                        <div class="content-box__head"><h6 class="mb-0"><?php echo Labels::getLabel('LBL_Company_Information', $siteLangId); ?></h6></div>
                        <div class="content-box__body">
                            <?php
                            $sellerType = (!empty($sellerProfileData) && isset($sellerTypeArr[$sellerProfileData['sprofile_seller_type']])) ? $sellerTypeArr[$sellerProfileData['sprofile_seller_type']] : Labels::getLabel('LBL_N/A', $siteLangId);
                            ?>
							<?php if($isProductDetail) { ?>
									<div class="contact-seller">
										<div class="contact-seller__left">
											<div class="shop-logo ratio ratio--1by1"><img src="<?php echo CommonHelper::generateFileUrl('Image', 'shopLogo', array($shop['shop_id'], $siteLangId, 'SMALL')); ?>" alt=""></div>
										</div>
										<div class="contact-seller__right">

											<div class="contact-seller__inner-l">

												<div class="shop-pro">
													<span class="shop-title d-block"><a href="<?php echo CommonHelper::generateUrl('shops', 'View', array($shop['shop_id'])); ?>"><?php echo $shop['shop_name']; ?></a></span>
													<div class="shop-details">
														<span class="shop-location"><?php if($shop['shop_state_name']) { echo $shop['shop_state_name'].', ';  } ?> <?php if($shop['shop_country_name']) { echo $shop['shop_country_name'].', ';  } ?></span>
													
														   <?php if (0 < FatApp::getConfig("CONF_ALLOW_REVIEWS", FatUtility::VAR_INT, 0)) { ?>
															<div class="shop-ratings">
																<div class="ratings">
																	<span class="ratings__star site-icon site-icon--small">
																			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 15.216">
																				<path d="M8.587,12.949,3.643,15.716l1.1-5.557L.587,6.312l5.627-.667L8.587.5,10.96,5.645l5.627.667-4.16,3.847,1.1,5.557Z" transform="translate(-0.587 -0.5)" fill="#f59f1f"></path>
																			</svg>
																		</span>
																	<span class="ratings__value"><?php echo round($shop_rating, 1); ?></span>
																</div>
															</div>
															<?php } ?>				
														
														
														
													</div>

												</div>

												<div class="seller-badges p-0 border-0 mt-3">

														<?php 
														if ($shop['subscription_package_id'] > 0) {  ?>

                                                        <?php if ((isset($shop['subscription_package_id']) && $shop['subscription_package_id'] == SellerPackages::GOLD_PACKAGE) && $shop['seller_verified'] == 1) { ?>
																<div class="seller-badges__grid">
																	<div class="badge-item">
																		<span class="badge-item__media"><img src="<?php echo CONF_WEBROOT_URL; ?>images/green-tick.svg" alt=""></span>
																		<span class="badge-item__label"><?php echo Labels::getLabel('LBL_Trustseal_Verified', $siteLangId); ?></span>
																	</div>
																</div>										
															
														<?php } ?>     


													<?php if (isset($sellerProfileData['sprofile_seller_type']) && !empty($sellerProfileData['sprofile_seller_type'])) { 
															$sellerType = ShopProfile::getSellerTypeArr($siteLangId); ?>
															<div class="seller-badges__grid">
																<div class="badge-item">
																	<span class="badge-item__media"><img src="<?php echo CONF_WEBROOT_URL; ?>images/manufacturer.svg" alt="<?php echo isset($sellerType[$shop['sprofile_seller_type']]) ? $sellerType[$shop['sprofile_seller_type']]  : ''; ?>"></span>
																	<span class="badge-item__label"><?php echo isset($sellerType[$sellerProfileData['sprofile_seller_type']]) ? $sellerType[$sellerProfileData['sprofile_seller_type']]  : ''; ?></span>
																</div>
															</div>
													<?php } ?>

														
															<?php if ($shop['subscription_package_id'] == SellerPackages::SILVER_PACKAGE) { ?>
																
																
																<div class="seller-badges__grid">
																	<div class="badge-item">
																		<span class="badge-item__media"><img class="gray-scale" width="18" height="18" loading="lazy" src="<?php echo CONF_WEBROOT_FRONT_URL; ?>images/dollar.png"></span>
																		<span class="badge-item__label"><?php echo Labels::getLabel('LBL_Silver_Member', $siteLangId); ?></span>
																	</div>
																</div>										
																
															<?php } elseif ($shop['subscription_package_id'] == SellerPackages::GOLD_PACKAGE) { ?>
																<div class="seller-badges__grid">
																	<div class="badge-item">
																		<span class="badge-item__media"><img width="18" height="18" loading="lazy" src="<?php echo CONF_WEBROOT_FRONT_URL; ?>images/dollar.png"></span>
																		<span class="badge-item__label"><?php echo Labels::getLabel('LBL_Gold_Member', $siteLangId); ?></span>
																	</div>
																</div>										
																
															<?php } else { ?>
																<div class="seller-badges__grid">
																	<div class="badge-item">
																		<span class="badge-item__media"></span>
																		<span class="badge-item__label"><?php echo Labels::getLabel('LBL_Free_Member', $siteLangId); ?></span>
																	</div>
																</div>											
																
																
															<?php } ?>

														<?php } ?>

														<?php if ($shop['is_founding_member'] == 1) { ?>
														   
															<div class="seller-badges__grid">
																<div class="badge-item">
																	<span class="badge-item__media"><img idth="22" height="22" loading="lazy" src="<?php echo CONF_WEBROOT_FRONT_URL; ?>images/crown.png"></span>
																	<span class="badge-item__label"><?php echo Labels::getLabel('LBL_Founding_Memeber', $siteLangId); ?></span>
																</div>
															</div>										
															
														<?php } ?>


												</div>


											</div>

											<div class="contact-seller__inner-r">

												<a onClick="contactWithSeller(<?php echo $shop['shop_id']; ?>, <?php echo $shop['selprod_id']; ?>);" href="javascript:void(0);" class="btn btn--bordered-brand d-flex align-items-center justify-content-center">
													<span class="site-icon site-icon--small mr-2">
															<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 14.4">
																<path d="M2.8,3H17.2a.8.8,0,0,1,.8.8V16.6a.8.8,0,0,1-.8.8H2.8a.8.8,0,0,1-.8-.8V3.8A.8.8,0,0,1,2.8,3Zm7.248,6.946L4.918,5.59,3.882,6.81l6.176,5.244,6.065-5.248L15.077,5.6,10.049,9.946Z" transform="translate(-2 -3)"></path>
															  </svg>                                                                                                                
														</span>
													<span> <?php echo Labels::getLabel('Lbl_Contact_Seller', $siteLangId); ?></span>

												</a>

											</div>

										</div>

									</div>							
							
							<?php } else { ?>
							
							
                            <div class="shop-pro"><h6>
                                <?php echo $shop['shop_name']; ?>
                                
                            </h6></div>
							
							<?php } ?>
							
							<?php if(!$isProductDetail) { ?>
                            <div class="seller-badges seller-badges--inline mt-4 mb-4">
                                <?php
                                if ($shop['subscription_package_id'] > 0) {                                  
                                ?>

                                <?php if ((isset($shop['subscription_package_id']) && $shop['subscription_package_id'] == SellerPackages::GOLD_PACKAGE) && $shop['seller_verified'] == 1) { ?>
										<div class="seller-badges__grid">
											<div class="badge-item">
												<span class="badge-item__media"><img src="<?php echo CONF_WEBROOT_URL; ?>images/green-tick.svg" alt=""></span>
												<span class="badge-item__label"><?php echo Labels::getLabel('LBL_Trustseal_Verified', $siteLangId); ?></span>
											</div>
										</div>										
									
                                <?php } ?>


								<?php if (isset($sellerProfileData['sprofile_seller_type']) && !empty($sellerProfileData['sprofile_seller_type'])) { ?>
										
									<div class="seller-badges__grid">
										<div class="badge-item">
											<span class="badge-item__media"><img src="<?php echo CONF_WEBROOT_URL; ?>images/manufacturer.svg" alt="<?php echo isset($sellerTypeArr[$shop['sprofile_seller_type']]) ? $sellerTypeArr[$shop['sprofile_seller_type']]  : ''; ?>"></span>
											<span class="badge-item__label"><?php echo isset($sellerTypeArr[$sellerProfileData['sprofile_seller_type']]) ? $sellerTypeArr[$sellerProfileData['sprofile_seller_type']]  : ''; ?></span>
										</div>
									</div>
								<?php } ?>

								<?php if (isset($seller_type) && !empty($seller_type)) { 
										$sellerType = ShopProfile::getSellerTypeArr($siteLangId); ?>
										<div class="seller-badges__grid">
											<div class="badge-item">
												<span class="badge-item__media"><img src="<?php echo CONF_WEBROOT_URL; ?>images/manufacturer.svg" alt="<?php echo isset($sellerType[$shop['sprofile_seller_type']]) ? $sellerType[$shop['sprofile_seller_type']]  : ''; ?>"></span>
												<span class="badge-item__label"><?php echo isset($sellerType[$seller_type]) ? $sellerType[$seller_type]  : ''; ?></span>
											</div>
										</div>
								<?php } ?>

                                    <?php if ($shop['subscription_package_id'] == SellerPackages::SILVER_PACKAGE) { ?>
                                        
										
                                        <div class="seller-badges__grid">
											<div class="badge-item">
												<span class="badge-item__media"><img class="gray-scale" width="18" height="18" loading="lazy" src="<?php echo CONF_WEBROOT_FRONT_URL; ?>images/dollar.png"></span>
												<span class="badge-item__label"><?php echo Labels::getLabel('LBL_Silver_Member', $siteLangId); ?></span>
											</div>
										</div>										
										
                                    <?php } elseif ($shop['subscription_package_id'] == SellerPackages::GOLD_PACKAGE) { ?>
                                        <div class="seller-badges__grid">
											<div class="badge-item">
												<span class="badge-item__media"><img width="18" height="18" loading="lazy" src="<?php echo CONF_WEBROOT_FRONT_URL; ?>images/dollar.png"></span>
												<span class="badge-item__label"><?php echo Labels::getLabel('LBL_Gold_Member', $siteLangId); ?></span>
											</div>
										</div>										
										
                                    <?php } else { ?>
                                        <div class="seller-badges__grid">
											<div class="badge-item">
												<span class="badge-item__media"></span>
												<span class="badge-item__label"><?php echo Labels::getLabel('LBL_Free_Member', $siteLangId); ?></span>
											</div>
										</div>											
										
										
                                    <?php } ?>

                                <?php } ?>

                                <?php if ($shop['is_founding_member'] == 1) { ?>
                                   
									<div class="seller-badges__grid">
										<div class="badge-item">
											<span class="badge-item__media"><img idth="22" height="22" loading="lazy" src="<?php echo CONF_WEBROOT_FRONT_URL; ?>images/crown.png"></span>
											<span class="badge-item__label"><?php echo Labels::getLabel('LBL_Founding_Memeber', $siteLangId); ?></span>
										</div>
									</div>										
									
                                <?php } ?>
                            </div>
							<?php } ?>
							
                            <?php
                            $companyInfo = (isset($shop['shop_seller_info']) && !empty(array_filter((array) $shop['shop_seller_info']))) ? $shop['shop_seller_info']['description'] : '';
                            ?>
                            <div class="cms"><p><?php echo $companyInfo; ?></p></div>
                        </div>
                    </div>
                    <?php if (!empty($tradeShowDocs)) { ?>
                        <div class="content-box" id="trade-show">
                            <div class="content-box__head"><h6 class="mb-0"><?php echo Labels::getLabel('LBL_Trade_Show', $siteLangId); ?></h6></div>
                             <div class="content-box__body">
                                <!-- [ repeating block -->
                                <?php
                                $i = 1;
                                $totalDocs = count($tradeShowDocs);
                                foreach ($tradeShowDocs as $tdoc) {
                                    $files = AttachedFile::getMultipleAttachments(AttachedFile::FILETYPE_SHOP_DOCUMENT, $tdoc['shopdoc_id']);
                                    if (!empty($files)) {
                                ?>
                                        <p><strong class="document-name"><?php echo ($tdoc['shopdoc_name'] == '') ? $tdoc['shopdoc_identifier'] : $tdoc['shopdoc_name']; ?></strong></p>
                                        <ul class="image-block">
                                            <?php
                                            foreach ($files as $file) {
                                                $ext = pathinfo($file['afile_name'], PATHINFO_EXTENSION);
                                            ?>
                                                <li>
                                                    <div class="img-border">
                                                        <?php if (in_array($ext, $imageType)) { ?>
                                                            <a href="<?php echo CommonHelper::generateFileUrl('Image', 'shopDocument', [$tdoc['shopdoc_id'], $file['afile_id']]); ?>" class="document-img--js">
                                                                <img src="<?php echo CommonHelper::generateFileUrl('Image', 'shopDocument', [$tdoc['shopdoc_id'], $file['afile_id'], 'THUMB']); ?>" />
                                                            </a>
                                                        <?php } else { ?>
                                                            <a href="<?php echo CommonHelper::generateFileUrl('Image', 'shopFile', [$tdoc['shopdoc_id'], $file['afile_id']]); ?>" title="<?php echo Labels::getLabel('LBL_Download_file', $siteLangId); ?>">
                                                                <i class="icn doc-file-icon">
                                                                    <svg class="svg">
                                                                        <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-my-subscriptions" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-my-subscriptions"></use>
                                                                    </svg>
                                                                </i>
                                                            </a>
                                                        <?php } ?>
                                                    </div>
                                                </li>
                                            <?php } ?>
                                        </ul>
                                        <?php if ($i < $totalDocs) { ?>
                                            <hr />
                                        <?php } ?>
                                    <?php } ?>
                                <?php
                                    $i++;
                                }
                                ?>
                                <!-- ] -->
                            </div>
                        </div>
                    <?php } ?>
                    <?php
                    if (!empty($sellerData)) {
                        foreach ($sellerData as $key => $val) {
                            $key = str_replace('sprofile_', 'LBL_', $key);
                            $id = str_replace('LBL_', '', $key);
							if(!empty($val)) {
                    ?>
                            <div class="content-box" id="<?php echo $id; ?>">
                                <div class="content-box__head"><h6 class="mb-0"><?php
                                                            echo Labels::getLabel($key, $siteLangId);
                                                            ?></h6></div>
                                <div class="content-box__body">
                                    <div class="cms"><p><?php echo $val; ?></p></div>
                                </div>
                            </div>
                    <?php
                        } }
                    }
                    ?>
                    <?php if (!empty($insReportDocs)) { ?>
                        <div class="content-box" id="inspection-reports">
                            <div class="content-box__head"><h6 class="mb-0"><?php echo Labels::getLabel('LBL_Factory_Inspection_Reports', $siteLangId); ?></h6></div>
                            <div class="content-box__body">
                                <!-- [ repeating block -->
                                <?php
                                $i = 1;
                                $totalDocs = count($insReportDocs);

                                foreach ($insReportDocs as $idoc) {
                                    $files = AttachedFile::getMultipleAttachments(AttachedFile::FILETYPE_SHOP_DOCUMENT, $idoc['shopdoc_id']);
                                    if (!empty($files)) {
                                ?>
                                        <p><strong class="document-name"><?php echo ($idoc['shopdoc_name'] == '') ? $idoc['shopdoc_identifier'] : $idoc['shopdoc_name']; ?></strong></p>
                                        <ul class="image-block">
                                            <?php
                                            foreach ($files as $file) {
                                                $ext = pathinfo($file['afile_name'], PATHINFO_EXTENSION);
                                            ?>
                                                <li>
                                                    <div class="img-border">
                                                        <?php
                                                        $imgClass = '';
                                                        if (in_array($ext, $imageType)) {
                                                            $imgClass = 'document-img--js';
                                                            $documentUrl = CommonHelper::generateFileUrl('Image', 'shopDocument', [$idoc['shopdoc_id'], $file['afile_id']]);
                                                        ?>
                                                            <a href="<?php echo $documentUrl; ?>" class="<?php echo $imgClass; ?>">
                                                                <img src="<?php echo CommonHelper::generateFileUrl('Image', 'shopDocument', [$idoc['shopdoc_id'], $file['afile_id'], 'THUMB']); ?>" />
                                                            </a>
                                                        <?php
                                                        } else {
                                                            $documentUrl = CommonHelper::generateFileUrl('Image', 'shopFile', [$idoc['shopdoc_id'], $file['afile_id']]);
                                                        ?>
                                                            <a href="<?php echo CommonHelper::generateFileUrl('Image', 'shopFile', [$idoc['shopdoc_id'], $file['afile_id']]); ?>" title="<?php echo Labels::getLabel('LBL_Download_file', $siteLangId); ?>">
                                                                <i class="icn doc-file-icon">
                                                                    <svg class="svg">
                                                                        <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-my-subscriptions" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-my-subscriptions"></use>
                                                                    </svg>
                                                                </i>
                                                            </a>
                                                        <?php } ?>
                                                    </div>
                                                    <a href="<?php echo $documentUrl; ?>" class="<?php echo $imgClass; ?>"><?php echo $file['afile_name']; ?></a>
                                                </li>
                                            <?php } ?>
                                        </ul>
                                        <?php if ($i < $totalDocs) { ?>
                                            <hr />
                                        <?php } ?>

                                    <?php
                                    }
                                    $i++;
                                    ?>
                                <?php } ?>
                                <!-- ] -->
                            </div>
                        </div>
                    <?php } ?>

                    <?php if (!empty($qcCertificates)) { ?>
                        <div class="content-box" id="quality-certificates">
                            <div class="content-box__head"><h6 class="mb-0"><?php echo Labels::getLabel('LBL_Quality_Certified', $siteLangId); ?></h6></div>
                            <div class="content-box__body">
                                <!-- [ repeating block -->
                                <?php
                                $i = 1;
                                $totalDocs = count($qcCertificates);

                                foreach ($qcCertificates as $certificate) {
                                    $files = AttachedFile::getMultipleAttachments(AttachedFile::FILETYPE_SHOP_DOCUMENT, $certificate['shopdoc_id']);
                                    if (!empty($files)) {
                                ?>
                                        <p><strong class="document-name"><?php echo ($certificate['shopdoc_name'] == '') ? $certificate['shopdoc_identifier'] : $certificate['shopdoc_name']; ?></strong></p>
                                        <ul class="image-block">
                                            <?php
                                            foreach ($files as $file) {
                                                $ext = pathinfo($file['afile_name'], PATHINFO_EXTENSION);
                                            ?>
                                                <li>
                                                    <div class="img-border">
                                                        <?php
                                                        $imgClass = '';
                                                        if (in_array($ext, $imageType)) {
                                                            $imgClass = 'document-img--js';
                                                            $documentUrl = CommonHelper::generateFileUrl('Image', 'shopDocument', [$certificate['shopdoc_id'], $file['afile_id']]);
                                                        ?>
                                                            <a href="<?php echo $documentUrl; ?>" class="<?php echo $imgClass; ?>">
                                                                <img src="<?php echo CommonHelper::generateFileUrl('Image', 'shopDocument', [$certificate['shopdoc_id'], $file['afile_id'], 'THUMB']); ?>" />
                                                            </a>
                                                        <?php
                                                        } else {
                                                            $documentUrl = CommonHelper::generateFileUrl('Image', 'shopFile', [$certificate['shopdoc_id'], $file['afile_id']]);
                                                        ?>
                                                            <a href="<?php echo CommonHelper::generateFileUrl('Image', 'shopFile', [$certificate['shopdoc_id'], $file['afile_id']]); ?>" title="<?php echo Labels::getLabel('LBL_Download_file', $siteLangId); ?>">
                                                                <i class="icn doc-file-icon">
                                                                    <svg class="svg">
                                                                        <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-my-subscriptions" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-my-subscriptions"></use>
                                                                    </svg>
                                                                </i>
                                                            </a>
                                                        <?php } ?>
                                                    </div>
                                                    <a href="<?php echo $documentUrl; ?>" class="<?php echo $imgClass; ?>"><?php echo $file['afile_name']; ?></a>
                                                </li>
                                            <?php } ?>
                                        </ul>
                                        <?php if ($i < $totalDocs) { ?>
                                            <hr />
                                        <?php } ?>

                                    <?php
                                    }
                                    $i++;
                                    ?>
                                <?php } ?>
                                <!-- ] -->
                            </div>
                        </div>
                    <?php } ?>

                    <?php if (!empty($youtube_embed_code)) { ?>
                        <div class="content-box" id="company-video">
                            <div class="content-box__head"><h6 class="mb-0"><?php echo Labels::getLabel('LBL_Company_Video', $siteLangId); ?></h6></div>
                            <div class="content-box__body">
                                <div class="video-tag">
                                    <iframe src="//www.youtube.com/embed/<?php echo $youtube_embed_code ?>" allowfullscreen> </iframe>
                                </div>
                            </div>
                        </div>
                    <?php } ?>

                    <?php if (!empty($faqs)) { ?>
                        <div class="content-box" id="faqs">
                            <div class="content-box__head"><h6 class="mb-0"><?php echo Labels::getLabel('LBL_Faqs', $siteLangId); ?><h6></div>
                            <div class="content-box__body">
                                <div class="video-tag">
                                    <ul class="faqlist" id="listing">
                                        <?php foreach ($faqs as $faq) { ?>
                                            <li>
                                                <h3 class="filterDiv account dropdown-toggle" href="javascript:void(0);" data-id="<?php echo $faq['faq_id']; ?>"><?php echo ($faq['faq_title'] != '') ? $faq['faq_title'] : $faq['faq_identifier']; ?></h3>
                                                <div class="faqanswer">
                                                    <p class="faq-content"><?php echo $faq['faq_content']; ?></p>
                                                </div>
                                            </li>
                                        <?php } ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                </div>
				</div>
		<?php if (!$isProductDetail) { ?>			
            
            </div>
          </div>
    </section>
		<?php } ?>
    <!-- SELLER PROFILE END ] -->

    <?php if (!$isProductDetail) { ?>
    </div>
<?php } ?>
<?php echo $this->includeTemplate('_partial/shareThisScript.php'); ?>
<script>
    $(document).ready(function() {
        $('.faqanswer').hide();
        $(document).on("click", 'h3', function() {
            $(this).next('.faqanswer').toggle(function() {
                $(this).next('.faqanswer');
            }, function() {
                $(this).next('.faqanswer').fadeIn('fast');
            });
        });
		
    $(".scrolls").click(function(event) {
        event.preventDefault();
        var full_url = this.href;
        var parts = full_url.split("#");
        var trgt = parts[1];
		$(".is-active").removeClass("is-active");
        var target_offset = $("#" + trgt).offset();
        var target_top = target_offset.top - 120;
		$(this).addClass("is-active");
        $('html, body').animate({
            scrollTop: target_top
        }, 1000);
    });		
		
    });
</script>
<script>
    $('.document-img--js').magnificPopup({
        type: 'image'
    });
</script>