<?php
defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>

<div class="filters__head">
    <div class="d-flex align-items-center justify-content-between">
        <div>
            <h5 class="mb-0"><?php echo Labels::getLabel('Lbl_Filters', $siteLangId); ?></h5>
        </div>
		<a href="javascript:void(0)" class="resetAll link" id="resetAll" onClick="resetListingFilter()" style="display:none;">
            <?php echo Labels::getLabel('LBL_Reset_All', $siteLangId); ?>
        </a>
        <!-- <div><a href="#" class="link">Reset All</a></div> -->
    </div>
	<div class="selected-filters" id="filters"> </div>
</div>

<div class="filters__body">

<?php $sellerTypesArr = ShopProfile::getSellerTypeArr($siteLangId); 
if (!empty($sellerTypesArr)) {
?>
    <!-- [ FILTER 2=========== -->
    <div class="filters-widget widget-js">
        <div class="filters-widget__head widget-trigger-js">
            <h6 class="mb-0"><?php echo Labels::getLabel('LBL_Business_Type', $siteLangId); ?></h6>
        </div>
        <div class="filters-widget__body widget-target-js" style="display: none;">
            <div class="filters-scroll">
                <ul class="list-vertical">
					<?php
					foreach ($sellerTypesArr as $typeKey => $sellerType) {
					?>
						<li><label class="checkbox seller-type" id="sellertypes_<?php echo $typeKey; ?>">
								<input value="<?php echo $typeKey; ?>" name="sellertypes" type="checkbox" <?php echo (in_array($typeKey, $sellerTypeCheckedArr)) ? "checked='true'" : ''; ?>>
								<i class="input-helper"></i>
								<?php echo $sellerType; ?>
							</label>
						</li>
					<?php }
					?>
                </ul>
            </div>
        </div>
    </div>
<?php } ?>
    <!-- FILTER 2 ]=========== -->

    <!-- [ FILTER 1=========== -->
    <div class="filters-widget widget-js is-active">
        <div class="filters-widget__head widget-trigger-js is-active">
            <h6 class="mb-0"><?php echo Labels::getLabel('LBL_Supplier_Type', $siteLangId); ?></h6>
        </div>
        <div class="filters-widget__body widget-target-js" style="">
            <div class="filters-scroll">
                <ul class="list-vertical">
                    <li>
						<label class="checkbox verified" id="verified_1">
                            <input name="verified" data-id="verified_1" <?php  if($verified) {  echo "checked='true'";  }   ?>  value="<?php echo Labels::getLabel('LBL_Verified', $siteLangId); ?>" data-title="<?php echo Labels::getLabel('LBL_Verified', $siteLangId); ?>" type="checkbox" >
                            <i class="input-helper"></i>
                            <?php echo Labels::getLabel('LBL_Verified', $siteLangId); ?> 
						</label>	
                    </li>
                    <li><label class="checkbox supplier" id="supplier_1">
                            <input name="supplier" data-id="supplier_1" <?php echo (in_array(1, $supplierTypeCheckedArr)) ? "checked" : ''; ?>  value="1" data-title="<?php echo Labels::getLabel('LBL_Gold_Member', $siteLangId); ?>" type="checkbox" >
                            <i class="input-helper"></i>
                            <?php echo Labels::getLabel('LBL_Gold_Member', $siteLangId); ?> </label>
                    </li>
                    <li><label class="checkbox foundingmember" id="foundingmember_1">
                            <input name="foundingmember" data-id="foundingmember_1" <?php  if($foundingmember) {  echo "checked='true'";  }   ?> value="1" data-title="<?php echo Labels::getLabel('LBL_Founding_Member', $siteLangId); ?>" type="checkbox" >
                            <i class="input-helper"></i>
                            <?php echo Labels::getLabel('LBL_Founding_Member', $siteLangId); ?> </label>
                    </li>
                </ul>
            </div>
        </div>
    </div>
    <!-- FILTER 1 ]=========== -->



<?php if(count($countriesArr) > 0) {  ?>
    <!-- [ FILTER 3=========== -->
    <div class="filters-widget  widget-js">
        <div class="filters-widget__head widget-trigger-js">
            <h6 class="mb-0"><?php echo Labels::getLabel('LBL_Country/Region', $siteLangId); ?></h6>
        </div>
        <div class="filters-widget__body widget-target-js" style="display: none;">

            <div class="filters-scroll">
                    <ul class="list-vertical countryFilter-js">
                        <?php
                        foreach ($countriesArr as $country) {
                        ?>
                            <li>
                                <label class="checkbox country" id="country_<?php echo $country['country_id']; ?>">
                                    <input name="country" data-id="country_<?php echo $country['country_id']; ?>" value="<?php echo $country['country_id']; ?>" data-title="<?php echo $country['country_name']; ?>" type="checkbox" <?php echo (in_array($country['country_id'], $checkedCountriesArr)) ? "checked" : ''; ?>>
                                    <i class="input-helper"></i>
                                    <?php echo $country['country_name']; ?>
                                </label>
                            </li>
                        <?php
                        }
                        ?>
                    </ul>
            </div>
        </div>
    </div>
    <!-- FILTER 3 ]=========== -->
<?php } ?>


    <!-- [ FILTER 4 =========== -->
    <div class="filters-widget  widget-js">
        <div class="filters-widget__head widget-trigger-js">
            <h6 class="mb-0"><?php echo Labels::getLabel('LBL_Suppliers_Ratings', $siteLangId); ?></h6>
        </div>
        <div class="filters-widget__body widget-target-js" style="display: none;">

            <div class="filters-scroll">
			
                <ul class="list-vertical ratingFilter-js">
                    <li>
                        <label class="d-flex checkbox rating" id="rating_4">
							<input name="rating" data-id="rating_4" value="4" data-title="4" type="checkbox" <?php echo (in_array(4, $ratingCheckedArr)) ? "checked='true'" : ''; ?> >
							<i class="input-helper"></i>
                            <div class="ratings">
                                <span class="ratings__star site-icon site-icon--small mr-2">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 15.216">
                                        <path d="M8.587,12.949,3.643,15.716l1.1-5.557L.587,6.312l5.627-.667L8.587.5,10.96,5.645l5.627.667-4.16,3.847,1.1,5.557Z" transform="translate(-0.587 -0.5)" fill="#f59f1f"></path>
                                    </svg>
                                </span>
                                4 &amp; <?php echo Labels::getLabel('LBL_above', $siteLangId); ?>
                            </div>
						</label>						
                    </li>
                    <li>
                        <label class="d-flex checkbox rating" id="rating_3">
							<input name="rating" data-id="rating_3" value="3" data-title="3" type="checkbox" <?php echo (in_array(3, $ratingCheckedArr)) ? "checked='true'" : ''; ?> >
							<i class="input-helper"></i>
                            <div class="ratings">
                                <span class="ratings__star site-icon site-icon--small mr-2">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 15.216">
                                        <path d="M8.587,12.949,3.643,15.716l1.1-5.557L.587,6.312l5.627-.667L8.587.5,10.96,5.645l5.627.667-4.16,3.847,1.1,5.557Z" transform="translate(-0.587 -0.5)" fill="#f59f1f"></path>
                                    </svg>
                                </span>
                                3 &amp; <?php echo Labels::getLabel('LBL_above', $siteLangId); ?>
                            </div>
						</label>						
                    </li>
                    <li>
                        <label class="d-flex checkbox rating" id="rating_2">
							<input name="rating" data-id="rating_2" value="2" data-title="2" type="checkbox"  <?php echo (in_array(2, $ratingCheckedArr)) ? "checked='true'" : ''; ?> >
							<i class="input-helper"></i>
                            <div class="ratings">
                                <span class="ratings__star site-icon site-icon--small mr-2">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 15.216">
                                        <path d="M8.587,12.949,3.643,15.716l1.1-5.557L.587,6.312l5.627-.667L8.587.5,10.96,5.645l5.627.667-4.16,3.847,1.1,5.557Z" transform="translate(-0.587 -0.5)" fill="#f59f1f"></path>
                                    </svg>
                                </span>
                                2 &amp; <?php echo Labels::getLabel('LBL_above', $siteLangId); ?>
                            </div>
						</label>
                    </li>
                    <li>
                        <label class="d-flex checkbox rating" id="rating_2">
							<input name="rating" data-id="rating_1" value="1" data-title="1" type="checkbox" <?php echo (in_array(1, $ratingCheckedArr)) ? "checked='true'" : ''; ?> >
							<i class="input-helper"></i>
                            <div class="ratings">
                                <span class="ratings__star site-icon site-icon--small mr-2">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 15.216">
                                        <path d="M8.587,12.949,3.643,15.716l1.1-5.557L.587,6.312l5.627-.667L8.587.5,10.96,5.645l5.627.667-4.16,3.847,1.1,5.557Z" transform="translate(-0.587 -0.5)" fill="#f59f1f"></path>
                                    </svg>
                                </span>
                                1 &amp; <?php echo Labels::getLabel('LBL_above', $siteLangId); ?>
                            </div>
						</label>
                    </li>
                </ul>
				
            </div>
        </div>
    </div>
    <!-- FILTER 4 ]=========== -->




</div>

<div class="filters__footer">
	<div class="filter-actions">
		<a href="javascript:void(0);" onclick="resetListingFilter()" class="filter-actions__trigger filter-actions__reset trigger-js clear-fileters is-active"><?php echo Labels::getLabel('LBL_Clear_All', $siteLangId); ?></a>
		<a href="javascript:void(0);" class="filter-actions__trigger filter-actions__submit apply-fileters trigger-js"><?php echo Labels::getLabel('LBL_Apply', $siteLangId); ?></a>
	</div>
</div>


<script language="javascript">
	$(".widget-target-js").hide();
	$(".widget-target-js:first").show();
	$(".widget-trigger-js").click(function() {
		if ($(this).parents('.widget-js').hasClass('is-active')) {
			$(this).siblings('.accordian__target-js').slideUp();
			$('.accordian-js').removeClass('is-active');
		} else {
			$('.widget-js').removeClass('is-active');
			$(this).parents('.widget-js').addClass('is-active');
			$('.widget-target-js').hide();
			$(this).siblings('.widget-target-js').show();
		}
	});
						
	$(".apply-fileters").click(function() {
		$("#filters-js").removeClass("is-visible");
		$(".is-toggle").removeClass("is-toggle");
	});
</script>						