<?php defined('SYSTEM_INIT') or die('Invalid Usage'); ?>
<?php
if (!empty($product)) {
	$frm->setFormTagAttribute('class', 'form form--horizontal');
} else {
	$frm->setFormTagAttribute('class', 'form');
}
$frm->developerTags['colClassPrefix'] = 'col-lg-12 col-md-12 col-sm-';
$frm->developerTags['fld_default_col'] = 12;
$frm->setFormTagAttribute('onSubmit', 'setUpSendContactMessage(this); return false;');

$fromFld = $frm->getField('send_message_from');
$toFld = $frm->getField('send_message_to');

$fromFldHtml = new HtmlElement('div', array('class' => 'field-set'));
$fromFldCaptionWrapper = $fromFldHtml->appendElement('div', array('class' => 'caption-wraper'));
$fromFldCaptionWrapper->appendElement('label', array('class' => 'field_label'), Labels::getLabel('LBL_From', $siteLangId));

$fromFldFieldWrapper = $fromFldHtml->appendElement('div', array('class' => 'field-wraper'));
$fromFldData = (isset($loggedUserData['credential_username']) ? $loggedUserData['credential_username'] : '') . ' (<em>' . (isset($loggedUserData['user_name']) ? $loggedUserData['user_name'] : '') . '</em>)';
$fromFldData .= '<br/><span class="form-text text-muted">' . Labels::getLabel('LBL_Contact_info_not_shared', $siteLangId) . '</span>';
$fromFldFieldWrapper->appendElement('div', array('class' => 'field_cover'), $fromFldData, true);

$fromFld->value = $fromFldHtml->getHtml();


$toFldHtml = new HtmlElement('div', array('class' => 'field-set'));
$toFldCaptionWrapper = $toFldHtml->appendElement('div', array('class' => 'caption-wraper'));
$toFldCaptionWrapper->appendElement('label', array('class' => 'field_label'), Labels::getLabel('LBL_To', $siteLangId));

$toFldFieldWrapper = $toFldHtml->appendElement('div', array('class' => 'field-wraper'));
$toFldFieldWrapper->appendElement('div', array('class' => 'field_cover'), $shop['shop_owner_name'] . ' (<em>' . $shop['shop_name'] . '</em>)', true);

$toFld->value = $toFldHtml->getHtml();

if (isset($product) && !empty($product)) {
	$productFld = $frm->getField('about_product');
	$productFldHTML = new HtmlElement('div', array('class' => 'field-set'));
	$productFldCaptionWrapper = $productFldHTML->appendElement('div', array('class' => 'caption-wraper'));
	$productFldCaptionWrapper->appendElement('label', array('class' => 'field_label'), Labels::getLabel('LBL_About_Product', $siteLangId));

	$productFldFieldWrapper = $productFldHTML->appendElement('div', array('class' => 'field-wraper'));
	$productFldFieldWrapper->appendElement('div', array('class' => 'field_cover'), $product['selprod_title'], true);

	$productFld->value = $productFldHTML->getHtml();
}

$fromFld = $frm->getField('btn_submit');
$fromFld->setFieldTagAttribute('class', 'float-right');

$shop_city = $shop['shop_city'];
$shop_state = (strlen($shop['shop_city']) > 0) ? ', ' . $shop['shop_state_name'] : $shop['shop_state_name'];
$shop_country = (strlen($shop_state) > 0) ? ', ' . $shop['shop_country_name'] : $shop['shop_country_name'];
$shopLocation = $shop_city . $shop_state . $shop_country;
?>


<div class="contact-panel contact-seller-form-popup">

	<!-- [ PANEL LARGE =========== -->
	<div class="contact-panel__large">

		<div class="quick-form">
			<div class="quick-form__head mb-5">
				<h4><?php echo Labels::getLabel('LBL_Looking_To_Buy_This_Product?_Contact_Now', $siteLangId); ?></h4>
				<p><?php echo Labels::getLabel('LBL_Send_Message_to_shop_owner', $siteLangId); ?></p>
			</div>
			<div class="quick-form__body">
				<?php echo $frm->getFormHtml(); ?>
			</div>
		</div>

	</div>
	<!-- ] -->
	<?php if (!empty($product)) { ?>
		<!-- [ PANEL SMALL =========== -->
		<div class="contact-panel__small">

			<div class="seller-portlet">
				<div class="seller-portlet__head">
					<div class="seller-portlet__logo"><img src="<?php echo CommonHelper::generateFileUrl('Image', 'shopLogo', array($shop['shop_id'], $siteLangId, 'SMALL')); ?>" alt="<?php echo $shop['shop_name']; ?>"></div>
					<div class="seller-portlet__info">
						<h6><a href="<?php echo CommonHelper::generateUrl('shops', 'View', array($shop['shop_id'])); ?>"> <?php echo $shop['shop_name']; ?></a></h6>

						<div class="seller-portlet__details">
							<span class="seller-location"><?php echo $shop['shop_state_name'] . ", " . $shop['shop_country_name']; ?></span>
							<div class="seller-ratings">
								<div class="ratings">
									<span class="ratings__star site-icon site-icon--small">
										<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 15.216">
											<path d="M8.587,12.949,3.643,15.716l1.1-5.557L.587,6.312l5.627-.667L8.587.5,10.96,5.645l5.627.667-4.16,3.847,1.1,5.557Z" transform="translate(-0.587 -0.5)" fill="#f59f1f"></path>
										</svg>
									</span>
									<span class="ratings__value"><?php echo round($shopRating, 1); ?></span>
								</div>
							</div>
						</div>
					</div>


				</div>
				<div class="seller-portlet__body">
					<?php if ($subscription_package_id > 0) { ?>
						<div class="seller-badges">

							<?php if ((isset($subscription_package_id) && $subscription_package_id == SellerPackages::GOLD_PACKAGE) && $shop['seller_verified'] == 1) { ?>
								<div class="seller-badges__grid">
									<div class="badge-item">
										<span class="badge-item__media"><img src="<?php echo CONF_WEBROOT_URL; ?>images/green-tick.svg" alt=""></span>
										<span class="badge-item__label"><?php echo Labels::getLabel('LBL_Trustseal_Verified', $siteLangId); ?></span>
									</div>
								</div>
							<?php } ?>
							<?php if ($subscription_package_id == SellerPackages::SILVER_PACKAGE) { ?>
								<div class="seller-badges__grid">
									<div class="badge-item">
										<span class="badge-item__media"><img class="gray-scale" src="<?php echo CONF_WEBROOT_URL; ?>images/dollar.png" alt=""></span>
										<span class="badge-item__label"><?php echo $subscription_package; ?></span>
									</div>
								</div>
							<?php } elseif ($subscription_package_id == SellerPackages::GOLD_PACKAGE) { ?>
								<div class="seller-badges__grid">
									<div class="badge-item">
										<span class="badge-item__media"><img src="<?php echo CONF_WEBROOT_URL; ?>images/dollar.png"></span>
										<span class="badge-item__label"><?php echo $subscription_package; ?></span>
									</div>
								</div>
							<?php } else { ?>
								<div class="seller-badges__grid">
									<div class="badge-item">
										<span class="badge-item__label"><?php echo $subscription_package; ?></span>
									</div>
								</div>
							<?php }
							if ($shop['is_founding_member'] == 1) { ?>
								<div class="seller-badges__grid">
									<div class="badge-item">
										<span class="badge-item__media"> <img src="<?php echo CONF_WEBROOT_URL; ?>images/crown.png"></span>
										<span class="badge-item__label"><?php echo Labels::getLabel('LBL_Founding_Member', $siteLangId); ?></span>
									</div>
								</div>
							<?php } ?>


						</div>
					<?php } ?>

				</div>


				<div class="seller-portlet__footer">
					<div class="product-card product-card--horizontal product-card--small">
						<div class="product-card__head">
							<div class="product-media ratio ratio--1by1">
								<a href="<?php echo CommonHelper::generateUrl('products', 'view', array($product['selprod_id'])) ?>">
									<?php if ($product['selprod_type'] == SellerProduct::PRODUCT_TYPE_SERVICE) { ?>
										<img src="<?php echo FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'serviceProduct', array($product['selprod_id'], 'THUMB')), CONF_IMG_CACHE_TIME, '.jpg'); ?>">
									<?php } else { ?>
										<img src="<?php echo FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'Product', array($product['product_id'], 'THUMB')), CONF_IMG_CACHE_TIME, '.jpg'); ?>">
									<?php } ?>

								</a>

							</div>
						</div>
						<div class="product-card__body">
							<div class="product-detail">
								<a href="<?php echo CommonHelper::generateUrl('Category', 'View', array($product['prodcat_id'])) ?>" class="product-category"><?php echo $product['prodcat_name']; ?></a>
								<a href="<?php echo CommonHelper::generateUrl('products', 'view', array($product['selprod_id'])) ?>" class="product-title"><?php echo $product['selprod_title']; ?></a>
								<?php if (CommonHelper::isDisplayPrice($product)) { ?>
									<div class="product-price">
										<span class="product-price__sell"><?php echo CommonHelper::getCurrencyCode() . CommonHelper::displayMoneyFormat($product['theprice']); ?></span>
										<?php if (isset($product['special_price_found']) && !empty($product['special_price_found'])) { ?>
											<span class="product-price__original"><?php echo CommonHelper::getCurrencyCode() . CommonHelper::displayMoneyFormat($product['selprod_price']); ?></span>
											<span class="product-price__off"><?php echo CommonHelper::showProductDiscountedText($product, $siteLangId); ?></span>
										<?php  } ?>
									</div>
								<?php } ?>
							</div>

						</div>
					</div>
				</div>



			</div>

		</div>
		<!-- ] -->

	<?php } ?>

</div>