<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
$frm->setFormTagAttribute('id', 'sellerProfileLangFrm');
$frm->setFormTagAttribute('class', 'form layout--' . $formLayout);
$frm->developerTags['colClassPrefix'] = 'col-md-';
$frm->developerTags['fld_default_col'] = 12;
$frm->setFormTagAttribute('onsubmit', 'setupSellerProfileLang(this); return(false);');

$submitFld = $frm->getField('btn_submit');
$submitFld->developerTags['noCaptionTag'] = true;

$langFld = $frm->getField('lang_id');
$langFld->setfieldTagAttribute('onChange', "sellerProfileLangForm(this.value);");

$variables = array('language' => $language, 'siteLangId' => $siteLangId, 'shop_id' => $shop_id, 'action' => 'sellerProfile');
$this->includeTemplate('seller/_partial/shop-navigation.php', $variables, false);
?>
<div class="cards">
    <div class="cards-content ">
        <div class="tabs__content">
            <div class="row">
                <div class="col-lg-12 col-md-12">
                    <div class="">
                        <div class="tabs tabs-sm tabs--scroll clearfix">
                            <ul class="setactive-js">
                                <li><a href="javascript:void(0)" onClick="sellerProfile(this)"><?php echo Labels::getLabel('LBL_General', $siteLangId); ?></a></li>
                                <li class="is-active">
                                    <a href="javascript:void(0);">
                                        <?php echo Labels::getLabel('LBL_Language_Data', $siteLangId); ?>
                                    </a>
                                </li>
                                <li>
                                    <a href="javascript:void(0);" onclick="sellerCertificates(<?php echo ShopDocument::SHOP_DOCUMENT_TYPE_QUALITY_CERTIFICATE; ?>);">
                                        <?php echo Labels::getLabel('LBL_Quality_Certificates', $siteLangId); ?>
                                    </a>
                                </li>
                                <li>
                                    <a href="javascript:void(0);" onclick="sellerCertificates(<?php echo ShopDocument::SHOP_DOCUMENT_TYPE_TRADE_SHOW; ?>);">
                                        <?php echo Labels::getLabel('LBL_Trade_Show_Certificates', $siteLangId); ?>
                                    </a>
                                </li>
                                <li>
                                    <a href="javascript:void(0);" onclick="sellerCertificates(<?php echo ShopDocument::SHOP_DOCUMENT_TYPE_INSPECTION_REPORT; ?>);">
                                        <?php echo Labels::getLabel('LBL_Inspection_Report', $siteLangId); ?>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <?php
                    $translatorSubscriptionKey = FatApp::getConfig('CONF_TRANSLATOR_SUBSCRIPTION_KEY', FatUtility::VAR_STRING, '');
                    $siteDefaultLangId = FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1);
                    if (!empty($translatorSubscriptionKey) && $formLangId != $siteDefaultLangId) {
                        ?> 
                        <div class="row justify-content-end"> 
                            <div class="col-auto mb-4">
                                <input class="btn btn-primary" type="button" value="<?php echo Labels::getLabel('LBL_AUTOFILL_LANGUAGE_DATA', $siteLangId); ?>" onClick="sellerProfileLangForm(<?php echo $formLangId; ?>, 1)">
                            </div>
                        </div>
                    <?php } ?>
                    <?php echo $frm->getFormHtml(); ?>
                </div>
            </div>
        </div>
    </div>
</div>
