<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
if (!empty($faqs)) {
    ?>
    <table class="table">
        <thead>
            <tr>
                <th><?php echo Labels::getLabel('LBL_Faq_Title', $siteLangId); ?></th>
                <th></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($faqs as $faq) { ?>
                <tr>
                    <td>
                        <?php echo (empty($faq['faq_title'])) ? $faq['faq_identifier'] : $faq['faq_title']; ?>
                    </td>
                    <td>
                        <ul class="actions">
                            <li>
                                <a href="javascript:void(0);" onclick="addUpdateFaqForm(<?php echo $faq['faq_id']; ?>);" title="<?php echo Labels::getLabel('LBL_Edit', $siteLangId); ?>">
                                    <i class="fa fa-edit"></i>
                                </a>
                            </li>
                            <li>
                                <a href="javascript:void(0);" onclick="deleteFaq(<?php echo $faq['faq_id']; ?>);" title="<?php echo Labels::getLabel('LBL_Delete', $siteLangId); ?>">
                                    <i class="fa fa-trash"></i>
                                </a>
                            </li>
                        </ul>
                    </td>
                </tr>

            <?php } ?>
        </tbody>
    </table>
<?php
} else {
    $message = Labels::getLabel('LBL_No_Records_Found', $siteLangId);
    $this->includeTemplate('_partial/no-record-found.php', array('siteLangId' => $siteLangId, 'message' => $message));
}
?> 
