<?php

defined('SYSTEM_INIT') or die('Invalid Usage.');
$arr_flds = array(
    'listserial' => 'Sr.',
    'selprod_identifier' => Labels::getLabel('LBL_Service_Name', $siteLangId),
    'selprod_price' => Labels::getLabel('LBL_Price', $siteLangId),
    'selprod_active' => Labels::getLabel('LBL_Status', $siteLangId),
    'action' => '',
);

$tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table'));
$th = $tbl->appendElement('thead')->appendElement('tr', array('class' => ''));
foreach ($arr_flds as $val) {
    $e = $th->appendElement('th', array(), $val);
}

$sr_no = ($page == 1) ? 0 : ($pageSize * ($page - 1));
foreach ($arr_listing as $sn => $row) {
    $sr_no++;
    $tr = $tbl->appendElement('tr', array('class' => ''));

    foreach ($arr_flds as $key => $val) {
        $td = $tr->appendElement('td');
        switch ($key) {
            case 'listserial':
                $td->appendElement('plaintext', array(), $sr_no, true);
                break;
            case 'selprod_identifier':
                $td->appendElement('plaintext', array(), $row['selprod_title'] . '<br>', true);
                //$td->appendElement('plaintext', array(), '(' . $row[$key] . ')', true);
                break;
            case 'selprod_price':
                $td->appendElement('plaintext', array(), CommonHelper::displayMoneyFormat($row[$key], true, false), true);
                break;

           case 'selprod_active':
                $active = "";
                if (0 < $row[$key]) {
                    $active = 'checked';
                }
                $status = ($row[$key] + 1) % 2;
                $str = '<label class="toggle-switch" for="switch' . $row['selprod_id'] . '"><input ' . $active . ' type="checkbox" id="switch' . $row['selprod_id'] . '" onclick="changeStatus('.$row['selprod_id'].', '.$status.')"/><div class="slider round"></div></label>';
                $td->appendElement('plaintext', array(), $str, true);
               break;
            case 'action':

                $ul = $td->appendElement("ul", array('class' => 'actions'), '', true);
                $li = $ul->appendElement("li");
                        $li->appendElement(
                            'a',
                            array('href' => CommonHelper::generateUrl('Services', 'form', [$row['selprod_id']]), 'class' => '', 'title' => Labels::getLabel('LBL_Add_To_Store', $siteLangId), true),
                            '<i class="fa fa-edit"></i>',
                            true
                        );
                       
                break;
            default:
                $td->appendElement('plaintext', array(), $row[$key], true);
                break;
        }
    }
}
echo $tbl->getHtml();
if (count($arr_listing) == 0) {
    $message = Labels::getLabel('LBL_No_result_found', $siteLangId);
    $linkArr = array();
    if (User::canAddCustomProductAvailableToAllSellers()) {
        $linkArr = array(
        0 => array(
            'href' => CommonHelper::generateUrl('Services', 'form'),
            'label' => Labels::getLabel('LBL_Request_New_Services', $siteLangId),
            )
        );
    }
    $this->includeTemplate('_partial/no-record-found.php', array('siteLangId' => $siteLangId, 'linkArr' => $linkArr, 'message' => $message));
}


$postedData['page'] = $page;
echo FatUtility::createHiddenFormFromData($postedData, array('name' => 'frmServiceProductSearchPaging'));

$pagingArr = array('pageCount' => $pageCount, 'page' => ($page > 0) ? $page : 1, 'callBackJsFunc' => 'goToServicesProductSearchPage');
$this->includeTemplate('_partial/pagination.php', $pagingArr, false);
