<?php

defined('SYSTEM_INIT') or die('Invalid Usage.');
$arr_flds = array(
    'listserial' => 'Sr.',
    'selprod_identifier' => Labels::getLabel('LBL_Service_Name', $siteLangId),
	'tags' => Labels::getLabel('LBL_Tags', $siteLangId)
);

$tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table'));
$th = $tbl->appendElement('thead')->appendElement('tr', array('class' => ''));

foreach ($arr_flds as $key => $val) {
    if ($key == 'listserial') {
        $e = $th->appendElement('th', array('width' => '5%'), $val);
    } elseif ($key == 'selprod_identifier') {
        $e = $th->appendElement('th', array('width' => '30%'), $val);
    } else {
        $e = $th->appendElement('th', array('width' => '65%'), $val);
    }
}

$sr_no = ($page == 1) ? 0 : ($pageSize * ($page - 1));
foreach ($arr_listing as $sn => $row) {
	$servicesArr[] = $row['selprod_id'];
    $sr_no++;
    $tr = $tbl->appendElement('tr', array('class' => ''));

    foreach ($arr_flds as $key => $val) {
        $td = $tr->appendElement('td');
        switch ($key) {
            case 'listserial':
                $td->appendElement('plaintext', array(), $sr_no, true);
                break;
            case 'selprod_identifier':
                $td->appendElement('plaintext', array(), $row['selprod_title'] . '<br>', true);
                //$td->appendElement('plaintext', array(), '(' . $row[$key] . ')', true);
                break;
			case 'tags':
                $serviceTags = Product::getProductTags($row['selprod_id'],$siteLangId,Tag::TAG_TYPE_SERVICE);
                $tagData = array();
                foreach ($serviceTags as $key => $data) {
                    $tagData[$key]['id'] = $data['tag_id'];
                    $tagData[$key]['value'] = $data['tag_name'];
                }
                $readOnly = (!$canEdit) ? 'readonly' : '';
                $encodedData = json_encode($tagData);
                $td->appendElement('plaintext', array(), "<div class='product-tag scroll-y' id='product".$row['selprod_id']."' data-simplebar><input ".$readOnly." class='tag_name' type='text' name='tag_name".$row['selprod_id']."' value='".$encodedData."' data-product_id='".$row['selprod_id']."'></div>", true);
                break;
            default:
                $td->appendElement('plaintext', array(), $row[$key], true);
                break;
        }
    }
}
echo $tbl->getHtml();
if (count($arr_listing) == 0) {
    $message = Labels::getLabel('LBL_No_result_found', $siteLangId);
    
    $this->includeTemplate('_partial/no-record-found.php', array('siteLangId' => $siteLangId, 'message' => $message));
}


$postedData['page'] = $page;
echo FatUtility::createHiddenFormFromData($postedData, array('name' => 'frmServiceProductSearchPaging'));

$pagingArr = array('pageCount' => $pageCount, 'page' => ($page > 0) ? $page : 1, 'callBackJsFunc' => 'goToServicesProductSearchPage');
$this->includeTemplate('_partial/pagination.php', $pagingArr, false);
?>
<?php if (count($arr_listing) > 0) { ?>
<script>
var servicesArr = [<?php echo '"'.implode('","', $servicesArr).'"' ?>];
$("document").ready(function() {
    getTagsAutoComplete = function(){
        var list = [];
        fcom.ajax(fcom.makeUrl('Seller', 'tagsAutoComplete',[2]), '', function(t) {
            var ans = $.parseJSON(t);
            for (i = 0; i < ans.length; i++) {
                list.push({
                    "id" : ans[i].id,
                    "value" : ans[i].tag_identifier,
                });
            }
        });
        return list;
    }
    var whitelist = getTagsAutoComplete();
    console.log(whitelist);
    $.each(servicesArr, function( index, value ) {
        tagify = new Tagify(document.querySelector('input[name=tag_name'+value+']'), {
               whitelist : whitelist,
               delimiters : "#",
               editTags : false,
               backspace : false
            }).on('add', addTagData).on('remove', removeTagData);
    });

});
</script>
<?php }?>