<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
$mediaForm->setFormTagAttribute('class', 'form');
$mediaForm->developerTags['colClassPrefix'] = 'col-md-';
$mediaForm->developerTags['fld_default_col'] = 4;

$fld = $mediaForm->getField('service_image');
$fld->addFieldTagAttribute('class', 'btn btn--sm');
$fld->addFieldTagAttribute('onChange', 'popupImage(this)');

echo $mediaForm->getFormHtml();
?>

<script type="text/javascript">
    (function () {
        popupImage = function (inputBtn) {
            if (inputBtn.files && inputBtn.files[0]) {
                fcom.ajax(fcom.makeUrl('Seller', 'imgCropper'), '', function (t) {
                    $.facebox(t, 'faceboxWidth');
                    var file = inputBtn.files[0];
                    //var minWidth = $('#frmCustomCatalogProductImage input[name="min_width"]').val();
                    //var minHeight = $('#frmCustomCatalogProductImage input[name="minHeight"]').val();
                    let minWidth = 500;
                    let minHeight = 500;
                    var options = {
                        aspectRatio: 1 / 1,
                        data: {
                            width: minWidth,
                            height: minHeight,
                        },
                        minCropBoxWidth: minWidth,
                        minCropBoxHeight: minHeight,
                        toggleDragModeOnDblclick: false,
                    };
                    return cropImage(file, options, 'uploadImage', inputBtn);
                });
            }
        };
    })();


    uploadImage = function (formData) {
        let service_id = $('input[name="service_id"]').val();
        let lang_id = $('select[name="lang_id"]').val();

        formData.append('service_id', service_id);
        formData.append('lang_id', lang_id);
        
        var service__id = $('input[name="service__id"]').val();
        
        $.ajax({
            url: fcom.makeUrl('Services', 'setupImage'),
            type: 'post',
            dataType: 'json',
            data: formData,
            cache: false,
            contentType: false,
            processData: false,
            beforeSend: function () {
                $('#loader-js').html(fcom.getLoader());
            },
            complete: function () {
                $('#loader-js').html(fcom.getLoader());
            },
            success: function (ans) {
                if (ans.status != 1) {
                    $.mbsmessage(ans.msg, true, 'alert--danger');    
                } else {
                    $.mbsmessage(ans.msg, true, 'alert--success');    
                }
                
                $(document).trigger('close.facebox');
                mediaListing();
				document.imageFrm.reset();
				setTimeout(function(){ $("html").removeClass('pop-on'); }, 2000); //Time before execution
            },
            error: function (xhr, ajaxOptions, thrownError) {
                alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
            }
        });
    };
</script>