<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<?php $this->includeTemplate('_partial/seller/sellerDashboardNavigation.php'); ?>
<main id="main-area" class="main" role="main">
    <div class="content-wrapper content-space">
        <div class="content-header row">
            <div class="col">
                <?php $this->includeTemplate('_partial/dashboardTop.php'); ?>
                <h2 class="content-header-title"><?php echo Labels::getLabel('LBL_Services', $siteLangId); ?></h2>
            </div>
            <div class="col-auto">
                <div class="btn-group">
                    <a class="btn btn-outline-primary btn--sm" title="<?php echo Labels::getLabel('LBL_Add_Service', $siteLangId); ?>"  href="<?php echo CommonHelper::generateUrl('Services', 'form'); ?>"><?php echo Labels::getLabel('LBL_Add_Service', $siteLangId); ?></a>
                </div>
            </div>
        </div>
        <div class="content-body">
            <div class="row mb-4">
                <div class="col-lg-12">
                    <div class="cards">
                        <div class="cards-content">
                            <div class="replaced">
                                <?php
                                $searchForm->setFormTagAttribute('id', 'frmSearchService');
                                $searchForm->setFormTagAttribute('class', 'form');
                                $searchForm->setFormTagAttribute('onsubmit', 'searchServiceProducts(this); return(false);');
                                $searchForm->getField('keyword')->addFieldTagAttribute('placeholder', Labels::getLabel('LBL_Search_by_', $siteLangId));
                                $searchForm->developerTags['colClassPrefix'] = 'col-md-';
                                $searchForm->developerTags['fld_default_col'] = 12;

                                $keywordFld = $searchForm->getField('keyword');
                                $keywordFld->setWrapperAttribute('class', 'col-lg-6');
                                $keywordFld->developerTags['col'] = 6;


                                $typeFld = $searchForm->getField('service_active');
                                $typeFld->setWrapperAttribute('class', 'col-lg-2');
                                $typeFld->developerTags['col'] = 2;

                                $submitFld = $searchForm->getField('btn_submit');
                                $submitFld->setFieldTagAttribute('class', 'btn--block btn btn--primary');
                                $submitFld->setWrapperAttribute('class', 'col-lg-2');
                                $submitFld->developerTags['col'] = 2;

                                $fldClear = $searchForm->getField('btn_clear');
                                $fldClear->setFieldTagAttribute('onclick', 'clearSearch()');
                                $fldClear->setFieldTagAttribute('class', 'btn--block btn btn-outline-primary');
                                $fldClear->setWrapperAttribute('class', 'col-lg-2');
                                $fldClear->developerTags['col'] = 2;

                                echo $searchForm->getFormHtml();
                                ?>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="cards">
                        <div class="cards-content">
                            <div id="services-products-listing-js"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<script type="text/javascript">
    (function () {
        var runningAjaxMsg = 'some requests already running or this stucked into runningAjaxReq variable value, so try to relaod the page and update the same to WebMaster. ';
        var runningAjaxReq = false;
        var dv = '#services-products-listing-js';

        checkRunningAjax = function () {
            if (runningAjaxReq == true) {
                console.log(runningAjaxMsg);
                return;
            }
            runningAjaxReq = true;
        };

        searchServiceProducts = function (frm) {
            checkRunningAjax();
            /*[ this block should be written before overriding html of 'form's parent div/element, otherwise it will through exception in ie due to form being removed from div */
            var data = fcom.frmData(frm);
            /*]*/
            $(dv).html(fcom.getLoader());

            fcom.ajax(fcom.makeUrl('Services', 'search'), data, function (res) {
                runningAjaxReq = false;
                $(dv).html(res);
            });
        };

        clearSearch = function () {
            document.frmSearchService.reset();
            searchServiceProducts(document.frmSearchService);
        };

        goToServicesProductSearchPage = function (page) {
            if (typeof page == undefined || page == null || page == '' || page < 1) {
                page = 1;
            }
            var frm = document.frmSearchService;
            $(frm.page).val(page);
            searchServiceProducts(frm);
        }

    })();

    function changeStatus(serviceId, status)
    {
        var data = 'serviceId=' + serviceId + '&status=' + status;
        fcom.updateWithAjax(fcom.makeUrl('Services', 'changeStatus'), data, function (t) {
            window.location.reload();
        });
    }
    searchServiceProducts();
</script>