<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<span class="shippingTabListing--js">
    <?php
    if (!empty($shipping_rates) && count($shipping_rates) > 0) {
        $shipping_row = 0;
        foreach ($shipping_rates as $key => $shipping) {
            ?>
            <div class="row align-items-center shippingRow--js" id="shipping-row<?php echo $shipping_row; ?>">
                <div class="col-lg-2 p-10">
                    <div class="field-set">
                        <input type="hidden" name="product_shipping[<?php echo $shipping_row; ?>][pship_id]" value="<?php echo $shipping['pship_id']; ?>">
                        <input type="hidden" name="product_shipping[<?php echo $shipping_row; ?>][country_id]" value="<?php echo $shipping["pship_country"] ?>">
                        <input type="text"
                               name="product_shipping[<?php echo $shipping_row; ?>][country_name]"
                               value="<?php echo $shipping["pship_country"] != "1" ? $shipping["country_name"] : "&#8594;" . Labels::getLabel('LBL_EveryWhere_Else', $siteLangId); ?>"
                               placeholder="<?php echo Labels::getLabel('LBL_Destination_Country', $siteLangId) ?>" class="pship_country" data-row="<?php echo $shipping_row; ?>">
                        <span class="country-select--js"></span>
                    </div>

                </div>
                <div class="col-lg-2 p-10">
                    <div class="field-set">
                        <input type="hidden" name="product_shipping[<?php echo $shipping_row; ?>][state_id]" value="<?php echo $shipping["pship_state_id"] ?>">
                        <input type="text"
                               name="product_shipping[<?php echo $shipping_row; ?>][state_name]"
                               value="<?php echo $shipping["pship_state_id"] != "1" ? $shipping["state_name"] : "&#8594;" . Labels::getLabel('LBL_EveryWhere_Else', $siteLangId); ?>"
                               placeholder="<?php echo Labels::getLabel('LBL_Destination_State', $siteLangId) ?>" class="pship_country" data-row="<?php echo $shipping_row; ?>">
                    </div>
                </div>

                <div class="col-lg-2 p-10">
                    <div class="field-set">
                        <input type="hidden" name="product_shipping[<?php echo $shipping_row; ?>][company_id]" value="<?php echo $shipping["pship_company"] ?>">
                        <input type="text" name="product_shipping[<?php echo $shipping_row; ?>][company_name]" value="<?php echo $shipping["scompany_name"] ?>" placeholder="<?php echo Labels::getLabel('LBL_Shipping_Company', $siteLangId); ?>" class="pship_company" data-row="<?php echo $shipping_row; ?>">
                    </div>
                </div>
                <div class="col-lg-2 p-10">
                    <div class="field-set">
                        <input type="hidden" name="product_shipping[<?php echo $shipping_row; ?>][processing_time_id]" value="<?php echo $shipping['pship_duration'] ?>">
                        <input type="text" name="product_shipping[<?php echo $shipping_row; ?>][processing_time]" value="<?php echo ShippingDurations::getShippingDurationTitle($shipping, $siteLangId) ?>"
                               placeholder="<?php echo Labels::getLabel('LBL_Shipping_Service_Type', $siteLangId) ?>" class="pship_duration" data-row="<?php echo $shipping_row; ?>">
                    </div>
                </div>

                <div class="col-lg-1 p-10">
                    <div class="field-set">
                        <input type="number" name="product_shipping[<?php echo $shipping_row; ?>][min_qty]" value="<?php echo $shipping["pship_min_qty"] ?>" placeholder="<?php echo Labels::getLabel('LBL_Min_Qty', $siteLangId); ?>" min="1">
                    </div>
                </div>
                <div class="col-lg-1 p-10">
                    <div class="field-set">
                        <div class="icon-group">
                            <input class="max-qty-fld" type="number" name="product_shipping[<?php echo $shipping_row; ?>][max_qty]" value ="<?php echo $shipping["pship_max_qty"] ?>" placeholder="<?php echo Labels::getLabel('LBL_Max_Qty', $siteLangId); ?>">
                            <i class="fa fa-info-circle info-button--css" data-toggle="tooltip" data-placement="right" title="" data-original-title="<?php echo Labels::getLabel('LBL_Use_-1_For_Unlimited', $siteLangId) ?>"></i>
                        </div>
                    </div>
                </div>

                <div class="col-lg-2 p-10">
                    <div class="field-set">
                        <div class="icon-group">
                        <?php /* echo (in_array($shipping['sduration_id'], $freeShippingLabels)) ? "disabled" : ""; */ ?>
                            <input type="text"  name="product_shipping[<?php echo $shipping_row; ?>][cost]" value="<?php echo $shipping["pship_charges"] ?>" placeholder="<?php echo Labels::getLabel('LBL_RATE', $siteLangId) . ' [' . commonHelper::getDefaultCurrencySymbol() . ']'; ?>">
                            <button type="button" onclick="removeShippingRow('<?php echo $shipping_row; ?>');" class="btn btn--secondary ripplelink" title="<?php echo Labels::getLabel('LBL_Remove', $siteLangId) ?>" style="<?php if ($shipping_row == 0) { ?> display:none;<?php } else { ?> display:block; <?php } ?>">
                                <i class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            <?php
            $shipping_row++;
        }
    } else {
        ?>
        <div class="row align-items-center shippingRow--js" id="shipping-row0">
            <div class="col-lg-2 p-10">
                <div class="field-set">
                    <input type="hidden" name="product_shipping[0][pship_id]" value="" />
                    <input type="hidden" name="product_shipping[0][country_id]" value="0">
                    <input type="text" name="product_shipping[0][country_name]" placeholder="<?php echo Labels::getLabel('LBL_Destination_Country"', $siteLangId) ?>" />
                    <span class="country-select--js"></span>
                </div>
            </div>
            <div class="col-lg-2 p-10">
                <div class="field-set">
                    <input type="hidden" name="product_shipping[0][state_id]">
                    <input type="text" name="product_shipping[0][state_name]" placeholder="<?php echo Labels::getLabel('LBL_Destination_State"', $siteLangId) ?>" />
                </div>
            </div>

            <div class="col-lg-2 p-10">
                <div class="field-set">
                    <input type="hidden" name="product_shipping[0][company_id]">
                    <input type="text" name="product_shipping[0][company_name]" placeholder="<?php echo Labels::getLabel('LBL_Shipping_Company', $siteLangId) ?>">
                </div>
            </div>
            <div class="col-lg-2 p-10">
                <div class="field-set">
                    <input type="hidden" name="product_shipping[0][processing_time_id]">
                    <input type="text" name="product_shipping[0][processing_time]" placeholder="<?php echo Labels::getLabel('LBL_Shipping_Service_Type', $siteLangId) ?>">
                </div>
            </div>
            <div class="col-lg-1 p-10">
                <div class="field-set">
                    <input type="number" name="product_shipping[0][min_qty]" placeholder="<?php echo Labels::getLabel('LBL_Min_Qty', $siteLangId); ?>" min="1">
                </div>
            </div>
            <div class="col-lg-1 p-10">
                <div class="field-set">
                    <input class="max-qty-fld" type="number" name="product_shipping[0][max_qty]" placeholder="<?php echo Labels::getLabel('LBL_Max_Qty', $siteLangId); ?>">
                    <i class="fa fa-info-circle info-button--css" data-toggle="tooltip" data-placement="right" title="" data-original-title="<?php echo Labels::getLabel('LBL_Use_-1_For_Unlimited', $siteLangId) ?>"></i>
                </div>
            </div>
            <div class="col-lg-2 p-10">
                <div class="field-set">
                    <div class="icon-group">
                        <input type="text" id="remove-shipping-input" name="product_shipping[0][cost]" placeholder="<?php echo Labels::getLabel('LBL_RATE', $siteLangId) . ' [' . commonHelper::getDefaultCurrencySymbol() . ']'; ?>">
                        <button type="button" onclick="removeShippingRow('0')" class="btn btn--secondary ripplelink" title="<?php echo Labels::getLabel('LBL_Remove', $siteLangId) ?>" style="display:none;">
                            <i class="fa fa-minus"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    <?php } ?>
</span>
<div class="row align-items-center justify-content-end">
    <div class="col-auto p-10">
        <button type="button" class="btn btn--secondary ripplelink" id="add-more-shipping-rates" title="<?php echo Labels::getLabel('LBL_Shipping', $siteLangId) ?>" onclick="addShipping();">
            <i class="fa fa-plus"></i> 
        </button>
    </div>
</div>
<script>
    
    checkFreeShipping();
    function checkFreeShipping(){
        if ($('#ps_free').is(':checked') == true){
            $('[name$="][cost]"').attr('disabled', 'disabled');
        } else {
            $('[name$="][cost]"').removeAttr('disabled');
        }
    }
    addShipping = function () {
        var shipping_row = parseInt($("span.shippingTabListing--js div.shippingRow--js").length);
        //$("span.shippingTabListing--js div.shippingRow--js:last").clone().appendTo('span.shippingTabListing--js');
        var new_row = $("span.shippingTabListing--js div.shippingRow--js:last").clone();
        new_row.appendTo('span.shippingTabListing--js');
        new_row.attr("id", "shipping-row" + shipping_row);

        $("span.shippingTabListing--js div.shippingRow--js:last input").each(function () {
            $(this).val("");
            var name = $(this).attr("name");
            var newName = name.replace("[" + (shipping_row - 1) + "]", "[" + (shipping_row) + "]");
            $(this).attr("name", newName);
            $(this).next('button').attr("onclick", 'removeShippingRow(' + shipping_row + ')');
        });


        $('input[name="product_shipping[' + shipping_row + '][country_name]"]').siblings('.country-select--js').html('');
        $('input[name="product_shipping[' + shipping_row + '][country_id]"]').val(0);
        $('input[name="product_shipping[' + shipping_row + '][country_name]"]').attr('data-row', shipping_row);
        $('input[name="product_shipping[' + shipping_row + '][company_name]"]').attr('data-row', shipping_row);
        $('input[name="product_shipping[' + shipping_row + '][state_name]"]').attr('data-row', shipping_row);
        $('input[name="product_shipping[' + shipping_row + '][processing_time]"]').attr('data-row', shipping_row);
        if (shipping_row > 0) {
            /* $('input[name="product_shipping[' + shipping_row + '][additional_cost]"]').next('button').css('display', 'block'); */
            $('input[name="product_shipping[' + shipping_row + '][cost]"]').next('button').css('display', 'block');
        }
        shippingautocomplete(shipping_row);
    }
    removeShippingRow = function (shipping_row) {
        var rowLen = parseInt($("span.shippingTabListing--js div.shippingRow--js").length);
        if (rowLen == 1) {
            return false;
        }
        $("#shipping-row" + shipping_row).remove();
    }
    $('span.shippingTabListing--js div.shippingRow--js').each(function (index, element) {
        shippingautocomplete(index);
    });


    $(document).on('change', '.pship_country', function () {
        if ($(this).val() == '') {
            var row = $(this).attr('data-row');
            $('input[name="product_shipping[' + row + '][country_id]"]').val(0);
        }
    });

    $(document).on('change', '.pship_company', function () {
        if ($(this).val() == '') {
            var row = $(this).attr('data-row');
            $('input[name="product_shipping[' + row + '][company_id]"]').val(0);
        }

    });

    $(document).on('change', '.pship_duration', function () {
        if ($(this).val() == '') {
            var row = $(this).attr('data-row');
            $('input[name="product_shipping[' + row + '][processing_time_id]"]').val(0);
        }
    });

</script>
<style>
    #tab_shipping {
        padding: 8px;
    }
    .p-10 {
        padding: 5px;
    }
    .info-button--css{
        position: absolute;
        right: 10px;
        top: 30px;
    }

    /* Chrome, Safari, Edge, Opera */
    input::-webkit-outer-spin-button,
    input::-webkit-inner-spin-button {
        -webkit-appearance: none;
        margin: 0;
    }

    /* Firefox */
    input[type=number] {
        -moz-appearance: textfield;
    }

    #tab_shipping .align-items-center {
        align-items: baseline !important;
    }

    @media (min-width: 992px) {
        #tab_shipping  .col-lg-2 {
            flex: 0 0 15.666667%;
            max-width: 15.6666666667%;
        }

        #tab_shipping  .col-lg-1 {
            flex: 0 0 10.333333%;
            max-width: 10.333333%;
        }
    }
    .max-qty-fld{padding-right: 25px !important;}
</style>