<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="box box--white box--radius order-summary">
    <?php if (!empty($defaultAddress)) { ?>
        <div class="p-4">
            <div class="section-head">
                <div class="section__heading">
                    <h6>
                        <?php
                        if ($hasPhysicalProd) {
                            echo Labels::getLabel('LBL_Shipping_to:', $siteLangId);
                        } else {
                            echo Labels::getLabel('LBL_Billing_to:', $siteLangId);
                        }
                        ?>
                    </h6>
                </div>
            </div>
            <div class="shipping-address">
                <?php /* echo $defaultAddress['ua_identifier']; */ ?>
                <?php echo $defaultAddress['oua_name']; ?><br>
                <?php echo $defaultAddress['oua_address1']; ?><br>
                <?php echo $defaultAddress['oua_city']; ?>, <?php echo $defaultAddress['oua_state']; ?>, <?php echo (strlen($defaultAddress['oua_zip']) > 0) ? Labels::getLabel('LBL_Zip:', $siteLangId) . ' ' . $defaultAddress['oua_zip'] . '<br>' : ''; ?>
                <?php echo (strlen($defaultAddress['oua_phone']) > 0) ? Labels::getLabel('LBL_Phone:', $siteLangId) . ' ' . $defaultAddress['oua_phone'] . '<br>' : ''; ?>
            </div>
        </div>
        <div class="divider"></div>
    <?php } ?>
    <div class="p-4">
        <div class="section-head">
            <div class="section__heading">
                <h6><?php echo Labels::getLabel('LBL_Order_Summary', $siteLangId); ?></h6>
            </div>
        </div>
        <div class="scrollbar-order-list" data-simplebar>
            <table class="table table--justify cart-summary order-table">
                <tbody>
                    <?php /* foreach ($products as $product) { */ ?>
                    <tr class="physical_product_tab-js">
                        <td>
                            <?php $productUrl = CommonHelper::generateUrl('Products', 'View', array($product['selprod_id'])); ?>
                            <div class="item__pic"><a href="<?php echo $productUrl; ?>"><img src=<?php echo FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'product', array($product['selprod_product_id'], "THUMB", $product['selprod_id'], 0, $siteLangId)), CONF_IMG_CACHE_TIME, '.jpg'); ?>" alt="<?php echo $product['op_product_name']; ?>" title="<?php echo $product['op_product_name']; ?>"></a></div>
                        </td>
                        <td>
                            <div class="item__description">
                                <div class="item__title"><a title="<?php echo $product['op_product_name'] ?>" href="<?php echo $productUrl; ?>"><?php echo $product['op_product_name'] ?></a></div>
                                <div class="item__title"><a title="<?php echo $product['op_product_name'] ?>" href="<?php echo $productUrl; ?>"><?php echo $product['op_selprod_title'] ?></a></div>
                                <div class="item__specification">
                                    <?php echo $product['op_selprod_options']; ?> <br />
                                    <?php echo Labels::getLabel('LBL_Quantity', $siteLangId); ?>: <?php echo $product['op_qty']; ?> </div>
                            </div>
                        </td>
                        <td>
                            <div class="product_price">
                                <span class="item__price"><?php echo CommonHelper::displayMoneyFormat($product['op_unit_price'] * $product['op_qty']); ?></span>
                            </div>
                        </td>
                    </tr>
                    <?php /* } */ ?>
                </tbody>
            </table>

        </div>
    </div>
    <div class="divider"></div>
    <div class="p-4">
        <div class="cartdetail__footer">
            <table class="table--justify">
                <tbody>
                    <tr>
                        <td><?php echo Labels::getLabel('LBL_Sub_Total', $siteLangId); ?></td>
                        <td> <?php echo CommonHelper::displayMoneyFormat($cartSummary['cartTotal']); ?></td>
                    </tr>
                    <?php if (FatApp::getConfig('CONF_TAX_AFTER_DISOCUNT', FatUtility::VAR_INT, 0) && !empty($cartSummary['cartDiscounts'])) { ?>
                        <tr>
                            <td><?php echo Labels::getLabel('LBL_Discount', $siteLangId); ?></td>
                            <td><?php echo CommonHelper::displayMoneyFormat($cartSummary['cartDiscounts']['coupon_discount_total']); ?></td>
                        </tr>
                    <?php } ?>

                    <?php
                    if ($cartSummary['taxOptions']) {
                        $taxOptions = json_decode(html_entity_decode($cartSummary['taxOptions']), true);
                        foreach ($taxOptions as $taxName => $taxVal) {
                    ?>
                            <tr>
                                <td><?php echo $taxVal['name']; ?></td>
                                <td><?php echo CommonHelper::displayMoneyFormat($taxVal['value']); ?></td>
                            </tr>
                    <?php
                        }
                    }
                    ?>

                    <?php if ($cartSummary['originalShipping']) { ?>
                        <tr>
                            <td><?php echo Labels::getLabel('LBL_Delivery_Charges', $siteLangId); ?></td>
                            <td><?php echo CommonHelper::displayMoneyFormat($cartSummary['shippingTotal']); ?></td>
                        </tr>
                    <?php } ?>

                    <tr>
                        <td><?php echo Labels::getLabel('LBL_Total_Amount', $siteLangId); ?></td>
                        <td><?php echo CommonHelper::displayMoneyFormat($cartSummary['orderNetAmount']); ?></td>
                    </tr>
                    <?php if ($cartSummary['total_paid_amount'] > 0) { ?>
                        <tr>
                            <td><?php echo Labels::getLabel('LBL_Paid_Amount', $siteLangId); ?></td>
                            <td><?php echo CommonHelper::displayMoneyFormat($cartSummary['total_paid_amount']); ?></td>
                        </tr>
                    <?php } ?>
                    <tr>
                        <td><?php echo Labels::getLabel('LBL_Amount_To_Pay', $siteLangId); ?></td>
                        <td><?php echo CommonHelper::displayMoneyFormat($cartSummary['orderPaymentGatewayCharges']); ?></td>
                    </tr>

                    <tr>
                        <td><?php echo Labels::getLabel('LBL_Remaining_Balance', $siteLangId); ?></td>
                        <td><?php echo CommonHelper::displayMoneyFormat(($cartSummary['orderNetAmount'] - $cartSummary['orderPaymentGatewayCharges'] - $cartSummary['total_paid_amount'] - $cartSummary['WalletAmountCharge'])); ?></td>
                    </tr>

                </tbody>
            </table>
        </div>
    </div>
</div>