<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
$arr_flds = array(
    'listserial'=>'Sr.',
    'selprod_title' => Labels::getLabel('LBL_Product_name', $siteLangId),
    'requestd_count' => Labels::getLabel('LBL_No._of_Received_Quotations', $siteLangId),
    'unread_count' => Labels::getLabel('LBL_No._of_Unread_Quotations', $siteLangId),
    'action' => Labels::getLabel('LBL_Action', $siteLangId),
);
$tbl = new HtmlElement('table', array('width'=>'100%', 'class'=>'table'));
$th = $tbl->appendElement('thead')->appendElement('tr', array('class' => ''));
foreach ($arr_flds as $val) {
    $e = $th->appendElement('th', array(), $val);
}

$sr_no = ($page == 1) ? 0 : ($pageSize*($page-1));
foreach ($arr_listing as $sn => $row) {
    $sr_no++;
    $link = CommonHelper::generateUrl('RequestForQuotes', 'productQuotes', array($row['rfq_selprod_id']));
    $tr = $tbl->appendElement('tr', array('class' => ''));

    foreach ($arr_flds as $key => $val) {
        $td = $tr->appendElement('td');
        switch ($key) {
            case 'listserial':
                $td->appendElement('plaintext', array(), $sr_no, true);
                break;
            case 'action':
                $td->appendElement(
                        'a',
                        array('href'=>$link, 'class'=>'btn btn--primary btn--sm', 'title'=>Labels::getLabel('LBL_View', $siteLangId)),
                        Labels::getLabel('LBL_View', $siteLangId),
                        true
                    );
                break;
            default:
                $td->appendElement('plaintext', array(), $row[$key], true);
                break;
        }
    }
}

echo $tbl->getHtml();
if (count($arr_listing) == 0) {
    $message = Labels::getLabel('LBL_No_Record_found', $siteLangId);
    $this->includeTemplate('_partial/no-record-found.php', array('siteLangId'=>$siteLangId,'message'=>$message));
}
$postedData['page'] = $page;
echo FatUtility::createHiddenFormFromData($postedData, array('name' => 'frmSearchQuotesRequestsPaging'));
$pagingArr=array('pageCount'=>$pageCount,'page'=>$page,'callBackJsFunc' => 'goToSearchPage');
$this->includeTemplate('_partial/pagination.php', $pagingArr, false);
