<?php

defined('SYSTEM_INIT') or die('Invalid Usage.');
$arr_flds = array(
    'rfq_id' => Labels::getLabel('LBL_Request_ID', $siteLangId),
    'selprod_title' => Labels::getLabel('LBL_Product_name', $siteLangId),
    'rfq_quantity' => Labels::getLabel('LBL_Qty', $siteLangId),
    'rfq_capacity' => Labels::getLabel('LBL_Capacity', $siteLangId),
    'rfq_added_on' => Labels::getLabel('LBL_Date', $siteLangId),
    'rfq_status' => Labels::getLabel('LBL_Status', $siteLangId),
    'action' => Labels::getLabel('LBL_Action', $siteLangId),
);

$tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table'));
$th = $tbl->appendElement('thead')->appendElement('tr', array('class' => ''));
foreach ($arr_flds as $val) {
    $e = $th->appendElement('th', array(), $val);
}

foreach ($arr_listing as $sn => $row) {
    $link = CommonHelper::generateUrl('RequestForQuotes', 'requestView', array($row['rfq_id']));
    $tr = $tbl->appendElement('tr', array('class' => ''));

    foreach ($arr_flds as $key => $val) {
        $td = $tr->appendElement('td');
        switch ($key) {
            case 'rfq_id':
                $td->appendElement('plaintext', array(), '#' . $row[$key], true);
                break;
            case 'rfq_status':
                $td->appendElement('plaintext', array(), $statusArr[$row[$key]], true);
                break;
            case 'rfq_added_on':
                $td->appendElement('plaintext', array(), FatDate::Format($row[$key]), true);
                break;
            case 'action':
                $td->appendElement(
                    'a',
                    array('href' => $link, 'class' => 'btn btn--primary btn--sm', 'title' => Labels::getLabel('LBL_View', $siteLangId)),
                    Labels::getLabel('LBL_View', $siteLangId),
                    true
                );
                switch ($row['rfq_status']) {
                    case RequestForQuote::REQUEST_CANCELLED_BY_BUYER:
                    case RequestForQuote::REQUEST_DECLINED_BY_SELLER:
                    case RequestForQuote::REQUEST_CLOSED_BY_ADMIN:
                    case RequestForQuote::REQUEST_QUOTE_VALIDITY:
                        if ($row['selprod_type'] == SellerProduct::PRODUCT_TYPE_SERVICE) {
                            $onClick = 'rfqForService(' . $row['rfq_selprod_id'] . ', ' . $row['rfq_id'] . ')';
                        } else {
                            $onClick = 'RequestForQuote(' . $row['rfq_selprod_id'] . ', ' . $row['rfq_id'] . ')';
                        }
                        $td->appendElement(
                            'a',
                            array('href' => "javascript:void(0);", 'onClick' => $onClick, 'class' => 'btn btn--primary btn--sm', 'title' => Labels::getLabel('LBL_Re-Quote', $siteLangId)),
                            Labels::getLabel('LBL_Re-Quote', $siteLangId),
                            true
                        );
                        break;
                }
                break;
            default:
                $td->appendElement('plaintext', array(), $row[$key], true);
                break;
        }
    }
}

echo $tbl->getHtml();
if (count($arr_listing) == 0) {
    $message = Labels::getLabel('LBL_No_Record_found', $siteLangId);
    $this->includeTemplate('_partial/no-record-found.php', array('siteLangId' => $siteLangId, 'message' => $message));
}
$postedData['page'] = $page;
echo FatUtility::createHiddenFormFromData($postedData, array('name' => 'frmSearchProductQuotesPaging'));

$pagingArr = array('pageCount' => $pageCount, 'page' => $page, 'callBackJsFunc' => 'goToSearchPage');
$this->includeTemplate('_partial/pagination.php', $pagingArr, false);
