<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
$frm->setFormTagAttribute('class', 'form');
$frm->setFormTagAttribute('onsubmit', 'setupRequestForQuote(this); return(false);');


$addressFrm->setFormTagAttribute('id', 'addressFrm');
$addressFrm->setFormTagAttribute('class', 'form');
$addressFrm->developerTags['colClassPrefix'] = 'col-sm-12 col-md-';
$addressFrm->developerTags['fld_default_col'] = 12;
$addressFrm->setFormTagAttribute('onsubmit', 'setupNewUserAddress(this); return(false);');

$countryFld = $addressFrm->getField('ua_country_id');
$countryFld->setFieldTagAttribute('id', 'ua_country_id');
$countryFld->setFieldTagAttribute('onChange', 'getCountryStates(this.value,' . $stateId . ',\'#ua_state_id\')');

$stateFld = $addressFrm->getField('ua_state_id');
$stateFld->setFieldTagAttribute('id', 'ua_state_id');
$cancelFld = $addressFrm->getField('btn_cancel');
$cancelFld->setFieldTagAttribute('onclick', 'resetAddressForm(true)');
$cancelFld->setFieldTagAttribute('class', 'btn btn-outline-primary btn-block');
//$cancelFld->developerTags['col'] = 2;
$cancelFld->developerTags['noCaptionTag'] = true;

$submitFld = $addressFrm->getField('btn_submit');
$submitFld->setFieldTagAttribute('class', 'btn btn--primary btn-block');
//$submitFld->developerTags['col'] = 2;
$submitFld->developerTags['noCaptionTag'] = true;

?>



<div class="contact-panel">


	<div id="manage-address-js" class="contact-panel__sidebar">
		<div class="contact-panel__head">
			<div class="d-flex align-items-center justify-content-between">
				<div>
					<h5 class="mb-0"><?php echo Labels::getLabel("LBL_Add_New_Address", $siteLangId); ?></h5>
				</div>
				<div><a href="javascript:void(0)" class="close-btn add-trigger-js is-active"></a></div>
			</div>
		</div>

		<div class="contact-panel__body">
			<?php echo $addressFrm->getFormHtml(); ?>
		</div>
	</div>


	<!-- [ PANEL SMALL =========== -->
	<div class="contact-panel__large">

		<div class="quick-form">
			<div class="quick-form__head mb-5">
				<h4><?php echo Labels::getLabel('Lbl_Looking_to_buy_this_product?_Get_a_free_quote', $siteLangId); ?></h4>
				<p><?php echo Labels::getLabel('Lbl_Tell_your_requirement_and_please_fill_out', $siteLangId); ?></p>
			</div>
			<div class="quick-form__body">

				<?php echo $frm->getFormTag(); ?>

				<div class="row">

					<div class="col-lg-4 col-sm-12">
						<div class="field-set">
							<div class="caption-wraper">
								<label class="field_label">
									<?php $fld = $frm->getField('rfq_required_capacity');
									echo $fld->getCaption();
									?>
								</label>
							</div>
							<div class="field-wraper">
								<div class="field_cover">
									<?php echo $frm->getFieldHtml('rfq_required_capacity'); ?>
								</div>
							</div>
						</div>
					</div>

					<div class="col-lg-4 col-sm-12">
						<div class="field-set">
							<div class="caption-wraper">
								<label class="field_label">
									<?php
									$fld = $frm->getField('rfq_quantity');
									echo $fld->getCaption();
									?>
									<span class="spn_must_field">*</span></label>
							</div>
							<div class="field-wraper">
								<div class="field_cover">
									<?php echo $frm->getFieldHtml('rfq_quantity'); ?>
								</div>
							</div>
						</div>
					</div>

					<div class="col-lg-4 col-sm-12">
						<div class="field-set">
							<div class="caption-wraper">
								<label class="field_label">
									<?php
									$fld = $frm->getField('rfq_delivery_time');
									echo $fld->getCaption();
									?>
									<span class="spn_must_field">*</span></label>
							</div>
							<div class="field-wraper">
								<div class="field_cover">
									<?php echo $frm->getFieldHtml('rfq_delivery_time'); ?>
								</div>
							</div>
						</div>
					</div>


					<?php
					$commentFldClass = 'col-lg-12 col-sm-12';
					if ($productData['selprod_type'] == SellerProduct::PRODUCT_TYPE_SERVICE && $productData['selprod_document_required'] == AppConstants::YES) {
						$commentFldClass = 'col-lg-12 col-sm-12';
					}
					?>
					<div class="<?php echo $commentFldClass; ?>">
						<div class="field-set">
							<div class="caption-wraper">
								<label class="field_label">
									<?php
									$fld = $frm->getField('rfq_comments');
									echo $fld->getCaption();
									?>
									<span class="spn_must_field">*</span></label>
							</div>
							<div class="field-wraper">
								<div class="field_cover">
									<?php echo $frm->getFieldHtml('rfq_comments'); ?>
								</div>
							</div>
						</div>
					</div>




					<?php
					if ($productData['selprod_type'] == SellerProduct::PRODUCT_TYPE_SERVICE && $productData['selprod_document_required'] == AppConstants::YES) {
					?>
						<div class="col-lg-12 col-sm-12" id="document-fld-js">
							<div class="field-set">
								<div class="caption-wraper">
									<label class="field_label">
										<?php echo Labels::getLabel('LBL_Upload_documents', $siteLangId); ?>
										<span class="spn_must_field">*</span>
									</label>
								</div>
								<div class="field-wraper">
									<div class="field_cover">
										<input type="file" name="rfq_documents" onchange="uploadDocument()" />
									</div>
									<div id="uploaded-documents-js" class="uploaded--documents"></div>
								</div>
							</div>
						</div>
					<?php } ?>


					<?php if (!empty($services)) { ?>
						<table class="table table-services">
							<tbody>
								<?php foreach ($services as $serviceId => $val) { ?>
									<tr class="<?php echo ($val['selprod_document_required']) ? "no-border-row" : ""; ?>">
										<td>
											<h6><span class="primary-color"><?php echo $val['selprod_title']; ?></span></h6>
										</td>
										<td>
											<div class="field-set">
												<div class="caption-wraper">
													<label class="field_label">
														<?php
														$fld = $frm->getField('rfq_required_capacity_service[' . $serviceId . ']');
														echo $fld->getCaption();
														?>
													</label>
												</div>
												<div class="field-wraper">
													<div class="field_cover">
														<?php echo $frm->getFieldHtml('rfq_required_capacity_service[' . $serviceId . ']'); ?>
													</div>
												</div>
											</div>
										</td>
										<td>
											<div class="field-set">
												<div class="caption-wraper">
													<label class="field_label">
														<?php
														$fld = $frm->getField('rfq_quantity_service[' . $serviceId . ']');
														echo $fld->getCaption();
														?>
													</label>
												</div>
												<div class="field-wraper">
													<div class="field_cover">
														<?php echo $frm->getFieldHtml('rfq_quantity_service[' . $serviceId . ']'); ?>
													</div>
												</div>
											</div>
										</td>
										<td>
											<?php if ($val['selprod_document_required']) { ?>
												<div class="field-set">
													<div class="caption-wraper">
														<label class="field_label">
															<?php echo Labels::getLabel('LBL_Upload_documents', $siteLangId); ?>
															<span class="spn_must_field">*</span>
														</label>
													</div>
													<div class="field-wraper">
														<div class="field_cover  service-doc_<?php echo $serviceId; ?>--js">
															<?php
															$fld = $frm->getField('service_group_id[' . $serviceId . ']');
															$fld->setFieldTagAttribute('class', 'service_doc_group');
															echo $frm->getFieldHtml('service_group_id[' . $serviceId . ']');
															?>
															<input type="file" name="rfq_documents_services" onchange="uploadDocument(<?php echo $serviceId; ?>)" />
														</div>
													</div>
												</div>
											<?php } ?>
										</td>
									</tr>
									<?php if ($val['selprod_document_required']) { ?>
										<tr>
											<td colspan="4">
												<div id="uploaded-documents-js_<?php echo $serviceId; ?>" class="uploaded--documents"></div>
											</td>
										</tr>
									<?php } ?>

								<?php } ?>
							</tbody>
						</table>
					<?php } ?>




					<div class="col-lg-12 col-sm-12">
						<div class="field-set">
							<div class="caption-wraper">
								<label class="field_label"> <?php echo Labels::getLabel("LBL_Delivery_address", $siteLangId); ?><span class="spn_must_field">*</span></label>
							</div>
							<div class="field-wraper">
								<div class="field_cover">

									<div class="address-group">

										<div class="address-group__large address-list-js">

											<?php if ($addresses) { ?>
												<div class="address-selection">
													<div class="address-selection__trigger <?php if (count($addresses) > 1) { ?> address-selection__trigger-arrow address-selection-js address-sel-val-top-js<?php } ?> ">

														<?php $isDefaultAddress = FALSE;
														$addressId = 0;
														foreach ($addresses as $address) {
															if ($address['ua_is_default'] == AppConstants::YES) {
																$isDefaultAddress = TRUE;
																$addressId = $address['ua_id']; ?>

																<span class="site-icon site-icon--small mr-2">
																	<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
																		<path d="M18.364 17.364L12 23.728l-6.364-6.364a9 9 0 1 1 12.728 0zM12 15a4 4 0 1 0 0-8 4 4 0 0 0 0 8zm0-2a2 2 0 1 1 0-4 2 2 0 0 1 0 4z"></path>
																	</svg>
																</span>
																<span class="address-selection__value"><strong><?php echo ($address['ua_identifier'] != '') ? $address['ua_identifier'] . ': ' . $address['ua_name'] : $address['ua_name']; ?></strong> -
																	<?php echo $address['ua_address1']; ?>,
																	<?php echo (strlen($address['ua_address2']) > 0) ? $address['ua_address2'] . ',' : ''; ?>
																	<?php echo (strlen($address['ua_city']) > 0) ? $address['ua_city'] . ',' : ''; ?>
																	<?php echo (strlen($address['state_name']) > 0) ? $address['state_name'] . ',' : ''; ?>
																	<?php echo (strlen($address['country_name']) > 0) ? $address['country_name'] . ',' : ''; ?>
																	<?php echo (strlen($address['ua_zip']) > 0) ? Labels::getLabel('LBL_Zip:', $siteLangId) . $address['ua_zip'] . ',' : ''; ?>
																	<?php echo (strlen($address['ua_phone']) > 0) ? Labels::getLabel('LBL_Phone:', $siteLangId) . $address['ua_phone'] . ',' : ''; ?>
																</span>
															<?php }
														}
														if ($isDefaultAddress == FALSE) {
															foreach ($addresses as $address) {
																$addressId = $address['ua_id']; ?>

																<span class="site-icon site-icon--small mr-2">
																	<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
																		<path d="M18.364 17.364L12 23.728l-6.364-6.364a9 9 0 1 1 12.728 0zM12 15a4 4 0 1 0 0-8 4 4 0 0 0 0 8zm0-2a2 2 0 1 1 0-4 2 2 0 0 1 0 4z"></path>
																	</svg>
																</span>
																<span class="address-selection__value"><strong><?php echo ($address['ua_identifier'] != '') ? $address['ua_identifier'] . ': ' . $address['ua_name'] : $address['ua_name']; ?></strong> -
																	<?php echo $address['ua_address1']; ?>,
																	<?php echo (strlen($address['ua_address2']) > 0) ? $address['ua_address2'] . ',' : ''; ?>
																	<?php echo (strlen($address['ua_city']) > 0) ? $address['ua_city'] . ',' : ''; ?>
																	<?php echo (strlen($address['state_name']) > 0) ? $address['state_name'] . ',' : ''; ?>
																	<?php echo (strlen($address['country_name']) > 0) ? $address['country_name'] . ',' : ''; ?>
																	<?php echo (strlen($address['ua_zip']) > 0) ? Labels::getLabel('LBL_Zip:', $siteLangId) . $address['ua_zip'] . ',' : ''; ?>
																	<?php echo (strlen($address['ua_phone']) > 0) ? Labels::getLabel('LBL_Phone:', $siteLangId) . $address['ua_phone'] . ',' : ''; ?>
																</span>
														<?php
																break;
															}
														} ?>

													</div>
													<input type="hidden" id="address_id" value="<?php echo isset($addressId) ? $addressId : 0; ?>" name="rfq_address_id">
													<?php if (count($addresses) > 1) { ?>
														<div class="address-selection__target address-target-js">

															<div class="address-selection__list">

																<?php foreach ($addresses as $address) { ?>


																	<div onClick="pickAddress(this)" data-id="<?php echo $address['ua_id']; ?>" class="address-selection__trigger <?php echo ($address['ua_is_default'] == AppConstants::YES) ? 'is-active' : ''; ?> ">

																		<span class="site-icon site-icon--small mr-2">
																			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
																				<path d="M18.364 17.364L12 23.728l-6.364-6.364a9 9 0 1 1 12.728 0zM12 15a4 4 0 1 0 0-8 4 4 0 0 0 0 8zm0-2a2 2 0 1 1 0-4 2 2 0 0 1 0 4z"></path>
																			</svg>
																		</span>
																		<span class="address-selection__value address-sel-val-bottom-js">
																			<strong><?php echo ($address['ua_identifier'] != '') ? $address['ua_identifier'] . ': ' . $address['ua_name'] : $address['ua_name']; ?></strong> -
																			<?php echo $address['ua_address1']; ?>,
																			<?php echo (strlen($address['ua_address2']) > 0) ? $address['ua_address2'] . ',' : ''; ?>
																			<?php echo (strlen($address['ua_city']) > 0) ? $address['ua_city'] . ',' : ''; ?>
																			<?php echo (strlen($address['state_name']) > 0) ? $address['state_name'] . ',' : ''; ?>
																			<?php echo (strlen($address['country_name']) > 0) ? $address['country_name'] . ',' : ''; ?>
																			<?php echo (strlen($address['ua_zip']) > 0) ? Labels::getLabel('LBL_Zip:', $siteLangId) . $address['ua_zip'] . ',' : ''; ?>
																			<?php echo (strlen($address['ua_phone']) > 0) ? Labels::getLabel('LBL_Phone:', $siteLangId) . $address['ua_phone'] . ',' : ''; ?>
																		</span>
																	</div>
																<?php  } ?>

															</div>
														</div>
													<?php  } ?>

												</div>
											<?php } else { ?>

												<small class="color-light mb-2 mt-2 d-block"><?php echo Labels::getLabel("LBL_You_havn't_added_delivery_address_yet", $siteLangId); ?></small>

											<?php } ?>


										</div>

										<div class="address-group__small">
											<!--a target="_blank" href="<?php echo CommonHelper::generateUrl('account', 'MyAddresses'); ?>" class="btn btn--bordered color-brand btn--block d-flex align-items-center justify-content-center manage-address-trigger add-trigger-js1">
												<span class="site-icon site-icon--small mr-2">
													<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
														<path d="M12 22C6.477 22 2 17.523 2 12S6.477 2 12 2s10 4.477 10 10-4.477 10-10 10zm-1-11H7v2h4v4h2v-4h4v-2h-4V7h-2v4z"></path>
													</svg>
												</span>
												<?php echo Labels::getLabel("LBL_Add_New_Address", $siteLangId); ?></a-->


											<a href="javascript:void(0)" class="btn btn--bordered color-brand btn--block d-flex align-items-center justify-content-center manage-address-trigger add-trigger-js is-active">
												<span class="site-icon site-icon--small mr-2">
													<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
														<path d="M12 22C6.477 22 2 17.523 2 12S6.477 2 12 2s10 4.477 10 10-4.477 10-10 10zm-1-11H7v2h4v4h2v-4h4v-2h-4V7h-2v4z"></path>
													</svg>
												</span>
												<?php echo Labels::getLabel("LBL_Add_New_Address", $siteLangId); ?></a>

										</div>

									</div>
								</div>
							</div>
						</div>
					</div>


					<div class="col-lg-4 col-md-4 col-sm-4">
						<div class="field-set">
							<div class="field-wraper">
								<div class="field_cover">
									<?php
									echo $frm->getFieldHtml('selprod_id');
									echo $frm->getFieldHtml('group_id');
									echo $frm->getFieldHtml('parent_id');
									echo $frm->getFieldHtml('btn_submit');
									?>
								</div>
							</div>
						</div>
					</div>
				</div>
				<?php echo $frm->getExternalJs(); ?>
				</form>
			</div>

		</div>

	</div>



	<div class="contact-panel__small">

		<div class="seller-portlet">
			<div class="seller-portlet__head">
				<div class="seller-portlet__logo"><img src="<?php echo CommonHelper::generateFileUrl('Image', 'shopLogo', array($productData['shop_id'], $siteLangId, 'SMALL')); ?>" alt="<?php echo $shop['shop_name']; ?>"></div>
				<div class="seller-portlet__info">
					<h6><a href="<?php echo CommonHelper::generateUrl('shops', 'View', array($productData['shop_id'])); ?>"> <?php echo $productData['shop_name']; ?></a></h6>

					<div class="seller-portlet__details">
						<span class="seller-location"><?php echo $productData['shop_state_name'] . ", " . $productData['shop_country_name']; ?></span>
						<div class="seller-ratings">
							<div class="ratings">
								<span class="ratings__star site-icon site-icon--small">
									<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 15.216">
										<path d="M8.587,12.949,3.643,15.716l1.1-5.557L.587,6.312l5.627-.667L8.587.5,10.96,5.645l5.627.667-4.16,3.847,1.1,5.557Z" transform="translate(-0.587 -0.5)" fill="#f59f1f"></path>
									</svg>
								</span>
								<span class="ratings__value"><?php echo round($shop_rating, 1); ?></span>
							</div>
						</div>
					</div>
				</div>


			</div>
			<div class="seller-portlet__body">
				<?php if ($subscription_package_id > 0) { ?>
					<div class="seller-badges">

						<?php if ((isset($subscription_package_id) && $subscription_package_id == SellerPackages::GOLD_PACKAGE) && $productData['seller_verified'] == 1) { ?>
							<div class="seller-badges__grid">
								<div class="badge-item">
									<span class="badge-item__media"><img src="<?php echo CONF_WEBROOT_URL; ?>images/green-tick.svg" alt=""></span>
									<span class="badge-item__label"><?php echo Labels::getLabel('LBL_Trustseal_Verified', $siteLangId); ?></span>
								</div>
							</div>
						<?php } ?>
						<?php if(FatApp::getConfig('CONF_ENABLE_SELLER_SUBSCRIPTION_MODULE', FatUtility::VAR_INT, 0)){ ?>
						<?php if ($subscription_package_id == SellerPackages::SILVER_PACKAGE) { ?>
							<div class="seller-badges__grid">
								<div class="badge-item">
									<span class="badge-item__media"><img class="gray-scale" src="<?php echo CONF_WEBROOT_URL; ?>images/dollar.png" alt=""></span>
									<span class="badge-item__label"><?php echo $subscription_package; ?></span>
								</div>
							</div>
						<?php } elseif ($subscription_package_id == SellerPackages::GOLD_PACKAGE) { ?>
							<div class="seller-badges__grid">
								<div class="badge-item">
									<span class="badge-item__media"><img src="<?php echo CONF_WEBROOT_URL; ?>images/dollar.png"></span>
									<span class="badge-item__label"><?php echo $subscription_package; ?></span>
								</div>
							</div>
						<?php } else { ?>
							<div class="seller-badges__grid">
								<div class="badge-item">
									<span class="badge-item__label"><?php echo $subscription_package; ?></span>
								</div>
							</div>
						<?php }}
						if ($productData['is_founding_member'] == 1) { ?>
							<div class="seller-badges__grid">
								<div class="badge-item">
									<span class="badge-item__media"> <img src="<?php echo CONF_WEBROOT_URL; ?>images/crown.png"></span>
									<span class="badge-item__label"><?php echo Labels::getLabel('LBL_Founding_Member', $siteLangId); ?></span>
								</div>
							</div>
						<?php } ?>


					</div>
				<?php } ?>

				<div class="seller-stats">
					<?php if ($sellerStats['responseTime']) { ?>
						<div class="seller-stats__item">
							<small><?php echo Labels::getLabel('LBL_Response_Time', $siteLangId); ?></small>
							<h6>&gt; <?php echo $sellerStats['responseTime']; ?></h6>
						</div>
					<?php }
					if ($sellerStats['deliveryRate']) { ?>
						<div class="seller-stats__item">
							<small><?php echo Labels::getLabel('LBL_On-time_delivery_rate', $siteLangId); ?></small>
							<h6><?php echo $sellerStats['deliveryRate']; ?>%</h6>
						</div>
					<?php } ?>
				</div>
			</div>


			<div class="seller-portlet__footer">
				<div class="product-card product-card--horizontal product-card--small">
					<div class="product-card__head">
						<div class="product-media ratio ratio--1by1">
							<?php if (isset($is_service) && $is_service == true) { ?>
								<a href="<?php echo CommonHelper::generateUrl('products', 'view', array($productData['selprod_id'])) ?>"><img src="<?php echo FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'serviceProduct', array($productData['selprod_id'], 'THUMB')), CONF_IMG_CACHE_TIME, '.jpg'); ?>"></a>
							<?php } else { ?>
								<a href="<?php echo CommonHelper::generateUrl('products', 'view', array($productData['selprod_id'])) ?>"><img src="<?php echo FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'product', array($productData['product_id'], 'THUMB', $productData['selprod_id'])), CONF_IMG_CACHE_TIME, '.jpg'); ?>"></a>
							<?php  } ?>
						</div>
					</div>
					<div class="product-card__body">
						<div class="product-detail">
							<a href="<?php echo CommonHelper::generateUrl('Category', 'View', array($productData['prodcat_id'])) ?>" class="product-category"><?php echo $productData['prodcat_name']; ?></a>
							<a href="<?php echo CommonHelper::generateUrl('products', 'view', array($productData['selprod_id'])) ?>" class="product-title"><?php echo $productData['selprod_title']; ?></a>
							<?php if (CommonHelper::isDisplayPrice($productData)) { ?>
								<div class="product-price">
									<span class="product-price__sell"><?php echo CommonHelper::getCurrencyCode() . CommonHelper::displayMoneyFormat($productData['theprice']); ?></span>
									<?php if (isset($productData['special_price_found']) && !empty($productData['special_price_found'])) { ?>
										<span class="product-price__original"><?php echo CommonHelper::getCurrencyCode() . CommonHelper::displayMoneyFormat($productData['selprod_price']); ?></span>
										<span class="product-price__off"><?php echo CommonHelper::showProductDiscountedText($productData, $siteLangId); ?></span>
									<?php  } ?>
								</div>
							<?php } ?>
						</div>

					</div>
				</div>
			</div>


		</div>

	</div>




</div>




<script>
	$(document).ready(function() {
		getCountryStates($("#ua_country_id").val(), <?php echo $stateId; ?>, '#ua_state_id');

		$('.delivery-date-picker--js').datetimepicker({
			minDate: new Date(),
			dateFormat: 'yy-mm-dd',
			timeFormat: 'HH:mm',
		});
	});


	$(".address-selection-js").click(function() {
		$(".address-target-js").slideToggle();
	});
	/* FOR MANAGE ADDRESS */
	$('.add-trigger-js').click(function() {
		$(this).toggleClass("is-active");
		$("#manage-address-js").toggleClass("is-visible");
		return false;

	});
</script>

<style type="text/css">
	.table-services td {
		vertical-align: middle;
	}

	.no-border-row td {
		border: 0px;
	}
</style>