<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
$disabledBuy = 0;
$detailproduct = $product;
if (!Product::isDisplayPriceByAdmin()) {
    $disabledBuy = 1;
}
$buyQuantity = $frmBuyProduct->getField('quantity');
$buyQuantity->addFieldTagAttribute('class', 'qty-input cartQtyTextBox productQty-js');
$buyQuantity->addFieldTagAttribute('data-page', 'product-view');
$selProdId = $detailproduct['selprod_id'];

$youtube_embed_code = CommonHelper::parseYoutubeUrl($detailproduct["product_youtube_video"]);
$videoThumbImg = '';
if (!empty($youtube_embed_code)) {
    $videoThumbImg = 'https://img.youtube.com/vi/' . $youtube_embed_code . '/hqdefault.jpg';
}
?>

<div id="body" class="body" role="main">
    <section class="section section-details">
        <div class="container">

            <div class="breadcrumbs">
                <?php $this->includeTemplate('_partial/custom/header-breadcrumb.php'); ?>
            </div>


            <div class="site-panel">

                <!-- [ PANEL LEFT =========== -->
                <div class="site-panel__large site-panel--first">
                    <div class="product-panel">
                        <div class="product-panel__media">
                            <div class="product-slideshow">
                                <div class="product-slideshow__media">
                                    <?php
                                    $data['product'] = $product;
                                    $data['productImagesArr'] = $productImagesArr;
                                    $data['imageGallery'] = true;
                                    /* $this->includeTemplate('products/product-gallery.php',$data,false); */
                                    ?>
                                    <div class="slideshow-media product-gallery--js slider-for" dir="<?php echo CommonHelper::getLayoutDirection(); ?>" id="slider-for">
                                        <?php if ($productImagesArr) { ?>
                                            <?php
                                            foreach ($productImagesArr as $afile_id => $image) {
                                                $originalImgUrl = FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'product', array($detailproduct['product_id'], 'ORIGINAL', 0, $image['afile_id'])), CONF_IMG_CACHE_TIME, '.jpg');
                                                $mainImgUrl = FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'product', array($detailproduct['product_id'], 'MEDIUM', 0, $image['afile_id'])), CONF_IMG_CACHE_TIME, '.jpg');
                                                $thumbImgUrl = FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'product', array($detailproduct['product_id'], 'THUMB', 0, $image['afile_id'])), CONF_IMG_CACHE_TIME, '.jpg');
                                                ?>
                                                <img class="xzoom active" id="xzoom-default" src="<?php echo $mainImgUrl; ?>" xoriginal="<?php echo $originalImgUrl; ?>">
                                                <?php
                                                break;
                                            }
                                            ?>
                                            <?php
                                        } else {
                                            $mainImgUrl = FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'product', array(0, 'MEDIUM', 0)), CONF_IMG_CACHE_TIME, '.jpg');
                                            $originalImgUrl = FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'product', array(0, 'ORIGINAL', 0)), CONF_IMG_CACHE_TIME, '.jpg');
                                            ?>
                                            <img class="xzoom" src="<?php echo $mainImgUrl; ?>" xoriginal="<?php echo $originalImgUrl; ?>">
                                        <?php } ?>
                                    </div>

                                    <?php if (!empty($youtube_embed_code)) { ?>
                                        <div class="product-video--js" style="display:none;">
                                            <iframe id="product-video" width="100%" height="400px" src="//www.youtube.com/embed/<?php echo $youtube_embed_code ?>" allowfullscreen></iframe>
                                        </div>
                                    <?php } ?>

                                </div>

                                <div class="product-slideshow__controls">

                                    <?php if ($productImagesArr) { ?>
                                        <div class="slider-nav slideshow-controls slideshow-controls-js xzoom-thumbs" dir="<?php echo CommonHelper::getLayoutDirection(); ?>" id="slider-nav">
                                            <?php
                                            foreach ($productImagesArr as $afile_id => $image) {
                                                $originalImgUrl = FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'product', array($detailproduct['product_id'], 'ORIGINAL', 0, $image['afile_id'])), CONF_IMG_CACHE_TIME, '.jpg');
                                                $mainImgUrl = FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'product', array($detailproduct['product_id'], 'MEDIUM', 0, $image['afile_id'])), CONF_IMG_CACHE_TIME, '.jpg');
                                                /* $thumbImgUrl = FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'product', array($detailproduct['product_id'], 'THUMB', 0, $image['afile_id']) ), CONF_IMG_CACHE_TIME, '.jpg'); */
                                                ?>
                                                <div class="slideshow-thumb product-thumb--js"><a href="<?php echo $originalImgUrl; ?>"><img class="xzoom-gallery " width="80" src="<?php echo $mainImgUrl; ?>"></a></div>
                                            <?php } ?>

                                            <!-- [ PRODUCT VIDEO THUMBNAIL SECTION -->
                                            <?php if (!empty($youtube_embed_code)) { ?>
                                                <div class="thumb"><a href="<?php echo $originalImgUrl; ?>" class="product-video-thum--js"><img width="80" height="80" src="<?php echo $videoThumbImg; ?>"></a></div>
                                            <?php } ?>
                                            <!-- ] -->
                                        </div>
                                    <?php } ?>
                                </div>
                            </div>



                        </div>

                        <!-- ] -->


                        <!-- [ PANEL MIDDLE =========== -->
                        <div class="product-panel__content">


                            <?php if (!empty($detailproduct['brand_name'])) {
                                ?>
                                <span class="brand-title"><strong><?php echo Labels::getLabel('LBL_Brand', $siteLangId); ?>:</strong> <a target="_blank" href="<?php echo CommonHelper::generateUrl('Brands', 'view', [$detailproduct['brand_id']]); ?>"> <?php echo $detailproduct['brand_name']; ?></a></span>
                            <?php } ?>
                            <h1 class="page-title mt-0 mb-2"><?php echo $detailproduct['selprod_title']; ?></h1>


                            <!-- [ PANEL ACTIONS =========== -->
                            <div class="panel-list">


                                <?php
                                if (FatApp::getConfig("CONF_ALLOW_REVIEWS", FatUtility::VAR_INT, 0)) {

                                    $totReviews = isset($reviews['totReviews']) ? FatUtility::int($reviews['totReviews']) : '';
                                    $avgRating = isset($reviews['avg_seller_rating']) ? FatUtility::convertToType($reviews['avg_seller_rating'], FatUtility::VAR_FLOAT) : 0;
                                    $rated_1 = isset($reviews['rated_1']) ? FatUtility::int($reviews['rated_1']) : '';
                                    $rated_2 = isset($reviews['rated_2']) ? FatUtility::int($reviews['rated_2']) : '';
                                    $rated_3 = isset($reviews['rated_3']) ? FatUtility::int($reviews['rated_3']) : '';
                                    $rated_4 = isset($reviews['rated_4']) ? FatUtility::int($reviews['rated_4']) : '';
                                    $rated_5 = isset($reviews['rated_5']) ? FatUtility::int($reviews['rated_5']) : '';

                                    $pixelToFillRight = $avgRating / 5 * 160;
                                    $pixelToFillRight = FatUtility::convertToType($pixelToFillRight, FatUtility::VAR_FLOAT);

                                    $rate_5_width = $rate_4_width = $rate_3_width = $rate_2_width = $rate_1_width = 0;

                                    if ($totReviews) {
                                        $rate_5_width = round(FatUtility::convertToType($rated_5 / $totReviews * 100, FatUtility::VAR_FLOAT), 2);
                                        $rate_4_width = round(FatUtility::convertToType($rated_4 / $totReviews * 100, FatUtility::VAR_FLOAT), 2);
                                        $rate_3_width = round(FatUtility::convertToType($rated_3 / $totReviews * 100, FatUtility::VAR_FLOAT), 2);
                                        $rate_2_width = round(FatUtility::convertToType($rated_2 / $totReviews * 100, FatUtility::VAR_FLOAT), 2);
                                        $rate_1_width = round(FatUtility::convertToType($rated_1 / $totReviews * 100, FatUtility::VAR_FLOAT), 2);
                                    }
                                    ?>
                                    <div class="panel-list__item">
                                        <?php $label = (round($detailproduct['prod_rating']) > 0) ? round($detailproduct['totReviews'], 1) . ' ' . Labels::getLabel('LBL_Reviews', $siteLangId) : Labels::getLabel('LBL_No_Reviews', $siteLangId); ?>
                                        <div class="ratings ratings--hovered">
                                            <a href="#ratings" class="ratings__trigger scrolls">
                                                <span class="ratings__star site-icon site-icon--xsmall">
                                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16">
                                                    <path d="M12.943,27.378,8,24.659,3.057,27.378,4,21.618,0,17.539l5.527-.84L8,11.378,10.473,16.7l5.527.84-4,4.079Z" transform="translate(0 -11.378)" fill="#f5961d"></path>
                                                    </svg>
                                                </span>
                                                <span class="ratings__value"><?php echo round($detailproduct['prod_rating'], 1); ?></span>
                                                <span class="ratings__count">| <?php echo $label; ?></span>
                                            </a>
                                            <div class="ratings__target">

                                                <div class="ratings-progress p-4">

                                                    <div class="ratings">
                                                        <span class="ratings__value m-0"><?php echo round($detailproduct['prod_rating'], 1) . ' ' . Labels::getLabel('Lbl_Out_of', $siteLangId) . ' ' . '5'; ?> </span>
                                                        <span class="ratings__count">| <?php echo $totReviews . ' ', Labels::getLabel('Lbl_Reviews_&_Ratings', $siteLangId); ?></span>
                                                    </div>

                                                    <div class="progress-list">
                                                        <ul>
                                                            <li>
                                                                <span class="progress-list__count">5 <?php echo Labels::getLabel('Lbl_Star', $siteLangId); ?></span>
                                                                <div class="progress-list__bar">
                                                                    <div title="<?php echo $rate_5_width, '% ', Labels::getLabel('LBL_Number_of_reviews_have_5_stars', $siteLangId); ?>" style="width: <?php echo $rate_5_width; ?>%; clip: rect(0px, 0px, 160px, 0px);" role="progressbar" class="progress-list__bar-fill"></div>
                                                                </div>
                                                            </li>
                                                            <li>
                                                                <span class="progress-list__count">4 <?php echo Labels::getLabel('Lbl_Star', $siteLangId); ?></span>
                                                                <div class="progress-list__bar">
                                                                    <div title="<?php echo $rate_4_width, '% ', Labels::getLabel('LBL_Number_of_reviews_have_4_stars', $siteLangId); ?>" style="width: <?php echo $rate_4_width; ?>%; clip: rect(0px, 0px, 160px, 0px);" role="progressbar" class="progress-list__bar-fill"></div>
                                                                </div>
                                                            </li>
                                                            <li>
                                                                <span class="progress-list__count">3 <?php echo Labels::getLabel('Lbl_Star', $siteLangId); ?></span>
                                                                <div class="progress-list__bar">
                                                                    <div title="<?php echo $rate_3_width, '% ', Labels::getLabel('LBL_Number_of_reviews_have_3_stars', $siteLangId); ?>" style="width: <?php echo $rate_3_width; ?>%; clip: rect(0px, 0px, 160px, 0px);" role="progressbar" class="progress-list__bar-fill"></div>
                                                                </div>
                                                            </li>
                                                            <li>
                                                                <span class="progress-list__count">2 <?php echo Labels::getLabel('Lbl_Star', $siteLangId); ?></span>
                                                                <div class="progress-list__bar">
                                                                    <div title="<?php echo $rate_2_width, '% ', Labels::getLabel('LBL_Number_of_reviews_have_2_stars', $siteLangId); ?>" style="width: <?php echo $rate_2_width; ?>%; clip: rect(0px, 0px, 160px, 0px);" role="progressbar" class="progress-list__bar-fill"></div>
                                                                </div>
                                                            </li>
                                                            <li>
                                                                <span class="progress-list__count">1 <?php echo Labels::getLabel('Lbl_Star', $siteLangId); ?></span>
                                                                <div class="progress-list__bar">
                                                                    <div title="<?php echo $rate_1_width, '% ', Labels::getLabel('LBL_Number_of_reviews_have_1_stars', $siteLangId); ?>" style="width: <?php echo $rate_1_width; ?>%; clip: rect(0px, 0px, 160px, 0px);" role="progressbar" class="progress-list__bar-fill"></div>
                                                                </div>
                                                            </li>
                                                        </ul>
                                                    </div>

                                                    <hr>
                                                    <a href="#ratings" class="link scrolls"><?php echo Labels::getLabel('LBL_See_all_customer_reviews', $siteLangId) ?></a>

                                                </div>

                                            </div>
                                        </div>

                                    </div>
                                <?php } ?>

                                <?php
                                if (FatApp::getConfig('CONF_ADD_FAVORITES_TO_WISHLIST', FatUtility::VAR_INT, 1) == AppConstants::NO) {
                                    $jsFunc = 0 < $detailproduct['ufp_id'] ? 'removeFromFavorite(' . $detailproduct['selprod_id'] . ')' : 'markAsFavorite(' . $detailproduct['selprod_id'] . ')';
                                    ?>
                                    <div class="panel-list__item">
                                        <a href="javascript:void(0)" class="btn btn--icon btn--fav <?php echo ($detailproduct['ufp_id']) ? 'is-active' : ''; ?>" onclick="<?php echo $jsFunc; ?>" data-id="<?php echo $detailproduct['selprod_id']; ?>"" title=" <?php echo ($detailproduct['ufp_id']) ? Labels::getLabel('LBL_Remove_product_from_favourite_list', $siteLangId) : Labels::getLabel('LBL_Add_Product_to_favourite_list', $siteLangId); ?>">
                                            <span class="site-icon">
                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 14.8">
                                                <path d="M13.6,3A4.521,4.521,0,0,1,18,7.8c0,5.6-6,8.8-8,10-2-1.2-8-4.4-8-10A4.54,4.54,0,0,1,6.4,3,5.293,5.293,0,0,1,10,4.6,5.293,5.293,0,0,1,13.6,3Z" transform="translate(-2 -3)"></path>
                                                </svg>
                                            </span> <?php echo Labels::getLabel('LBL_Favorite', $siteLangId) ?>
                                        </a>
                                    </div>
                                <?php } else { ?>
                                    <div class="panel-list__item">
                                        <a href="javascript:void(0)" class="btn btn--icon btn--fav  <?php echo ($detailproduct['is_in_any_wishlist']) ? 'is-active' : ''; ?>" id="listDisplayDiv_<?php echo $detailproduct['selprod_id']; ?>" data-id="<?php echo $detailproduct['selprod_id']; ?>" onClick="viewWishList(<?php echo $detailproduct['selprod_id']; ?>, this, event);" title="<?php echo ($detailproduct['is_in_any_wishlist']) ? Labels::getLabel('LBL_Remove_product_from_your_wishlist', $siteLangId) : Labels::getLabel('LBL_Add_Product_to_your_wishlist', $siteLangId); ?>">
                                            <span class="site-icon">
                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 14.8">
                                                <path d="M13.6,3A4.521,4.521,0,0,1,18,7.8c0,5.6-6,8.8-8,10-2-1.2-8-4.4-8-10A4.54,4.54,0,0,1,6.4,3,5.293,5.293,0,0,1,10,4.6,5.293,5.293,0,0,1,13.6,3Z" transform="translate(-2 -3)"></path>
                                                </svg>
                                            </span><?php echo Labels::getLabel('LBL_Favorite', $siteLangId) ?>
                                        </a>
                                    </div>
                                <?php } ?>




                                <div class="panel-list__item">

                                    <div class="social-share social-share--hovered">
                                        <a href="#social-target-js" class="btn btn--icon btn--share trigger-js">
                                            <span class="site-icon">
                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 13 13.009">
                                                <path d="M1514.616,192.269a2.38,2.38,0,0,0-1.866.908l-4.058-2.058a2.1,2.1,0,0,0-.017-1.278l4.039-2.049a2.356,2.356,0,1,0-.487-1.421,2.331,2.331,0,0,0,.092.615l-4.056,2.059a2.368,2.368,0,1,0,.035,2.879l4.038,2.049a2.32,2.32,0,0,0-.109.667,2.389,2.389,0,1,0,2.388-2.371Z" transform="translate(-1504.006 -184.001)"></path>
                                                </svg>
                                            </span> <?php echo Labels::getLabel('Lbl_Share', $siteLangId); ?>
                                        </a>
                                        <div id="social-target-js" class="social-share__target social-share__target-js">
                                            <ul class="sharing-actions">
                                                <li class="social-facebook">
                                                    <a class="st-custom-button" data-network="facebook" data-url="<?php echo CommonHelper::generateFullUrl('Products', 'view', array($detailproduct['selprod_id'])); ?>/">
                                                        <i class="icn">
                                                            <svg class="svg" viewBox="0 0 430.113 430.114">
                                                            <path d="M158.081,83.3c0,10.839,0,59.218,0,59.218h-43.385v72.412h43.385v215.183h89.122V214.936h59.805   c0,0,5.601-34.721,8.316-72.685c-7.784,0-67.784,0-67.784,0s0-42.127,0-49.511c0-7.4,9.717-17.354,19.321-17.354   c9.586,0,29.818,0,48.557,0c0-9.859,0-43.924,0-75.385c-25.016,0-53.476,0-66.021,0C155.878-0.004,158.081,72.48,158.081,83.3z"></path>
                                                            </svg></i>
                                                    </a>
                                                </li>
                                                <li class="social-twitter">
                                                    <a class="st-custom-button" data-network="twitter">
                                                        <i class="icn">
                                                            <svg class="svg" viewBox="0 0 512 512">
                                                            <path d="M512,97.248c-19.04,8.352-39.328,13.888-60.48,16.576c21.76-12.992,38.368-33.408,46.176-58.016    c-20.288,12.096-42.688,20.64-66.56,25.408C411.872,60.704,384.416,48,354.464,48c-58.112,0-104.896,47.168-104.896,104.992    c0,8.32,0.704,16.32,2.432,23.936c-87.264-4.256-164.48-46.08-216.352-109.792c-9.056,15.712-14.368,33.696-14.368,53.056    c0,36.352,18.72,68.576,46.624,87.232c-16.864-0.32-33.408-5.216-47.424-12.928c0,0.32,0,0.736,0,1.152    c0,51.008,36.384,93.376,84.096,103.136c-8.544,2.336-17.856,3.456-27.52,3.456c-6.72,0-13.504-0.384-19.872-1.792    c13.6,41.568,52.192,72.128,98.08,73.12c-35.712,27.936-81.056,44.768-130.144,44.768c-8.608,0-16.864-0.384-25.12-1.44    C46.496,446.88,101.6,464,161.024,464c193.152,0,298.752-160,298.752-298.688c0-4.64-0.16-9.12-0.384-13.568    C480.224,136.96,497.728,118.496,512,97.248z"></path>
                                                            </svg></i>
                                                    </a>
                                                </li>
                                                <li class="social-pintrest">
                                                    <a class="st-custom-button" data-network="pinterest">
                                                        <i class="icn"><svg class="svg" viewBox="0 0 100.001 100.001">
                                                            <path d="M43.081,66.14c-2.626,13.767-5.833,26.966-15.333,33.861c-2.932-20.809,4.307-36.436,7.668-53.027   c-5.73-9.646,0.689-29.062,12.777-24.277c14.873,5.885-12.881,35.865,5.75,39.611c19.453,3.908,27.395-33.752,15.332-46   C51.847-1.376,18.542,15.905,22.638,41.224c0.996,6.191,7.391,8.068,2.555,16.611c-11.154-2.473-14.484-11.27-14.055-23   c0.69-19.197,17.25-32.639,33.86-34.498c21.006-2.352,40.721,7.711,43.443,27.471c3.066,22.303-9.48,46.459-31.943,44.721   C50.41,72.056,47.853,69.04,43.081,66.14z"></path>
                                                            </svg></i>
                                                    </a>
                                                </li>
                                                <li class="social-email">
                                                    <a class="st-custom-button" data-network="email">
                                                        <i class="icn"><svg class="svg" viewBox="0 0 483.3 483.3">
                                                            <g>
                                                            <path d="M424.3,57.75H59.1c-32.6,0-59.1,26.5-59.1,59.1v249.6c0,32.6,26.5,59.1,59.1,59.1h365.1c32.6,0,59.1-26.5,59.1-59.1    v-249.5C483.4,84.35,456.9,57.75,424.3,57.75z M456.4,366.45c0,17.7-14.4,32.1-32.1,32.1H59.1c-17.7,0-32.1-14.4-32.1-32.1v-249.5    c0-17.7,14.4-32.1,32.1-32.1h365.1c17.7,0,32.1,14.4,32.1,32.1v249.5H456.4z"></path>
                                                            <path d="M304.8,238.55l118.2-106c5.5-5,6-13.5,1-19.1c-5-5.5-13.5-6-19.1-1l-163,146.3l-31.8-28.4c-0.1-0.1-0.2-0.2-0.2-0.3    c-0.7-0.7-1.4-1.3-2.2-1.9L78.3,112.35c-5.6-5-14.1-4.5-19.1,1.1c-5,5.6-4.5,14.1,1.1,19.1l119.6,106.9L60.8,350.95    c-5.4,5.1-5.7,13.6-0.6,19.1c2.7,2.8,6.3,4.3,9.9,4.3c3.3,0,6.6-1.2,9.2-3.6l120.9-113.1l32.8,29.3c2.6,2.3,5.8,3.4,9,3.4    c3.2,0,6.5-1.2,9-3.5l33.7-30.2l120.2,114.2c2.6,2.5,6,3.7,9.3,3.7c3.6,0,7.1-1.4,9.8-4.2c5.1-5.4,4.9-14-0.5-19.1L304.8,238.55z"></path>
                                                            </g>
                                                            </svg></i>
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>


                                </div>



                            </div>
                            <!-- ] -->

                            <?php if (CommonHelper::isDisplayPrice($product)) { //echo '<pre>';print_r($product); 
                                ?>
                                <div class="panel-price">

                                    <?php if ($detailproduct['special_price_found']) { ?>
                                        <span class="panel-price__old"><?php echo CommonHelper::getCurrencyCode() . CommonHelper::displayMoneyFormat($detailproduct['selprod_price']); ?></span>

                                    <?php } ?>
                                    <span class="panel-price__standard">
                                        <span class="panel-price__main pro-price-js"><?php echo CommonHelper::getCurrencyCode() . CommonHelper::displayMoneyFormat($detailproduct['theprice']); ?></span>
                                        <span class="panel-price__normal-text"><?php echo $detailproduct['selprod_min_order_qty']; ?> <?php echo Labels::getLabel('Lbl_Piece/Pieces(Min._Order)', $siteLangId); ?></span>
                                    </span>
                                    <?php if ($detailproduct['special_price_found']) { ?>
                                        <span class="panel-price__off">
                                            <span class="panel-price__discounted"><?php echo CommonHelper::showProductDiscountedText($product, $siteLangId); ?></span>
                                            <span><?php echo Labels::getLabel('Lbl_discount_ends_in', $siteLangId); ?></span>

                                            <span class="validity-timer">
                                                <span class="validity-timer__media">
                                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 14 14">
                                                    <path d="M9,16a7,7,0,1,1,7-7A7,7,0,0,1,9,16Zm0-1.4A5.6,5.6,0,1,0,3.4,9,5.6,5.6,0,0,0,9,14.6ZM9.7,9h2.8v1.4H8.3V5.5H9.7Z" transform="translate(-2 -2)" fill="#333"></path>
                                                    </svg>
                                                </span>
                                                <span class="validity-timer__counter">
                                                    <div class="count-down">
                                                        <span id="days"></span>
                                                        <span id="hours"></span>
                                                        <span id="minutes"></span>
                                                        <span id="seconds"></span>
                                                    </div>
                                                </span>
                                            </span>
                                        </span>
                                    <?php } ?>
                                </div>
                            <?php } ?>


                            <div class="panel-options">

                                <!-- [ OPTION 1  =========== -->
                                <?php if (count($productSpecifications) > 0) { ?>
                                    <div class="options-list">
                                        <div class="options-list__trigger"><?php echo Labels::getLabel('LBL_Specifications', $siteLangId); ?></div>
                                        <div class="options-list__target">
                                            <div class="bullet-list">
                                                <ul>
                                                    <?php foreach ($productSpecifications as $key => $specification) { ?>
                                                        <li><strong><?php echo $specification['prodspec_name'] . ":"; ?></strong> <?php echo html_entity_decode($specification['prodspec_value'], ENT_QUOTES, 'utf-8'); ?></li>
                                                    <?php } ?>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                                <!-- ] -->


                                <!-- [ OPTION 2  =========== -->

                                <?php if (!empty($optionRows)) { ?>

                                    <?php
                                    $selectedOptionsArr = $detailproduct['selectedOptionValues'];
                                    $count = 0;
                                    foreach ($optionRows as $key => $option) {
                                        $selectedOptionValue = $option['values'][$selectedOptionsArr[$key]]['optionvalue_name'];
                                        $selectedOptionColor = $option['values'][$selectedOptionsArr[$key]]['optionvalue_color_code'];
                                        ?>
                                        <div class="options-list">
                                            <div class="options-list__trigger"><?php echo $option['option_name']; ?></div>

                                            <div class="options-list__target">

                                                <?php if ($option['values']) { ?>
                                                    <div class="option-selector">

                                                        <?php
                                                        foreach ($option['values'] as $opVal) {
                                                            $isAvailable = true;
                                                            if (in_array($opVal['optionvalue_id'], $detailproduct['selectedOptionValues'])) {
                                                                $optionUrl = CommonHelper::generateUrl('Products', 'view', array($detailproduct['selprod_id']));
                                                            } else {
                                                                $optionUrl = Product::generateProductOptionsUrl($detailproduct['selprod_id'], $selectedOptionsArr, $option['option_id'], $opVal['optionvalue_id'], $detailproduct['product_id']);
                                                                $optionUrlArr = explode("::", $optionUrl);
                                                                if (is_array($optionUrlArr) && count($optionUrlArr) == 2) {
                                                                    $optionUrl = $optionUrlArr[0];
                                                                    $isAvailable = false;
                                                                }
                                                            }
                                                            ?>
                                                            <?php if ($isAvailable) { ?>
                                                                <?php if ($option['option_is_color'] && $opVal['optionvalue_color_code'] != '') { ?>
                                                                    <a optionValueId="<?php echo $opVal['optionvalue_id']; ?>" selectedOptionValues="<?php echo implode("_", $selectedOptionsArr); ?>" title="<?php
                                                                    echo $opVal['optionvalue_name'];
                                                                    echo (!$isAvailable) ? ' ' . Labels::getLabel('LBL_Not_Available', $siteLangId) : '';
                                                                    ?>" class="option-selector__item <?php echo (in_array($opVal['optionvalue_id'], $detailproduct['selectedOptionValues'])) ? ' is-active' : ' '; ?> <?php
                                                                       echo (!$option['option_is_color']) ? 'selector__link' : '';
                                                                       echo (in_array($opVal['optionvalue_id'], $detailproduct['selectedOptionValues'])) ? ' ' : ' ';
                                                                       echo (!$optionUrl) ? ' is-disabled' : '';
                                                                       ?>" href="<?php echo ($optionUrl) ? $optionUrl : 'javascript:void(0)'; ?>"> <span class="color-option" style="background-color:#<?php echo $opVal['optionvalue_color_code']; ?>;"></span><?php /* echo $opVal['optionvalue_name']; */ ?></a>
                                                                   <?php } else { ?>
                                                                    <a optionValueId="<?php echo $opVal['optionvalue_id']; ?>" selectedOptionValues="<?php echo implode("_", $selectedOptionsArr); ?>" title="<?php
                                                                    echo $opVal['optionvalue_name'];
                                                                    echo (!$isAvailable) ? ' ' . Labels::getLabel('LBL_Not_Available', $siteLangId) : '';
                                                                    ?>" class="option-selector__item <?php echo (in_array($opVal['optionvalue_id'], $detailproduct['selectedOptionValues'])) ? ' is-active' : ' '; ?> <?php
                                                                       echo (in_array($opVal['optionvalue_id'], $detailproduct['selectedOptionValues'])) ? '' : ' ';
                                                                       echo (!$optionUrl) ? ' is-disabled' : '';
                                                                       ?>" href="<?php echo ($optionUrl) ? $optionUrl : 'javascript:void(0)'; ?>">
                                                                        <span class="p-2"><?php echo $opVal['optionvalue_name']; ?> </span></a>
                                                                <?php } ?>
                                                            <?php } ?>
                                                        <?php } ?>

                                                    </div>
                                                <?php } ?>
                                            </div>

                                        </div>
                                        <?php
                                        $count++;
                                    }
                                    ?>

                                <?php } ?>

                                <!-- ] -->


                                <!-- [ OPTION 4  =========== -->
                                <?php if (count($serviceProducts) > 0) { ?>
                                    <div class="options-list">
                                        <div class="options-list__trigger"><?php echo Labels::getLabel('LBL_Services', $siteLangId); ?></div>
                                        <div class="options-list__target">


                                            <div class="options-content">
                                                <div class="options-scollbar list-addons--js">
                                                    <?php
                                                    foreach ($serviceProducts as $serviceProduct) {
                                                        $title = ($serviceProduct['selprod_title'] != '') ? $serviceProduct['selprod_title'] : '';
                                                        ?>
                                                        <label class="options-content__list is-active">
                                                            <div class="options-content__list-left">
                                                                <span class="checkbox">
                                                                    <input type="checkbox" onClick="selectAddonService(this)" checked="checked" class="cancel" id="check_services" name="check_services" title="<?php echo Labels::getLabel('LBL_Remove', $siteLangId); ?>">
                                                                    <i class="input-helper"></i>
                                                                </span>
                                                            </div>
                                                            <div class="options-content__list-middle">

                                                                <div class="product-card product-card--horizontal product-card--xsmall align-items-center">
                                                                    <div class="product-card__head">
                                                                        <div class="product-media ratio ratio--1by1 border">
                                                                            <img src="<?php echo FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'serviceProduct', array($serviceProduct['selprod_id'], 'MINI', 0, $siteLangId)), CONF_IMG_CACHE_TIME, '.jpg'); ?>" alt="<?php echo $title; ?>">
                                                                        </div>
                                                                    </div>
                                                                    <div class="product-card__body">
                                                                        <div class="product-detail">
                                                                            <span class="product-title"><?php echo $title; ?></span>
                                                                            <div class="product-price mt-0">
                                                                                <span class="product-price__sell">
                                                                                    <?php
                                                                                    if (CommonHelper::isDisplayPrice($serviceProduct)) {
                                                                                        echo CommonHelper::getCurrencyCode() . CommonHelper::displayMoneyFormat($serviceProduct['selprod_price']);
                                                                                    }
                                                                                    ?></span>
                                                                            </div>
                                                                        </div>

                                                                    </div>
                                                                </div>

                                                            </div>

                                                            <div class="options-content__list-last">
                                                                <div class="field-for-qty addon--js">
                                                                    <input type="text" value="1" data-page="product-view" placeholder="Qty" class="qty-input cartQtyTextBox productQty-js" data-lang="service[<?php echo $serviceProduct['selprod_id'] ?>]" name="service[<?php echo $serviceProduct['selprod_id'] ?>]">
                                                                </div>
                                                            </div>

                                                        </label>
                                                    <?php } ?>
                                                </div>

                                            </div>

                                        </div>
                                    </div>
                                <?php } ?>
                                <!-- ] -->


                                <!-- Upsell Products [ -->
                                <?php if (count($upsellProducts) > 0) { ?>

                                    <div class="options-list upsell-products">
                                        <div class="options-list__trigger"><?php echo Labels::getLabel('LBL_Product_Add-ons', $siteLangId); ?></div>

                                        <div class="options-list__target">
                                            <div class="options-content">
                                                <div class="options-scollbar list-addons--js">

                                                    <?php
                                                    foreach ($upsellProducts as $usproduct) {
                                                        $cancelClass = '';
                                                        $uncheckBoxClass = '';
                                                        if ($usproduct['selprod_stock'] <= 0) {
                                                            $cancelClass = 'cancel cancelled--js';
                                                            $uncheckBoxClass = 'remove-add-on';
                                                        }
                                                        ?>

                                                        <label class="options-content__list is-active">
                                                            <div class="options-content__list-left">
                                                                <span class="checkbox">
                                                                    <input <?php echo ($usproduct['selprod_stock'] > 0) ? 'checked="checked"' : ''; ?> onClick="selectAddonService(this)" type="checkbox" class="cancel <?php echo $uncheckBoxClass; ?>" name="check_addons" title="<?php echo Labels::getLabel('LBL_Remove', $siteLangId); ?>">
                                                                    <i class="input-helper"></i>
                                                                </span>
                                                            </div>
                                                            <div class="options-content__list-middle">

                                                                <div class="product-card product-card--horizontal product-card--xsmall align-items-center">
                                                                    <div class="product-card__head">
                                                                        <div class="product-media ratio ratio--1by1 border">
                                                                            <img src="<?php echo FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'product', array($usproduct['product_id'], 'MINI', $usproduct['selprod_id'])), CONF_IMG_CACHE_TIME, '.jpg'); ?>">
                                                                        </div>

                                                                    </div>
                                                                    <div class="product-card__body">
                                                                        <div class="product-detail">
                                                                            <span class="product-title"><?php echo $usproduct['selprod_title']; ?></span>
                                                                            <div class="product-price mt-0">
                                                                                <span class="product-price__sell">
                                                                                    <?php if (CommonHelper::isDisplayPrice($product)) { ?>
                                                                                        <?php echo CommonHelper::displayMoneyFormat($usproduct['theprice']); ?>
                                                                                    <?php } ?>
                                                                                </span>
                                                                            </div>
                                                                        </div>

                                                                    </div>
                                                                </div>

                                                            </div>

                                                            <div class="options-content__list-last">
                                                                <div class="field-for-qty addon--js <?php echo $cancelClass; ?>">
                                                                    <input type="text" value="<?php echo $usproduct['selprod_min_order_qty']; ?>" data-page="product-view" placeholder="Qty" class="qty-input cartQtyTextBox productQty-js" data-lang="addons[<?php echo $usproduct['selprod_id'] ?>]" name="addons[<?php echo $usproduct['selprod_id'] ?>]">
                                                                </div>
                                                            </div>

                                                        </label>
                                                    <?php } ?>



                                                </div>
                                            </div>
                                        </div>


                                    </div>

                                <?php } ?>
                                <!-- ] -->


                                <!-- [ OPTION 8  =========== -->
                                <div class="options-list">
                                    <div class="options-list__trigger"><?php echo Labels::getLabel('Lbl_Payments', $siteLangId); ?></div>
                                    <div class="options-list__target">

                                        <div class="pay-cards">
                                            <img class="border" src="<?php echo CommonHelper::generateFullUrl(); ?>/public/images/banktransfer.png" alt="Bank Transfer" title="Bank Transfer">
                                            <img class="border" src="<?php echo CommonHelper::generateFullUrl(); ?>/public/images/payment-3.png" alt="Paypal" title="Paypal">
                                            <img class="border" src="<?php echo CommonHelper::generateFullUrl(); ?>/public/images/payment-2.png" alt="Stripe" title="Stripe">
                                        </div>

                                    </div>
                                </div>
                                <!-- ] -->

                                <!-- [ OPTION 9  =========== -->
                                <?php include(CONF_THEME_PATH . '_partial/product/shipping-rates.php'); ?>
                                <!-- ] -->

                            </div>


                        </div>
                        <!-- ] -->

                    </div>
                </div>



                <!-- [ PANEL RIGHT =========== -->
                <div class="site-panel__small site-panel--second">
                    <div class="site-panel__box-sticky">
                        <!-- [ PANEL BOX BUYING FORM===========-->
                        <div class="panel-box mb-4 panel-box--buying">
                            <?php
                            /* Volume Discounts[ */
                            if (CommonHelper::isDisplayPrice($product) && isset($volumeDiscountRows) && !empty($volumeDiscountRows) && $detailproduct['in_stock']) {
                                ?>
                                <div class="price-selection">

                                    <div class="price-selection__trigger price-selection__trigger-arrow selection-trigger-js">
                                        <?php
                                        foreach ($volumeDiscountRows as $volumeDiscountRow) {
                                            $volumeDiscount = $detailproduct['theprice'] * ($volumeDiscountRow['voldiscount_percentage'] / 100);
                                            $price = ($detailproduct['theprice'] - $volumeDiscount);
                                            ?>

                                            <div class="price-selection__check">
                                                <!--span class="radio">
                                                    <input type="radio">
                                                    <i class="input-helper"></i>
                                            </span-->
                                            </div>
                                            <div class="price-selection__content">
                                                <div class="selection-price">
                                                    <span class="selection-price__normal-text"><?php echo Labels::getLabel('Lbl_Up_to', $siteLangId); ?> <span class="volume-qty"><?php echo ($volumeDiscountRow['voldiscount_min_qty']); ?></span> <?php echo Labels::getLabel('Lbl_pieces', $siteLangId); ?></span>
                                                    <span class="selection-price__standard">
                                                        <span class="selection-price__main"><?php echo CommonHelper::getCurrencyCode() . CommonHelper::displayMoneyFormat($price); ?></span>
                                                    </span>
                                                    <span class="selection-price__old"><?php echo CommonHelper::getCurrencyCode() . CommonHelper::displayMoneyFormat($detailproduct['theprice']); ?></span>
                                                    <span class="selection-price__discounted">(<?php echo $volumeDiscountRow['voldiscount_percentage'] . '%'; ?>)</span>
                                                </div>
                                            </div>


                                            <?php
                                            break;
                                        }
                                        ?>

                                    </div>

                                    <div class="price-selection__target selection-target-js" style="display: none;">
                                        <div class="price-selection__list">

                                            <?php
                                            foreach ($volumeDiscountRows as $volumeDiscountRow) {
                                                $volumeDiscount = $detailproduct['theprice'] * ($volumeDiscountRow['voldiscount_percentage'] / 100);
                                                $price = ($detailproduct['theprice'] - $volumeDiscount);
                                                ?>
                                                <label class="price-selection__trigger price-selection__trigger-pointer">
                                                    <div class="price-selection__check">
                                                        <span class="radio">
                                                            <input type="radio" name="1" onClick="pickVolumeDiscountProducts(this)" data-volume-qty="<?php echo ($volumeDiscountRow['voldiscount_min_qty']); ?>" data-volume-price="<?php echo CommonHelper::getCurrencyCode() . CommonHelper::displayMoneyFormat($price); ?>">
                                                            <i class="input-helper"></i>
                                                        </span>
                                                    </div>
                                                    <div class="price-selection__content">
                                                        <div class="selection-price">
                                                            <span class="selection-price__normal-text"><?php echo Labels::getLabel('Lbl_Up_to', $siteLangId); ?> <span class="volume-qty"><?php echo ($volumeDiscountRow['voldiscount_min_qty']); ?></span> <?php echo Labels::getLabel('Lbl_pieces', $siteLangId); ?></span>
                                                            <span class="selection-price__standard">
                                                                <span class="selection-price__main"><?php echo CommonHelper::getCurrencyCode() . CommonHelper::displayMoneyFormat($price); ?></span>
                                                            </span>
                                                            <span class="selection-price__old"><?php echo CommonHelper::getCurrencyCode() . CommonHelper::displayMoneyFormat($detailproduct['theprice']); ?></span>
                                                            <span class="selection-price__discounted">(<?php echo $volumeDiscountRow['voldiscount_percentage'] . '%'; ?>)</span>
                                                        </div>
                                                    </div>
                                                </label>
                                            <?php } ?>

                                        </div>
                                    </div>

                                </div>
                            <?php } /* ] */ ?>
                            <!-- ] -->

                            <div class="buying-selection buying-sticky-js">
                                <!-- Add To Cart [ -->
                                <?php
                                if ($detailproduct['in_stock']) {
                                    echo $frmBuyProduct->getFormTag();
                                    $qtyField = $frmBuyProduct->getField('quantity');
                                    $qtyField->value = $detailproduct['selprod_min_order_qty'];
                                    $qtyField->addFieldTagAttribute('data-min-qty', $detailproduct['selprod_min_order_qty']);
                                    $qtyFieldName = $qtyField->getCaption();
                                    if (strtotime($detailproduct['selprod_available_from']) <= strtotime(FatDate::nowInTimezone(FatApp::getConfig('CONF_TIMEZONE'), 'Y-m-d'))) {
                                        ?>
                                        <?php if ($detailproduct['selprod_type'] != SellerProduct::PRODUCT_TYPE_SERVICE && CommonHelper::isDisplayPrice($product) && $disabledBuy == 0 && $shop['is_buy_now'] == AppConstants::YES) { ?>

                                            <div class="qty-selection">
                                                <div class="qty-selection__left">
                                                    <span class="qty-selection__label"><?php echo Labels::getLabel('Lbl_Quantity', $siteLangId); ?></span>
                                                    <small class="small-label"><?php echo Labels::getLabel('Lbl_Maximum', $siteLangId); ?> <?php echo $detailproduct['selprod_stock']; ?> <?php echo Labels::getLabel('Lbl_Piece(s)', $siteLangId); ?></small>
                                                </div>
                                                <div class="qty-selection__right">
                                                    <?php echo $frmBuyProduct->getFieldHtml('quantity'); ?>
                                                </div>
                                            </div>
                                        <?php } ?>

                                        <?php if ($disabledBuy == 0 && $shop['is_buy_now'] == AppConstants::YES) {
                                            ?>
                                            <div class="btns-selection  mt-3 mb-4">
                                                <div class="btns-selection__pair">
                                                    <?php echo $frmBuyProduct->getFieldHtml('btnProductBuy'); ?>
                                                    <?php echo $frmBuyProduct->getFieldHtml('btnAddToCart'); ?>
                                                    <?php echo $frmBuyProduct->getFieldHtml('selprod_id'); ?>
                                                </div>
                                            </div>
                                        <?php } ?>

                                        <div class="btns-selection">
                                            <div class="btns-selection__group text-center">
                                                <small class="small-label"><?php echo Labels::getLabel('Lbl_Or_get_a_quote_for_this_product', $siteLangId); ?></small>
                                                <a onclick="RequestForQuote(<?php echo $selProdId; ?>)" href="javascript:void(0);" class="btn btn--brand btn--block"><?php echo Labels::getLabel('LBL_Request_for_quote', $siteLangId); ?></a>
                                            </div>
                                        </div>


                                    <?php } ?>

                                    </form>
                                    <?php
                                    echo $frmBuyProduct->getExternalJs();
                                } else {
                                    ?>
                                    <div class="sold">
                                        <span class="qty-selection__label"><?php echo Labels::getLabel('LBL_Sold_Out', $siteLangId); ?></span>
                                        <p class="text--normal-secondary"><?php echo Labels::getLabel('LBL_This_item_is_currently_out_of_stock', $siteLangId); ?></p>
                                    </div>
                                <?php } ?>
                                <?php if (strtotime($detailproduct['selprod_available_from']) > strtotime(FatDate::nowInTimezone(FatApp::getConfig('CONF_TIMEZONE'), 'Y-m-d'))) { ?>
                                    <div class="sold">
                                        <span class="qty-selection__label"><?php echo Labels::getLabel('LBL_Not_Available', $siteLangId); ?></span>
                                        <p class="text--normal-secondary">
                                            <?php echo str_replace('{available-date}', FatDate::Format($detailproduct['selprod_available_from']), Labels::getLabel('LBL_This_item_will_be_available_from_{available-date}', $siteLangId)); ?>
                                        </p>
                                    </div>
                                <?php } ?>
                            </div>

                            <!-- ] -->






                        </div>
                        <!-- ] -->


                        <!-- [ PANEL BOX SELLER DETAILS =========== -->
                        <div class="panel-box mb-4 panel-box--seller">

                            <div class="seller-connect">

                                <!-- [ SELLER PROFILE =========== -->
                                <div class="seller-portlet">
                                    <div class="seller-portlet__head">
                                        <div class="seller-portlet__logo"><img src="<?php echo CommonHelper::generateFileUrl('Image', 'shopLogo', array($shop['shop_id'], $siteLangId, 'SMALL')); ?>" alt="<?php echo $shop['shop_name']; ?>"></div>
                                        <div class="seller-portlet__info">
                                            <h6><a href="<?php echo CommonHelper::generateUrl('shops', 'View', array($shop['shop_id'])); ?>"> <?php echo $shop['shop_name']; ?></a></h6>

                                            <div class="seller-portlet__details">
                                                <span class="seller-location"><?php
                                                    if ($shop['shop_state_name']) {
                                                        echo $shop['shop_state_name'] . ', ';
                                                    }
                                                    ?> <?php
                                                    if ($shop['shop_country_name']) {
                                                        echo $shop['shop_country_name'] . ', ';
                                                    }
                                                    ?></span>
                                                <?php if (0 < FatApp::getConfig("CONF_ALLOW_REVIEWS", FatUtility::VAR_INT, 0)) { ?>
                                                    <div class="seller-ratings">
                                                        <div class="ratings">
                                                            <span class="ratings__star site-icon site-icon--small">
                                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 15.216">
                                                                <path d="M8.587,12.949,3.643,15.716l1.1-5.557L.587,6.312l5.627-.667L8.587.5,10.96,5.645l5.627.667-4.16,3.847,1.1,5.557Z" transform="translate(-0.587 -0.5)" fill="#f59f1f"></path>
                                                                </svg>
                                                            </span>
                                                            <span class="ratings__value"><?php echo round($shop_rating, 1); ?></span>
                                                        </div>
                                                    </div>
                                                <?php } ?>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="seller-portlet__body">
                                        <?php if ($subscription_package_id > 0) { ?>
                                            <div class="seller-badges">

                                                <?php if ((isset($subscription_package_id) && $subscription_package_id == SellerPackages::GOLD_PACKAGE) && $shop['seller_verified'] == 1) { ?>
                                                    <div class="seller-badges__grid">
                                                        <div class="badge-item">
                                                            <span class="badge-item__media"><img src="<?php echo CommonHelper::generateFullUrl(); ?>images/green-tick.svg" alt=""></span>
                                                            <span class="badge-item__label"><?php echo Labels::getLabel('LBL_TrustSEAL_Verified', $siteLangId); ?></span>
                                                        </div>
                                                    </div>
                                                <?php } ?>
                                                <?php if ($subscription_package_id == SellerPackages::SILVER_PACKAGE) { ?>
                                                    <div class="seller-badges__grid">
                                                        <div class="badge-item">
                                                            <span class="badge-item__media"><img class="gray-scale" src="<?php echo CONF_WEBROOT_URL; ?>images/dollar.png" alt=""></span>
                                                            <span class="badge-item__label"><?php echo $subscription_package; ?></span>
                                                        </div>
                                                    </div>
                                                <?php } elseif ($subscription_package_id == SellerPackages::GOLD_PACKAGE) { ?>
                                                    <div class="seller-badges__grid">
                                                        <div class="badge-item">
                                                            <span class="badge-item__media"><img src="<?php echo CONF_WEBROOT_URL; ?>images/dollar.png"></span>
                                                            <span class="badge-item__label"><?php echo $subscription_package; ?></span>
                                                        </div>
                                                    </div>
                                                <?php } else { ?>
                                                    <div class="seller-badges__grid">
                                                        <div class="badge-item">
                                                            <span class="badge-item__label"><?php echo $subscription_package; ?></span>
                                                        </div>
                                                    </div>
                                                    <?php
                                                }
                                                if ($shop['is_founding_member'] == 1) {
                                                    ?>
                                                    <div class="seller-badges__grid">
                                                        <div class="badge-item">
                                                            <span class="badge-item__media"> <img src="<?php echo CONF_WEBROOT_URL; ?>images/crown.png"></span>
                                                            <span class="badge-item__label"><?php echo Labels::getLabel('LBL_Founding_Member', $siteLangId); ?></span>
                                                        </div>
                                                    </div>
                                                <?php } ?>

                                            </div>
                                        <?php } ?>

                                        <div class="seller-stats">
                                            <?php if ($sellerStats['responseTime']) { ?>
                                                <div class="seller-stats__item">
                                                    <small><?php echo Labels::getLabel('LBL_Response_Time', $siteLangId); ?></small>
                                                    <h6>&gt; <?php echo $sellerStats['responseTime']; ?></h6>
                                                </div>
                                                <?php
                                            }
                                            if ($sellerStats['deliveryRate']) {
                                                ?>
                                                <div class="seller-stats__item">
                                                    <small><?php echo Labels::getLabel('LBL_On-time_delivery_rate', $siteLangId); ?></small>
                                                    <h6><?php echo $sellerStats['deliveryRate']; ?>%</h6>
                                                </div>
                                            <?php } ?>
                                        </div>

                                        <div class="btns-selection mt-3">
                                            <div class="btns-selection__group text-center">
                                                <small class="small-label"><?php echo Labels::getLabel('Lbl_Ask_for_more_details_from_the_seller', $siteLangId); ?></small>
                                                <a onClick="contactWithSeller(<?php echo $detailproduct['shop_id']; ?>, <?php echo $detailproduct['selprod_id']; ?>);" href="javascript:void(0);" class="btn btn--bordered-brand d-flex align-items-center justify-content-center">
                                                    <span class="site-icon site-icon--small mr-2">
                                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 14.4">
                                                        <path d="M2.8,3H17.2a.8.8,0,0,1,.8.8V16.6a.8.8,0,0,1-.8.8H2.8a.8.8,0,0,1-.8-.8V3.8A.8.8,0,0,1,2.8,3Zm7.248,6.946L4.918,5.59,3.882,6.81l6.176,5.244,6.065-5.248L15.077,5.6,10.049,9.946Z" transform="translate(-2 -3)"></path>
                                                        </svg>
                                                    </span>
                                                    <span> <?php echo Labels::getLabel('Lbl_Contact_Seller', $siteLangId); ?></span>

                                                </a>
                                            </div>
                                        </div>


                                    </div>

                                </div>
                                <!-- ] -->

                            </div>

                        </div>
                        <!-- ] -->


                        <!-- [ PANEL BOX OTHER SELLERS =========== -->
                        <?php if (count($detailproduct['moreSellersArr']) > 0) { ?>
                            <div class="panel-box MB-4 panel-box--others">
                                <div class="panel-box__head d-flex align-items-center justify-content-between">
                                    <div>
                                        <h6 class="mb-0 color-secondary"><?php echo Labels::getLabel('Lbl_Other_Sellers', $siteLangId); ?></h6>
                                    </div>
                                    <div><a href="<?php echo CommonHelper::generateUrl('products', 'sellers', array($detailproduct['selprod_id'])); ?>" class="link"><?php echo Labels::getLabel('Lbl_View_All', $siteLangId); ?></a></div>
                                </div>
                                <div class="panel-box__body">

                                    <div class="pricing-options">
                                        <?php foreach ($detailproduct['moreSellersArr'] as $moreSellerArr) { ?>

                                            <div class="pricing-item">
                                                <div class="pricing-item__head">
                                                    <h6 class="mb-0"><?php echo CommonHelper::displayMoneyFormat($moreSellerArr['theprice']); ?></h6>
                                                    <?php if ($moreSellerArr['is_buy_now'] == AppConstants::YES && strtotime($detailproduct['selprod_available_from']) <= strtotime(FatDate::nowInTimezone(FatApp::getConfig('CONF_TIMEZONE'), 'Y-m-d'))) { ?>
                                                        <a href="javascript:void(0);" class="btn btn--sm btn--bordered color-primary"><?php echo Labels::getLabel('Lbl_Add_to_Cart', $siteLangId); ?></a>
                                                    <?php } ?>
                                                </div>
                                                <div class="pricing-item__content">

                                                    <div class="shop-pro">
                                                        <span class="shop-title d-block"><a href="<?php echo CommonHelper::generateFullUrl('Shops', 'view', array($moreSellerArr['shop_id'])); ?>"><?php echo $moreSellerArr['shop_name']; ?></a></span>
                                                        <div class="shop-details">
                                                            <span class="shop-location"><?php
                                                                if ($moreSellerArr['shop_state_name']) {
                                                                    echo $moreSellerArr['shop_state_name'] . ', ';
                                                                }
                                                                ?> <?php
                                                                if ($moreSellerArr['shop_country_name']) {
                                                                    echo $moreSellerArr['shop_country_name'] . ', ';
                                                                }
                                                                ?></span>
                                                            <div class="shop-ratings">
                                                                <div class="ratings">
                                                                    <span class="ratings__star site-icon site-icon--small">
                                                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 15.216">
                                                                        <path d="M8.587,12.949,3.643,15.716l1.1-5.557L.587,6.312l5.627-.667L8.587.5,10.96,5.645l5.627.667-4.16,3.847,1.1,5.557Z" transform="translate(-0.587 -0.5)" fill="#f59f1f"></path>
                                                                        </svg>
                                                                    </span>
                                                                    <span class="ratings__value"><?php echo round($moreSellerArr['rating'], 1); ?></span>
                                                                </div>
                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>

                                        <?php } ?>
                                    </div>

                                </div>
                            </div>
                        <?php } ?>
                        <!-- ] -->


                    </div>
                    <!-- ] -->

                </div>








                <div class="site-panel__large site-panel--third">
                    <div class="site-content">

                        <nav class="nav-detail horizontal-jump-nav-js">
                            <ul>
                                <?php if ($detailproduct['product_description'] != '') { ?>
                                    <li><a class="scrolls is-active" href="#description"><?php echo Labels::getLabel('LBL_Description', $siteLangId); ?> </a></li>
                                <?php } ?>
                                <?php if ($youtube_embed_code) { ?>
                                    <li><a class="scrolls" href="#video"><?php echo Labels::getLabel('LBL_Video', $siteLangId); ?> </a></li>
                                <?php } ?>
                                <?php if (count($productSpecifications) > 0) { ?>
                                    <li><a class="scrolls" href="#specifications"><?php echo Labels::getLabel('LBL_Specifications', $siteLangId); ?> </a></li>
                                <?php } ?>
                                <li><a class="scrolls" href="#seller-profile"><?php echo Labels::getLabel('LBL_Seller_Profile', $siteLangId); ?> </a></li>
                                <?php if (FatApp::getConfig("CONF_ALLOW_REVIEWS", FatUtility::VAR_INT, 0)) { ?>
                                    <li><a class="scrolls" href="#ratings"><?php echo Labels::getLabel('LBL_Ratings_and_Reviews', $siteLangId); ?> </a></li>
                                <?php } ?>
                                <?php if (!empty($detailproduct['selprodComments'])) { ?>
                                    <li><a class="scrolls" href="#extra-comments"><?php echo Labels::getLabel('LBL_Extra_comments', $siteLangId); ?> </a></li>
                                <?php } ?>

                            </ul>
                        </nav>


                        <div class="site-content__container">

                            <!--[ DESCRITION-->
                            <?php if ($detailproduct['product_description'] != '') { ?>
                                <div id="description" class="panel-row cms">
                                    <h3><?php echo Labels::getLabel('LBL_Description', $siteLangId); ?></h3>
                                    <p><?php echo CommonHelper::renderHtml($detailproduct['product_description']); ?></p>
                                </div>
                            <?php } ?>
                            <!--]-->

                            <?php if ($youtube_embed_code) { ?>
                                <div id="video" class="panel-row">
                                    <div class="cms">
                                        <h3><?php echo Labels::getLabel('LBL_Video', $siteLangId); ?></h3>
                                    </div>

                                    <?php if ($youtube_embed_code != "") : ?>
                                        <div class="mb-4 video-wrapper">
                                            <iframe width="100%" height="415" src="//www.youtube.com/embed/<?php echo $youtube_embed_code ?>" allowfullscreen></iframe>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            <?php } ?>



                            <!--[ SPECIFICATIONS-->
                            <?php if (count($productSpecifications) > 0) { ?>
                                <div id="specifications" class="panel-row cms">
                                    <h3><?php echo Labels::getLabel('LBL_Specifications', $siteLangId); ?></h3>

                                    <div class="row">
                                        <div class="col-sm-6">
                                            <table>
                                                <tbody>

                                                    <?php foreach ($productSpecifications as $key => $specification) { ?>
                                                        <tr>
                                                            <th width="50%"><?php echo $specification['prodspec_name'] . ":"; ?></th>
                                                            <td><?php echo html_entity_decode($specification['prodspec_value'], ENT_QUOTES, 'utf-8'); ?></td>
                                                        </tr>
                                                    <?php } ?>
                                                </tbody>
                                            </table>
                                        </div>

                                    </div>

                                </div>
                            <?php } ?>
                            <!--]-->


                            <div id="seller-profile" class="panel-row">
                                <div class="cms">
                                    <h3><?php echo Labels::getLabel('LBL_Seller_Profile', $siteLangId); ?></h3>
                                </div>
                                <?php
                                $shop['subscription_package_id'] = $subscription_package_id;
                                $shop['selprod_id'] = $detailproduct['selprod_id'];
                                $this->includeTemplate('/shops/seller-profile.php', array('isProductDetail' => true, 'sellerProfileData' => $sellerProfileData, 'shop_rating' => $shop_rating, 'shop' => $shop, 'siteLangId' => $siteLangId, 'faqs' => $faqs, 'sellerProfileData' => $sellerProfileData, 'countryCode' => $detailproduct['seller_country'], 'sellerTypeArr' => $sellerTypeArr, 'shopDocuments' => $shopDocuments), false);
                                ?>
                            </div>
                            <!--]-->


                            <!--[ RATINGS-->
                            <?php if (FatApp::getConfig("CONF_ALLOW_REVIEWS", FatUtility::VAR_INT, 0)) { ?>

                                <div id="ratings" class="panel-row">

                                    <?php echo $frmReviewSearch->getFormHtml(); ?>
                                    <?php $this->includeTemplate('_partial/product-reviews.php', array('reviews' => $reviews, 'siteLangId' => $siteLangId, 'product_id' => $detailproduct['product_id'], 'canSubmitFeedback' => $canSubmitFeedback), false); ?>


                                </div>
                            <?php } ?>
                            <!--]-->

                            <?php if (!empty($detailproduct['selprodComments'])) { ?>
                                <div id="extra-comments" class="panel-row">
                                    <div class="cms">
                                        <h3><?php echo Labels::getLabel('LBL_Extra_comments', $siteLangId); ?></h3>
                                        <p><?php echo CommonHelper::displayNotApplicable($siteLangId, nl2br($detailproduct['selprodComments'])); ?></p>
                                    </div>
                                </div>
                            <?php } ?>

                        </div>


                        <!-- ] -->

                        <!-- [ PANEL RIGHT =========== -->

                        <!-- ] -->
                    </div>



                </div>

            </div>
        </div>
    </section>


    <!-- [ SIMILAR PRODUCTS =========== -->
    <?php if ($relatedProductsRs) { ?>

        <?php include(CONF_THEME_PATH . 'products/related-products.php'); ?>

    <?php } ?>

    <?php if ($recommendedProducts) { ?>

        <?php include(CONF_THEME_PATH . 'products/recommended-products.php'); ?>

    <?php } ?>



    <?php if (isset($banners['Product_Detail_Page_Banner']) && $banners['Product_Detail_Page_Banner']['blocation_active'] && count($banners['Product_Detail_Page_Banner']['banners'])) { ?>
        <section class="section">
            <div class="container">
                <div class="row justify-content-center">


                    <?php
                    foreach ($banners['Product_Detail_Page_Banner']['banners'] as $val) {
                        $desktop_url = '';
                        $tablet_url = '';
                        $mobile_url = '';
                        if (!AttachedFile::getMultipleAttachments(AttachedFile::FILETYPE_BANNER, $val['banner_id'], 0, $siteLangId)) {
                            continue;
                        } else {
                            $slideArr = AttachedFile::getMultipleAttachments(AttachedFile::FILETYPE_BANNER, $val['banner_id'], 0, $siteLangId);
                            foreach ($slideArr as $slideScreen) {
                                $mobile_url = CommonHelper::generateFileUrl('Banner', 'productDetailPageBanner', array($val['banner_id'], $siteLangId, AppConstants::SCREEN_MOBILE)) . ",";
                                $tablet_url = CommonHelper::generateFileUrl('Banner', 'productDetailPageBanner', array($val['banner_id'], $siteLangId, AppConstants::SCREEN_IPAD)) . ",";
                                $desktop_url = CommonHelper::generateFileUrl('Banner', 'productDetailPageBanner', array($val['banner_id'], $siteLangId, AppConstants::SCREEN_DESKTOP)) . ",";
                            }
                        }
                        ?>
                        <div class="col-md-6">
                            <div class="banner-ppc 1">
                                <a href="<?php echo CommonHelper::generateFileUrl('Banner', 'url', array($val['banner_id'])); ?>" target="<?php echo $val['banner_target']; ?>" title="<?php echo $val['banner_title']; ?>">

                                    <picture>
                                        <source data-aspect-ratio="4:3" srcset="<?php echo $mobile_url; ?>" media="(max-width: 767px)">
                                        <source data-aspect-ratio="4:3" srcset="<?php echo $tablet_url; ?>" media="(max-width: 1024px)">
                                        <source data-aspect-ratio="4:1" srcset="<?php echo $desktop_url; ?>">
                                        <img data-aspect-ratio="4:1" srcset="<?php echo $desktop_url; ?>" alt="">
                                    </picture>

                                </a>
                            </div>
                        </div>
                    <?php } ?>


                </div>
            </div>
            <?php
            if (isset($val['banner_record_id']) && $val['banner_record_id'] > 0 && $val['banner_type'] == Banner::TYPE_PPC) {
                Promotion::updateImpressionData($val['banner_record_id']);
            }
            ?>
        </section>
    <?php } ?>

    <!-- Don't remove scrollUpTo-js span -->
    <span id="scrollUpTo-js"></span>
    <!-- ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ -->




    <div id="recentlyViewedProductsDiv"></div>

</div>
<script type="text/javascript">
    var mainSelprodId = <?php echo $detailproduct['selprod_id']; ?>;
    var layout = '<?php echo CommonHelper::getLayoutDirection(); ?>';

    $("document").ready(function () {
        recentlyViewedProducts(<?php echo $detailproduct['selprod_id']; ?>);
        /*zheight = $(window).height() - 180; */
        zwidth = $(window).width() / 3 - 15;

        if (layout == 'rtl') {
            $('.xzoom, .xzoom-gallery').xzoom({
                zoomWidth: zwidth,
                /*zoomHeight: zheight,*/
                title: true,
                tint: '#333',
                position: 'left'
            });
        } else {
            $('.xzoom, .xzoom-gallery').xzoom({
                zoomWidth: zwidth,
                /*zoomHeight: zheight,*/
                title: true,
                tint: '#333',
                Xoffset: 2
            });
        }

        window.setInterval(function () {
            var scrollPos = $(window).scrollTop();
            if (scrollPos > 0) {
                setProductWeightage('<?php echo $detailproduct['selprod_code']; ?>');
            }
        }, 5000);

    });

<?php /* if( isset($banners['Product_Detail_Page_Banner']) && $banners['Product_Detail_Page_Banner']['blocation_active'] && count($banners['Product_Detail_Page_Banner']['banners']) ) { ?>
  $(function() {
  if ($(window).width() > 1050) {
  $(window).scroll(sticky_relocate);
  sticky_relocate();
  }
  });
  <?php } */ ?>
</script>
<script>

    
    $(document).ready(function () {
        $('.xzoom-gallery').click(function(){
            $(".product-video--js").hide();
            $(".product-gallery--js").show();
        });

        /* [ HIDE SHOW PAYMENT ICONS ON HOVER */
        $('.payment-icon--js').on('mouseover', function () {
            //$('.on-hover-active').hide();
            $(this).find('.on-hover-active').addClass('show-payment-icon');
        });
        $('.payment-icon--js').on('mouseout', function () {
            //$('.on-hover-active').hide();
            $(this).find('.on-hover-active').removeClass('show-payment-icon');
        });
        /* ] */
        $("#btnAddToCart").addClass("quickView");
        $('#slider-for').slick(getSlickGallerySettings(false));
        //	$('#slider-nav').slick(getSlickGallerySettings(true, '<?php echo CommonHelper::getLayoutDirection(); ?>'));

        /* for toggling of tab/list view[ */
        $('.list-js').hide();
        $('.view--link-js').on('click', function (e) {
            $('.view--link-js').removeClass("btn--active");
            $(this).addClass("btn--active");
            if ($(this).hasClass('list')) {
                $('.tab-js').hide();
                $('.list-js').show();
            } else if ($(this).hasClass('tab')) {
                $('.list-js').hide();
                $('.tab-js').show();
            }
        });
        /* ] */

        $(".nav-scroll-js").click(function (event) {
            event.preventDefault();
            var full_url = this.href;
            var parts = full_url.split("#");
            var trgt = parts[1];
            /* var target_offset = $("#" + trgt).offset();
             
             var target_top = target_offset.top - $('#header').height();
             $('html, body').animate({
             scrollTop: target_top
             }, 800); */
            $('html, body').animate({
                scrollTop: parseInt($("#" + trgt).position().top) + parseInt($("#scrollUpTo-js").position().top)
            }, 800);

        });
        $('.nav-detail-js li a').click(function () {
            $('.nav-detail-js li a').removeClass('is-active');
            $(this).addClass('is-active');
        });

        var headerHeight = $("#header").height();
        var subHeaderHeight = $("#header .last-bar").height();
        headerHeight = headerHeight - subHeaderHeight - 5;
        $(".nav-detail-js").css('top', headerHeight);

    });



    /* FOR PRODUCT SLIDESHOW */
    $('.slideshow-controls-js').slick({
        slidesToShow: 4,
        slidesToScroll: 1,
        infinite: false,
        arrows: true,

        prevArrow: '<a data-role="none" class="slick-prev" aria-label="previous"><span></span></a>',
        nextArrow: '<a data-role="none" class="slick-next" aria-label="next"><span></span></a>',
        responsive: [

            {
                breakpoint: 1199,
                settings: {
                    slidesToShow: 3,
                }
            }, {
                breakpoint: 1023,
                settings: {
                    slidesToShow: 6,
                }
            }, {
                breakpoint: 767,
                settings: {
                    slidesToShow: 4,
                }
            }


        ]
    });




    $(".selection-trigger-js").click(function () {
        $(this).toggleClass("is-active");
        $(".selection-target-js").slideToggle();
    });
</script>
<script>
    $(document).ready(function () {
        var stopVideo = function (player) {
            var vidSrc = $(player).prop('src');
            $(player).prop('src', ''); // to force it to pause
            $(player).prop('src', vidSrc);
        };

        $('.product-video-thum--js').on('click', function (e) {
            e.preventDefault();
            $('.product-gallery--js').hide();
            $('.product-video--js').show();
        });
<?php if (!empty($youtube_embed_code)) { ?>
            $('.product-thumb--js').on('click', function (e) {
                stopVideo('#product-video');
                $('.product-gallery--js').show();
                $('.product-video--js').hide();
            })
<?php } ?>
    })


    function makeTimer() {
        var endTime = new Date("<?php echo $detailproduct['splprice_end_date']; ?>");
        endTime = (Date.parse(endTime) / 1000);

        var now = new Date();
        now = (Date.parse(now) / 1000);

        var timeLeft = endTime - now;

        var days = Math.floor(timeLeft / 86400);
        var hours = Math.floor((timeLeft - (days * 86400)) / 3600);
        var minutes = Math.floor((timeLeft - (days * 86400) - (hours * 3600)) / 60);
        var seconds = Math.floor((timeLeft - (days * 86400) - (hours * 3600) - (minutes * 60)));

        $("#days").html(days + "<span><?php echo Labels::getLabel('LBL_Days', $siteLangId); ?></span>");
        $("#hours").html(hours + "<span><?php echo Labels::getLabel('LBL_Hours', $siteLangId); ?></span>");
        /* $("#minutes").html(minutes + "<span><?php echo Labels::getLabel('LBL_Minutes', $siteLangId); ?></span>");
         $("#seconds").html(seconds + "<span><?php echo Labels::getLabel('LBL_Seconds', $siteLangId); ?></span>"); */

        if (days <= "1") {
            $("#days").html("");
        }
        if (days > "1") {
            $("#hours, #minutes, #seconds").html("");
        }
    }
    setInterval(function () {
        makeTimer();
    }, 1000);
</script>
<style>
    .slick-track {
        margin-left: 0px;
    }

    .w-inh {
        width: inherit;
    }

    .detail-page .product-labels {
        position: initial;
    }
</style>
<!--Here is the facebook OG for this product  -->
<?php echo $this->includeTemplate('_partial/shareThisScript.php'); ?>

<script type="application/ld+json">
    {
        "@context": "http://schema.org",
        "@type": "Product",
        <?php if (isset($reviews['prod_rating']) && 0 < $reviews['prod_rating']) { ?> 
            "aggregateRating": {
                "@type": "AggregateRating",
                "ratingValue": "<?php echo round(FatUtility::convertToType($reviews['prod_rating'], FatUtility::VAR_FLOAT), 1); ?>",
                "reviewCount": "<?php echo FatUtility::int($reviews['totReviews']); ?>"
            },
        <?php } ?> 
        "description": "<?php echo strip_tags(CommonHelper::renderHtml($product['product_description'])); ?>",
        "name": "<?php echo $product['selprod_title']; ?>",
        <?php if (isset($product['brand_name']) && !empty($product['brand_name'])) { ?> 
            "brand": "<?php echo $product['brand_name']; ?>",
        <?php } ?>
        <?php if (isset($product['selprod_sku']) && !empty($product['selprod_sku'])) { ?> 
            "sku": "<?php echo $product['selprod_sku']; ?>",
        <?php } ?> 
        "image": "<?php echo UrlHelper::getCachedUrl(UrlHelper::generateFullFileUrl('Image', 'product', [$product['product_id'], 'THUMB', 0, $image['afile_id']]), CONF_IMG_CACHE_TIME, '.jpg'); ?>",
        "offers": {
            "@type": "Offer",
            "availability": "http://schema.org/InStock",
            "price": "<?php echo $product['theprice']; ?>",
            "url": "<?php echo UrlHelper::generateFullUrl('Products', 'view', [$product['selprod_id']]); ?>",
            "priceCurrency": "<?php echo CommonHelper::getCurrencyCode(); ?>"
        }
    }
</script>