<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
if ($recentViewedProducts) {
?>
    <section class="section section-large section-gray">
        <div class="container">
            <div class="section-card">
                <div class="section-head mb-5">
                    <div class="section-head__title justify-content-center">
                        <h2><?php echo Labels::getLabel('LBL_Recently_Viewed', $siteLangId); ?></h2>
                    </div>
                </div>
                <div class="section-body">
                    <div class="site-caraousel site-caraousel--6 site-caraousel-jsrecent" dir="<?php echo CommonHelper::getLayoutDirection(); ?>">
                        <?php
                        foreach ($recentViewedProducts as $product) {
                            $product['product_id'] = $product['product_id'];
                            $product['product_updated_on'] = $product['selprod_updated_on'];
                            $product['product_name'] = $product['selprod_title'];
                            $productUrl = CommonHelper::generateUrl('Products', 'View', array($product['selprod_id']));
                        ?>
                            <div>
                                <div class="site-caraousel__item">
                                    <div class="product-card product-card--hovered">
                                        <?php include(CONF_THEME_PATH . '_partial/collection/product-card.php'); ?>
                                    </div>
                                </div>
                            </div>


                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <script>
        var rtlmode = false;
        if (langLbl.layoutDirection == 'rtl') {
            rtlmode = true;
        }

        $('.site-caraousel-jsrecent').slick({
            dots: false,
            arrows: true,
            rtl: rtlmode,
            infinite: false,
            speed: 300,
            slidesToShow: 6,
            slidesToScroll: 1,
            prevArrow: '<a data-role="none" class="slick-prev" aria-label="previous"></a>',
            nextArrow: '<a data-role="none" class="slick-next" aria-label="next"></a>',
            responsive: [{
                    breakpoint: 1599,
                    settings: {
                        slidesToShow: 5,
                        slidesToScroll: 1,
                    }
                },

                {
                    breakpoint: 1199,
                    settings: {
                        slidesToShow: 4,
                        slidesToScroll: 1,
                        arrows: false,
                        dots: true,
                    }
                },
                {
                    breakpoint: 1023,
                    settings: {
                        slidesToShow: 3,
                        slidesToScroll: 1,
                        arrows: false,
                        dots: true,
                    }
                },
                {
                    breakpoint: 767,
                    settings: {
                        slidesToShow: 2,
                        slidesToScroll: 1,
                        arrows: false,
                        dots: true,

                    }
                }
            ]
        });
    </script>
<?php } ?>