<section class="section section-details">
	<div class="container">

		<div class="front-panel">

			<!-- [ PANEL LEFT =========== -->
			<div class="front-panel__left">

				<div class="js-product-gallery1 product-gallery">
					<div class="slideshow-media">
						<?php
						if ($product['selprod_type'] == SellerProduct::PRODUCT_TYPE_SERVICE) {
							$imgUrl = FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'serviceProduct', array(FatUtility::int($product['selprod_id']), 'MEDIUM', 0, $siteLangId)), CONF_IMG_CACHE_TIME, '.jpg');
						} else {
							$imgUrl = FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'product', array($product['product_id'], "MEDIUM", $product['selprod_id'], 0, $siteLangId)), CONF_IMG_CACHE_TIME, '.jpg');
						}						
						?>
						<img id="xzoom-default" src="<?php echo $imgUrl; ?>" alt="">
					</div>
				</div>

			</div>
			<!-- ] -->


			<!-- [ PANEL MIDDLE =========== -->
			<div class="front-panel__middle">
				<?php if (!empty($product['brand_name'])) { ?>
					<span class="brand-title"><strong><?php echo Labels::getLabel('LBL_Brand', $siteLangId); ?>:</strong> <a target="_blank" href="<?php echo CommonHelper::generateUrl('Brands', 'view', [$product['brand_id']]); ?>"> <?php echo $product['brand_name']; ?></a></span>
				<?php } ?>
				<h1 class="page-title mt-0 mb-2"><a href="<?php echo CommonHelper::generateUrl('Products', 'View', array($product['selprod_id'])); ?>"><?php echo $product['selprod_title']; ?></a> </h1>


				<!-- [ PANEL ACTIONS =========== -->
				<div class="panel-list">
					<?php if (FatApp::getConfig("CONF_ALLOW_REVIEWS", FatUtility::VAR_INT, 0)) {
						$totReviews = isset($reviews['totReviews']) ? FatUtility::int($reviews['totReviews']) : '';
						$avgRating = isset($reviews['avg_seller_rating']) ? FatUtility::convertToType($reviews['avg_seller_rating'], FatUtility::VAR_FLOAT) : 0;
						$rated_1 = isset($reviews['rated_1']) ? FatUtility::int($reviews['rated_1']) : '';
						$rated_2 = isset($reviews['rated_2']) ? FatUtility::int($reviews['rated_2']) : '';
						$rated_3 = isset($reviews['rated_3']) ? FatUtility::int($reviews['rated_3']) : '';
						$rated_4 = isset($reviews['rated_4']) ? FatUtility::int($reviews['rated_4']) : '';
						$rated_5 = isset($reviews['rated_5']) ? FatUtility::int($reviews['rated_5']) : '';

						$pixelToFillRight = $avgRating / 5 * 160;
						$pixelToFillRight = FatUtility::convertToType($pixelToFillRight, FatUtility::VAR_FLOAT);

						$rate_5_width = $rate_4_width = $rate_3_width = $rate_2_width = $rate_1_width = 0;

						if ($totReviews) {
							$rate_5_width = round(FatUtility::convertToType($rated_5 / $totReviews * 100, FatUtility::VAR_FLOAT), 2);
							$rate_4_width = round(FatUtility::convertToType($rated_4 / $totReviews * 100, FatUtility::VAR_FLOAT), 2);
							$rate_3_width = round(FatUtility::convertToType($rated_3 / $totReviews * 100, FatUtility::VAR_FLOAT), 2);
							$rate_2_width = round(FatUtility::convertToType($rated_2 / $totReviews * 100, FatUtility::VAR_FLOAT), 2);
							$rate_1_width = round(FatUtility::convertToType($rated_1 / $totReviews * 100, FatUtility::VAR_FLOAT), 2);
						}


					?>
						<div class="panel-list__item">
							<?php $label = (round($product['prod_rating']) > 0) ? round($product['totReviews'], 1) . ' ' . Labels::getLabel('LBL_Reviews', $siteLangId) : Labels::getLabel('LBL_No_Reviews', $siteLangId); ?>
							<div class="ratings ratings--hovered">
								<a href="#ratings" class="ratings__trigger scrolls">
									<span class="ratings__star site-icon site-icon--xsmall">
										<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16">
											<path d="M12.943,27.378,8,24.659,3.057,27.378,4,21.618,0,17.539l5.527-.84L8,11.378,10.473,16.7l5.527.84-4,4.079Z" transform="translate(0 -11.378)" fill="#f5961d"></path>
										</svg>
									</span>
									<span class="ratings__value"><?php echo round($product['prod_rating'], 1); ?></span>
									<span class="ratings__count">| <?php echo $label; ?></span>
								</a>
								<div class="ratings__target">

									<div class="ratings-progress p-4">

										<div class="ratings">
											<span class="ratings__value m-0"><?php echo round($product['prod_rating'], 1) . ' ' . Labels::getLabel('Lbl_Out_of', $siteLangId) . ' ' . '5'; ?></span>
											<span class="ratings__count">| <?php echo $totReviews . ' ', Labels::getLabel('Lbl_Reviews_&_Ratings', $siteLangId); ?></span>
										</div>

										<div class="progress-list">
											<ul>
												<li>
													<span class="progress-list__count">5 <?php echo Labels::getLabel('Lbl_Star', $siteLangId); ?></span>
													<div class="progress-list__bar">
														<div title="<?php echo $rate_5_width, '% ', Labels::getLabel('LBL_Number_of_reviews_have_5_stars', $siteLangId); ?>" style="width: <?php echo $rate_5_width; ?>%; clip: rect(0px, 0px, 160px, 0px);" role="progressbar" class="progress-list__bar-fill"></div>
													</div>
												</li>
												<li>
													<span class="progress-list__count">4 <?php echo Labels::getLabel('Lbl_Star', $siteLangId); ?></span>
													<div class="progress-list__bar">
														<div title="<?php echo $rate_4_width, '% ', Labels::getLabel('LBL_Number_of_reviews_have_4_stars', $siteLangId); ?>" style="width: <?php echo $rate_4_width; ?>%; clip: rect(0px, 0px, 160px, 0px);" role="progressbar" class="progress-list__bar-fill"></div>
													</div>
												</li>
												<li>
													<span class="progress-list__count">3 <?php echo Labels::getLabel('Lbl_Star', $siteLangId); ?></span>
													<div class="progress-list__bar">
														<div title="<?php echo $rate_3_width, '% ', Labels::getLabel('LBL_Number_of_reviews_have_3_stars', $siteLangId); ?>" style="width: <?php echo $rate_3_width; ?>%; clip: rect(0px, 0px, 160px, 0px);" role="progressbar" class="progress-list__bar-fill"></div>
													</div>
												</li>
												<li>
													<span class="progress-list__count">2 <?php echo Labels::getLabel('Lbl_Star', $siteLangId); ?></span>
													<div class="progress-list__bar">
														<div title="<?php echo $rate_2_width, '% ', Labels::getLabel('LBL_Number_of_reviews_have_2_stars', $siteLangId); ?>" style="width: <?php echo $rate_2_width; ?>%; clip: rect(0px, 0px, 160px, 0px);" role="progressbar" class="progress-list__bar-fill"></div>
													</div>
												</li>
												<li>
													<span class="progress-list__count">1 <?php echo Labels::getLabel('Lbl_Star', $siteLangId); ?></span>
													<div class="progress-list__bar">
														<div title="<?php echo $rate_1_width, '% ', Labels::getLabel('LBL_Number_of_reviews_have_1_stars', $siteLangId); ?>" style="width: <?php echo $rate_1_width; ?>%; clip: rect(0px, 0px, 160px, 0px);" role="progressbar" class="progress-list__bar-fill"></div>
													</div>
												</li>
											</ul>
										</div>

										<hr>
										<a href="<?php echo CommonHelper::generateUrl('Products', 'View', array($product['selprod_id'])); ?>" class="link scrolls"><?php echo Labels::getLabel('LBL_See_all_customer_reviews', $siteLangId) ?></a>

									</div>

								</div>
							</div>

						</div>
					<?php } ?>

					<?php
					if (FatApp::getConfig('CONF_ADD_FAVORITES_TO_WISHLIST', FatUtility::VAR_INT, 1) == AppConstants::NO) {
						$jsFunc = 0 < $product['ufp_id'] ? 'removeFromFavorite(' . $product['selprod_id'] . ')' : 'markAsFavorite(' . $product['selprod_id'] . ')';
					?>
						<div class="panel-list__item">
							<a href="javascript:void(0)" class="btn btn--icon btn--fav <?php echo ($product['ufp_id']) ? 'is-active' : ''; ?>" onclick="<?php echo $jsFunc; ?>" data-id="<?php echo $product['selprod_id']; ?>"" title=" <?php echo ($product['ufp_id']) ? Labels::getLabel('LBL_Remove_product_from_favourite_list', $siteLangId) : Labels::getLabel('LBL_Add_Product_to_favourite_list', $siteLangId); ?>">
								<span class="site-icon">
									<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 14.8">
										<path d="M13.6,3A4.521,4.521,0,0,1,18,7.8c0,5.6-6,8.8-8,10-2-1.2-8-4.4-8-10A4.54,4.54,0,0,1,6.4,3,5.293,5.293,0,0,1,10,4.6,5.293,5.293,0,0,1,13.6,3Z" transform="translate(-2 -3)"></path>
									</svg>
								</span> <?php echo Labels::getLabel('LBL_Favorite', $siteLangId) ?>
							</a>
						</div>
					<?php } else { ?>
						<div class="panel-list__item">
							<a href="javascript:void(0)" class="btn btn--icon btn--fav  <?php echo ($product['is_in_any_wishlist']) ? 'is-active' : ''; ?>" id="listDisplayDiv_<?php echo $product['selprod_id']; ?>" data-id="<?php echo $product['selprod_id']; ?>" onClick="viewWishList(<?php echo $product['selprod_id']; ?>, this, event);" title="<?php echo ($product['is_in_any_wishlist']) ? Labels::getLabel('LBL_Remove_product_from_your_wishlist', $siteLangId) : Labels::getLabel('LBL_Add_Product_to_your_wishlist', $siteLangId); ?>">
								<span class="site-icon">
									<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 14.8">
										<path d="M13.6,3A4.521,4.521,0,0,1,18,7.8c0,5.6-6,8.8-8,10-2-1.2-8-4.4-8-10A4.54,4.54,0,0,1,6.4,3,5.293,5.293,0,0,1,10,4.6,5.293,5.293,0,0,1,13.6,3Z" transform="translate(-2 -3)"></path>
									</svg>
								</span><?php echo Labels::getLabel('LBL_Favorite', $siteLangId) ?>
							</a>
						</div>
					<?php  } ?>

					<div class="panel-list__item">

						<div class="social-share social-share--hovered">
							<a href="#social-target-js" class="btn btn--icon btn--share trigger-js">
								<span class="site-icon">
									<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 13 13.009">
										<path d="M1514.616,192.269a2.38,2.38,0,0,0-1.866.908l-4.058-2.058a2.1,2.1,0,0,0-.017-1.278l4.039-2.049a2.356,2.356,0,1,0-.487-1.421,2.331,2.331,0,0,0,.092.615l-4.056,2.059a2.368,2.368,0,1,0,.035,2.879l4.038,2.049a2.32,2.32,0,0,0-.109.667,2.389,2.389,0,1,0,2.388-2.371Z" transform="translate(-1504.006 -184.001)"></path>
									</svg>
								</span> <?php echo Labels::getLabel('Lbl_Share', $siteLangId); ?>
							</a>
							<div id="social-target-js" class="social-share__target social-share__target-js">
								<ul class="sharing-actions">
									<li class="social-facebook">
										<a class="st-custom-button" data-network="facebook" data-url="<?php echo CommonHelper::generateFullUrl('Products', 'view', array($product['selprod_id'])); ?>/">
											<i class="icn">
												<svg class="svg" viewBox="0 0 430.113 430.114">
													<path d="M158.081,83.3c0,10.839,0,59.218,0,59.218h-43.385v72.412h43.385v215.183h89.122V214.936h59.805   c0,0,5.601-34.721,8.316-72.685c-7.784,0-67.784,0-67.784,0s0-42.127,0-49.511c0-7.4,9.717-17.354,19.321-17.354   c9.586,0,29.818,0,48.557,0c0-9.859,0-43.924,0-75.385c-25.016,0-53.476,0-66.021,0C155.878-0.004,158.081,72.48,158.081,83.3z"></path>
												</svg></i>
										</a>
									</li>
									<li class="social-twitter">
										<a class="st-custom-button" data-network="twitter">
											<i class="icn">
												<svg class="svg" viewBox="0 0 512 512">
													<path d="M512,97.248c-19.04,8.352-39.328,13.888-60.48,16.576c21.76-12.992,38.368-33.408,46.176-58.016    c-20.288,12.096-42.688,20.64-66.56,25.408C411.872,60.704,384.416,48,354.464,48c-58.112,0-104.896,47.168-104.896,104.992    c0,8.32,0.704,16.32,2.432,23.936c-87.264-4.256-164.48-46.08-216.352-109.792c-9.056,15.712-14.368,33.696-14.368,53.056    c0,36.352,18.72,68.576,46.624,87.232c-16.864-0.32-33.408-5.216-47.424-12.928c0,0.32,0,0.736,0,1.152    c0,51.008,36.384,93.376,84.096,103.136c-8.544,2.336-17.856,3.456-27.52,3.456c-6.72,0-13.504-0.384-19.872-1.792    c13.6,41.568,52.192,72.128,98.08,73.12c-35.712,27.936-81.056,44.768-130.144,44.768c-8.608,0-16.864-0.384-25.12-1.44    C46.496,446.88,101.6,464,161.024,464c193.152,0,298.752-160,298.752-298.688c0-4.64-0.16-9.12-0.384-13.568    C480.224,136.96,497.728,118.496,512,97.248z"></path>
												</svg></i>
										</a>
									</li>
									<li class="social-pintrest">
										<a class="st-custom-button" data-network="pinterest">
											<i class="icn"><svg class="svg" viewBox="0 0 100.001 100.001">
													<path d="M43.081,66.14c-2.626,13.767-5.833,26.966-15.333,33.861c-2.932-20.809,4.307-36.436,7.668-53.027   c-5.73-9.646,0.689-29.062,12.777-24.277c14.873,5.885-12.881,35.865,5.75,39.611c19.453,3.908,27.395-33.752,15.332-46   C51.847-1.376,18.542,15.905,22.638,41.224c0.996,6.191,7.391,8.068,2.555,16.611c-11.154-2.473-14.484-11.27-14.055-23   c0.69-19.197,17.25-32.639,33.86-34.498c21.006-2.352,40.721,7.711,43.443,27.471c3.066,22.303-9.48,46.459-31.943,44.721   C50.41,72.056,47.853,69.04,43.081,66.14z"></path>
												</svg></i>
										</a>
									</li>
									<li class="social-email">
										<a class="st-custom-button" data-network="email">
											<i class="icn"><svg class="svg" viewBox="0 0 483.3 483.3">
													<g>
														<path d="M424.3,57.75H59.1c-32.6,0-59.1,26.5-59.1,59.1v249.6c0,32.6,26.5,59.1,59.1,59.1h365.1c32.6,0,59.1-26.5,59.1-59.1    v-249.5C483.4,84.35,456.9,57.75,424.3,57.75z M456.4,366.45c0,17.7-14.4,32.1-32.1,32.1H59.1c-17.7,0-32.1-14.4-32.1-32.1v-249.5    c0-17.7,14.4-32.1,32.1-32.1h365.1c17.7,0,32.1,14.4,32.1,32.1v249.5H456.4z"></path>
														<path d="M304.8,238.55l118.2-106c5.5-5,6-13.5,1-19.1c-5-5.5-13.5-6-19.1-1l-163,146.3l-31.8-28.4c-0.1-0.1-0.2-0.2-0.2-0.3    c-0.7-0.7-1.4-1.3-2.2-1.9L78.3,112.35c-5.6-5-14.1-4.5-19.1,1.1c-5,5.6-4.5,14.1,1.1,19.1l119.6,106.9L60.8,350.95    c-5.4,5.1-5.7,13.6-0.6,19.1c2.7,2.8,6.3,4.3,9.9,4.3c3.3,0,6.6-1.2,9.2-3.6l120.9-113.1l32.8,29.3c2.6,2.3,5.8,3.4,9,3.4    c3.2,0,6.5-1.2,9-3.5l33.7-30.2l120.2,114.2c2.6,2.5,6,3.7,9.3,3.7c3.6,0,7.1-1.4,9.8-4.2c5.1-5.4,4.9-14-0.5-19.1L304.8,238.55z"></path>
													</g>
												</svg></i>
										</a>
									</li>
								</ul>
							</div>
						</div>


					</div>



				</div>
				<!-- ] -->


				<?php if (CommonHelper::isDisplayPrice($product)) { //echo '<pre>';print_r($product); 
				?>
					<div class="panel-price">

						<?php if ($product['special_price_found']) { ?>
							<span class="panel-price__old"><?php echo CommonHelper::getCurrencyCode() . CommonHelper::displayMoneyFormat($product['selprod_price']); ?></span>

						<?php } ?>
						<span class="panel-price__standard">
							<span class="panel-price__main"><?php echo CommonHelper::getCurrencyCode() . CommonHelper::displayMoneyFormat($product['theprice']); ?></span>
							<span class="panel-price__normal-text"><?php echo $product['selprod_min_order_qty']; ?> <?php echo Labels::getLabel('Lbl_Piece/Pieces(Min._Order)', $siteLangId); ?></span>
						</span>
						<?php if ($product['special_price_found']) { ?>
							<span class="panel-price__off">
								<span class="panel-price__discounted"><?php echo CommonHelper::showProductDiscountedText($product, $siteLangId); ?></span>
								<span><?php echo Labels::getLabel('Lbl_discount_ends_in', $siteLangId); ?></span>

								<span class="validity-timer">
									<span class="validity-timer__media">
										<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 14 14">
											<path d="M9,16a7,7,0,1,1,7-7A7,7,0,0,1,9,16Zm0-1.4A5.6,5.6,0,1,0,3.4,9,5.6,5.6,0,0,0,9,14.6ZM9.7,9h2.8v1.4H8.3V5.5H9.7Z" transform="translate(-2 -2)" fill="#333"></path>
										</svg>
									</span>
									<span class="validity-timer__counter">
										<div class="count-down">
											<span id="days"></span>
											<span id="hours"></span>
											<span id="minutes"></span>
											<span id="seconds"></span>
										</div>
									</span>
								</span>
							</span>
						<?php } ?>
					</div>
				<?php } ?>


				<div class="panel-options">
					<?php if ($product['selprod_type'] == SellerProduct::PRODUCT_TYPE_SERVICE) {
							?>
						<div class="options-list">
							<div class="options-list__trigger"><?php $yesOrNo = AppConstants::getYesNoArr($siteLangId); 
							echo Labels::getLabel('LBL_Shipping_Required', $siteLangId); ?></div>
							<div class="options-list__target">
								<div class="hifen-list"> <?php echo $yesOrNo[$product['selprod_is_shipping_required']]; ?></div>
							</div>
						</div>                            
						<div class="options-list">
							<div class="options-list__trigger"><?php echo Labels::getLabel('LBL_Document_Required', $siteLangId); ?></div>
							<div class="options-list__target">
								<div class="hifen-list"> <?php echo $yesOrNo[$product['selprod_document_required']]; ?></div>
							</div>
						</div>
					<?php } ?>
					<!-- [ OPTION 2  =========== -->

					<?php if (!empty($optionRows)) { ?>

						<?php
						$selectedOptionsArr = $product['selectedOptionValues'];
						$count = 0;
						foreach ($optionRows as $key => $option) {
							$selectedOptionValue = $option['values'][$selectedOptionsArr[$key]]['optionvalue_name'];
							$selectedOptionColor = $option['values'][$selectedOptionsArr[$key]]['optionvalue_color_code'];
						?>
							<div class="options-list">
								<div class="options-list__trigger"><?php echo $option['option_name']; ?></div>

								<div class="options-list__target">

									<?php if ($option['values']) { ?>
										<div class="option-selector">

											<?php
											foreach ($option['values'] as $opVal) {
												$isAvailable = true;
												if (in_array($opVal['optionvalue_id'], $product['selectedOptionValues'])) {
													$optionUrl = CommonHelper::generateUrl('Products', 'view', array($product['selprod_id']));
													$selprodId = $product['selprod_id'];
												} else {
													$optionUrl = Product::generateProductOptionsUrl($product['selprod_id'], $selectedOptionsArr, $option['option_id'], $opVal['optionvalue_id'], $product['product_id']);
													$selprodId = Product::generateProductOptionsUrl($product['selprod_id'], $selectedOptionsArr, $option['option_id'], $opVal['optionvalue_id'], $product['product_id'], true);

													$optionUrlArr = explode("::", $optionUrl);
													if (is_array($optionUrlArr) && count($optionUrlArr) == 2) {
														$optionUrl = $optionUrlArr[0];
														$isAvailable = false;
													}
												}
											?>

												<?php if($isAvailable) { ?>
														<?php if ($option['option_is_color'] && $opVal['optionvalue_color_code'] != '') { ?>
															<a optionValueId="<?php echo $opVal['optionvalue_id']; ?>" selectedOptionValues="<?php echo implode("_", $selectedOptionsArr); ?>" title="<?php
																																																		echo $opVal['optionvalue_name'];
																																																		echo (!$isAvailable) ? ' ' . Labels::getLabel('LBL_Not_Available', $siteLangId) : '';
																																																		?>" class="option-selector__item <?php echo (in_array($opVal['optionvalue_id'], $product['selectedOptionValues'])) ? ' is-active' : ' '; ?> <?php
																																																																																					echo (!$option['option_is_color']) ? 'selector__link' : '';
																																																																																					echo (in_array($opVal['optionvalue_id'], $product['selectedOptionValues'])) ? ' ' : ' ';
																																																																																					echo (!$optionUrl) ? ' is-disabled' : '';
																																																																																					?>" href="javascript:void(0)" onclick="quickDetail(<?php echo $selprodId; ?>)"> <span class="color-option" style="background-color:#<?php echo $opVal['optionvalue_color_code']; ?>;"></span><?php /* echo $opVal['optionvalue_name']; */ ?></a>
														<?php } else { ?>
															<a optionValueId="<?php echo $opVal['optionvalue_id']; ?>" selectedOptionValues="<?php echo implode("_", $selectedOptionsArr); ?>" title="<?php
																																																		echo $opVal['optionvalue_name'];
																																																		echo (!$isAvailable) ? ' ' . Labels::getLabel('LBL_Not_Available', $siteLangId) : '';
																																																		?>" class="option-selector__item <?php echo (in_array($opVal['optionvalue_id'], $product['selectedOptionValues'])) ? ' is-active' : ' '; ?> <?php
																																																																																					echo (in_array($opVal['optionvalue_id'], $product['selectedOptionValues'])) ? '' : ' ';
																																																																																					echo (!$optionUrl) ? ' is-disabled' : '';
																																																																																					?>" href="javascript:void(0)" onclick="quickDetail(<?php echo $selprodId; ?>)">
																<span class="p-2"><?php echo $opVal['optionvalue_name']; ?> </span></a>
														<?php } ?>
											<?php } ?>
											<?php } ?>

										</div>
									<?php } ?>
								</div>

							</div>
						<?php
							$count++;
						}
						?>

					<?php } ?>

					<!-- ] -->

				</div>


			</div>
			<!-- ] -->

			<!-- [ PANEL RIGHT =========== -->
			<div class="front-panel__right">


				<!-- [ PANEL BOX BUYING FORM =========== -->
				<div class="panel-box mb-4 panel-box--buying">

					<!-- [ BUYING FORM =========== -->
					<div class="buying-selection buying-sticky-js">
						<!-- Add To Cart [ -->

						<?php
						$disabledBuy = 0;
						if (!Product::isDisplayPriceByAdmin()) {
							$disabledBuy = 1;
						}
						if ($product['in_stock']) {
							echo $frmBuyProduct->getFormTag();
							$qtyField = $frmBuyProduct->getField('quantity');
							$qtyField->value = $product['selprod_min_order_qty'];
							$qtyField->addFieldTagAttribute('data-min-qty', $product['selprod_min_order_qty']);
							$qtyFieldName = $qtyField->getCaption();
						?>
							<?php if ($product['selprod_type'] != SellerProduct::PRODUCT_TYPE_SERVICE && CommonHelper::isDisplayPrice($product) && $product['is_buy_now'] == AppConstants::YES) {
							?>
								<div class="qty-selection">
									<div class="qty-selection__left">
										<span class="qty-selection__label"><?php echo Labels::getLabel('Lbl_Quantity', $siteLangId); ?></span>
										<small class="small-label"><?php echo Labels::getLabel('Lbl_Maximum', $siteLangId); ?> <?php echo $product['selprod_stock']; ?> <?php echo Labels::getLabel('Lbl_Piece(s)', $siteLangId); ?></small>
									</div>
									<div class="qty-selection__right">
										<?php echo $frmBuyProduct->getFieldHtml('quantity'); ?>
									</div>
								</div>
							<?php } ?>
							<div class="btns-selection">
								<?php

								$rfqFunction = 'RequestForQuote(' . $product["selprod_id"] . ')';
								if ($product['selprod_type'] == SellerProduct::PRODUCT_TYPE_SERVICE) {
									$rfqFunction = 'rfqForService(' . $product["selprod_id"] . ')';
								}
								if ($disabledBuy == 0 && $product['is_buy_now'] == AppConstants::YES && strtotime($product['selprod_available_from']) <= strtotime(FatDate::nowInTimezone(FatApp::getConfig('CONF_TIMEZONE'), 'Y-m-d'))) { ?>
									<?php
									if ($product['selprod_type'] != SellerProduct::PRODUCT_TYPE_SERVICE) { ?>
										<div class="btns-selection__pair">
											<?php echo $frmBuyProduct->getFieldHtml('btnProductBuy');  ?>
											<?php echo $frmBuyProduct->getFieldHtml('btnAddToCart'); ?>
											<?php echo $frmBuyProduct->getFieldHtml('selprod_id'); ?>
										</div>
									<?php  } ?>
								<?php  } ?>
								<div class="btns-selection__group text-center">
									<small class="small-label"><?php echo Labels::getLabel('Lbl_Or_get_a_quote_for_this_product', $siteLangId); ?></small>
									<a onclick="<?php echo $rfqFunction; ?>" href="javascript:void(0);" class="btn btn--brand btn--block"><?php echo Labels::getLabel('LBL_Request_for_quote', $siteLangId); ?></a>
								</div>

							</div>



							</form>
						<?php echo $frmBuyProduct->getExternalJs();
						} else {
						?>
							<div class="sold">
								<span class="qty-selection__label"><?php echo Labels::getLabel('LBL_Sold_Out', $siteLangId); ?></span>
								<p class="text--normal-secondary"><?php echo Labels::getLabel('LBL_This_item_is_currently_out_of_stock', $siteLangId); ?></p>
							</div>
						<?php } ?>
						<?php if (strtotime($product['selprod_available_from']) > strtotime(FatDate::nowInTimezone(FatApp::getConfig('CONF_TIMEZONE'), 'Y-m-d'))) { ?>
							<div class="sold">
								<span class="qty-selection__label"><?php echo Labels::getLabel('LBL_Not_Available', $siteLangId); ?></span>
								<p class="text--normal-secondary">
									<?php echo str_replace('{available-date}', FatDate::Format($product['selprod_available_from']), Labels::getLabel('LBL_This_item_will_be_available_from_{available-date}', $siteLangId)); ?>
								</p>
							</div>
						<?php } ?>
					</div>
					<!-- ] -->

				</div>
				<!-- ] -->


				<!-- [ PANEL BOX SELLER DETAILS =========== -->
				<div class="panel-box panel-box--seller">

					<div class="seller-connect">

						<!-- [ SELLER PROFILE =========== -->
						<div class="seller-portlet">
							<div class="seller-portlet__head">
								<div class="seller-portlet__logo"><img src="<?php echo CommonHelper::generateFileUrl('Image', 'shopLogo', array($shop['shop_id'], $siteLangId, 'SMALL')); ?>" alt="<?php echo $shop['shop_name']; ?>"></div>
								<div class="seller-portlet__info">
									<h6><a href="<?php echo CommonHelper::generateUrl('shops', 'View', array($shop['shop_id'])); ?>"> <?php echo $shop['shop_name']; ?></a></h6>

									<div class="seller-portlet__details">
										<span class="seller-location"><?php if ($shop['shop_state_name']) {
																			echo $shop['shop_state_name'] . ', ';
																		} ?> <?php if ($shop['shop_country_name']) {
																					echo $shop['shop_country_name'] . ', ';
																				} ?></span>
										<div class="seller-ratings">
											<div class="ratings">
												<span class="ratings__star site-icon site-icon--small">
													<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 15.216">
														<path d="M8.587,12.949,3.643,15.716l1.1-5.557L.587,6.312l5.627-.667L8.587.5,10.96,5.645l5.627.667-4.16,3.847,1.1,5.557Z" transform="translate(-0.587 -0.5)" fill="#f59f1f"></path>
													</svg>
												</span>
												<span class="ratings__value"><?php echo round($shop_rating, 1); ?></span>
											</div>
										</div>
									</div>
								</div>


							</div>

						</div>
						<!-- ] -->

					</div>

				</div>
				<!-- ] -->


			</div>
			<!-- ] -->





		</div>

	</div>

</section>



<?php echo $this->includeTemplate('_partial/shareThisScript.php'); ?>


<script>
	$(document).ready(function() {
		var layoutDirection = '<?php echo CommonHelper::getLayoutDirection(); ?>';
		if (layoutDirection == 'rtl') {
			$('.js-product-gallery').slick({
				dots: true,
				arrows: false,
				autoplay: false,
				pauseOnHover: false,
				slidesToShow: 1,
				draggable: true,
				rtl: true,
			});
		} else {
			$('.js-product-gallery').slick({
				dots: true,
				arrows: false,
				autoplay: false,
				pauseOnHover: false,
				slidesToShow: 1,
				draggable: true,
			});
		}

		$('#close-quick-js').click(function() {
			if ($('html').removeClass('quick-view--open')) {
				$('.quick-view').removeClass('quick-view--open');
			}
		});

		/* $('#close-quick-js').click(function () {
		 if ($('html').removeClass('quick-view--open')) {
		 $(document).trigger('close.facebox');
		 $('.quick-view').removeClass('quick-view--open');
		 }
		 }); */
		/* $('#quickView-slider-for').slick( getSlickGallerySettings(false,'<?php echo CommonHelper::getLayoutDirection(); ?>') );
		 $('#quickView-slider-nav').slick( getSlickGallerySettings(true,'<?php echo CommonHelper::getLayoutDirection(); ?>') ); */

		function DropDown(el) {
			this.dd = el;
			this.placeholder = this.dd.children('span');
			this.opts = this.dd.find('ul.drop li');
			this.val = '';
			this.index = -1;
			this.initEvents();
		}

		DropDown.prototype = {
			initEvents: function() {
				var obj = this;
				obj.dd.on('click', function(e) {
					e.preventDefault();
					e.stopPropagation();
					$(this).toggleClass('active');
				});
				obj.opts.on('click', function() {
					var opt = $(this);
					obj.val = opt.text();
					obj.index = opt.index();
					obj.placeholder.text(obj.val);
					opt.siblings().removeClass('is-active');
					opt.filter(':contains("' + obj.val + '")').addClass('is-active');
					var link = opt.filter(':contains("' + obj.val + '")').find('a').attr('href');
					window.location.replace(link);
				}).change();
			},
			getValue: function() {
				return this.val;
			},
			getIndex: function() {
				return this.index;
			}
		};

		$(function() {
			// create new variable for each menu
			$(document).click(function() {
				// close menu on document click
				$('.wrap-drop').removeClass('active');
			});

			$('.js-wrap-drop-quick').click(function() {
				$(this).parent().siblings().children('.js-wrap-drop-quick').removeClass('active');
			});
		});

		$(".js-wrap-drop-quick").each(function(index, element) {
			var div = '#js-wrap-drop-quick' + index;
			new DropDown($(div));
		});

	});

	function makeTimer() {
		var endTime = new Date("<?php echo $product['splprice_end_date']; ?>");
		endTime = (Date.parse(endTime) / 1000);

		var now = new Date();
		now = (Date.parse(now) / 1000);

		var timeLeft = endTime - now;

		var days = Math.floor(timeLeft / 86400);
		var hours = Math.floor((timeLeft - (days * 86400)) / 3600);
		var minutes = Math.floor((timeLeft - (days * 86400) - (hours * 3600)) / 60);
		var seconds = Math.floor((timeLeft - (days * 86400) - (hours * 3600) - (minutes * 60)));

		if (hours < "10") {
			hours = "0" + hours;
		}
		if (minutes < "10") {
			minutes = "0" + minutes;
		}
		if (seconds < "10") {
			seconds = "0" + seconds;
		}

		$("#days").html(days + "<span><?php echo Labels::getLabel('LBL_Days', $siteLangId); ?></span>");
		$("#hours").html(hours + "<span><?php echo Labels::getLabel('LBL_Hours', $siteLangId); ?></span>");
		/* $("#minutes").html(minutes + "<span><?php echo Labels::getLabel('LBL_Min', $siteLangId); ?></span>");
		$("#seconds").html(seconds + "<span><?php echo Labels::getLabel('LBL_Sec', $siteLangId); ?></span>"); */

		if(days <= "1") {
			$("#days").html("");
		}if(days > "1") {
			$("#hours, #minutes, #seconds").html("");
		}
	}
	setInterval(function() {
		makeTimer();
	}, 1000);
</script>

