<?php
$countriesCheckedArr = (isset($countriesCheckedArr) && !empty($countriesCheckedArr)) ? $countriesCheckedArr : array();
$charArr = array();
$firstCharacter = '';
$countryHtml = '';
$mySelection = array();
foreach ($countriesArr as $country) {
    if (in_array($country['country_id'], $countriesCheckedArr)) {
        $mySelection[$country['country_id']] = $country['country_name'];
        continue;
    }

    $str = substr(strtolower($country['country_name']), 0, 1);
    if (is_numeric($str)) {
        $str = '0-9';
    }

    if ($str != $firstCharacter) {
        $countryHtml .= '<li class="filter-directory_list_title ' . $str . '" data-item="' . $str . '" id="' . $str . '">' . $str . '</li>';
        $firstCharacter = $str;
    }
    $charArr[$str] = strtoupper($str);
    $countryHtml .= '<li class="countryList-js b-' . $str . '" data-caption=' . substr(strtolower($country['country_name']), 0, 1) . '>
                <label class="checkbox country" >
                <input name="country" value="' . $country['country_id'] . '" data-id="country_' . $country['country_id'] . '" data-title="' . $country['country_name'] . '" type="checkbox" ><i class="input-helper"></i><span class="lb-txt">' . $country['country_name'] . '</span></label>
            </li>';
}
?>
<div class="filter-directory">
    <div class="filter-directory_bar">
        <input type="text" placeholder="<?php echo Labels::getLabel('LBL_Store_Location', $siteLangId); ?>" class="filter-directory_search_input" onKeyup="autoKeywordSearch(this.value)">
        <ul class="filter-directory_indices bfilter-js">      
            <?php
            foreach (range('A', 'Z') as $char) {
                $disabled = '';
                if (!in_array($char, $charArr)) {
                    $disabled = 'class="filter-directory_disabled"';
                }
                ?>
                <li data-item="<?php echo $char; ?>" <?php echo $disabled; ?>><a href="#<?php echo $char; ?>"><?php echo $char; ?></a>
                <?php } ?>
        </ul>
    </div>
    <div>
        <ul class="filter-directory_list">
            <?php
            foreach ($mySelection as $countryId => $country) {
                echo ' <li>
                <label class="checkbox country" ><input name="country" value="' . $countryId . '" data-id="country_' . $countryId . '" type="checkbox" checked="true" data-title="' . $country . '"><i class="input-helper"></i><span class="lb-txt">' . $country . '</span></label>
            </li>';
            }
            ?>
            <?php echo $countryHtml; ?>
        </ul>
    </div>
</div>