<?php

defined('SYSTEM_INIT') or die('Invalid Usage.');
$arr_flds = array(
    'order_id' => Labels::getLabel('LBL_Order_ID_Date', $siteLangId),
    'product' => Labels::getLabel('LBL_Details', $siteLangId),
    'total' => Labels::getLabel('LBL_Total', $siteLangId),
    'status' => Labels::getLabel('LBL_Status', $siteLangId),
    'action' => '',
);

$tbl = new HtmlElement('table', array('class' => 'table'));
$th = $tbl->appendElement('thead')->appendElement('tr', array('class' => ''));
foreach ($arr_flds as $val) {
    $e = $th->appendElement('th', array(), $val);
}

$sr_no = 0;
$canCancelOrder = true;
$canReturnRefund = true;



foreach ($orders as $sn => $order) {
    $sr_no++;
    $tr = $tbl->appendElement('tr', array('class' => ''));
    $orderDetailUrl = CommonHelper::generateUrl('Buyer', 'viewOrder', array($order['order_id'], $order['op_id']));

    if ($order['op_product_type'] == Product::PRODUCT_TYPE_DIGITAL) {
        $canCancelOrder = (in_array($order["op_status_id"], (array) Orders::getBuyerAllowedOrderCancellationStatuses(true)));
        $canReturnRefund = (in_array($order["op_status_id"], (array) Orders::getBuyerAllowedOrderReturnStatuses(true)));
    } else {
        $canCancelOrder = (in_array($order["op_status_id"], (array) Orders::getBuyerAllowedOrderCancellationStatuses()));
        $canReturnRefund = (in_array($order["op_status_id"], (array) Orders::getBuyerAllowedOrderReturnStatuses()));
    }
    if ($order['order_is_rfq'] == AppConstants::YES) {
        $canReturnRefund = false;
    }
    $isValidForReview = false;
    if (in_array($order["op_status_id"], SelProdReview::getBuyerAllowedOrderReviewStatuses())) {
        $isValidForReview = true;
    }
    foreach ($arr_flds as $key => $val) {
        $td = $tr->appendElement('td');
        switch ($key) {
            case 'order_id':
                $txt = '<a title="' . Labels::getLabel('LBL_View_Order_Detail', $siteLangId) . '" href="' . $orderDetailUrl . '">';
                if ($order['totOrders'] > 1) {
                    $txt .= $order['op_invoice_number'];
                } else {
                    $txt .= $order['order_id'];
                }
                $txt .= '</a><br/>' . FatDate::format($order['order_date_added']);
                $td->appendElement('plaintext', array(), $txt, true);
                break;
            case 'product':
                $txt = '<div class="item__description">';
                if ($order['op_selprod_title'] != '') {
                    $txt .= '<div class="item__title">' . $order['op_selprod_title'] . '</div>';
                }
                $txt .= '<div class="item__sub_title">' . $order['op_product_name'] . ' (' . Labels::getLabel('LBL_Qty', $siteLangId) . ': ' . $order['op_qty'] . ')</div>';
                $txt .= '<div class="item__brand">';
                if (!empty($order['op_brand_name'])) {
                    $txt .= Labels::getLabel('LBL_Brand', $siteLangId) . ': ' . $order['op_brand_name'];
                }
                if (!empty($order['op_brand_name']) && !empty($order['op_selprod_options'])) {
                    $txt .= ' | ';
                }
                if ($order['op_selprod_options'] != '') {
                    $txt .= $order['op_selprod_options'];
                }
                $txt .= '</div>';
                if ($order['totOrders'] > 1) {
                    $txt .= '<div class="item__specification">' . Labels::getLabel('LBL_Part_combined_order', $siteLangId) . ' <a title="' . Labels::getLabel('LBL_View_Order_Detail', $siteLangId) . '" href="' . CommonHelper::generateUrl('Buyer', 'viewOrder', array($order['order_id'])) . '">' . $order['order_id'] . '</div>';
                }
                $txt .= '</div>';
                $td->appendElement('plaintext', array(), $txt, true);
                break;
            case 'total':
                $txt = '';
                $txt .= CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($order));
                $td->appendElement('plaintext', array(), $txt, true);
                break;
            case 'status':
                $pMethod = '';
                if ($order['order_pmethod_id'] == PaymentSettings::CASH_ON_DELIVERY && $order['order_status'] == FatApp::getConfig('CONF_DEFAULT_ORDER_STATUS')) {
                    $pMethod = " - " . $order['pmethod_name'];
                }
                $txt = $order['orderstatus_name'] . $pMethod;
                $td->appendElement('plaintext', array(), $txt, true);
                break;


            case 'action':
                $ul = $td->appendElement("ul", array("class" => "actions"), '', true);
                $opCancelUrl = CommonHelper::generateUrl('Buyer', 'orderCancellationRequest', array($order['op_id']));
                $now = time(); // or your date as well
                $orderDate = strtotime($order['order_date_added']);
                $datediff = $now - $orderDate;
                $daysSpent = round($datediff / (60 * 60 * 24));
                $returnAge = !empty($order['return_age']) ? $order['return_age'] : FatApp::getConfig("CONF_DEFAULT_RETURN_AGE", FatUtility::VAR_INT, 7);

                $li = $ul->appendElement("li");
                $li->appendElement(
                        'a', array('href' => $orderDetailUrl, 'class' => '',
                    'title' => Labels::getLabel('LBL_View_Order', $siteLangId)), '<i class="fa fa-eye"></i>', true
                );

                if ($order['order_is_rfq'] == AppConstants::YES && in_array($order['order_is_paid'], Orders::getUnpaidStatus()) && $order['invoice_id'] > 0 && $order['invoice_status'] == Invoice::INVOICE_IS_SHARED_WITH_BUYER && $order['op_status_id'] != FatApp::getConfig('CONF_DEFAULT_CANCEL_ORDER_STATUS') && $order['rfq_status'] != RequestForQuote::REQUEST_QUOTE_VALIDITY) {
                    $invoiceValidTill = date('Y-m-d H:i:s', strtotime('+24 hours', strtotime($order['invoice_added_on'])));

                    $li = $ul->appendElement("li");
                    $li->appendElement(
                            'a', array('href' => CommonHelper::generateUrl('invoices', 'payInvoice', [$order['order_id']]), 'class' => '',
                        'title' => Labels::getLabel('LBL_View_Invoice', $siteLangId)), '<i class="fa fa-file-invoice"></i>', true
                    );

                    if (strtotime($invoiceValidTill) > strtotime(date('Y-m-d H:i:s'))) {
                        $li = $ul->appendElement("li");
                        $li->appendElement(
                                'a', array('href' => CommonHelper::generateUrl('RfqCheckout', 'index', [$order['order_id']]), 'class' => '',
                            'title' => Labels::getLabel('LBL_Pay_Now', $siteLangId)), '<i class="fas fa-money-check"></i>', true
                        );
                    }
                }

                if (($order['order_is_rfq'] == AppConstants::YES && $order['order_is_paid'] == Orders::ORDER_IS_PAID) || $order['order_is_rfq'] == AppConstants::NO) {
                    if ($canCancelOrder && false === OrderCancelRequest::getCancelRequestById($order['op_id']) && $order['cancellation_age'] >= $daysSpent) {
                        $li = $ul->appendElement("li");
                        $li->appendElement(
                                'a', array('href' => $opCancelUrl, 'class' => '',
                            'title' => Labels::getLabel('LBL_Cancel_Order', $siteLangId)), '<i class="fas fa-times"></i>', true
                        );
                    }

                    $canSubmitFeedback = Orders::canSubmitFeedback($order['order_user_id'], $order['order_id'], $order['op_selprod_id']);
                    if ($canSubmitFeedback && $isValidForReview) {
                        $opFeedBackUrl = CommonHelper::generateUrl('Buyer', 'orderFeedback', array($order['op_id']));
                        $li = $ul->appendElement("li");
                        $li->appendElement(
                                'a', array('href' => $opFeedBackUrl, 'class' => '',
                            'title' => Labels::getLabel('LBL_Feedback', $siteLangId)), '<i class="fa fa-star"></i>', true
                        );
                    }
                    if ($canReturnRefund && ($order['return_request'] == 0 && $order['cancel_request'] == 0) && $returnAge >= $daysSpent) {
                        $opRefundRequestUrl = CommonHelper::generateUrl('Buyer', 'orderReturnRequest', array($order['op_id']));
                        $li = $ul->appendElement("li");
                        $li->appendElement(
                                'a', array('href' => $opRefundRequestUrl, 'class' => '',
                            'title' => Labels::getLabel('LBL_Refund', $siteLangId)), '<i class="fas fa-dollar-sign"></i>', true
                        );
                    }
                }
                if (($order['order_is_rfq'] == AppConstants::YES && $order['order_is_paid'] == Orders::ORDER_IS_PARTIAL_PAID)) {
                    if ($canCancelOrder && false === OrderCancelRequest::getCancelRequestById($order['op_id'])) {
                        $li = $ul->appendElement("li");
                        $li->appendElement(
                                'a', array('href' => $opCancelUrl, 'class' => '',
                            'title' => Labels::getLabel('LBL_Cancel_Order', $siteLangId)), '<i class="fas fa-times"></i>', true
                        );
                    }
                }

                if ($order['order_is_rfq'] == AppConstants::NO) {
                    $cartUrl = CommonHelper::generateUrl('cart');
                    $li = $ul->appendElement("li");
                    $li->appendElement(
                            'a', array('href' => 'javascript:void(0)', 'onClick' => 'return addItemsToCart("' . $order['order_id'] . '");',
                        'title' => Labels::getLabel('LBL_Re-Order', $siteLangId)), '<i class="fa fa-cart-plus"></i>', true
                    );
                }

                break;
            default:
                $td->appendElement('plaintext', array(), $order[$key], true);
                break;
        }
    }
}
echo $tbl->getHtml();
if (count($orders) == 0) {
    $message = Labels::getLabel('LBL_No_Records_Found', $siteLangId);
    $this->includeTemplate('_partial/no-record-found.php', array('siteLangId' => $siteLangId, 'message' => $message));
}
$postedData['page'] = $page;
echo FatUtility::createHiddenFormFromData($postedData, array('name' => 'frmOrderSrchPaging'));
$pagingArr = array('pageCount' => $pageCount, 'page' => $page, 'recordCount' => $recordCount, 'callBackJsFunc' => 'goToOrderSearchPage');
$this->includeTemplate('_partial/pagination.php', $pagingArr, false);
