$(document).ready(function () {
    searchProducts(document.frmProfileSearch);
    $("body").on('click', function () {
        $('.search-card-pro--js').hide();
    });

    $(".search-card-pro--js, #filterText").on('click', function (e) {
        e.stopPropagation();
        $('.search-card-pro--js').show();
    });
});

(function () {
    var runningAjaxReq = false;
    var dv = '#service-products-listing-js';
    goToSearchPage = function (page) {
        if (typeof page == undefined || page == null) {
            page = 1;
        }
        var frm = document.frmProductSearchPaging;
        $(frm.page).val(page);
        searchProducts(frm);
    }

    reloadList = function () {
        var frm = document.frmProductSearchPaging;
        searchProducts(frm);
    };

    searchProducts = function (form) {
        var data = '';
        if (form) {
            data = fcom.frmData(form);
        }
        $(dv).html(fcom.getLoader());
        fcom.ajax(fcom.makeUrl('AttachServices', 'search'), data, function (res) {
            $(dv).html(res);
        });
    }

    clearSearch = function () {
        document.frmSearchServiceProduct.reset();
        searchProducts(document.frmSearch);
    };

    saveServiceWithProducts = function (frm) {
        var serviceId = parseInt($("input[name='service_product_id']").val());
        var selectedProducts = [];
        var treeView = $("#treeview").data("yomultiselectTreeView");
        getCheckedNodes(treeView.dataSource.view(), selectedProducts);

        if (serviceId <= 0 || selectedProducts.length < 1) {
            $.mbsmessage(langLbl.pleaseSelectServiceAndProducts, true, 'alert--danger');
            return false;
        }

        var data = "service_product_id=" + serviceId + "&products_data=" + selectedProducts;
        fcom.updateWithAjax(fcom.makeUrl('AttachServices', 'updateServiceWithProducts'), data, function (t) {
            var treeView = $("#treeview").data("yomultiselectTreeView");
            treeView.dataSource.data([]);
            $("#filterText").val('');
            $(".selectAll").css("visibility", "hidden");
            reloadList();
        });
    };

    deleteAttachedProduct = function (serviceProdId, sellerProdId) {
        if (!confirm(langLbl.confirmDelete)) {
            return;
        }
        data = 'service_product_id=' + serviceProdId + "&seller_product_id=" + sellerProdId;
        fcom.updateWithAjax(fcom.makeUrl('AttachServices', 'deleteAttachedProduct'), data, function (res) {
            reloadList();
        });
    }

})();

