<?php defined('SYSTEM_INIT') or die('Invalid usage');
/* reviews processing */

$totReviews = isset($reviews['totReviews']) ? FatUtility::int($reviews['totReviews']) : '';
$avgRating = isset($reviews['avg_seller_rating']) ? FatUtility::convertToType($reviews['avg_seller_rating'],FatUtility::VAR_FLOAT) : 0;
$rated_1 = isset($reviews['rated_1']) ? FatUtility::int($reviews['rated_1']) : '';
$rated_2 = isset($reviews['rated_2']) ? FatUtility::int($reviews['rated_2']) : '';
$rated_3 = isset($reviews['rated_3']) ? FatUtility::int($reviews['rated_3']) : '';
$rated_4 = isset($reviews['rated_4']) ? FatUtility::int($reviews['rated_4']) : '';
$rated_5 = isset($reviews['rated_5']) ? FatUtility::int($reviews['rated_5']) : '';


$pixelToFillRight = $avgRating/5*160;
$pixelToFillRight = FatUtility::convertToType($pixelToFillRight,FatUtility::VAR_FLOAT);

$rate_5_width = $rate_4_width =$rate_3_width= $rate_2_width= $rate_1_width = 0;

if($totReviews){
	$rate_5_width = round(FatUtility::convertToType($rated_5/$totReviews*100,FatUtility::VAR_FLOAT),2);
	$rate_4_width = round(FatUtility::convertToType($rated_4/$totReviews*100,FatUtility::VAR_FLOAT),2);
	$rate_3_width = round(FatUtility::convertToType($rated_3/$totReviews*100,FatUtility::VAR_FLOAT),2);
	$rate_2_width = round(FatUtility::convertToType($rated_2/$totReviews*100,FatUtility::VAR_FLOAT),2);
	$rate_1_width = round(FatUtility::convertToType($rated_1/$totReviews*100,FatUtility::VAR_FLOAT),2);
}
?>




<div class="review-panel" id="itemRatings">

	<div class="review-panel__head p-xl-4 p-3 m-0 pb-0">
		<div class="row justify-content-between">
			<div class="col-sm-2 column">
				<div class="shop-reviews-wrapper">
					<div class="shop-reviews">
						<svg class="svg" xmlns="http://www.w3.org/2000/svg" width="103" height="98" viewBox="0 0 103 98">
									<path d="M890.5,2341l16.973,30.8,34.52,6.63-24.03,25.67,4.362,34.9L890.5,2424.06,858.675,2439l4.361-34.9-24.029-25.67,34.52-6.63L890.5,2341" transform="translate(-839 -2341)"></path>
									</svg>


						<div class="shop-reviews-points"><?php echo round($avgRating,1); ?></div>
					</div>
					<div class="total-reviews"><?php echo $totReviews.' '.Labels::getLabel('Lbl_ratings',$siteLangId); ?></div>
				</div>
			</div>
			<div class="col-sm-5 column">
				<div class="progress-list m-0">
					<ul>
						<li>
							<span class="progress-list__count">5 <?php echo Labels::getLabel('Lbl_Star',$siteLangId); ?></span>
							<div class="progress-list__bar">
								<div title="<?php echo $rate_5_width,'% ',Labels::getLabel('LBL_Number_of_reviews_have_5_stars',$siteLangId); ?>" style="width: <?php echo $rate_5_width; ?>%; clip: rect(0px, 0px, 160px, 0px);" role="progressbar" class="progress-list__bar-fill"></div>
							</div>
						</li>
						<li>
							<span class="progress-list__count">4 <?php echo Labels::getLabel('Lbl_Star',$siteLangId); ?></span>
							<div class="progress-list__bar">
								<div title="<?php echo $rate_4_width,'% ',Labels::getLabel('LBL_Number_of_reviews_have_4_stars',$siteLangId); ?>" style="width: <?php echo $rate_4_width; ?>%; clip: rect(0px, 0px, 160px, 0px);" role="progressbar" class="progress-list__bar-fill"></div>
							</div>
						</li>
						<li>
							<span class="progress-list__count">3 <?php echo Labels::getLabel('Lbl_Star',$siteLangId); ?></span>
							<div class="progress-list__bar">
								<div title="<?php echo $rate_3_width,'% ',Labels::getLabel('LBL_Number_of_reviews_have_3_stars',$siteLangId); ?>" style="width: <?php echo $rate_3_width; ?>%; clip: rect(0px, 0px, 160px, 0px);" role="progressbar" class="progress-list__bar-fill"></div>
							</div>
						</li>
						<li>
							<span class="progress-list__count">2 <?php echo Labels::getLabel('Lbl_Star',$siteLangId); ?></span>
							<div class="progress-list__bar">
								<div title="<?php echo $rate_2_width,'% ',Labels::getLabel('LBL_Number_of_reviews_have_2_stars',$siteLangId); ?>" style="width: <?php echo $rate_2_width; ?>%; clip: rect(0px, 0px, 160px, 0px);" role="progressbar" class="progress-list__bar-fill"></div>
							</div>
						</li>
						<li>
							<span class="progress-list__count">1 <?php echo Labels::getLabel('Lbl_Star',$siteLangId); ?></span>
							<div class="progress-list__bar">
								<div title="<?php echo $rate_1_width,'% ',Labels::getLabel('LBL_Number_of_reviews_have_1_stars',$siteLangId); ?>" style="width: <?php echo $rate_1_width; ?>%; clip: rect(0px, 0px, 160px, 0px);" role="progressbar" class="progress-list__bar-fill"></div>
							</div>
						</li>
					</ul>
				</div>
			</div>

			<!--div class="col-sm-4 column">
				<div class="text-center mt-3">
					<h6><?php echo Labels::getLabel('LBL_HAVE_YOU_USED_THIS_PRODUCT',$siteLangId); ?> </h6>
					<a class="btn btn-outline-primary btn--wide" href="#"><?php echo Labels::getLabel('Lbl_Rate_it_Now',$siteLangId); ?></a>
				</div>
			</div-->

		</div>

	</div>


	<div class="review-panel__sort">
		<div class="row align-items-center justify-content-between">
			<div class="col-sm-6">
				<p><span id='reviews-pagination-strip--js'><?php echo Labels::getLabel('Lbl_Displaying_Reviews',$siteLangId); ?>  <span id='reviewStartIndex'>XX</span>-<span id='reviewEndIndex'>XX</span> <?php echo Labels::getLabel('Lbl_of',$siteLangId); ?> <span id='reviewsTotal'>XX</span></span>
				</p>
			</div>
			<div class="col-sm-auto">

				<ul class="links-inline text-right">
					<li class="is-active"><a href="javascript:void(0);" class="" data-sort='most_recent' onclick="getSortedReviews(this);return false;"><?php echo Labels::getLabel('Lbl_Most_Recent', $siteLangId); ?></a></li>
					<li><a href="javascript:void(0);" class="" data-sort='most_helpful' onclick="getSortedReviews(this);return false;"><?php echo Labels::getLabel('Lbl_Most_Helpful', $siteLangId); ?></a></li>
				</ul>

			</div>
		</div>
	</div>

		
	<div class="review-panel__body">
		<div class="review-panel__all">
			
			<div class="listing__all"></div>
			<div id="loadMoreReviewsBtnDiv" class="align--center"></div>
		
		</div>
	</div>


</div>


<script>

var $linkMoreText = '<?php echo Labels::getLabel('Lbl_SHOW_MORE',$siteLangId); ?>';
var $linkLessText = '<?php echo Labels::getLabel('Lbl_SHOW_LESS',$siteLangId); ?>';

$('#itemRatings div.progress__fill').css({'clip':'rect(0px, <?php echo $pixelToFillRight; ?>px, 160px, 0px)'});
</script>
