<?php
$controller = strtolower($controller);
$action = strtolower($action);
?>
<sidebar class="sidebar no-print">
    <div class="logo-wrapper"> <?php
                                if (CommonHelper::isThemePreview() && isset($_SESSION['preview_theme'])) {
                                    $logoUrl = CommonHelper::generateUrl('home', 'index');
                                } else {
                                    $logoUrl = CommonHelper::generateUrl();
                                }
                                ?>
        <?php
        $fileData = AttachedFile::getAttachment(AttachedFile::FILETYPE_FRONT_LOGO, 0, 0, $siteLangId, false);
        $aspectRatioArr = AttachedFile::getRatioTypeArray($siteLangId);
        ?>
        <div class="logo-dashboard">
            <a href="<?php echo $logoUrl; ?>">
                <img loading="lazy" <?php if ($fileData['afile_aspect_ratio'] > 0) { ?> data-ratio="<?php echo $aspectRatioArr[$fileData['afile_aspect_ratio']]; ?>" <?php } ?> src="<?php echo CommonHelper::generateFullFileUrl('image', 'siteLogo', array($siteLangId), CONF_WEBROOT_FRONT_URL); ?>" alt="<?php echo FatApp::getConfig('CONF_WEBSITE_NAME_' . $siteLangId) ?>" title="<?php echo FatApp::getConfig('CONF_WEBSITE_NAME_' . $siteLangId) ?>">
            </a>
        </div>

        <?php
        $isOpened = '';
        if (array_key_exists('openSidebar', $_COOKIE) && !empty(FatUtility::int($_COOKIE['openSidebar'])) && array_key_exists('screenWidth', $_COOKIE) && AppConstants::MOBILE_SCREEN_WIDTH < FatUtility::int($_COOKIE['screenWidth'])) {
            $isOpened = 'is-opened';
        }
        ?>
        <div class="js-hamburger hamburger-toggle <?php echo $isOpened; ?>"><span class="bar-top"></span><span class="bar-mid"></span><span class="bar-bot"></span></div>
    </div>
    <div class="sidebar__content custom-scrollbar" data-simplebar>
        <nav class="dashboard-menu">
            <ul>
                <?php
                if (
                    $userPrivilege->canViewShop(UserAuthentication::getLoggedUserId(), true) ||
                    $userPrivilege->canViewProducts(UserAuthentication::getLoggedUserId(), true) ||
                    $userPrivilege->canViewProductTags(UserAuthentication::getLoggedUserId(), true) ||
                    $userPrivilege->canViewProductOptions(UserAuthentication::getLoggedUserId(), true) ||
                    $userPrivilege->canViewTaxCategory(UserAuthentication::getLoggedUserId(), true)
                ) {
                ?>
                    <li class="menu__item">
                        <div class="menu__item__inner"> <span class="menu-head"><?php echo Labels::getLabel('LBL_Shop', $siteLangId); ?></span></div>
                    </li>
                    <?php if ($userPrivilege->canViewShop(UserAuthentication::getLoggedUserId(), true)) { ?>
                        <li class="menu__item <?php echo ($controller == 'seller' && $action == 'shop') ? 'is-active' : ''; ?>">
                            <div class="menu__item__inner"><a title="<?php echo Labels::getLabel('LBL_Manage_Shop', $siteLangId); ?>" href="<?php echo CommonHelper::generateUrl('Seller', 'shop'); ?>">
                                    <i class="icn shop"><svg class="svg">
                                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#manage-shop" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#manage-shop"></use>
                                        </svg>
                                    </i><span class="menu-item__title"><?php echo Labels::getLabel('LBL_Manage_Shop', $siteLangId); ?></span></a></div>
                        </li>
                    <?php } ?>
                    <!-- <li class="menu__item"><div class="menu__item__inner"><a title="<?php echo Labels::getLabel('LBL_View_Shop', $siteLangId); ?>" target="_blank" href="<?php echo CommonHelper::generateUrl('Shops', 'view', array($shop_id)); ?>"><i class="icn shop"><svg class="svg"><use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-view-shop" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-view-shop"></use></svg>
    </i><span class="menu-item__title"><?php echo Labels::getLabel('LBL_View_Shop', $siteLangId); ?></span></a></    div></li> -->
                    <?php if ($userPrivilege->canViewProducts(UserAuthentication::getLoggedUserId(), true)) { ?>
                        <li class="menu__item <?php echo ($controller == 'seller' && ($action == 'customcatalogproductform' || $action == 'customproductform' || $action == 'catalog' || $action == 'products' || $action == 'customcatalogproducts')) ? 'is-active' : ''; ?>">
                            <div class="menu__item__inner"><a title="<?php echo Labels::getLabel('LBL_Products', $siteLangId); ?>" href="<?php echo CommonHelper::generateUrl('seller', 'catalog'); ?>"><i class="icn shop"><svg class="svg">
                                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-products" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-products"></use>
                                        </svg>
                                    </i><span class="menu-item__title"><?php echo Labels::getLabel('LBL_Products', $siteLangId); ?></span></a></div>
                        </li>
                    <?php } ?>
                    <?php if ($userPrivilege->canViewServices(UserAuthentication::getLoggedUserId(), true)) { ?>
                        <li class="menu__item <?php echo ($controller == 'services' && $action != 'attachtags') ? 'is-active' : ''; ?>">
                            <div class="menu__item__inner">
                                <a title="<?php echo Labels::getLabel('LBL_Services_(Label_for_navigation)', $siteLangId); ?>" href="<?php echo CommonHelper::generateUrl('Services'); ?>">
                                    <i class="icn shop"><svg class="svg">
                                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#services" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#services"></use>
                                        </svg>
                                    </i><span class="menu-item__title"><?php echo Labels::getLabel('LBL_Services_(Label_for_navigation)', $siteLangId); ?></span>
                                </a>
                            </div>
                        </li>

                        <li class="menu__item <?php echo ($controller == 'attachservices') ? 'is-active' : ''; ?>">
                            <div class="menu__item__inner">
                                <a title="<?php echo Labels::getLabel('LBL_Attach_Services', $siteLangId); ?>" href="<?php echo CommonHelper::generateUrl('AttachServices'); ?>">
                                    <i class="icn shop"><svg class="svg">
                                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#attach-services" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#attach-services"></use>
                                        </svg>
                                    </i><span class="menu-item__title"><?php echo Labels::getLabel('LBL_Attach_Services', $siteLangId); ?></span>
                                </a>
                            </div>
                        </li>



                    <?php } ?>


                    <?php if (User::canAddCustomProduct() && $userPrivilege->canViewProductTags(UserAuthentication::getLoggedUserId(), true)) { ?>
                        <li class="menu__item <?php echo ($controller == 'tags') ? 'is-active' : ''; ?>">
                            <div class="menu__item__inner"><a title="<?php echo Labels::getLabel('LBL_Tags_(Label_for_navigation)', $siteLangId); ?>" href="<?php echo CommonHelper::generateUrl('Tags', 'index'); ?>">
                                    <i class="icn shop"><svg class="svg">
                                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#product-tags" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#product-tags"></use>
                                        </svg>
                                    </i><span class="menu-item__title"><?php echo Labels::getLabel('LBL_Tags_(Label_for_navigation)', $siteLangId); ?></span></a></div>
                        </li>
                    <?php } ?>

                    <?php if ($userPrivilege->canViewServices(UserAuthentication::getLoggedUserId(), true)) { ?>
                        <li class="menu__item <?php echo ($controller == 'services' && $action == 'attachtags') ? 'is-active' : ''; ?>">
                            <div class="menu__item__inner"><a title="<?php echo Labels::getLabel('LBL_Service_Tags_(Label_for_navigation)', $siteLangId); ?>" href="<?php echo CommonHelper::generateUrl('Services', 'attachTags'); ?>">
                                    <i class="icn shop"><svg class="svg">
                                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#product-tags" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#product-tags"></use>
                                        </svg>
                                    </i><span class="menu-item__title"><?php echo Labels::getLabel('LBL_Service_Tags_(Label_for_navigation)', $siteLangId); ?></span></a></div>
                        </li>
                    <?php } ?>

                    <?php if (User::canAddCustomProduct() && $userPrivilege->canViewProductTags(UserAuthentication::getLoggedUserId(), true)) { ?>
                        <li class="menu__item <?php echo ($controller == 'seller' && $action == 'producttags') ? 'is-active' : ''; ?>">
                            <div class="menu__item__inner"><a title="<?php echo Labels::getLabel('LBL_Product_Tags_(Label_for_navigation)', $siteLangId); ?>" href="<?php echo CommonHelper::generateUrl('Seller', 'productTags'); ?>">
                                    <i class="icn shop"><svg class="svg">
                                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#product-tags" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#product-tags"></use>
                                        </svg>
                                    </i><span class="menu-item__title"><?php echo Labels::getLabel('LBL_Product_Tags_(Label_for_navigation)', $siteLangId); ?></span></a></div>
                        </li>
                    <?php } ?>



                    <?php
                    $canRequest = FatApp::getConfig('CONF_SELLER_CAN_REQUEST_CUSTOM_PRODUCT', FatUtility::VAR_INT, 0);
                    $canRequestCustomProd = FatApp::getConfig('CONF_ENABLED_SELLER_CUSTOM_PRODUCT', FatUtility::VAR_INT, 0);
                    if (0 < $canRequest && 0 < $canRequestCustomProd && $userPrivilege->canViewProductOptions(UserAuthentication::getLoggedUserId(), true)) {
                    ?>
                        <li class="menu__item <?php echo ($controller == 'seller' && $action == 'options') ? 'is-active' : ''; ?>">
                            <div class="menu__item__inner"><a title="<?php echo Labels::getLabel('LBL_Product_Options', $siteLangId); ?>" href="<?php echo CommonHelper::generateUrl('Seller', 'options'); ?>">
                                    <i class="icn shop"><svg class="svg">
                                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-options" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-options"></use>
                                        </svg>
                                    </i><span class="menu-item__title"><?php echo Labels::getLabel('LBL_Product_Options', $siteLangId); ?></span></a></div>
                        </li>
                    <?php } ?>
                    <?php if ($userPrivilege->canViewTaxCategory(UserAuthentication::getLoggedUserId(), true)) { ?>
                        <li class="menu__item <?php echo ($controller == 'seller' && $action == 'taxcategories') ? 'is-active' : ''; ?>">
                            <div class="menu__item__inner"><a title="<?php echo Labels::getLabel('LBL_Tax_Categories_(Label_for_navigation)', $siteLangId); ?>" href="<?php echo CommonHelper::generateUrl('Seller', 'taxCategories'); ?>">
                                    <i class="icn shop"><svg class="svg">
                                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-tax-category" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-tax-category"></use>
                                        </svg>
                                    </i><span class="menu-item__title"><?php echo Labels::getLabel('LBL_Tax_Categories_(Label_for_navigation)', $siteLangId); ?></span></a></div>
                        </li>
                    <?php } ?>
                    <li class="divider"></li>
                <?php } ?>
                <?php
                if (
                    $userPrivilege->canViewSales(UserAuthentication::getLoggedUserId(), true) ||
                    $userPrivilege->canViewCancellationRequests(UserAuthentication::getLoggedUserId(), true) ||
                    $userPrivilege->canViewReturnRequests(UserAuthentication::getLoggedUserId(), true) ||
                    $userPrivilege->canViewOfferManagement(UserAuthentication::getLoggedUserId(), true) ||
                    $userPrivilege->canViewInvoices(UserAuthentication::getLoggedUserId(), true)
                ) {
                ?>
                    <li class="menu__item">
                        <div class="menu__item__inner"> <span class="menu-head"><?php echo Labels::getLabel('LBL_Sales', $siteLangId); ?></span></div>
                    </li>
                    <?php if ($userPrivilege->canViewSales(UserAuthentication::getLoggedUserId(), true)) { ?>
                        <li class="menu__item <?php echo ($controller == 'seller' && $action == 'sales') ? 'is-active' : ''; ?>">
                            <div class="menu__item__inner"><a title="<?php echo Labels::getLabel('LBL_Orders', $siteLangId); ?>" href="<?php echo CommonHelper::generateUrl('Seller', 'Sales'); ?>">
                                    <i class="icn shop"><svg class="svg">
                                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-sales" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-sales"></use>
                                        </svg>
                                    </i><span class="menu-item__title"><?php echo Labels::getLabel('LBL_Orders', $siteLangId); ?></span></a></div>
                        </li>
                    <?php } ?>
                    <?php if ($userPrivilege->canViewCancellationRequests(UserAuthentication::getLoggedUserId(), true)) { ?>
                        <li class="menu__item <?php echo ($controller == 'seller' && $action == 'ordercancellationrequests') ? 'is-active' : '' ?>">
                            <div class="menu__item__inner"><a title="<?php echo Labels::getLabel('LBL_Order_Cancellation_Requests', $siteLangId); ?>" href="<?php echo CommonHelper::generateUrl('Seller', 'orderCancellationRequests'); ?>">
                                    <i class="icn shop"><svg class="svg">
                                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-cancellation-request" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-cancellation-request"></use>
                                        </svg>
                                    </i><span class="menu-item__title"><?php echo Labels::getLabel("LBL_Order_Cancellation_Requests", $siteLangId); ?></span></a></div>
                        </li>
                    <?php } ?>
                    <?php if ($userPrivilege->canViewReturnRequests(UserAuthentication::getLoggedUserId(), true)) { ?>
                        <li class="menu__item <?php echo ($controller == 'seller' && ($action == 'orderreturnrequests' || $action == 'vieworderreturnrequest')) ? 'is-active' : ''; ?>">
                            <div class="menu__item__inner"><a title="<?php echo Labels::getLabel('LBL_Order_Return_Requests', $siteLangId); ?>" href="<?php echo CommonHelper::generateUrl('Seller', 'orderReturnRequests'); ?>">
                                    <i class="icn shop"><svg class="svg">
                                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-return-request" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-return-request"></use>
                                        </svg>
                                    </i><span class="menu-item__title"><?php echo Labels::getLabel("LBL_Order_Return_Requests", $siteLangId); ?></span></a></div>
                        </li>
                    <?php } ?>
                    <?php
                    if (($userPrivilege->canViewOfferManagement(UserAuthentication::getLoggedUserId(), true))) {
                    ?>
                        <li class="menu__item <?php echo ($controller == 'requestforquotes' && (in_array(strtolower($action), ['listing', 'productquotes', 'view']))) ? 'is-active' : ''; ?>">
                            <div class="menu__item__inner"><a title="<?php echo Labels::getLabel('LBL_Offers_Management ', $siteLangId); ?>" href="<?php echo CommonHelper::generateUrl('RequestForQuotes', 'listing'); ?>">
                                    <i class="icn shop">
                                        <svg class="svg" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve">
                                            <g>
                                                <g>
                                                    <path d="M71.1,155.6c2.6,0,5.1-1,7.1-2.9l0,0c3.9-3.9,3.9-10.2,0-14.1c-3.9-3.9-10.3-3.9-14.2,0c-3.9,3.9-3.9,10.2,0,14.1
                                              C66,154.6,68.6,155.6,71.1,155.6z" />
                                                    <path d="M512,113.6C512,51,461,0,398.4,0c-53,0-97.7,36.5-110.2,85.7c-22.3-7.5-45.6-11.3-69.4-11.3c-43.5,0-85.5,12.7-121.5,36.8
                                              c-4.6,3.1-5.8,9.3-2.7,13.9c1.9,2.9,5.1,4.4,8.3,4.4c1.9,0,3.8-0.5,5.6-1.7c32.7-21.9,70.9-33.5,110.4-33.5
                                              c22.8,0,45.1,3.8,66.2,11.3c-0.2,2.6-0.3,5.2-0.3,7.9c0,62.6,51,113.6,113.6,113.6c2.6,0,5.3-0.1,7.9-0.3
                                              c7.5,21.3,11.3,43.5,11.3,66.2c0,26.5-5.2,51.8-14.7,74.9c-5.6-18.2-19-33.3-36.5-40.9c5.9-9.3,9.3-20.3,9.3-32
                                              c0-33.1-26.9-60-60-60c-9.9,0-19.5,2.4-28,6.9c-9.3-29.2-36.6-50.5-68.9-50.5c-32.3,0-59.6,21.2-68.9,50.5
                                              c-8.5-4.5-18.1-6.9-28-6.9c-33.1,0-60,26.9-60,60c0,11.8,3.4,22.7,9.3,32c-17.5,7.6-30.9,22.7-36.5,40.9
                                              C25.2,345,20,319.7,20,293.2c0-39.2,11.4-77.1,33-109.7c3.1-4.6,1.8-10.8-2.8-13.9s-10.8-1.8-13.9,2.8C12.6,208.3,0,250.1,0,293.2
                                              c0,58.4,22.8,113.4,64.1,154.7c41.3,41.3,96.3,64.1,154.7,64.1c58.4,0,113.4-22.8,154.7-64.1s64.1-96.3,64.1-154.7
                                              c0-23.8-3.8-47.1-11.3-69.4C475.5,211.3,512,166.6,512,113.6L512,113.6z M218.8,211.8c28.8,0,52.2,23.4,52.2,52.2
                                              c0,28.8-23.4,52.2-52.2,52.2s-52.2-23.4-52.2-52.2C166.5,235.2,190,211.8,218.8,211.8z M109.2,378v81
                                              c-22.8-15.2-42.4-34.9-57.3-57.9v-14.3c0-20.6,14.4-38.6,34-43.5c7.8,5.8,17,9.8,27,11.3C110.5,362,109.2,369.9,109.2,378
                                              L109.2,378z M121.8,335.3c-22,0-40-17.9-40-40c0-22,17.9-40,40-40c9.1,0,17.7,3,24.7,8.5c0,0,0,0.1,0,0.1c0,15.2,4.7,29.3,12.8,41
                                              c-15.4,6-28.4,16.8-37.2,30.3C122,335.3,121.9,335.3,121.8,335.3L121.8,335.3z M308.3,470.7C281.4,484.3,251,492,218.8,492
                                              c-32.2,0-62.6-7.7-89.5-21.4V378c0-27.1,19.2-50.9,45.4-56.9c12.2,9.5,27.5,15.1,44.1,15.1s31.9-5.7,44.1-15.1
                                              c26.2,6,45.4,29.7,45.4,56.9V470.7z M315.4,335.3c-8.9-13.5-21.8-24.3-37.2-30.3c8.1-11.7,12.8-25.8,12.8-41c0-0.1,0-0.1,0-0.2
                                              c7-5.5,15.6-8.5,24.7-8.5c22.1,0,40,17.9,40,40c0,22.1-17.9,40-40,40C315.6,335.3,315.5,335.3,315.4,335.3L315.4,335.3z
                                              M385.7,401c-14.9,23-34.5,42.8-57.4,58v-81c0-8.1-1.3-16-3.6-23.4c10-1.5,19.2-5.5,27-11.3c19.7,4.9,34,23,34,43.5V401z
                                              M398.4,207.2c-51.6,0-93.6-42-93.6-93.6c0-51.6,42-93.6,93.6-93.6S492,62,492,113.6C492,165.2,450,207.2,398.4,207.2z" />
                                                    <path d="M443.5,103.6h-35.1V68.5c0-5.5-4.5-10-10-10s-10,4.5-10,10v35.2h-35.2c-5.5,0-10,4.5-10,10s4.5,10,10,10h35.2v35.1c0,5.5,4.5,10,10,10s10-4.5,10-10v-35.1h35.1c5.5,0,10-4.5,10-10S449,103.6,443.5,103.6z" />
                                                </g>
                                            </g>
                                        </svg>
                                    </i><span class="menu-item__title"><?php echo Labels::getLabel('LBL_Offers_Management', $siteLangId); ?></span></a>
                            </div>
                        </li>

                        <li class="menu__item <?php echo ($controller == 'requestforquotes' && $action == 'acceptedoffers') ? 'is-active' : ''; ?>">
                            <div class="menu__item__inner"><a title="<?php echo Labels::getLabel('LBL_Accepted_Offers', $siteLangId); ?>" href="<?php echo CommonHelper::generateUrl('RequestForQuotes', 'AcceptedOffers'); ?>">
                                    <i class="icn shop"><svg class="svg">
                                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#volume-discount" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#volume-discount"></use>
                                        </svg>
                                    </i><span class="menu-item__title"><?php echo Labels::getLabel('LBL_Accepted_Offers', $siteLangId); ?></span></a>
                            </div>
                        </li>

                        <li class="menu__item <?php echo ($controller == 'requestforquotes' && $action == 'requotedoffers') ? 'is-active' : ''; ?>">
                            <div class="menu__item__inner"><a title="<?php echo Labels::getLabel('LBL_Re-Quoted_Offers', $siteLangId); ?>" href="<?php echo CommonHelper::generateUrl('RequestForQuotes', 'reQuotedOffers'); ?>">
                                    <i class="icn shop">
                                        <svg class="svg" id="my_requote_requests" height="512pt" viewBox="0 0 512 512" width="512pt" xmlns="http://www.w3.org/2000/svg">
                                            <path d="m143.9375 382.8125c18.640625-14.515625 30.664062-37.148438 30.664062-62.546875 0-43.707031-35.5625-79.265625-79.269531-79.265625s-79.265625 35.558594-79.265625 79.265625c0 25.398437 12.023438 48.03125 30.660156 62.546875-26.304687 15.648438-46.726562 45.203125-46.726562 82.054688v32.132812c0 8.285156 6.714844 15 15 15h160.667969c8.28125 0 15-6.714844 15-15v-32.132812c0-36.84375-20.417969-66.402344-46.730469-82.054688zm-97.871094-62.546875c0-27.164063 22.101563-49.265625 49.269532-49.265625 27.164062 0 49.265624 22.101562 49.265624 49.265625 0 27.167969-22.101562 49.269531-49.265624 49.269531-27.167969 0-49.269532-22.101562-49.269532-49.269531zm114.601563 161.734375h-130.667969v-17.132812c0-36.085938 29.195312-65.332032 65.332031-65.332032 36.085938 0 65.332031 29.195313 65.332031 65.332032v17.132812zm0 0" />
                                            <path d="m448.800781 0h-192.800781c-34.90625 0-63.199219 28.242188-63.199219 63.199219v289.199219c0 12.269531 14.070313 19.445312 24 12l60.265625-45.199219h171.734375c34.90625 0 63.199219-28.242188 63.199219-63.199219v-192.800781c0-34.90625-28.242188-63.199219-63.199219-63.199219zm33.199219 256c0 18.351562-14.839844 33.199219-33.199219 33.199219h-176.734375c-3.246094 0-6.402344 1.054687-9 3l-40.265625 30.199219v-259.199219c0-18.351563 14.839844-33.199219 33.199219-33.199219h192.800781c18.351563 0 33.199219 14.839844 33.199219 33.199219zm0 0" />
                                            <path d="m432.734375 80.332031h-160.667969c-8.285156 0-15 6.71875-15 15 0 8.285157 6.714844 15 15 15h160.667969c8.28125 0 15-6.714843 15-15 0-8.28125-6.714844-15-15-15zm0 0" />
                                            <path d="m432.734375 144.601562h-160.667969c-8.285156 0-15 6.714844-15 15 0 8.28125 6.714844 15 15 15h160.667969c8.28125 0 15-6.71875 15-15 0-8.285156-6.714844-15-15-15zm0 0" />
                                            <path d="m352.398438 208.867188h-80.332032c-8.285156 0-15 6.714843-15 15 0 8.285156 6.714844 15 15 15h80.332032c8.285156 0 15-6.714844 15-15 0-8.285157-6.714844-15-15-15zm0 0" />
                                        </svg>
                                    </i>
                                    <span class="menu-item__title"><?php echo Labels::getLabel('LBL_Re-Quoted_Offers', $siteLangId); ?></span></a>
                            </div>
                        </li>

                    <?php } ?>
                    <?php if ($userPrivilege->canViewInvoices(UserAuthentication::getLoggedUserId(), true)) { ?>
                        <li class="menu__item <?php echo ($controller == 'invoices' && $action == 'invoicerequests') ? 'is-active' : ''; ?>">
                            <div class="menu__item__inner">
                                <a title="<?php echo Labels::getLabel('LBL_Invoice_Requests', $siteLangId); ?>" href="<?php echo CommonHelper::generateUrl('Invoices', 'invoiceRequests'); ?>">
                                    <i class="icn shop">
                                        <svg class="svg">
                                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#my_requests" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#my_requests"></use>
                                        </svg>
                                    </i><span class="menu-item__title"><?php echo Labels::getLabel('LBL_Invoice_Requests', $siteLangId); ?></span>
                                </a>
                            </div>
                        </li>
                    <?php } ?>
                    <li class="divider"></li>
                <?php } ?>

                <?php
                if (
                    $userPrivilege->canViewSpecialPrice(UserAuthentication::getLoggedUserId(), true) ||
                    $userPrivilege->canViewVolumeDiscount(UserAuthentication::getLoggedUserId(), true) ||
                    $userPrivilege->canViewBuyTogetherProducts(UserAuthentication::getLoggedUserId(), true) ||
                    $userPrivilege->canViewRelatedProducts(UserAuthentication::getLoggedUserId(), true)
                ) {
                ?>
                    <li class="menu__item">
                        <div class="menu__item__inner"> <span class="menu-head"><?php echo Labels::getLabel('LBL_Promotions', $siteLangId); ?></span></div>
                    </li>
                    <?php if ($userPrivilege->canViewSpecialPrice(UserAuthentication::getLoggedUserId(), true)) { ?>
                        <li class="menu__item <?php echo ($controller == 'seller' && $action == 'specialprice') ? 'is-active' : ''; ?>">
                            <div class="menu__item__inner">
                                <a title="<?php echo Labels::getLabel('LBL_Special_Price', $siteLangId); ?>" href="<?php echo CommonHelper::generateUrl('Seller', 'specialPrice'); ?>">
                                    <i class="icn shop"><svg class="svg">
                                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#special-price" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#special-price"></use>
                                        </svg>
                                    </i>
                                    <span class="menu-item__title"><?php echo Labels::getLabel('LBL_Special_Price', $siteLangId); ?></span>
                                </a>
                            </div>
                        </li>
                    <?php } ?>
                    <?php if ($userPrivilege->canViewVolumeDiscount(UserAuthentication::getLoggedUserId(), true)) { ?>
                        <li class="menu__item <?php echo ($controller == 'seller' && $action == 'volumediscount') ? 'is-active' : ''; ?>">
                            <div class="menu__item__inner"><a title="<?php echo Labels::getLabel('LBL_Volume_Discount', $siteLangId); ?>" href="<?php echo CommonHelper::generateUrl('Seller', 'volumeDiscount'); ?>">
                                    <i class="icn shop"><svg class="svg">
                                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#volume-discount" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#volume-discount"></use>
                                        </svg>
                                    </i><span class="menu-item__title"><?php echo Labels::getLabel('LBL_Volume_Discount', $siteLangId); ?></span></a></div>
                        </li>
                    <?php } ?>
                    <?php if ($userPrivilege->canViewBuyTogetherProducts(UserAuthentication::getLoggedUserId(), true)) { ?>
                        <li class="menu__item <?php echo ($controller == 'seller' && $action == 'upsellproducts') ? 'is-active' : ''; ?>">
                            <div class="menu__item__inner"><a title="<?php echo Labels::getLabel('LBL_Buy_Together_Products', $siteLangId); ?>" href="<?php echo CommonHelper::generateUrl('Seller', 'upsellProducts'); ?>">
                                    <i class="icn shop"><svg class="svg">
                                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#buy-together-products" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#buy-together-products"></use>
                                        </svg>
                                    </i><span class="menu-item__title"><?php echo Labels::getLabel('LBL_Buy_Together_Products', $siteLangId); ?></span></a></div>
                        </li>
                    <?php } ?>
                    <?php if ($userPrivilege->canViewRelatedProducts(UserAuthentication::getLoggedUserId(), true)) { ?>
                        <li class="menu__item <?php echo ($controller == 'seller' && $action == 'relatedproducts') ? 'is-active' : ''; ?>">
                            <div class="menu__item__inner"><a title="<?php echo Labels::getLabel('LBL_Related_Products', $siteLangId); ?>" href="<?php echo CommonHelper::generateUrl('Seller', 'RelatedProducts'); ?>">
                                    <i class="icn shop"><svg class="svg">
                                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#related-products" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#related-products"></use>
                                        </svg>
                                    </i><span class="menu-item__title"><?php echo Labels::getLabel('LBL_Related_Products', $siteLangId); ?></span></a></div>
                        </li>
                    <?php } ?>
                    <?php
                    $obj = new Plugin();
                    $pluginData = $obj->getDefaultPluginData(Plugin::TYPE_ADVERTISEMENT_FEED, null, $siteLangId);
                    if (false !== $pluginData && 0 < $pluginData['plugin_active'] && $userPrivilege->canViewPromotions(UserAuthentication::getLoggedUserId(), true)) {
                    ?>
                        <li class="menu__item <?php echo ($controller == strtolower($pluginData['plugin_code'])) ? 'is-active' : ''; ?>">
                            <div class="menu__item__inner">
                                <a title="<?php echo $pluginData['plugin_name']; ?>" href="<?php echo CommonHelper::generateUrl($pluginData['plugin_code']); ?>">
                                    <i class="icn shop">
                                        <svg class="svg">
                                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-promotions" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-promotions"></use>
                                        </svg>
                                    </i>
                                    <span class="menu-item__title"><?php echo $pluginData['plugin_name']; ?></span>
                                </a>
                            </div>
                        </li>
                    <?php } ?>
                    <li class="divider"></li>
                <?php } ?>
                <?php
                if (
                    $userPrivilege->canViewMetaTags(UserAuthentication::getLoggedUserId(), true) ||
                    $userPrivilege->canViewUrlRewriting(UserAuthentication::getLoggedUserId(), true)
                ) {
                ?>
                    <li class="menu__item">
                        <div class="menu__item__inner"> <span class="menu-head"><?php echo Labels::getLabel('LBL_SEO', $siteLangId); ?></span></div>
                    </li>
                    <?php if ($userPrivilege->canViewMetaTags(UserAuthentication::getLoggedUserId(), true)) { ?>
                        <li class="menu__item <?php echo ($controller == 'seller' && $action == 'productseo') ? 'is-active' : ''; ?>">
                            <div class="menu__item__inner">
                                <a title="<?php echo Labels::getLabel('LBL_Meta_Tags', $siteLangId); ?>" href="<?php echo CommonHelper::generateUrl('Seller', 'productSeo'); ?>">
                                    <i class="icn shop"><svg class="svg">
                                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#meta-tags" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#meta-tags"></use>
                                        </svg>
                                    </i>
                                    <span class="menu-item__title"><?php echo Labels::getLabel('LBL_Meta_Tags', $siteLangId); ?></span>
                                </a>
                            </div>
                        </li>
                    <?php } ?>
                    <?php if ($userPrivilege->canViewUrlRewriting(UserAuthentication::getLoggedUserId(), true)) { ?>
                        <li class="menu__item <?php echo ($controller == 'seller' && $action == 'producturlrewriting') ? 'is-active' : ''; ?>">
                            <div class="menu__item__inner"><a title="<?php echo Labels::getLabel('LBL_URL_Rewriting', $siteLangId); ?>" href="<?php echo CommonHelper::generateUrl('Seller', 'productUrlRewriting'); ?>">
                                    <i class="icn shop"><svg class="svg">
                                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#url-rewriting" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#url-rewriting"></use>
                                        </svg>
                                    </i><span class="menu-item__title"><?php echo Labels::getLabel('LBL_URL_Rewriting', $siteLangId); ?></span></a></div>
                        </li>
                    <?php } ?>
                    <li class="divider"></li>
                <?php } ?>
                <?php if (FatApp::getConfig('CONF_ENABLE_SELLER_SUBSCRIPTION_MODULE') && $userPrivilege->canViewSubscription(UserAuthentication::getLoggedUserId(), true)) { ?>
                    <li class="menu__item">
                        <div class="menu__item__inner"> <span class="menu-head"><?php echo Labels::getLabel('LBL_Subscription', $siteLangId); ?></span></div>
                    </li>
                    <li class="menu__item <?php echo ($controller == 'seller' && ($action == 'subscriptions' || $action == 'viewsubscriptionorder')) ? 'is-active' : ''; ?>">
                        <div class="menu__item__inner"><a title="<?php echo Labels::getLabel('LBL_My_Subscriptions', $siteLangId); ?>" href="<?php echo CommonHelper::generateUrl('Seller', 'subscriptions'); ?>">
                                <i class="icn shop"><svg class="svg">
                                        <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-my-subscriptions" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-my-subscriptions"></use>
                                    </svg>
                                </i><span class="menu-item__title"><?php echo Labels::getLabel("LBL_My_Subscriptions", $siteLangId); ?></span></a></div>
                    </li>
                    <li class="menu__item <?php echo ($controller == 'seller' && ($action == 'packages')) ? 'is-active' : ''; ?>">
                        <div class="menu__item__inner"><a title="<?php echo Labels::getLabel('LBL_Subscription_Packages', $siteLangId); ?>" href="<?php echo CommonHelper::generateUrl('seller', 'Packages'); ?>">
                                <i class="icn shop"><svg class="svg">
                                        <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-subscription-packages" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-subscription-packages"></use>
                                    </svg>
                                </i><span class="menu-item__title"><?php echo Labels::getLabel('LBL_Subscription_Packages', $siteLangId); ?></span></a></div>
                    </li>
                    <li class="menu__item <?php echo ($controller == 'seller' && ($action == 'selleroffers')) ? 'is-active' : ''; ?>">
                        <div class="menu__item__inner"><a title="<?php echo Labels::getLabel('LBL_Subscription_Offers', $siteLangId); ?>" href="<?php echo CommonHelper::generateUrl('seller', 'SellerOffers'); ?>">
                                <i class="icn shop"><svg class="svg">
                                        <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-offers" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-offers"></use>
                                    </svg>
                                </i><span class="menu-item__title"><?php echo Labels::getLabel('LBL_Subscription_Offers', $siteLangId); ?></span></a></div>
                    </li>
                    <li class="divider"></li>
                <?php } ?>
                <?php
                if (
                    $userPrivilege->canViewSalesReport(UserAuthentication::getLoggedUserId(), true) ||
                    $userPrivilege->canViewPerformanceReport(UserAuthentication::getLoggedUserId(), true) ||
                    $userPrivilege->canViewInventoryReport(UserAuthentication::getLoggedUserId(), true)
                ) {
                ?>
                    <li class="menu__item">
                        <div class="menu__item__inner"> <span class="menu-head"><?php echo Labels::getLabel("LBL_Reports", $siteLangId); ?></span></div>
                    </li>
                    <?php if ($userPrivilege->canViewSalesReport(UserAuthentication::getLoggedUserId(), true)) { ?>
                        <li class="menu__item <?php echo ($controller == 'reports' && $action == 'salesreport') ? 'is-active' : ''; ?>">
                            <div class="menu__item__inner"><a title="<?php echo Labels::getLabel('LBL_Sales_Report', $siteLangId); ?>" href="<?php echo CommonHelper::generateUrl('Reports', 'SalesReport'); ?>">
                                    <i class="icn shop"><svg class="svg">
                                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-sales-report" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-sales-report"></use>
                                        </svg>
                                    </i><span class="menu-item__title"><?php echo Labels::getLabel('LBL_Sales_Report', $siteLangId); ?></span></a></div>
                        </li>
                    <?php } ?>
                    <?php if ($userPrivilege->canViewPerformanceReport(UserAuthentication::getLoggedUserId(), true)) { ?>
                        <li class="menu__item <?php echo ($controller == 'reports' && $action == 'productsperformance') ? 'is-active' : ''; ?>">
                            <div class="menu__item__inner"><a title="<?php echo Labels::getLabel('LBL_Products_Performance', $siteLangId); ?>" href="<?php echo CommonHelper::generateUrl('Reports', 'ProductsPerformance'); ?>">
                                    <i class="icn shop"><svg class="svg">
                                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-product-performance" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-product-performance"></use>
                                        </svg>
                                    </i><span class="menu-item__title"><?php echo Labels::getLabel('LBL_Products_Performance', $siteLangId); ?></span></a></div>
                        </li>
                    <?php } ?>
                    <?php if ($userPrivilege->canViewInventoryReport(UserAuthentication::getLoggedUserId(), true)) { ?>
                        <li class="menu__item <?php echo ($controller == 'reports' && $action == 'productsinventory') ? 'is-active' : ''; ?>">
                            <div class="menu__item__inner"><a title="<?php echo Labels::getLabel('LBL_Products_Inventory', $siteLangId); ?>" href="<?php echo CommonHelper::generateUrl('Reports', 'productsInventory'); ?>">
                                    <i class="icn shop"><svg class="svg">
                                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-product-inventory" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-product-inventory"></use>
                                        </svg>
                                    </i><span class="menu-item__title"><?php echo Labels::getLabel('LBL_Products_Inventory', $siteLangId); ?></span></a></div>
                        </li>
                        <li class="menu__item <?php echo ($controller == 'reports' && $action == 'productsinventorystockstatus') ? 'is-active' : ''; ?>">
                            <div class="menu__item__inner"><a title="<?php echo Labels::getLabel('LBL_Products_Inventory_Stock_Status', $siteLangId); ?>" href="<?php echo CommonHelper::generateUrl('Reports', 'productsInventoryStockStatus'); ?>">
                                    <i class="icn shop"><svg class="svg">
                                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-product-inventory-stock" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-product-inventory-stock"></use>
                                        </svg>
                                    </i><span class="menu-item__title"><?php echo Labels::getLabel('LBL_Products_Inventory_Stock_Status', $siteLangId); ?></span></a></div>
                        </li>
                    <?php } ?>
                    <li class="divider"></li>
                <?php } ?>
                <li class="menu__item">
                    <div class="menu__item__inner"> <span class="menu-head"><?php echo Labels::getLabel("LBL_Profile", $siteLangId); ?></span></div>
                </li>
                <li class="menu__item <?php echo ($controller == 'account' && $action == 'profileinfo') ? 'is-active' : ''; ?>">
                    <div class="menu__item__inner"><a title="<?php echo Labels::getLabel('LBL_My_Account', $siteLangId); ?>" href="<?php echo CommonHelper::generateUrl('Account', 'ProfileInfo'); ?>">
                            <i class="icn shop"><svg class="svg">
                                    <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-account" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-account"></use>
                                </svg>
                            </i><span class="menu-item__title"><?php echo Labels::getLabel("LBL_My_Account", $siteLangId); ?></span></a></div>
                </li>
                <?php if ($userParentId == UserAuthentication::getLoggedUserId()) { ?>
                    <li class="menu__item <?php echo ($controller == 'seller' && ($action == 'users' || $action == 'userpermissions')) ? 'is-active' : ''; ?>">
                        <div class="menu__item__inner"><a title="<?php echo Labels::getLabel('LBL_Sub_Users', $siteLangId); ?>" href="<?php echo CommonHelper::generateUrl('Seller', 'Users'); ?>">
                                <i class="icn shop"><svg class="svg">
                                        <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-account" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-account"></use>
                                    </svg>
                                </i><span class="menu-item__title"><?php echo Labels::getLabel("LBL_Sub_Users", $siteLangId); ?></span></a></div>
                    </li>
                <?php } ?>
                <?php if ($userPrivilege->canViewMessages(UserAuthentication::getLoggedUserId(), true)) { ?>
                    <li class="menu__item <?php echo ($controller == 'account' && $action == 'messages') ? 'is-active' : ''; ?>">
                        <div class="menu__item__inner"><a title="<?php echo Labels::getLabel('LBL_Messages', $siteLangId); ?>" href="<?php echo CommonHelper::generateUrl('Account', 'Messages'); ?>">
                                <i class="icn shop">
                                    <svg class="svg">
                                        <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-top-message" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-top-message"></use>
                                    </svg>
                                </i><span class="menu-item__title"><?php echo Labels::getLabel("LBL_Messages", $siteLangId); ?>
                                    <?php if ($todayUnreadMessageCount > 0) { ?>
                                        <span class="msg-count"><?php echo ($todayUnreadMessageCount < 9) ? $todayUnreadMessageCount : '9+'; ?></span>
                                    <?php } ?></span></a></div>
                    </li>
                <?php } ?>
                <?php if ($userParentId == UserAuthentication::getLoggedUserId()) { ?>
                    <li class="menu__item <?php echo ($controller == 'account' && $action == 'credits') ? 'is-active' : ''; ?>">
                        <div class="menu__item__inner"><a title="<?php echo Labels::getLabel('LBL_My_Credits', $siteLangId); ?>" href="<?php echo CommonHelper::generateUrl('Account', 'credits'); ?>">
                                <i class="icn shop"><svg class="svg">
                                        <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-credits" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-credits"></use>
                                    </svg>
                                </i><span class="menu-item__title"><?php echo Labels::getLabel('LBL_My_Credits', $siteLangId); ?></span></a></div>
                    </li>
                <?php } ?>
                <li class="menu__item <?php echo ($controller == 'account' && $action == 'changeemailpassword') ? 'is-active' : ''; ?>">
                    <div class="menu__item__inner"><a title="<?php echo Labels::getLabel('LBL_UPDATE_CREDENTIALS', $siteLangId); ?>" href="<?php echo CommonHelper::generateUrl('Account', 'changeEmailPassword'); ?>">
                            <i class="icn shop"><svg class="svg">
                                    <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-change-email" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-change-password"></use>
                                </svg>
                            </i><span class="menu-item__title"><?php echo Labels::getLabel('LBL_UPDATE_CREDENTIALS', $siteLangId); ?></span></a></div>
                </li>
                <?php if ($userPrivilege->canViewImportExport(UserAuthentication::getLoggedUserId(), true)) { ?>
                    <li class="divider"></li>
                    <li class="menu__item">
                        <div class="menu__item__inner"> <span class="menu-head"><?php echo Labels::getLabel('LBL_Import_Export', $siteLangId); ?></span></div>
                    </li>
                    <?php if (FatApp::getConfig('CONF_ENABLE_IMPORT_EXPORT', FatUtility::VAR_INT, 0)) { ?>
                        <li class="menu__item <?php echo ($controller == 'importexport' && ($action == 'index')) ? 'is-active' : ''; ?>">
                            <div class="menu__item__inner"><a title="<?php echo Labels::getLabel('LBL_Import_Export', $siteLangId); ?>" href="<?php echo CommonHelper::generateUrl('ImportExport', 'index'); ?>"><i class="icn shop"><svg class="svg">
                                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-import-export" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-import-export"></use>
                                        </svg>
                                    </i><span class="menu-item__title"><?php echo Labels::getLabel('LBL_Import_Export', $siteLangId); ?></span></a></div>
                        </li>
                    <?php } ?>
                <?php } ?>
                <?php $this->includeTemplate('_partial/dashboardLanguageArea.php'); ?>
            </ul>
        </nav>
    </div>
</sidebar>
<?php if (FatApp::getConfig('CONF_ENABLE_SELLER_SUBSCRIPTION_MODULE') && !empty($currentPlanData) && 14 > $pendingDaysForCurrentPlan && ((isset($_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['displayed_expire_popup']) && !$_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['displayed_expire_popup']) || !isset($_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['displayed_expire_popup']))) { ?>
    <script>
        displaySubscriptionExpirePopup();
    </script>
<?php } ?>