<?php
if (!empty($product['selprod_warranty_policies']) || !empty($product['selprod_return_policies']) || (isset($shippingDetails['ps_free']) && $shippingDetails['ps_free'] == AppConstants::YES) || (count($shippingRates) > 0) || (isset($codEnabled) && $codEnabled == AppConstants::YES)) { ?>
    <div class="options-list">
        <div class="options-list__trigger"><?php echo Labels::getLabel('Lbl_Seller_Guarantee', $siteLangId); ?></div>
        <div class="options-list__target">
            <div class="check-list check-list--half">
                <ul>
                    <?php if (!empty($product['product_warranty'])) { ?>
                        <li>
                            <?php
                            $lbl = Labels::getLabel('LBL_{DAYS}_DAYS_WARRANTY', $siteLangId);
                            echo CommonHelper::replaceStringData($lbl, ['{DAYS}' => $product['product_warranty']]);
                            ?>

                        </li>
                    <?php } ?>
                    <?php if (!empty($product['shop_return_age']) || !empty($product['selprod_return_age'])) { ?>
                        <li>
                            <?php
                            $lbl = Labels::getLabel('LBL_{DAYS}_DAYS_RETURN_BACK_POLICY', $siteLangId);
                            $returnAge = !empty($product['selprod_return_age']) ? $product['selprod_return_age'] : $product['shop_return_age'];
                            $returnAge = !empty($returnAge) ? $returnAge : 0;
                            echo CommonHelper::replaceStringData($lbl, ['{DAYS}' => $returnAge]);
                            ?>

                        </li>
                    <?php } ?>
                    <?php if (!empty($product['shop_cancellation_age']) || !empty($product['selprod_cancellation_age'])) { ?>
                        <li><?php
                            $lbl = Labels::getLabel('LBL_{DAYS}_DAYS_CANCELLATION_POLICY', $siteLangId);
                            $cancellationAge = !empty($product['selprod_cancellation_age']) ? $product['selprod_cancellation_age'] : $product['shop_cancellation_age'];
                            $cancellationAge = !empty($cancellationAge) ? $cancellationAge : 0;
                            echo CommonHelper::replaceStringData($lbl, ['{DAYS}' => $cancellationAge]);
                            ?>

                        </li>
                    <?php } ?>
                    <?php if (isset($shippingDetails['ps_free']) && $shippingDetails['ps_free'] == AppConstants::YES) { ?>
                        <li>
                            <?php echo Labels::getLabel('LBL_Free_Shipping_on_this_Order', $siteLangId); ?>

                        </li>
                    <?php } elseif (count($shippingRates) > 0) { ?>
                        <li>

                            <?php echo Labels::getLabel('LBL_Shipping_Rates', $siteLangId); ?>
                            <a href="#shipRates" rel="facebox"><?php echo Labels::getLabel('LBL_Check', $siteLangId); ?></a>


                        </li>
                    <?php } ?>
                    <?php if (isset($codEnabled) && $codEnabled == AppConstants::YES) { ?>
                        <li>
                            <?php echo Labels::getLabel('LBL_Cash_on_delivery_is_available', $siteLangId); ?>

                        </li>
                    <?php } ?>
                </ul>
            </div>
            <div id="shipRates" style="display:none">
                <div>
                    <?php
                    $arr_flds = array(
                        'country_name' => Labels::getLabel('LBL_Ship_to', $siteLangId),
                        'pship_min_qty' => Labels::getLabel('LBL_Minimum_Qty', $siteLangId),
                        'pship_max_qty' => Labels::getLabel('LBL_Maximum_Qty', $siteLangId),
                        'pship_charges' => Labels::getLabel('LBL_Cost', $siteLangId),
                        //'pship_additional_charges' => Labels::getLabel('LBL_With_Another_item', $siteLangId),
                    );
                    $tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table'));
                    $th = $tbl->appendElement('thead')->appendElement('tr');
                    foreach ($arr_flds as $val) {
                        $e = $th->appendElement('th', array(), $val);
                    }
                    foreach ($shippingRates as $sn => $row) {
                        $tr = $tbl->appendElement('tr');

                        foreach ($arr_flds as $key => $val) {
                            $td = $tr->appendElement('td');
                            switch ($key) {
                                case 'pship_additional_charges':
                                    $otherCharges = $row[$key];
                                    $td->appendElement('plaintext', array(), CommonHelper::displayMoneyFormat($otherCharges));
                                    break;
                                case 'pship_charges':
                                    $shippingCharges = $row[$key];
                                    $td->appendElement('plaintext', array(), CommonHelper::displayMoneyFormat($shippingCharges));
                                    break;
                                case 'country_name':
                                    $td->appendElement('plaintext', array(), Product::getProductShippingTitle($siteLangId, $row), true);
                                    break;
                                case 'pship_min_qty':
                                case 'pship_max_qty':
                                    $label = ($row[$key] == -1) ? Labels::getLabel('LBL_Unlimited_Quantity', $siteLangId) : $row[$key];
                                    $td->appendElement('plaintext', array(), $label, true);
                                    break;
                                default:
                                    $td->appendElement('plaintext', array(), $row[$key], true);
                                    break;
                            }
                        }
                    }
                    echo $tbl->getHtml();
                    ?>
                </div>
            </div>


        </div>
    </div>
<?php
}
