<?php
defined('SYSTEM_INIT') or die('Invalid Usage');
$user_is_buyer = 0;
if (UserAuthentication::isUserLogged()) {
    $user_is_buyer = User::getAttributesById(UserAuthentication::getLoggedUserId(), 'user_is_buyer');
}
if ($user_is_buyer > 0 || (!UserAuthentication::isUserLogged())) {
?>
    <div class="header-control__trigger" data-trigger-cart="side-cart">
        <span class="header-control__trigger-media">
            <span class="site-icon site-icon--large">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 26 23.908">
                    <path d="M0,0H5.482c.345,1.377.687,2.745,1.03,4.125H26c-.213.859-.421,1.7-.629,2.534q-1.107,4.436-2.208,8.876c-.062.252-.159.325-.421.324q-6.474-.016-12.95-.007H9.44c.182.739.356,1.443.532,2.147.109.436.11.436.549.436H20.4a2.74,2.74,0,1,1-2.585,3.114,3.1,3.1,0,0,1,.229-1.56H11.573a2.748,2.748,0,0,1-.353,2.89,2.555,2.555,0,0,1-1.665.985,2.719,2.719,0,0,1-3.12-2.079A2.76,2.76,0,0,1,8.5,18.489a1.961,1.961,0,0,0-.03-.214L4.357,1.788c-.046-.185-.117-.256-.32-.254-1.244.011-2.489.006-3.731,0-.1,0-.2-.007-.3-.012ZM24.036,5.676H6.9L9.052,14.3H21.885C22.6,11.426,23.316,8.562,24.036,5.676ZM7.9,21.165a1.2,1.2,0,1,0,1.2-1.192,1.2,1.2,0,0,0-1.2,1.192Zm11.425,0a1.2,1.2,0,1,0,1.2-1.2,1.2,1.2,0,0,0-1.2,1.2Z" fill="#333" />
                </svg>

            </span>
            <span class="header-control__trigger-count"><?php echo (Cart::CART_MAX_DISPLAY_QTY < $totalCartItems) ? Cart::CART_MAX_DISPLAY_QTY . '+' : $totalCartItems; ?></span>
        </span>
        <span class="header-control__trigger-meta">
            <span class="header-control__trigger-label"><?php echo Labels::getLabel("LBL_Cart", $siteLangId); ?></span>
            <span class="header-control__trigger-value"><?php echo CommonHelper::displayMoneyFormat($cartSummary['cartTotal']); ?></span>
        </span>
    </div>

    <div class="side-cart" id="side-cart" data-close-on-click-outside-cart="side-cart">
        <a href="javascript:void(0)" class="close-layer" data-target-close-cart="side-cart"></a>
        <?php if ($totalCartItems > 0) { ?>
            <div class="cartdetail__body" data-simplebar>
                <div class="short-detail">
                    <table class="cart-summary">
                        <tbody>
                            <?php
                            if (count($products)) {
                                foreach ($products as $product) {
                                    $productUrl = CommonHelper::generateUrl('Products', 'View', array($product['selprod_id']));
                                    $shopUrl = CommonHelper::generateUrl('Shops', 'View', array($product['shop_id']));
                                    $imageUrl = FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'product', array($product['product_id'], "EXTRA-SMALL", $product['selprod_id'], 0, $siteLangId)), CONF_IMG_CACHE_TIME, '.jpg');
                            ?>
                                    <tr class="<?php
                                                echo (!$product['in_stock']) ? 'disabled' : '';
                                                echo ($product['is_digital_product']) ? 'digital_product_tab-js' : 'physical_product_tab-js';
                                                ?>">
                                        <td>
                                            <div class="item__pic">
                                                <?php
                                                if ($product['selprod_type'] == SellerProduct::PRODUCT_TYPE_SERVICE) {
                                                    $imageUrl = FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'serviceProduct', array(FatUtility::int($product['selprod_id']), 'EXTRA-SMALL', 0, $siteLangId)), CONF_IMG_CACHE_TIME, '.jpg');
                                                } else {
                                                    $imageUrl = FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'product', array($product['product_id'], "EXTRA-SMALL", $product['selprod_id'], 0, $siteLangId)), CONF_IMG_CACHE_TIME, '.jpg');
                                                }
                                                ?>
                                                <a href="<?php echo $productUrl; ?>">
                                                    <img loading='lazy' src="<?php echo $imageUrl; ?>" alt="<?php echo $product['product_name']; ?>" title="<?php echo $product['product_name']; ?>">
                                                </a>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="item__description">
                                                <div class="item__category"><a href="<?php echo $shopUrl; ?>"><?php echo $product['shop_name']; ?> </a></div>
                                                <div class="item__title"><a title="<?php echo $product['product_name']; ?>" href="<?php echo $productUrl; ?>"><?php echo ($product['selprod_title']) ? $product['selprod_title'] : $product['product_name']; ?></a></div>
                                                <div class="item__specification"> <?php
                                                                                    if (isset($product['options']) && count($product['options'])) {
                                                                                        $count = 0;
                                                                                        foreach ($product['options'] as $option) {
                                                                                    ?> <?php
                                                                                            echo ($count > 0) ? ' | ' : '';
                                                                                            echo $option['option_name'] . ':';
                                                                                        ?> <?php echo $option['optionvalue_name']; ?> <?php
                                                                                                                                        $count++;
                                                                                                                                    }
                                                                                                                                }
                                                                                                                                        ?> | <?php echo Labels::getLabel('LBL_Quantity:', $siteLangId) ?> <?php echo $product['quantity']; ?> </div>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="product_price"><span class="item__price"><?php echo CommonHelper::displayMoneyFormat($product['theprice'] * $product['quantity']); ?> </span>
                                                <?php if ($product['special_price_found']) { ?>
                                                    <span class="text--normal text--normal-secondary text-nowrap"><?php echo CommonHelper::showProductDiscountedText($product, $siteLangId); ?></span>
                                                <?php } ?>
                                            </div>
                                        </td>
                                        <td class="">
                                            <a href="javascript:void(0)" class="icons-wrapper" onclick="cart.remove('<?php echo md5($product['key']); ?>')" title="<?php echo Labels::getLabel('LBL_Remove', $siteLangId); ?>">
                                                <i class="icn">
                                                    <svg class="svg">
                                                        <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#bin" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#bin"></use>
                                                    </svg>
                                                </i>
                                            </a>
                                        </td>
                                    </tr> <?php
                                        }
                                    } else {
                                        echo Labels::getLabel('LBL_Your_cart_is_empty', $siteLangId);
                                    }
                                            ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="cartdetail__footer">
                <table class="table--justify">
                    <tr>
                        <td class=""><?php echo Labels::getLabel('LBL_Sub_Total', $siteLangId); ?></td>
                        <td class=""><?php echo CommonHelper::displayMoneyFormat($cartSummary['cartTotal']); ?></td>
                    </tr>
                    <?php if (0 < $cartSummary['cartVolumeDiscount']) { ?>
                        <tr>
                            <td><?php echo Labels::getLabel('LBL_Volume_Discount', $siteLangId); ?></td>
                            <td><?php echo CommonHelper::displayMoneyFormat($cartSummary['cartVolumeDiscount']); ?></td>
                        </tr>
                    <?php } ?>
                    <?php
                    if (isset($cartSummary['taxOptions'])) {
                        foreach ($cartSummary['taxOptions'] as $taxName => $taxVal) {
                    ?>
                            <tr>
                                <td><?php echo $taxVal['title']; ?></td>
                                <td><?php echo CommonHelper::displayMoneyFormat($taxVal['value']); ?></td>
                            </tr>
                    <?php
                        }
                    }
                    ?>
                    <?php $netChargeAmt = $cartSummary['cartTotal'] + $cartSummary['cartTaxTotal'] - ((0 < $cartSummary['cartVolumeDiscount']) ? $cartSummary['cartVolumeDiscount'] : 0); ?>
                    <tr>
                        <td class="hightlighted"><?php echo Labels::getLabel('LBL_Net_Payable', $siteLangId); ?></td>
                        <td class="hightlighted"><?php echo CommonHelper::displayMoneyFormat($netChargeAmt); ?></td>
                    </tr>
                    <tr>
                        <td class=""><a href="<?php echo CommonHelper::generateUrl('cart'); ?>" class="btn btn--primary ripplelink"><?php echo Labels::getLabel('LBL_View_Bag', $siteLangId); ?> </a></td>
                        <td class=""><a class="btn btn-outline-primary ripplelink" href="<?php echo CommonHelper::generateUrl('Checkout'); ?>"><?php echo Labels::getLabel('LBL_Proceed_To_Pay', $siteLangId); ?></a></td>
                    </tr>
                </table>
            </div>
        <?php } else { ?>
            <div class="block--empty m-auto text-center"> <img loading='lazy' class="block__img" src="<?php echo CONF_WEBROOT_URL; ?>images/retina/empty_cart.svg" alt="No Record Found" width="80">
                <h4><?php echo Labels::getLabel('LBL_Your_Shopping_Bag_is_Empty', $siteLangId); ?></h4>
            </div>
        <?php } ?>
    </div>
<?php } ?>
<script type="text/javascript">
    $(document).ready(function() {
        $('body').find('*[data-trigger-cart]').click(function() {
            var targetElmId = $(this).data('trigger-cart');
            var elmToggleClass = targetElmId + '--on';
            if ($('body').hasClass(elmToggleClass)) {
                $('body').removeClass(elmToggleClass);
            } else {
                $('body').addClass(elmToggleClass);
            }
        });

        $('body').find('*[data-target-close-cart]').click(function() {
            var targetElmId = $(this).data('target-close-cart');
            $('body').toggleClass(targetElmId + '--on');
        });

        $('body').mouseup(function(event) {
            if ($(event.target).data('triggerCart') != '' && typeof $(event.target).data('triggerCart') !== typeof undefined) {
                event.preventDefault();
                return;
            }

            $('body').find('*[data-close-on-click-outside-cart]').each(function(idx, elm) {
                var slctr = $(elm);
                if (!slctr.is(event.target) && !$.contains(slctr[0], event.target)) {
                    $('body').removeClass(slctr.data('close-on-click-outside-cart') + '--on');
                }
            });
        });

    });
</script>