<?php
defined('SYSTEM_INIT') or die('Invalid Usage');
$getOrgUrl = (CONF_DEVELOPMENT_MODE) ? true : false;
if (!$isUserLogged) {
    if (UserAuthentication::isGuestUserLogged()) {
?>
        <div class="header-control header-control--account header-control--hovered">
            <?php $userName = User::getAttributesById(UserAuthentication::getLoggedUserId(), "user_name"); ?>
            <a href="#account-links-js" class="header-control__trigger header-control__trigger-arrow trigger-js">
                <span class="header-control__trigger-media">
                    <span class="avtar"><img loading='lazy' src="<?php echo $profilePicUrl; ?>" alt=""></span>
                </span>
                <span class="header-control__trigger-meta">
                    <span class="header-control__trigger-label"><?php echo Labels::getLabel("LBL_Welcome", $siteLangId) . " " . $userName; ?></span>
                    <span class="header-control__trigger-value"><?php echo Labels::getLabel("LBL_My_Acount", $siteLangId); ?></span>
                </span>
            </a>
            <div id="account-links-js" class="header-control__target header-control__target--right">
                <nav class="menu-vertical p-4">
                    <ul>
                        <li><a href="<?php echo CommonHelper::generateUrl('account', 'profileInfo'); ?>"><?php echo Labels::getLabel("LBL_My_Account", $siteLangId); ?></a></li>
                        <li class="last-menu-item"><a href="<?php echo CommonHelper::generateUrl('GuestUser', 'logout'); ?>"><?php echo Labels::getLabel("LBL_Logout", $siteLangId); ?></a></li>
                    </ul>
                </nav>
            </div>
        </div>
    <?php } else {
    ?>
        <div class="header-control header-control--account header-control--hovered">
            <a href="javascript:void(0)" class="header-control__trigger header-control__trigger-arrow header__setting-trigger-js sign-in-popup-js">
                <span class="header-control__trigger-media">
                    <span class="site-icon site-icon--large">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 25.898">
                            <g transform="translate(0 12.924)">
                                <g>
                                    <path d="M70.49,255.5H66.11a7.821,7.821,0,0,0-7.81,7.81v5.164h20V263.31A7.821,7.821,0,0,0,70.49,255.5ZM59.817,266.957V263.31a6.3,6.3,0,0,1,6.292-6.292h4.38a6.3,6.3,0,0,1,6.292,6.292v3.647Z" transform="translate(-58.3 -255.5)" fill="#333" />
                                </g>
                            </g>
                            <g transform="translate(3.961)">
                                <g transform="translate(0)">
                                    <path d="M142.639,0a6.039,6.039,0,1,0,6.039,6.039A6.049,6.049,0,0,0,142.639,0Zm0,10.561a4.522,4.522,0,1,1,4.522-4.522A4.527,4.527,0,0,1,142.639,10.561Z" transform="translate(-136.6 0)" fill="#333" />
                                </g>
                            </g>
                        </svg>
                    </span>
                </span>
                <span class="header-control__trigger-meta">
                    <span class="header-control__trigger-label"><?php echo Labels::getLabel("LBL_Welcome_User", $siteLangId); ?></span>
                    <span class="header-control__trigger-value"><?php echo Labels::getLabel('LBL_Login_&_Register', $siteLangId); ?></span>
                </span>
            </a>

            <div class="header-control__target header-control__target--right">
                <div class="account-meta text-center">
                    <p><strong> <?php echo Labels::getLabel('LBL_New_to_Yo-kart-B2B?', $siteLangId); ?></strong> <br><?php echo Labels::getLabel('LBL_Join_Now_as_a', $siteLangId); ?> <a href="<?php echo CommonHelper::generateUrl("Supplier"); ?>" class="account-meta__action"><?php echo Labels::getLabel('LBL_Seller', $siteLangId); ?></a>&nbsp;<?php echo Labels::getLabel('LBL_OR_as_a', $siteLangId); ?> <a href="<?php echo CommonHelper::generateUrl("GuestUser", "LoginForm", [$siteLangId]); ?>" class="account-meta__action"><?php echo Labels::getLabel('LBL_Buyer', $siteLangId); ?></a></p>
                    <hr>
                    <p><strong><?php echo Labels::getLabel('LBL_Already_to_Yo-kart-B2B?', $siteLangId); ?></strong><br>
                        <a href="javascript:void(0);" class="btn btn--primary btn--wide mt-2 sign-in-popup-js"><?php echo Labels::getLabel('LBL_Login', $siteLangId); ?></a>
                    </p>
                    <?php if (!empty($socialLoginApis) && 0 < count($socialLoginApis)) { ?>    
                    <p class="m-0"><strong><?php echo Labels::getLabel('LBL_Or_Continue_with:', $siteLangId); ?></strong></p>
                    <div class="buttons-list mt-2">
                        <ul>
                             <?php foreach ($socialLoginApis as $plugin) { ?>
                                <li>
                                    <a href="<?php echo CommonHelper::generateUrl($plugin['plugin_code']); ?>" class="btn btn--social btn--<?php echo $plugin['plugin_code']; ?>">
                                        <i class="icn">
                                            <img src="<?php echo CONF_WEBROOT_URL; ?>images/retina/social-icons/<?php echo $plugin['plugin_code']; ?>.svg">
                                        </i>
                                    </a>
                                </li>
                            <?php } ?>
                        </ul>
                    </div>
                    <?php } ?>
                </div>
            </div>

        </div>

    <?php }
    ?> <?php
        // $this->includeTemplate('guest-user/loginFormTemplate.php');
    } else {
        $userActiveTab = false;
        if (User::canViewSupplierTab() && (isset($_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab']) && $_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab'] == 'S')) {
            $userActiveTab = true;
            $dashboardUrl = CommonHelper::generateUrl('Seller');
            $dashboardOrgUrl = CommonHelper::generateUrl('Seller', '', array(), '', null, false, $getOrgUrl);
        } elseif (User::canViewBuyerTab() && (isset($_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab']) && $_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab'] == 'B')) {
            $userActiveTab = true;
            $dashboardUrl = CommonHelper::generateUrl('Buyer');
            $dashboardOrgUrl = CommonHelper::generateUrl('Buyer', '', array(), '', null, false, $getOrgUrl);
        } elseif (User::canViewAdvertiserTab() && (isset($_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab']) && $_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab'] == 'Ad')) {
            $userActiveTab = true;
            $dashboardUrl = CommonHelper::generateUrl('Advertiser');
            $dashboardOrgUrl = CommonHelper::generateUrl('Advertiser', '', array(), '', null, false, $getOrgUrl);
        } elseif (User::canViewAffiliateTab() && (isset($_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab']) && $_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab'] == 'AFFILIATE')) {
            $userActiveTab = true;
            $dashboardUrl = CommonHelper::generateUrl('Affiliate');
            $dashboardOrgUrl = CommonHelper::generateUrl('Affiliate', '', array(), '', null, false, $getOrgUrl);
        }
        if (!$userActiveTab) {
            $dashboardUrl = CommonHelper::generateUrl('Account');
            $dashboardOrgUrl = CommonHelper::generateUrl('Account', '', array(), '', null, false, $getOrgUrl);
        }
        ?>

    <div class="header-control header-control--account header-control--hovered">
        <?php $userName = User::getAttributesById(UserAuthentication::getLoggedUserId(), "user_name"); ?>
        <a href="#account-links-js" class="header-control__trigger header-control__trigger-arrow trigger-js">
            <span class="header-control__trigger-media">
                <span class="avtar"><img loading='lazy' src="<?php echo $profilePicUrl; ?>" alt=""></span>
            </span>
            <span class="header-control__trigger-meta">
                <span class="header-control__trigger-label"><?php echo Labels::getLabel("LBL_Welcome", $siteLangId) . " " . $userName; ?></span>
                <span class="header-control__trigger-value"><?php echo Labels::getLabel("LBL_My_Acount_&_Orders", $siteLangId); ?></span>
            </span>
        </a>
        <div id="account-links-js" class="header-control__target header-control__target--right">
            <?php
            $orderUrl = "";
            if (User::canViewSupplierTab()) {
                $orderUrl = CommonHelper::generateUrl('seller', 'sales');
            }
            if (User::canViewBuyerTab()) {
                $orderUrl = CommonHelper::generateUrl('Buyer', 'orders');
            }
            ?>
            <nav class="menu-vertical p-4">
                <ul>
                    <li><a href="<?php echo $dashboardUrl; ?>"><?php echo Labels::getLabel("LBL_Dashboard", $siteLangId); ?></a></li>
                    <li><a href="<?php echo CommonHelper::generateUrl('account', 'profileInfo'); ?>"><?php echo Labels::getLabel("LBL_My_Account", $siteLangId); ?></a></li>
                    <?php if (!empty($orderUrl)) { ?>
                        <li><a href="<?php echo $orderUrl; ?>"><?php echo Labels::getLabel("LBL_My_Orders", $siteLangId); ?></a></li>
                    <?php } ?>
                    <?php if (User::canViewSupplierTab()) { ?>
                        <li><a href="<?php echo CommonHelper::generateUrl("seller", "products"); ?>"><?php echo Labels::getLabel("LBL_My_Products", $siteLangId); ?></a></li>
                    <?php } ?>
                    <li class="last-menu-item"><a href="<?php echo CommonHelper::generateUrl('GuestUser', 'logout'); ?>"><?php echo Labels::getLabel("LBL_Logout", $siteLangId); ?></a></li>
                </ul>
            </nav>
        </div>

    </div>
<?php } ?>