<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<?php
$adjustmentAmount = 0;

if (!empty($orderDetail['order_cart_data'])) {
    $cartData = $orderDetail['order_cart_data'];
    $cartData = unserialize(html_entity_decode($cartData));
    $cartData = $cartData['subscription_shopping_cart'];

    if (array_key_exists('adjusted_amount', $cartData)) {
        $adjustmentAmount = $cartData['adjusted_amount'];
    }
}


?>
<table cellspacing="0" cellpadding="0" border="0" width="100%" style="border:1px solid #ddd; border-collapse:collapse;">
    <thead>
        <tr>
            <td width="40%" style="padding:10px;background:#eee;font-size:13px;border:1px solid #ddd; color:#333; font-weight:bold;">
                <?php echo Labels::getLabel('LBL_Plan_Name', $siteLangId); ?>
            </td>
            <td width="40%" style="padding:10px;background:#eee;font-size:13px;border:1px solid #ddd; color:#333; font-weight:bold;">
                <?php echo Labels::getLabel('LBL_Amount', $siteLangId); ?>
            </td>
            <td width="40%" style="padding:10px;background:#eee;font-size:13px;border:1px solid #ddd; color:#333; font-weight:bold;">
                <?php echo Labels::getLabel('LBL_Subscription_Start_From', $siteLangId); ?>
            </td>
            <td width="40%" style="padding:10px;background:#eee;font-size:13px;border:1px solid #ddd; color:#333; font-weight:bold;">
                <?php echo Labels::getLabel('LBL_Subscription_Valid_till', $siteLangId); ?>
            </td>
            <td width="40%" style="padding:10px;background:#eee;font-size:13px;border:1px solid #ddd; color:#333; font-weight:bold;">
                <?php echo Labels::getLabel('LBL_Taxes', $siteLangId); ?>
            </td>

        </tr>
    </thead>
    <tbody>
        <tr>
            <td width="40%" style="padding:10px;font-size:13px;border:1px solid #ddd; color:#333;">
                <?php echo $orderDetail['ossubs_subscription_name']; ?>
            </td>
            <td width="40%" style="padding:10px;font-size:13px;border:1px solid #ddd; color:#333;">
                <?php echo CommonHelper::displayMoneyFormat($orderDetail['ossubs_price']); ?>
            </td>

            <td width="40%" style="padding:10px;font-size:13px;border:1px solid #ddd; color:#333;">
                <?php echo FatDate::format($orderDetail['ossubs_from_date']); ?>
            </td>
            <td width="40%" style="padding:10px;font-size:13px;border:1px solid #ddd; color:#333;">
                <?php echo FatDate::format($orderDetail['ossubs_till_date']); ?>
            </td>
            <td width="40%" style="padding:10px;font-size:13px;border:1px solid #ddd; color:#333;">
                <?php echo CommonHelper::displayMoneyFormat($orderDetail['order_tax_charged']); ?>
            </td>

        </tr>
        <tr>
            <td colspan="5" style="padding:10px;font-size:13px; color:#333;border:1px solid #ddd;" align="right">
                <?php echo Labels::getLabel('LBL_Cart_Total', $siteLangId); ?>
            </td>
            <td style="padding:10px;font-size:13px; color:#333;border:1px solid #ddd;" align="right">
                <?php echo CommonHelper::displayMoneyFormat($orderDetail['ossubs_price']); ?>
            </td>
        </tr>

        <tr>
            <td colspan="5" style="padding:10px;font-size:13px; color:#333;border:1px solid #ddd;" align="right">
                <?php echo Labels::getLabel('LBL_Volume/Loyalty_Discount', $siteLangId); ?>
            </td>
            <td style="padding:10px;font-size:13px; color:#333;border:1px solid #ddd;" align="right">
                <?php echo CommonHelper::displayMoneyFormat($orderDetail['order_volume_discount_total']); ?>
            </td>
        </tr>
        <?php if ($adjustmentAmount > 0) { ?>
            <tr>
                <td colspan="5" style="padding:10px;font-size:13px; color:#333;border:1px solid #ddd;" align="right">
                    <?php echo Labels::getLabel('LBL_Adjusted_Amount', $siteLangId); ?>
                </td>
                <td style="padding:10px;font-size:13px; color:#333;border:1px solid #ddd;" align="right">
                    <?php echo CommonHelper::displayMoneyFormat($adjustmentAmount); ?>
                </td>
            </tr>

        <?php } ?>


        <tr>
            <td colspan="5" style="padding:10px;font-size:13px; color:#333;border:1px solid #ddd;" align="right">
                <?php echo Labels::getLabel('LBL_Net_Payable_Amount', $siteLangId); ?>
            </td>
            <td style="padding:10px;font-size:13px; color:#333;border:1px solid #ddd;" align="right">
                <?php echo CommonHelper::displayMoneyFormat($orderDetail['order_net_amount']); ?>
            </td>
        </tr>
    </tbody>
</table>