<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
$paymentTypeArr = Orders::getPaymentTypeArr($siteLangId);
?>
<table cellspacing="0" cellpadding="0" border="0" width="100%" style="border:1px solid #ddd; border-collapse:collapse; text-align: left;">
    <thead>
        <tr style="text-align: center;">
            <th colspan="2" style="padding:10px;font-size:13px; color:#333;border:1px solid #ddd;"><?php echo $orderInfo['selprod_title']; ?></th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td style="padding:10px;font-size:13px; color:#333;border:1px solid #ddd;">
                <strong><?php echo Labels::getLabel('LBL_Order', $siteLangId); ?></strong> : #<?php echo $orderInfo['order_id']; ?>
            </td>
            <td style="padding:10px;font-size:13px; color:#333;border:1px solid #ddd;">
                <strong><?php echo Labels::getLabel('LBL_Payment_Type', $siteLangId); ?></strong> : <?php echo $paymentTypeArr[$orderInfo['invoice_payment_type']]; ?>
            </td>
        </tr>
        <tr>
            <td style="padding:10px;font-size:13px; color:#333;border:1px solid #ddd;">
                <strong><?php echo Labels::getLabel('LBL_Shop', $siteLangId); ?></strong> : <?php echo $orderInfo['shop_name']; ?>
            </td>
            <td style="padding:10px;font-size:13px; color:#333;border:1px solid #ddd;">
                <strong><?php echo Labels::getLabel('LBL_Seller', $siteLangId); ?></strong> : <?php echo $orderInfo['shop_owner']; ?>
            </td>
        </tr>
        <tr>
            <td style="padding:10px;font-size:13px; color:#333;border:1px solid #ddd;">
                <strong><?php echo Labels::getLabel('LBL_Order_Total', $siteLangId); ?></strong> : <?php echo CommonHelper::displayMoneyFormat($orderInfo['total_amount'], true, false, true, false, true); ?>
            </td>
            <td style="padding:10px;font-size:13px; color:#333;border:1px solid #ddd;">
                <strong><?php echo Labels::getLabel('LBL_Amount_To_Pay', $siteLangId); ?></strong> : <?php echo CommonHelper::displayMoneyFormat($orderInfo['invoice_payment_amount'], true, false, true, false, true); ?>
            </td>
        </tr>
        <tr>
            <td style="padding:10px;font-size:13px; color:#333;border:1px solid #ddd;">
                <strong><?php echo Labels::getLabel('LBL_Paid_Amount', $siteLangId); ?></strong> : <?php echo CommonHelper::displayMoneyFormat($orderInfo['total_paid_amount'], true, false, true, false, true); ?>
            </td>
            <td style="padding:10px;font-size:13px; color:#333;border:1px solid #ddd;">
                <strong><?php echo Labels::getLabel('LBL_Remaining_Balance', $siteLangId); ?></strong> : <?php echo CommonHelper::displayMoneyFormat($orderInfo['total_amount'] - $orderInfo['total_paid_amount'] - $orderInfo['invoice_payment_amount'], true, false, true, false, true); ?>
            </td>
        </tr>
        <tr>
            <td colspan="2" style="padding:10px;font-size:13px; color:#333;border:1px solid #ddd;">
                <strong><?php echo Labels::getLabel('LBL_Seller_Comments', $siteLangId); ?></strong> : <?php echo $orderInfo['invoice_description']; ?>
            </td>
        </tr>
    </tbody>
</table>