<?php
if (isset($collections) && count($collections)) {
	foreach ($collections as $collection_id => $row) {

		$imgUpdatedOn =  Collections::getAttributesById($collection_id, 'collection_img_updated_on');
		$imgUpdatedOn = AttachedFile::setTimeParam($imgUpdatedOn);
		$imgUrl = FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'collectionReal', array($collection_id, $siteLangId, 'homesquare'), CONF_WEBROOT_FRONT_URL) . $imgUpdatedOn, CONF_IMG_CACHE_TIME, '.jpg');
		/* category listing design [ */
		if (isset($row['categories']) && count($row['categories'])) { ?>
			<section class="section">
				<div class="container">
					<div class="section-card">
						<div class="section-head">
							<?php echo ($row['collection_name'] != '') ? ' <div class="section__heading"><h2>' . $row['collection_name'] . '</h2></div>' : ''; ?>
							<?php if ($row['totCategories'] > Collections::LIMIT_CATEGORY_LAYOUT2) { ?>
								<div class="section__action"> <a href="<?php echo CommonHelper::generateUrl('Collections', 'View', array($row['collection_id'])); ?>" class="link"><?php echo Labels::getLabel('LBL_View_More', $siteLangId); ?></a> </div>
							<?php }  ?>
						</div>
						<div class="section-body">
							<div class="collection-grid-wrapper">
								<div class="collection-ad">
									<div class="collection-ad-media">
										<?php if (!empty($imgUrl)) { ?>
											<a title="<?php echo $row['collection_name']; ?>" href="<?php echo CommonHelper::generateUrl('Collections', 'View', array($row['collection_id'])); ?>"> <img loading="lazy" alt="<?php echo $row['collection_name']; ?>" src="<?php echo $imgUrl; ?>"></a>
										<?php } ?>
									</div>
								</div>
								<div class="home-collection-grid">
									<?php foreach ($row['categories'] as $category) { ?>
										<div class="home-grid-item">
											<div class="home-grid-head">
												<h5><a href="<?php echo CommonHelper::generateUrl('Category', 'View', array($category['prodcat_id'])); ?>"> <?php echo $category['prodcat_name']; ?></a></h5>
											</div>
											<div class="home-grid-body">
												<div class="home-grid-list">
													<ul>
														<?php $i = 1;
														foreach ($category['subCategories'] as $subCat) { ?>
															<li> <a href="<?php echo CommonHelper::generateUrl('Category', 'View', array($subCat['prodcat_id'])); ?>"><?php echo $subCat['prodcat_name']; ?></a> </li>
														<?php $i++;
															if ($i >= 4) break;
														} ?>

													</ul>
												</div>
												<div class="home-grid-media">
													<img loading="lazy" src="<?php echo CommonHelper::generateFileUrl("Category", "Image", [$category["prodcat_id"], 0, 'THUMB']); ?>">
												</div>
											</div>
										</div>
									<?php } ?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</section>
<?php }
	}
}	/* ] */
?>