<?php
if (isset($collections) && count($collections)) {


    $counter = 1;

    foreach ($collections as $collection_id => $row) { /* brand listing design [ */
        if (isset($row['brands']) && count($row['brands'])) {
?>

            <section class="section">
                <div class="container">
                    <div class="section-card">
                        <div class="section-head">
                            <?php echo ($row['collection_name'] != '') ? ' <div class="section-head__title"><h2>' . $row['collection_name'] . '</h2></div>' : ''; ?>
                            <?php if ($row['totBrands'] > Collections::LIMIT_BRAND_LAYOUT1) { ?>
                                <div class="section__action"> <a href="<?php echo CommonHelper::generateUrl('Collections', 'View', array($row['collection_id'])); ?>" class="link"><?php echo Labels::getLabel('LBL_View_More', $siteLangId); ?></a> </div>
                            <?php } ?>
                        </div>
                        <div class="section-body">
                            <div class="site-caraousel site-caraousel--7 site-caraousel-7-js">


                                <?php $i = 0;
                                foreach ($row['brands'] as $brand) { ?>

                                    <div>
                                        <div class="site-caraousel__item">
                                            <a class="brands-logo" href="<?php echo CommonHelper::generateUrl('brands', 'View', array($brand['brand_id'])); ?>">
                                                <?php $fileData = AttachedFile::getAttachment(AttachedFile::FILETYPE_BRAND_LOGO, $brand['brand_id'], 0, 0, false);
                                                $aspectRatioArr = AttachedFile::getRatioTypeArray($siteLangId);
                                                ?>
                                                <img loading="lazy" <?php if ($fileData['afile_aspect_ratio'] > 0) { ?> data-ratio="<?php echo $aspectRatioArr[$fileData['afile_aspect_ratio']]; ?>" <?php } ?> src="<?php echo FatCache::getCachedUrl(CommonHelper::generateFileUrl('Image', 'brand', array($brand['brand_id'], $siteLangId, 'COLLECTION_PAGE')), CONF_IMG_CACHE_TIME, '.jpg'); ?>" alt="<?php echo $brand['brand_name']; ?>" title="<?php echo $brand['brand_name']; ?>">
                                            </a>
                                        </div>
                                    </div>
                                <?php } ?>

                            </div>
                        </div>
                    </div>
                </div>
            </section>
<?php
        }
    }
}
?>