<?php

class Common
{

    public static function headerWishListAndCartSummary($template)
    {
        $siteLangId = CommonHelper::getLangId();
        $loggedUserId = 0;
        if (UserAuthentication::isUserLogged()) {
            $loggedUserId = UserAuthentication::getLoggedUserId();
        }
        $cartObj = new Cart($loggedUserId);
        $wislistPSrchObj = new UserWishListProductSearch();
        $wislistPSrchObj->joinWishLists();
        $wislistPSrchObj->doNotLimitRecords();
        $wislistPSrchObj->addCondition('uwlist_user_id', '=', $loggedUserId);
        $wislistPSrchObj->addGroupBy('uwlp_selprod_id');
        $wislistPSrchObj->addMultipleFields(array('uwlp_uwlist_id'));
        $rs = $wislistPSrchObj->getResultSet();
        $totalWishListItems = $wislistPSrchObj->recordCount();
        $productsArr = $cartObj->getProducts($siteLangId);
        $cartSummary = $cartObj->getCartFinancialSummary($siteLangId);
        $template->set('siteLangId', $siteLangId);
        $template->set('products', $productsArr);
        $template->set('cartSummary', $cartSummary);
        $template->set('totalWishListItems', $totalWishListItems);
        $template->set('totalCartItems', $cartObj->countProducts());
    }

    public static function countWishList()
    {
        $loggedUserId = 0;
        if (UserAuthentication::isUserLogged()) {
            $loggedUserId = UserAuthentication::getLoggedUserId();
        }

        $wislistPSrchObj = new UserWishListProductSearch();
        $wislistPSrchObj->joinSellerProducts();
        $wislistPSrchObj->joinProducts();
        $wislistPSrchObj->joinSellers();
        $wislistPSrchObj->joinShops();
        $wislistPSrchObj->joinProductToCategory();
        $wislistPSrchObj->joinSellerSubscription();
        $wislistPSrchObj->addSubscriptionValidCondition();
        $wislistPSrchObj->joinWishLists();
        $wislistPSrchObj->doNotLimitRecords();
        $wislistPSrchObj->addCondition('uwlist_user_id', '=', $loggedUserId);
        $wislistPSrchObj->addCondition('selprod_deleted', '=', AppConstants::NO);
        $wislistPSrchObj->addCondition('selprod_active', '=', AppConstants::YES);
        $wislistPSrchObj->addGroupBy('uwlp_selprod_id');
        $wislistPSrchObj->addMultipleFields(array('uwlp_uwlist_id'));
        $rs = $wislistPSrchObj->getResultSet();
        $totalWishListItems = $wislistPSrchObj->recordCount();

        return $totalWishListItems;
    }

    public static function setHeaderBreadCrumb($template)
    {
        $controllerName = FatApp::getController();
        $action = FatApp::getAction();

        $controller = new $controllerName('');
        $template->set('siteLangId', CommonHelper::getLangId());
        $template->set('nodes', $controller->getBreadcrumbNodes($action));
    }

    public static function headerUserArea($template)
    {
        $template->set('siteLangId', CommonHelper::getLangId());
        $isUserLogged = UserAuthentication::isUserLogged();
        $template->set('isUserLogged', $isUserLogged);
        $socialLoginApis = Plugin::getDataByType(Plugin::TYPE_SOCIAL_LOGIN, CommonHelper::getLangId());
        $template->set('socialLoginApis', $socialLoginApis);
        if ($isUserLogged) {
            $userId = UserAuthentication::getLoggedUserId();
            $userImgUpdatedOn = User::getAttributesById($userId, 'user_updated_on');
            $uploadedTime = AttachedFile::setTimeParam($userImgUpdatedOn);
            $profileImage = FatCache::getCachedUrl(CommonHelper::generateFileUrl('Account', 'userProfileImage', array($userId, 'croped', true)) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg');
            $template->set('userName', ucfirst(CommonHelper::getUserFirstName(UserAuthentication::getLoggedUserAttribute('user_name'))));
            $template->set('userEmail', UserAuthentication::getLoggedUserAttribute('user_email'));
            $template->set('profilePicUrl', $profileImage);
        }
    }

    public static function headerSearchFormArea($template)
    {
        $siteLangId = CommonHelper::getLangId();
        $headerSrchFrm = static::getSiteSearchForm();
        $headerSrchFrm->setFormTagAttribute('onSubmit', 'submitSiteSearch(this, ' . FatApp::getConfig('CONF_ITEMS_PER_PAGE_CATALOG', FatUtility::VAR_INT, 10) . '); return(false);');
        /* to fill the posted data to form[ */
        $paramsArr = FatApp::getParameters();
        $paramsAssocArr = SearchItem::convertArrToSrchFiltersAssocArr($paramsArr);
        /* $paramsAssocArr = CommonHelper::arrayToAssocArray($paramsArr); */
        $headerSrchFrm->fill($paramsAssocArr);
        /* ] */

        $headerRootCatArr = FatCache::get('headerRootCatArr' . $siteLangId, CONF_HOME_PAGE_CACHE_TIME, '.txt');
        if ($headerRootCatArr) {
            $categoriesArr = unserialize($headerRootCatArr);
        } else {
            /* SubQuery, Category have products[ */
            $prodSrchObj = new ProductSearch();
            $prodSrchObj->setDefinedCriteria(0, 0, array('doNotJoinSpecialPrice' => true));
            $prodSrchObj->joinProductToCategory($siteLangId);
            $prodSrchObj->doNotCalculateRecords();
            $prodSrchObj->doNotLimitRecords();
            $prodSrchObj->joinSellerSubscription($siteLangId, true);
            $prodSrchObj->addSubscriptionValidCondition();
            $prodSrchObj->addGroupBy('prodcat_id');
            $prodSrchObj->addMultipleFields(array('prodcat_code AS prodrootcat_code', 'count(selprod_id) as productCounts', 'prodcat_id', 'IFNULL(prodcat_name, prodcat_identifier) as prodcat_name', 'prodcat_parent'));

            $rs = $prodSrchObj->getResultSet();

            $productRows = FatApp::getDb()->fetchAll($rs);

            $mainRootCategories = FatUtility::int(array_column($productRows, 'prodrootcat_code'));

            $categoriesMainRootArr = array();

            if ($productRows) {
                $categoriesMainRootArr = array_unique($mainRootCategories);
                array_flip($categoriesMainRootArr);
            }
            /* ] */

            $catSrch = ProductCategory::getSearchObject(false, $siteLangId);
            $catSrch->addMultipleFields(array('prodcat_id', 'IFNULL(prodcat_name, prodcat_identifier) as category_name'));
            $catSrch->addOrder('category_name');
            $catSrch->doNotCalculateRecords();
            $catSrch->addCondition('prodcat_active', '=', AppConstants::YES);
            $catSrch->addCondition('prodcat_deleted', '=', AppConstants::NO);
            if ($categoriesMainRootArr) {
                $catSrch->addCondition('prodcat_id', 'in', $categoriesMainRootArr);
            }
            $catSrch->setPageSize(25);
            $catRs = $catSrch->getResultSet();
            $categoriesArr = [];
            while ($row = FatApp::getDb()->fetch($catRs)) {
                $categoriesArr[$row['prodcat_id']] = strip_tags($row['category_name']);
            }
        }

        FatCache::set('headerRootCatArr' . $siteLangId, serialize($categoriesArr), '.txt');

        $template->set('categoriesArr', $categoriesArr);
        $template->set('headerSrchFrm', $headerSrchFrm);
        $template->set('siteLangId', $siteLangId);
    }

    public static function getSiteSearchForm()
    {
        $siteLangId = CommonHelper::getLangId();
        $frm = new Form('frmSiteSearch');
        $frm->setFormTagAttribute('class', 'main-search-form');
        $frm->setFormTagAttribute('autocomplete', 'off');
        $frm->addTextBox('', 'keyword');
        $frm->addHiddenField('', 'category');
        $frm->addHiddenField('', 'sellertype', 0);
        $frm->addSubmitButton('', 'btnSiteSrchSubmit', Labels::getLabel('LBL_Search', CommonHelper::getLangId()));
        return $frm;
    }

    public static function headerLanguageArea($template)
    {
        $template->set('siteLangId', CommonHelper::getLangId());
        $template->set('siteCurrencyId', CommonHelper::getCurrencyId());
        $template->set('languages', Language::getAllNames(false));
        $template->set('currencies', Currency::getCurrencyAssoc(CommonHelper::getLangId()));
    }

    public static function footerNewsLetterForm($template)
    {
        $siteLangId = CommonHelper::getLangId();
        $frm = static::getNewsLetterForm($siteLangId);
        $template->set('frm', $frm);
        $template->set('siteLangId', $siteLangId);
    }

    public static function footerTrustBanners($template)
    {
        $siteLangId = CommonHelper::getLangId();
        $obj = new Extrapage();
        $footerData = $obj->getContentByPageType(Extrapage::FOOTER_TRUST_BANNERS, $siteLangId);
        $template->set('footerData', $footerData);
    }

    public static function getNewsLetterForm($langId)
    {
        $frm = new Form('frmNewsLetter');
        $frm->setRequiredStarWith('');
        $fld1 = $frm->addEmailField('', 'email');
        $fld2 = $frm->addSubmitButton('', 'btnSubmit', Labels::getLabel('LBL_Subscribe', $langId));
        $fld1->attachField($fld2);
        $frm->setJsErrorDisplay('afterfield');
        return $frm;
    }

    public static function footerSocialMedia($template)
    {
        $siteLangId = CommonHelper::getLangId();
        $srch = SocialPlatform::getSearchObject($siteLangId);
        $srch->doNotCalculateRecords();
        $srch->doNotLimitRecords();
        $srch->addCondition('splatform_user_id', '=', 0);
        $rs = $srch->getResultSet();
        $rows = FatApp::getDb()->fetchAll($rs);
        $template->set('rows', $rows);
        $template->set('siteLangId', $siteLangId);
    }

    public static function homePageBelowSlider($template)
    {
        $siteLangId = CommonHelper::getLangId();
    }

    public static function productDetailPageBanner($template)
    {
        $siteLangId = CommonHelper::getLangId();
    }

    public static function blogSidePanelArea($template)
    {
        $siteLangId = CommonHelper::getLangId();
        $blogSrchFrm = static::getBlogSearchForm();
        $blogSrchFrm->setFormTagAttribute('action', CommonHelper::generateUrl('Blog'));

        /* to fill the posted data into form[ */
        $postedData = FatApp::getPostedData();
        $blogSrchFrm->fill($postedData);
        /* ] */

        /* Right Side Categories Data[ */
        $categoriesArr = BlogPostCategory::getBlogPostCatParentChildWiseArr($siteLangId);
        $template->set('categoriesArr', $categoriesArr);
        /* ] */

        $template->set('blogSrchFrm', $blogSrchFrm);
        $template->set('siteLangId', $siteLangId);
    }

    public static function blogTopFeaturedCategories($template)
    {
        $siteLangId = CommonHelper::getLangId();
        $bpCatObj = new BlogPostCategory();
        $arrCategories = $bpCatObj->getFeaturedCategories($siteLangId);
        $categories = $bpCatObj->makeAssociativeArray($arrCategories);
        $template->set('featuredBlogCategories', $categories);
        $template->set('siteLangId', $siteLangId);
    }

    public static function getBlogSearchForm()
    {
        $frm = new Form('frmBlogSearch');
        $frm->setFormTagAttribute('autocomplete', 'off');
        $frm->addTextBox('', 'keyword', '');
        $frm->addHiddenField('', 'page', 1);
        $frm->addSubmitButton('', 'btn_submit', '');
        return $frm;
    }

    public static function getPollForm($pollId, $langId)
    {
        $frm = new Form('frmPoll');
        $frm->addHiddenField('', 'pollfeedback_polling_id', $pollId);
        $frm->addRadioButtons('', 'pollfeedback_response_type', Polling::getPollingResponseTypeArr($langId), '1', array('class' => 'listing--vertical listing--vertical-chcek'), array());
        $frm->addSubmitButton('', 'btn_submit', Labels::getLabel('Lbl_Vote', $langId), array('class' => 'btn btn--primary poll--link-js'));
        return $frm;
    }

}
