<?php

class ServiceSearch extends SearchBase
{

    private $sellersJoined = false;
    private $shopsJoined = false;
    private $sellerSubscriptionJoined = false;
    private $serviceCategoryJoined = false;

    public function __construct($langId = 0, $isNotDeleted = true, $isActive = true)
    {
        $this->langId = FatUtility::int($langId);
        $this->commonLangId = CommonHelper::getLangId();

        parent::__construct(SellerProduct::DB_TBL, 'selprod');
        if ($langId > 0) {
            $this->joinTable(SellerProduct::DB_TBL_LANG, 'LEFT OUTER JOIN', SellerProduct::DB_TBL_LANG_PREFIX . 'selprod_id = selprod_id AND ' . SellerProduct::DB_TBL_LANG_PREFIX . 'lang_id = ' . $this->langId);
        }

        if ($isActive) {
            $this->addCondition(SellerProduct::DB_TBL_PREFIX . 'active', '=', AppConstants::YES);
        }

        if ($isNotDeleted) {
            $this->addCondition(SellerProduct::DB_TBL_PREFIX . 'deleted', '=', AppConstants::NO);
        }

        $this->addOrder(SellerProduct::DB_TBL_PREFIX . 'active', 'DESC');
        $this->addCondition(SellerProduct::DB_TBL_PREFIX . 'type', '=', SellerProduct::PRODUCT_TYPE_SERVICE);
    }

    public function joinSellers()
    {
        if ($this->sellersJoined) {
            return;
        }

        $this->joinTable(User::DB_TBL, 'INNER JOIN', 'selprod_user_id = seller_user.user_id and seller_user.user_is_supplier = ' . AppConstants::YES . ' AND seller_user.user_deleted = ' . AppConstants::NO, 'seller_user');
        $this->joinTable(User::DB_TBL_CRED, 'INNER JOIN', 'credential_user_id = seller_user.user_id and credential_active = ' . AppConstants::ACTIVE . ' and credential_verified = ' . AppConstants::YES, 'seller_user_cred');
        $this->joinTable(ShopProfile::DB_TBL, 'LEFT OUTER JOIN', 'seller_profile.sprofile_user_id = seller_user.user_id ', 'seller_profile');
        //$this->joinTable(User::DB_TBL_USR_RETURN_ADDR, 'LEFT JOIN', 'seller_user.user_id = raddress.ura_user_id', 'raddress');
        $this->sellersJoined = true;
    }

    public function joinSellerSubscription($isSubscriptionActive = true)
    {
        if ($this->sellerSubscriptionJoined) {
            return;
        }

        if (FatApp::getConfig('CONF_ENABLE_SELLER_SUBSCRIPTION_MODULE', FatUtility::VAR_INT, 0)) {
            $validDateCondition = " and oss.ossubs_till_date >= '" . date('Y-m-d') . "'";
            $this->joinTable(Orders::DB_TBL, 'INNER JOIN', 'o.order_user_id = seller_user.user_id AND o.order_type=' . ORDERS::ORDER_SUBSCRIPTION . ' AND o.order_is_paid =1', 'o');
            $this->joinTable(OrderSubscription::DB_TBL, 'INNER JOIN', 'o.order_id = oss.ossubs_order_id and oss.ossubs_status_id=' . FatApp::getConfig('CONF_DEFAULT_SUBSCRIPTION_PAID_ORDER_STATUS') . $validDateCondition, 'oss');
            if ($this->langId > 0) {
                $this->joinTable(OrderSubscription::DB_TBL_LANG, 'LEFT OUTER JOIN', 'oss.ossubs_id = ossl.' . OrderSubscription::DB_TBL_LANG_PREFIX . 'ossubs_id AND ossubslang_lang_id = ' . $this->langId, 'ossl');
            }
            $this->joinTable(SellerPackagePlans::DB_TBL, 'INNER JOIN', 'oss.ossubs_plan_id = spack.spplan_id', 'spack'); /* join to get plan package */
            if ($isSubscriptionActive) {
                $this->addCondition('oss.ossubs_till_date', '>=', date("Y-m-d"));
                $this->addCondition('ossubs_status_id', 'IN ', Orders::getActiveSubscriptionStatusArr());
            }
        }
        $this->sellerSubscriptionJoined = true;
    }

    public function joinShops($langId = 0)
    {
        if ($this->shopsJoined) {
            return;
        }

        $shopCondition = ' and shop.shop_active = ' . AppConstants::ACTIVE;
        $this->joinTable(Shop::DB_TBL, 'INNER JOIN', 'seller_user.user_id = shop.shop_user_id ' . $shopCondition, 'shop');
        if ($langId > 0) {
            $this->joinTable(Shop::DB_TBL_LANG, 'LEFT OUTER JOIN', 'shoplang.shoplang_shop_id = shop.shop_id AND shoplang.shoplang_lang_id = '. $langId , 'shoplang');
        }

        $this->joinTable(Countries::DB_TBL, 'LEFT JOIN', 'shop.shop_country_id = rcountry.country_id', 'rcountry');
        $this->joinTable(Countries::DB_TBL_LANG, 'LEFT OUTER JOIN', 'rcountrylang.countrylang_country_id = rcountry.country_id AND rcountrylang.countrylang_lang_id = ' . $this->langId, 'rcountrylang');
        
        $this->joinTable(States::DB_TBL, 'INNER JOIN', 'shop.shop_state_id = shop_state.state_id ', 'shop_state');

        if ($langId) {
            $this->joinTable(States::DB_TBL_LANG, 'LEFT OUTER JOIN', 'shop_state.state_id = shop_state_l.statelang_state_id AND shop_state_l.statelang_lang_id = ' . $langId, 'shop_state_l');
        }


        $this->shopsJoined = true;
    }

    public function joinServiceCategory($isCatRequired = true, $isCatActive = true)
    {
        if ($this->serviceCategoryJoined) {
            return;
        }

        if ($isCatRequired) {
            $catJoinType = 'INNER JOIN';
        } else {
            $catJoinType = 'LEFT OUTER JOIN';
        }

        $this->joinTable(Product::DB_TBL_PRODUCT_TO_CATEGORY, $catJoinType, 'ptc.ptc_product_id = selprod.selprod_id AND ptc.ptc_type = ' . Product::PRODUCT_TO_CATEGORY_TYPE_SERVICE, 'ptc');
        $this->joinTable(ProductCategory::DB_TBL, $catJoinType, 'c.prodcat_id = ptc.ptc_prodcat_id', 'c');
        $this->joinTable(ProductCategory::DB_TBL_LANG, $catJoinType, 'c_l.prodcatlang_prodcat_id = c.prodcat_id AND prodcatlang_lang_id = ' . $this->langId, 'c_l');
        if ($isCatActive) {
            $this->addCondition('prodcat_active', '=', 1);
        }
        $this->serviceCategoryJoined = true;
    }

}
