<?php

class RfqCancellationRules extends MyAppModel
{
    public const DB_TBL = 'tbl_rfq_cancel_rules';
    public const DB_TBL_PREFIX = 'rfqcrule_';
    
    public const DB_TBL_REASON_TO_RULE = 'tbl_reason_to_rule';
    public const DB_TBL_REASON_TO_RULE_PREFIX = 'reasontorule_';
    
    public const RFQ_CANCEL_RULE_FOR_BUYER = 1;
    public const RFQ_CANCEL_RULE_FOR_SELLER = 2;


    public function __construct($id = 0)
    {
        parent::__construct(static::DB_TBL, static::DB_TBL_PREFIX . 'id', $id);
        $this->db = FatApp::getDb();
    }

    public static function getSearchObject()
    {
        $srch = new SearchBase(static::DB_TBL);
        return $srch;
    }
    
    public function validateReasons(array $reasonsArr, int $rfqCancelRuleId, int $langId = 0): array
    {
        $srch = new ReasonToRuleSearch();
        $srch->joinRulesTable();
        $srch->joinReasonsTable($langId);
        $srch->addCondition('reasontorule_reason_id', 'IN', $reasonsArr);
        $srch->addCondition('reasontorule_rule_id', '!=', $rfqCancelRuleId);
        $srch->addCondition('rfqcrule_active', '=', AppConstants::YES);
        $srch->addMultipleFields(array('rfqcrule_label', 'IFNULL(rcr_title, rcr_identifier) as rcr_title'));
        $srchRs = $srch->getResultSet();
        return FatApp::getDb()->fetchAll($srchRs);
    }
    

    public function getReasonsArr(array $ruleIdArr = [], int $langId = 0): array
    {
         $srch = new ReasonToRuleSearch();
         $srch->joinReasonsTable($langId);
         $srch->addCondition('reasontorule_rule_id','in', $ruleIdArr);
         $srch->addMultipleFields(array('IFNULL(rcr_title, rcr_identifier) as rcr_title', 'reasontorule_rule_id', 'reasontorule_reason_id'));
         $rs = $srch->getResultSet();
         return FatApp::getDb()->fetchAll($rs);
    }

    public static function getRuleDetailsByReasonId(int $reasonId): array
    {
        if (1 > $reasonId) {
            return[];
        }
        $srch = new SearchBase(static::DB_TBL_REASON_TO_RULE, 'reasontorule');
        $srch->joinTable(static::DB_TBL, 'INNER JOIN', 'reasontorule.reasontorule_rule_id = rule.rfqcrule_id', 'rule');
        $srch->addCondition('rfqcrule_active', '=', AppConstants::YES);
        $srch->addCondition('reasontorule_reason_id', '=', $reasonId);
        $rs = $srch->getResultSet();
        $row = FatApp::getDb()->fetch($rs);
        if ($row === false) {
            return [];
        }
        return $row;
    }
    
    public function getdetail()
    {
        $srch = SELF::getSearchObject();
        $srch->joinTable(RfqCancelReason::DB_TBL, 'LEFT OUTER JOIN', 'reasontorule_reason_id = rcr_id');
        $srch->addCondition('rfqcrule_id', '=', $this->mainTableRecordId);
        $rs = $srch->getResultSet();
        return FatApp::getDb()->fetchAll($rs);
    }
    
    public function deleteAttachedReasons()
    {
        if (!FatApp::getDb()->deleteRecords(SELF::DB_TBL_REASON_TO_RULE, array('smt' => 'reasontorule_rule_id = ?', 'vals' => array($this->mainTableRecordId)))) {
            $this->error = FatApp::getDb()->getError();
            return false;
        }
        return true;
    }

}
