<?php

class RequestForQuoteSearch extends SearchBase
{
    public function __construct()
    {
        parent::__construct(RequestForQuote::DB_TBL, 'rfq');
    }
    
    public function joinWithSellerProduct(int $langId = 0)
    {
        $this->joinTable(SellerProduct::DB_TBL, 'LEFT OUTER JOIN', 'selprod_id = rfq_selprod_id');
        if ($langId > 0) {
            $this->joinTable(SellerProduct::DB_TBL_LANG, 'LEFT OUTER JOIN', 'selprodlang_selprod_id = selprod_id and sp_l.selprodlang_lang_id = ' . $langId, 'sp_l');
        }
    }
    
    public function joinUsers($joinCredentials = false)
    {
        $this->joinTable(User::DB_TBL, 'LEFT OUTER JOIN', 'rfq_user_id = user.user_id', 'user');
        if ($joinCredentials == true) {
            $this->joinTable(User::DB_TBL_CRED, 'LEFT OUTER JOIN', 'user.user_id = user_cred.credential_user_id', 'user_cred');
        }
    }


    public function joinShops()
    {
        $this->joinTable(Shop::DB_TBL, 'INNER JOIN', 'seller.user_id = shop.shop_user_id', 'shop');
    }

    
    public function joinForSeller($joinCredentials = false)
    {
        $this->joinTable(User::DB_TBL, 'LEFT OUTER JOIN', 'selprod_user_id = seller.user_id', 'seller');
        if ($joinCredentials == true) {
            $this->joinTable(User::DB_TBL_CRED, 'LEFT OUTER JOIN', 'seller.user_id = seller_cred.credential_user_id', 'seller_cred');
        }
    }
    
    public function joinForShop(int $langId)
    {
        $this->joinTable(Shop::DB_TBL, 'LEFT OUTER JOIN', 'selprod_user_id = shop.shop_user_id', 'shop');
        $this->joinTable(Shop::DB_TBL_LANG, 'LEFT OUTER JOIN', 'shop.shop_id = shoplang_shop_id AND shoplang_lang_id = '.$langId);
    }
    
    public function joinWithProduct($langId = 0)
    {
        $this->joinTable(Product::DB_TBL, 'LEFT JOIN', Product::DB_TBL_PREFIX.'id = selprod_product_id','p');
        if ($langId > 0) {
            $this->joinTable(Product::DB_TBL_LANG, 'LEFT OUTER JOIN', 'p.product_id = p_l.productlang_product_id AND p_l.productlang_lang_id = ' . $langId, 'p_l');
        } 
    }
}
