<?php
class RequestForQuote extends MyAppModel
{

    public const DB_TBL = 'tbl_request_for_quotes';
    public const DB_TBL_PREFIX = 'rfq_';
    public const DB_TBL_RFQ_TO_SERVICES = 'tbl_rfq_attached_services';
    public const DB_TBL_RFQ_TO_SERVICES_PREFIX = 'rfqattser_';
    
    public const REQUEST_INPROGRESS = 0;
    public const REQUEST_QUOTED = 1;
    public const REQUEST_APPROVED = 2;
    public const REQUEST_COUNTER_BY_BUYER = 3;
    public const REQUEST_COUNTER_BY_SELLER = 4;
    public const REQUEST_CANCELLED_BY_BUYER = 5;
    public const REQUEST_DECLINED_BY_SELLER = 6;
    public const REQUEST_ACCEPTED_BY_BUYER = 7;
    public const REQUEST_RE_QUOTED = 8;
    public const REQUEST_CLOSED_BY_ADMIN = 9;
    public const REQUEST_QUOTE_VALIDITY = 10;
    
    public function __construct($rfqId = 0)
    {
        parent::__construct(static::DB_TBL, static::DB_TBL_PREFIX . 'id', $rfqId);
    }

    public static function getSearchObject()
    {
        $srch = new SearchBase(static::DB_TBL, 'rfq');
        return $srch;
    }

    public static function statusArray($langId)
    {
        return array(
            static::REQUEST_INPROGRESS => Labels::getLabel('LBL_In-Progress', $langId),
            static::REQUEST_APPROVED => Labels::getLabel('LBL_Accepted_&_Confirmed', $langId),
            static::REQUEST_QUOTED => Labels::getLabel('LBL_Quoted', $langId),
            static::REQUEST_COUNTER_BY_BUYER => Labels::getLabel('LBL_Buyer_counter_offer', $langId),
            static::REQUEST_COUNTER_BY_SELLER => Labels::getLabel('LBL_Seller_counter_offer', $langId),
            static::REQUEST_CANCELLED_BY_BUYER => Labels::getLabel('LBL_Closed_by_buyer', $langId),
            static::REQUEST_DECLINED_BY_SELLER => Labels::getLabel('LBL_Declined_by_seller', $langId),
            static::REQUEST_ACCEPTED_BY_BUYER => Labels::getLabel('LBL_Accepted_by_buyer', $langId),
            static::REQUEST_RE_QUOTED => Labels::getLabel('LBL_Re-quoted', $langId),
            static::REQUEST_CLOSED_BY_ADMIN => Labels::getLabel('LBL_Closed_by_admin', $langId),
            static::REQUEST_QUOTE_VALIDITY => Labels::getLabel('LBL_Quote_Expired', $langId),
        );
    }

    public static function canBuyerUpdateStatus(int $status): bool
    {
        $buyerStatusArr = array(
            static::REQUEST_COUNTER_BY_BUYER,
            static::REQUEST_CANCELLED_BY_BUYER,
            static::REQUEST_ACCEPTED_BY_BUYER,
            static::REQUEST_RE_QUOTED
        );

        if (in_array($status, $buyerStatusArr)) {
            return true;
        }
        return false;
    }

    public static function canSellerUpdateStatus(int $status): bool
    {
        $sellerStatusArr = array(
            static::REQUEST_APPROVED,
            static::REQUEST_COUNTER_BY_SELLER,
            static::REQUEST_DECLINED_BY_SELLER,
        );

        if (in_array($status, $sellerStatusArr)) {
            return true;
        }
        return false;
    }

    public static function canAdminUpdateStatus(int $status): bool
    {
        $sellerStatusArr = array(
            static::REQUEST_INPROGRESS,
            static::REQUEST_QUOTED,
            static::REQUEST_COUNTER_BY_BUYER,
            static::REQUEST_COUNTER_BY_SELLER,
            static::REQUEST_ACCEPTED_BY_BUYER,
            static::REQUEST_RE_QUOTED,
        );

        if (in_array($status, $sellerStatusArr)) {
            return true;
        }
        return false;
    }

    public function getRequestDetail(int $userId = 0, int $langId = 0): array
    {
        $srch = $this->getRequestDetailObject($userId, $langId);
        $srch->addCondition('rfq_id', '=', $this->mainTableRecordId);
        $srchRs = $srch->getResultSet();
        $record = FatApp::getDb()->fetch($srchRs);
        if (empty($record)) {
            return array();
        }
        return $record;
    }

    public function getRequestDetailWithParentId(int $userId = 0, int $langId = 0): array
    {
        $srch = $this->getRequestDetailObject($userId, $langId);
        $srch->addCondition('rfq_parent_id', '=', $this->mainTableRecordId);
        $srchRs = $srch->getResultSet();
        $record = FatApp::getDb()->fetch($srchRs);
        if (empty($record)) {
            return array();
        }
        return $record;
    }

    private function getRequestDetailObject(int $userId = 0, int $langId = 0)
    {
        $srch = new RequestForQuoteSearch();
        $srch->joinWithSellerProduct($langId);
        $srch->joinWithProduct();
        $srch->joinUsers();
        if (0 < $userId) {
            $cond = $srch->addCondition('selprod_user_id', '=', $userId);
            $cond->attachCondition('rfq_user_id', '=', $userId, 'OR');
        }
        return $srch;
    }

    public function updateStatus(int $status)
    {
        $dataToUpdate = array(
            'rfq_status' => $status
        );
        $db = FatApp::getDb();
//$db->startTransaction();
        $record = new RequestForQuote($this->mainTableRecordId);
        $record->assignValues($dataToUpdate);

        if (!$record->save()) {
            $this->error = $record->getError();
            return false;
        }

        return true;
    }

    public static function getSearchObjForEmail($rfqId, $langId)
    {
        $srch = new RequestForQuoteSearch();
        $srch->joinWithSellerProduct($langId);
        $srch->joinWithProduct();
        $srch->joinForShop($langId);
        $srch->joinUsers(true);
        $srch->joinForSeller(true);
        $srch->addMultipleFields(
                array('rfq.*', 'selprod_title', 'user.user_name as sender_name',
                    'product_updated_on', 'IFNULL(selprod_title, product_identifier) as selprod_title',
                    'CONCAT(seller.user_name, " - ", IFNULL(shop_name, shop_identifier)) as receiver_name', 'seller_cred.credential_email as receiver_email',
                    'seller.user_id as receiver_id', 'user.user_id as sender_id',
                    'user_cred.credential_email as sender_email'
                )
        );
        $srch->addCondition('rfq_id', '=', $rfqId);
        return $srch;
    }

    public static function getRfqStatus($rfqId)
    {
        $srch = self::getSearchObject();
        $srch->addMultipleFields(array('rfq_status'));
        $srch->addCondition('rfq_id', '=', $rfqId);
        $srchRs = $srch->getResultSet();
        $record = FatApp::getDb()->fetch($srchRs);
        if (empty($record)) {
            return array();
        }
        return $record;
    }

    public function saveServiceWithRfq(array $dataToSave): bool
    {
        if (empty($dataToSave)) {
            $this->error = Labels::getLabel("LBL_Request_submitted_successfully", CommonHelper::getLangId());
            return false;
        }
        if (!FatApp::getDb()->insertFromArray(static::DB_TBL_RFQ_TO_SERVICES, $dataToSave, false, array(), $dataToSave)) {
            $this->error = FatApp::getDb()->getError();
            return false;
        }
        return true;
    }

    public function getAttachedServices(int $langId): array
    {
        $srch = new SearchBase(static::DB_TBL_RFQ_TO_SERVICES, 'rfqattser');
        $srch->joinTable(SellerProduct::DB_TBL, 'INNER JOIN', 'selprod_id = '. static::DB_TBL_RFQ_TO_SERVICES_PREFIX .'selprod_id');
        $srch->joinTable(
                SellerProduct::DB_TBL_LANG, 'LEFT OUTER JOIN', 'sp_l.' . SellerProduct::DB_TBL_LANG_PREFIX . 'selprod_id = rfqattser.' . static::DB_TBL_RFQ_TO_SERVICES_PREFIX. 'selprod_id and
			sp_l.' . SellerProduct::DB_TBL_LANG_PREFIX . 'lang_id = ' . $langId, 'sp_l'
        );
        $srch->addMultipleFields(['rfqattser.*', 'sp_l.selprod_title as selprod_title', 'selprod_price', 'selprod_id', 'selprod_document_required']);
        $srch->addCondition('rfqattser_rfq_id', '=', $this->mainTableRecordId);
        $rs = $srch->getResultset();
        return FatApp::getDb()->fetchAll($rs);
    }



    public function addOrderForRfq()
    {
        $rfqDetails = RequestForQuote::getAttributesById($this->mainTableRecordId);
        $coObj = new CounterOffer(0, $this->mainTableRecordId);
        $offerDetails = $coObj->getFinalOfferByRfqId();
        if (empty($rfqDetails) || empty($offerDetails)) {
            $this->error = Labels::getLabel('MSG_INVALID_REQUEST', CommonHelper::getLangId());
            return false;
        }

        if (!Orders::validRfqForOrder($this->mainTableRecordId)) {
            $this->error = Labels::getLabel('MSG_INVALID_REQUEST', CommonHelper::getLangId());
            return false;
        }

        $productType = SellerProduct::getAttributesById($rfqDetails['rfq_selprod_id'], 'selprod_type');
        $productInfo = $this->getCartProductInfo($rfqDetails['rfq_selprod_id'], $productType);
        $unitPrice = $offerDetails["counter_offer_total_cost"] / $rfqDetails['rfq_quantity'];


        $shippingAddress = $billingAddress = array(
            'ua_address1' => $rfqDetails['rfq_shipping_address1'],
            'ua_address2' => $rfqDetails['rfq_shipping_address2'],
            'ua_city' => $rfqDetails['rfq_shipping_city'],
            'ua_state_id' => $rfqDetails['rfq_shipping_state_id'],
            'ua_country_id' => $rfqDetails['rfq_shipping_country_id'],
            'ua_phone' => $rfqDetails['rfq_shipping_phone'],
            'ua_zip' => $rfqDetails['rfq_shipping_zipcode'],
        );

        $extraData = array(
            'billingAddress' => $billingAddress,
            'shippingAddress' => $shippingAddress,
            'shippedBySeller' => 1, /*RFQ order is shipped by seller because shipping cose decided by seller*/
            'shippingCost' => $offerDetails['counter_offer_shipping_cost'],
            'buyerId' => $rfqDetails['rfq_user_id'],
            'productType' => $productType
        );

        $taxObj = new Tax();
        $productId = $productInfo['product_id'];
        if ($productType == SellerProduct::PRODUCT_TYPE_SERVICE) {
            $productId = $rfqDetails['rfq_selprod_id'];
        }

        $taxData = $taxObj->calculateTaxRates($productId, $unitPrice, $productInfo['selprod_user_id'], CommonHelper::getLangId(), $rfqDetails['rfq_quantity'], $extraData, false);
        $productInfo['tax'] = $taxData['tax'];

        $maxConfiguredCommissionVal = FatApp::getConfig("CONF_MAX_COMMISSION");
        $commissionPercentage = SellerProduct::getProductCommission($rfqDetails['rfq_selprod_id']);
        $commission = MIN(ROUND(($offerDetails["counter_offer_total_cost"] + $offerDetails['counter_offer_shipping_cost'] + $taxData['tax']) * $commissionPercentage / 100, 2), $maxConfiguredCommissionVal);
        $productInfo['commission_percentage'] = $commissionPercentage;
        $productInfo['commission'] = ROUND($commission, 2);

        $orderData = [];
        $orderData['order_id'] = '';
        $orderData['order_user_id'] = $rfqDetails['rfq_user_id'];
        $orderData['order_date_added'] = date('Y-m-d H:i:s');
        $orderData['order_date_updated'] = date('Y-m-d H:i:s');
        $orderData['order_is_rfq'] = AppConstants::YES;
        $orderData['order_rfq_id'] = $this->mainTableRecordId;
        $userAddresses[0] = array(
            'oua_order_id' => '',
            'oua_type' => Orders::BILLING_ADDRESS_TYPE,
            'oua_name' => $rfqDetails['rfq_name'],
            'oua_address1' => $rfqDetails['rfq_shipping_address1'],
            'oua_address2' => $rfqDetails['rfq_shipping_address2'],
            'oua_city' => $rfqDetails['rfq_shipping_city'],
            'oua_state' => $rfqDetails['rfq_shipping_state'],
            'oua_country' => $rfqDetails['rfq_shipping_country'],
            /* 'oua_country_code' => $rfqDetails['country_code'], */
            'oua_phone' => $rfqDetails['rfq_shipping_phone'],
            'oua_zip' => $rfqDetails['rfq_shipping_zipcode'],
        );
        $userAddresses[1] = $userAddresses[0];
        $userAddresses[1]['oua_type'] = Orders::SHIPPING_ADDRESS_TYPE;
        $orderData['userAddresses'] = $userAddresses;

        $orderData['extra'] = array(
            'oextra_order_id' => '',
            'order_ip_address' => $_SERVER['REMOTE_ADDR']
        );

        if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            $orderData['extra']['order_forwarded_ip'] = $_SERVER['HTTP_X_FORWARDED_FOR'];
        } elseif (!empty($_SERVER['HTTP_CLIENT_IP'])) {
            $orderData['extra']['order_forwarded_ip'] = $_SERVER['HTTP_CLIENT_IP'];
        } else {
            $orderData['extra']['order_forwarded_ip'] = '';
        }

        if (isset($_SERVER['HTTP_USER_AGENT'])) {
            $orderData['extra']['order_user_agent'] = $_SERVER['HTTP_USER_AGENT'];
        } else {
            $orderData['extra']['order_user_agent'] = '';
        }

        if (isset($_SERVER['HTTP_ACCEPT_LANGUAGE'])) {
            $orderData['extra']['order_accept_language'] = $_SERVER['HTTP_ACCEPT_LANGUAGE'];
        } else {
            $orderData['extra']['order_accept_language'] = '';
        }

        $languageRow = Language::getAttributesById(CommonHelper::getLangId());
        $orderData['order_language_id'] = $languageRow['language_id'];
        $orderData['order_language_code'] = $languageRow['language_code'];

        $currencyRow = Currency::getAttributesById($this->siteCurrencyId);
        $orderData['order_currency_id'] = $currencyRow['currency_id'];
        $orderData['order_currency_code'] = $currencyRow['currency_code'];
        $orderData['order_currency_value'] = $currencyRow['currency_value'];
        $orderData['order_default_currency_to_cop'] = 1;
        $columbianCurrValue = Currency::getCurrencyDetailWithCode(Currency::COLOMBIAN_CURRENCY_CODE);
        if (!empty($columbianCurrValue)) {
            $orderData['order_default_currency_to_cop'] = $columbianCurrValue['currency_value'];
        }

        $orderData['order_user_comments'] = '';
        $orderData['order_admin_comments'] = '';

        $orderData['order_tax_charged'] = $productInfo['tax'];
        $orderData['order_site_commission'] = $productInfo['commission'];
        $orderData['order_volume_discount_total'] = 0;

        $orderData['order_net_amount'] = $offerDetails["counter_offer_total_cost"] + $offerDetails["counter_offer_shipping_cost"] + $productInfo['tax'];
        $orderData['order_is_wallet_selected'] = 0;
        $orderData['order_wallet_amount_charge'] = 0;
        $orderData['order_type'] = Orders::ORDER_PRODUCT;

        $allLanguages = Language::getAllNames();
        $orderLangData = array();
        $productShippingData['opshipping_by_seller_user_id'] = $productInfo['selprod_user_id'];


        foreach ($allLanguages as $lang_id => $language_name) {
            $orderLangData[$lang_id] = array(
                'orderlang_lang_id' => $lang_id,
                'order_shippingapi_name' => ''
            );
            $langSpecificProductInfo = $this->getCartProductLangData($rfqDetails['rfq_selprod_id'], $lang_id, $productType);
            if (!$langSpecificProductInfo) {
                continue;
            }

            $weightUnitsArr = AppConstants::getWeightUnitsArr($lang_id);
            $lengthUnitsArr = AppConstants::getLengthUnitsArr($lang_id);
            $op_selprod_title = ($langSpecificProductInfo['selprod_title'] != '') ? $langSpecificProductInfo['selprod_title'] : '';

            $op_selprod_options = '';
            $productOptionsRows = SellerProduct::getSellerProductOptions($rfqDetails['rfq_selprod_id'], true, $lang_id);
            if (!empty($productOptionsRows)) {
                $optionCounter = 1;
                foreach ($productOptionsRows as $poLang) {
                    $op_selprod_options .= $poLang['option_name'] . ': ' . $poLang['optionvalue_name'];
                    if ($optionCounter != count($productOptionsRows)) {
                        $op_selprod_options .= ' | ';
                    }
                    $optionCounter++;
                }
            }

            $op_products_dimension_unit_name = ($productInfo['product_dimension_unit']) ? $lengthUnitsArr[$productInfo['product_dimension_unit']] : '';
            $op_product_weight_unit_name = ($productInfo['product_weight_unit']) ? $weightUnitsArr[$productInfo['product_weight_unit']] : '';
            $op_product_tax_options = array();

            if (array_key_exists('options', $taxData)) {
                foreach ($taxData['options'] as $taxStroId => $taxStroName) {
                    $label = Labels::getLabel('LBL_Tax', $lang_id);
                    if (array_key_exists('name', $taxStroName) && $taxStroName['name'] != '') {
                        $label = $taxStroName['name'];
                    }
                    $op_product_tax_options[$label]['name'] = $label;
                    $op_product_tax_options[$label]['value'] = $taxStroName['value'];
                    $op_product_tax_options[$label]['percentageValue'] = $taxStroName['percentageValue'];
                    $op_product_tax_options[$label]['inPercentage'] = $taxStroName['inPercentage'];
                }
            }

            $sduration_name = '';
            $shippingDurationTitle = '';
            $productsLangData[$lang_id] = [
                'oplang_lang_id' => $lang_id,
                'op_product_name' => $langSpecificProductInfo['product_name'],
                'op_selprod_title' => $op_selprod_title,
                'op_selprod_options' => $op_selprod_options,
                'op_brand_name' => (isset($langSpecificProductInfo['brand_name']) && !empty($langSpecificProductInfo['brand_name'])) ? $langSpecificProductInfo['brand_name'] : '',
                'op_shop_name' => $langSpecificProductInfo['shop_name'],
                'op_shipping_duration_name' => $sduration_name,
                'op_shipping_durations' => $shippingDurationTitle,
                'op_products_dimension_unit_name' => $op_products_dimension_unit_name,
                'op_product_weight_unit_name' => $op_product_weight_unit_name,
                'op_product_tax_options' => json_encode($op_product_tax_options),
            ];
        }

        $orderData['products'][CART::CART_KEY_PREFIX_PRODUCT . $productInfo['selprod_id']] = [
            'op_selprod_id' => $productInfo['selprod_id'],
            'op_is_batch' => 0,
            'op_type' => $productInfo['selprod_type'],
            'op_selprod_user_id' => $productInfo['selprod_user_id'],
            'op_selprod_code' => $productInfo['selprod_code'],
            'op_qty' => $rfqDetails['rfq_quantity'],
            'op_unit_price' => $unitPrice,
            'op_unit_cost' => ($offerDetails["counter_offer_total_cost"] + $offerDetails["counter_offer_shipping_cost"] + $productInfo['tax']) / $rfqDetails['rfq_quantity'],
            'op_selprod_sku' => $productInfo['selprod_sku'],
            'op_selprod_condition' => $productInfo['selprod_condition'],
            'op_product_model' => $productInfo['product_model'],
            'op_product_type' => $productInfo['product_type'],
            'op_product_length' => $productInfo['product_length'],
            'op_product_width' => $productInfo['product_width'],
            'op_product_height' => $productInfo['product_height'],
            'op_product_dimension_unit' => $productInfo['product_dimension_unit'],
            'op_product_weight' => $productInfo['product_weight'],
            'op_product_weight_unit' => $productInfo['product_weight_unit'],
            'op_shop_id' => $productInfo['shop_id'],
            'op_shop_owner_username' => $productInfo['shop_owner_username'],
            'op_shop_owner_name' => $productInfo['shop_onwer_name'],
            'op_shop_owner_email' => $productInfo['shop_owner_email'],
            'op_shop_owner_phone' => isset($productInfo['shop_owner_phone']) && !empty($productInfo['shop_owner_phone']) ? $productInfo['shop_owner_phone'] : '',
            'op_selprod_max_download_times' => ($productInfo['selprod_max_download_times'] != '-1') ? $rfqDetails['rfq_quantity'] * $productInfo['selprod_max_download_times'] : $productInfo['selprod_max_download_times'],
            'op_selprod_download_validity_in_days' => $productInfo['selprod_download_validity_in_days'],
            'op_sduration_id' => 0,
            'op_commission_charged' => $productInfo['commission'],
            'op_commission_percentage' => $productInfo['commission_percentage'],
            'op_affiliate_commission_percentage' => 0,
            'op_affiliate_commission_charged' => 0,
            'op_status_id' => FatApp::getConfig("CONF_DEFAULT_ORDER_STATUS"),
            'productsLangData' => $productsLangData,
            'productShippingData' => $productShippingData,
            'productShippingLangData' => [],
            'op_free_ship_upto' => 0,
            'op_actual_shipping_charges' => $offerDetails['counter_offer_shipping_cost'],
            'op_tax_collected_by_seller' => FatApp::getConfig("CONF_TAX_COLLECTED_BY_SELLER"),
            'productSpecifics' => [
                'op_selprod_return_age' => $productInfo['return_age'],
                'op_selprod_cancellation_age' => $productInfo['cancellation_age'],
                'op_product_warranty' => $productInfo['product_warranty']
            ]
        ];

        $shippingCost = $offerDetails["counter_offer_shipping_cost"];
        $orderData['prodCharges'][CART::CART_KEY_PREFIX_PRODUCT . $productInfo['selprod_id']] = [
            OrderProduct::CHARGE_TYPE_SHIPPING => ['amount' => $shippingCost],
            OrderProduct::CHARGE_TYPE_TAX => ['amount' => $taxData['tax']],
            OrderProduct::CHARGE_TYPE_DISCOUNT => ['amount' => 0],
            OrderProduct::CHARGE_TYPE_REWARD_POINT_DISCOUNT => ['amount' => 0],
            OrderProduct::CHARGE_TYPE_VOLUME_DISCOUNT => ['amount' => 0],
        ];

        $orderData['orderLangData'] = $orderLangData;
        $orderObj = new Orders();
        if (!$orderObj->addUpdateOrder($orderData, CommonHelper::getLangId())) {
            $this->error = $orderObj->getError();
            return false;
        }

        return true;
    }


    public function getCartProductInfo(int $selprod_id, $type = SellerProduct::PRODUCT_TYPE_PRODUCT)
    {
        $prodSrch = new ProductSearch(CommonHelper::getLangId());
        $joinBrands = false;
        if ($type == SellerProduct::PRODUCT_TYPE_PRODUCT) {
            $joinBrands = true;
        }
        $prodSrch->setDefinedCriteria(0, 0, array(), true, false, $joinBrands);
        $prodSrch->joinShopSpecifics();
        $prodSrch->joinSellerProductSpecifics();
        $prodSrch->joinProductSpecifics();
        $prodSrch->joinSellerSubscription();
        $prodSrch->addSubscriptionValidCondition();
        $prodSrch->joinProductToCategory();
        $prodSrch->doNotCalculateRecords();
        $prodSrch->doNotLimitRecords();
        $prodSrch->addCondition('selprod_deleted', '=', AppConstants::NO);
        $prodSrch->addCondition('selprod_id', '=', $selprod_id);
        $fields = array(
            'product_id', 'product_type', 'product_length', 'product_width', 'product_height',
            'product_dimension_unit', 'product_weight', 'product_weight_unit', 'product_model',
            'selprod_id', 'selprod_user_id', 'selprod_stock', 'IF(selprod_stock > 0, 1, 0) AS in_stock', 'selprod_sku',
            'selprod_condition', 'selprod_code', 'selprod_type',
            'special_price_found', 'theprice', 'shop_id', 'IFNULL(product_name, product_identifier) as product_name', 'IFNULL(selprod_title  ,IFNULL(product_name, product_identifier)) as selprod_title', 'shop_name',
            'seller_user.user_name as shop_onwer_name', 'seller_user_cred.credential_username as shop_owner_username',
            'seller_user.user_phone as shop_owner_phone', 'seller_user_cred.credential_email as shop_owner_email', 'selprod_download_validity_in_days', 'selprod_max_download_times', 'ps.product_warranty', 'COALESCE(sps.selprod_return_age, ss.shop_return_age) as return_age', 'COALESCE(sps.selprod_cancellation_age, ss.shop_cancellation_age) as cancellation_age'
        );
        $prodSrch->addMultipleFields($fields);
        $rs = $prodSrch->getResultSet();
        return FatApp::getDb()->fetch($rs);
    }


    public function getCartProductLangData($selprod_id, $lang_id, $type = SellerProduct::PRODUCT_TYPE_PRODUCT)
    {
        $langProdSrch = new ProductSearch($lang_id);
        $joinBrands = false;
        if ($type == SellerProduct::PRODUCT_TYPE_PRODUCT) {
            $joinBrands = true;
        }

        $langProdSrch->setDefinedCriteria(0, 0, array(), true, false, $joinBrands);
        $langProdSrch->joinProductToCategory();
        $langProdSrch->joinSellerSubscription();
        $langProdSrch->addSubscriptionValidCondition();
        $langProdSrch->doNotCalculateRecords();
        $langProdSrch->doNotLimitRecords();
        $langProdSrch->addCondition('selprod_deleted', '=', AppConstants::NO);
        $langProdSrch->addCondition('selprod_id', '=', $selprod_id);
        $fields = array('IFNULL(product_name, product_identifier) as product_name', 'IFNULL(selprod_title  ,IFNULL(product_name, product_identifier)) as selprod_title', 'IFNULL(shop_name, shop_identifier) as shop_name');
        $langProdSrch->addMultipleFields($fields);
        if ($type == SellerProduct::PRODUCT_TYPE_PRODUCT) {
            $langProdSrch->addFld(['IFNULL(brand_name, brand_identifier) as brand_name']);
        }

        $langProdRs = $langProdSrch->getResultSet();
        return FatApp::getDb()->fetch($langProdRs);
    }
	
	public static function getSellerStates(int $sellerUserId) 
	{
		$responseTime = self::getSellerResponseTime($sellerUserId, true);	
		$deliveryRate = self::getSellerOnTimeDeliveryRate($sellerUserId);	
		return ['responseTime'=>$responseTime, 'deliveryRate'=>$deliveryRate];
	}
	
	public static function getSellerResponseTime(int $sellerUserId, $applyUnit=false)
	{
		$srch = new RequestForQuoteSearch();
		$srch->joinTable(CounterOffer::DB_TBL, 'INNER JOIN', 'rfq_id = co.counter_offer_rfq_id', 'co');
		$srch->addFld('time_to_sec(timediff(counter_offer_added_on, rfq_added_on )) / 3600 as duration');
		$srch->addCondition('counter_offer_by', '=', $sellerUserId);		
		$srch->addGroupBy('counter_offer_rfq_id');		
		$srch->doNotCalculateRecords();
		$srch->doNotLimitRecords();		
		$records = FatApp::getDb()->fetchAll($srch->getResultSet());
		$sum = 0;	
		$resTime = 0;
		$sum = array_sum(array_column($records,'duration'));
		if($sum>0){
			$resTime = round($sum/count($records));
		}
		if($resTime>12) {
			$resTime = round($resTime/24);
			if($applyUnit==true){ 
				$resTime = $resTime.' '.Labels::getLabel('LBL_days', CommonHelper::getLangId());
			}
		}else {
			if($applyUnit==true){
				if(0>=$resTime) { $resTime = 24; }
				$resTime = $resTime.' '.Labels::getLabel('LBL_hrs', CommonHelper::getLangId());
			}
		}		
		return $resTime; 
	}
	
	public static function getSellerOnTimeDeliveryRate(int $sellerUserId)
	{
		$srch = new OrderProductSearch(0, true);
		$allowedStatusArr = array_merge(unserialize(FatApp::getConfig("CONF_COMPLETED_ORDER_STATUS")), (array) FatApp::getConfig("CONF_DEFAULT_DEIVERED_ORDER_STATUS"));		
		$srch->addStatusCondition($allowedStatusArr);
		$srch->joinTable(RequestForQuote::DB_TBL, 'LEFT JOIN', 'order_rfq_id = rfq.rfq_id', 'rfq');
		$srch->joinTable(Orders::DB_TBL_ORDER_STATUS_HISTORY, 'LEFT JOIN', 'op_id = osh.oshistory_op_id', 'osh');
		$srch->addCondition('oshistory_orderstatus_id', '=', FatApp::getConfig("CONF_DEFAULT_DEIVERED_ORDER_STATUS"));
		$srch->addCondition('order_is_rfq', '=', AppConstants::YES);
		$srch->addCondition('op_selprod_user_id', '=', $sellerUserId);
		$srch->addFld('datediff(rfq_delivery_time,oshistory_date_added) AS deliveryAge');
		$srch->doNotCalculateRecords();
		$srch->doNotLimitRecords();
		$records = FatApp::getDb()->fetchAll($srch->getResultSet());
		$late = 0;
		$ontime = 0;
		$percntage = 100;
		foreach($records as $record){
			if($record['deliveryAge']<0) {
				$late = 	$late+1;
			}else{
				$ontime = $ontime+1;
			}
		}
		if($late > 0 && $ontime > 0 && $ontime != $late) {
			$percntage = (($ontime/count($records))*100);
			$percntage = round($percntage);
		}
		return $percntage;
  	}

	
}
