<?php

class ReasonToRuleSearch extends SearchBase
{
    public function __construct()
    {
        parent::__construct(RfqCancellationRules::DB_TBL_REASON_TO_RULE);
    }
    
    public function joinRulesTable()
    {
        $this->joinTable(RfqCancellationRules::DB_TBL, 'LEFT OUTER JOIN', 'reasontorule_rule_id = rfqcrule_id');
    }
    
    public function joinReasonsTable(int $langId = 0)
    {
        $this->joinTable(RfqCancelReason::DB_TBL, 'LEFT OUTER JOIN', 'reasontorule_reason_id = rcr_id');
        if ($langId > 0) {
            $this->joinTable(RfqCancelReason::DB_TBL_LANG, 'LEFT OUTER JOIN', 'rcr_id = rcrlang_rcr_id AND rcrlang_lang_id = '.$langId);
        }
    }
}