<?php

class BannerLocation extends MyAppModel
{
    public const DB_TBL = 'tbl_banner_locations';
    public const DB_TBL_PREFIX = 'blocation_';

    public const DB_TBL_LANG = 'tbl_banner_locations_lang';

    public const DB_DIMENSIONS_TBL = 'tbl_banner_location_dimensions';
    public const DB_DIMENSIONS_TBL_PREFIX = 'bldimensions_';

    public const HOME_PAGE_TOP_BANNER = 1;
    public const HOME_PAGE_BOTTOM_BANNER = 2;
    public const PRODUCT_DETAIL_PAGE_BANNER = 3;
    public const HOME_PAGE_MIDDLE_BANNER = 4;

    public const MOBILE_API_BANNER_PAGESIZE = 1;

    public function __construct($id = 0)
    {
        parent::__construct(static::DB_TBL, static::DB_TBL_PREFIX . 'id', $id);
    }

    public static function getSearchObject($langId = 0, $isActive = true, $deviceType = 0)
    {
        $srch = new SearchBase(static::DB_TBL, 'bl');
        if ($langId > 0) {
            $srch->joinTable(
                static::DB_TBL_LANG,
                'LEFT OUTER JOIN',
                'blocationlang_blocation_id = blocation_id
			AND blocationlang_lang_id = ' . $langId,
                'bl_l'
            );
        }
        if ($isActive) {
            $srch->addCondition('blocation_active', '=', AppConstants::ACTIVE);
        }
        $deviceType = FatUtility::int($deviceType);
        if (1 > $deviceType) {
            $deviceType = AppConstants::SCREEN_DESKTOP;
        }
        $srch->joinTable(BannerLocation::DB_DIMENSIONS_TBL, 'LEFT OUTER JOIN', 'bldim.bldimension_blocation_id = bl.blocation_id AND bldim.bldimension_device_type = ' . $deviceType, 'bldim');
        return $srch;
    }

    public static function getDimensions($bannerLocationId, $deviceType)
    {
        $srch = new BannerSearch(0, false);
        $srch->joinLocations();
        $srch->joinLocationDimension($deviceType);
        $srch->addMultipleFields(array('blocation_banner_width', 'blocation_banner_height'));
        $srch->addCondition('bldimension_blocation_id', '=', $bannerLocationId);
        $srch->addCondition('bldimension_device_type', '=', $deviceType);
        $srch->setPageSize(1);
        $srch->doNotCalculateRecords();
        return FatApp::getDb()->fetch($srch->getResultSet());
    }

    public static function getPromotionalBanners($blocationIds, $langId, $pageSize = 0)
    {
        $blocationIds = FatUtility::int($blocationIds);
        $db = FatApp::getDb();
        $bannerSrch = Banner::getBannerLocationSrchObj(true);
        if (is_array($blocationIds) && !empty($blocationIds)) {
            $bannerSrch->addCondition('blocation_id', 'IN', $blocationIds);
        } else {
            $bannerSrch->addCondition('blocation_id', '=', $blocationIds);
        }
        $bannerSrch->doNotCalculateRecords();
        $rs = $bannerSrch->getResultSet();
        $bannerLocation = $db->fetchAll($rs, 'blocation_key');
        $banners = $bannerLocation;
        $locationIds  = array_column($bannerLocation, 'blocation_id');
        if (empty($locationIds)) {
            return [];
        }
        $bsrch = new BannerSearch($langId, true);
        $bsrch->joinPromotions($langId, true, true, true);
        $bsrch->addPromotionTypeCondition();
        $bsrch->joinActiveUser();
        $bsrch->joinUserWallet();
        $bsrch->addSkipExpiredPromotionAndBannerCondition();
        $bsrch->joinBudget();
        $bsrch->addMultipleFields(array('banner_id', 'banner_blocation_id', 'banner_type', 'banner_record_id', 'banner_url', 'banner_target', 'banner_title', 'promotion_id', 'daily_cost', 'weekly_cost', 'monthly_cost', 'total_cost', 'banner_img_updated_on'));
        $bsrch->doNotCalculateRecords();
        $bsrch->joinAttachedFile();
        $bsrch->addDirectCondition('banner_blocation_id IN (' . implode(',', $locationIds) . ')');
        $srch = new SearchBase('(' . $bsrch->getQuery() . ') as t');
        $srch->doNotCalculateRecords();
        $srch->addDirectCondition(
            '((CASE
                WHEN promotion_duration=' . Promotion::DAILY . ' THEN promotion_budget > COALESCE(daily_cost,0)
                WHEN promotion_duration=' . Promotion::WEEKLY . ' THEN promotion_budget > COALESCE(weekly_cost,0)
                WHEN promotion_duration=' . Promotion::MONTHLY . ' THEN promotion_budget > COALESCE(monthly_cost,0)
                WHEN promotion_duration=' . Promotion::DURATION_NOT_AVAILABALE . ' THEN promotion_budget = -1
                END ) )'
        );
        $srch->addMultipleFields(array('banner_id', 'banner_blocation_id', 'banner_type', 'banner_record_id', 'banner_url', 'banner_target', 'banner_title', 'promotion_id', 'userBalance', 'daily_cost', 'weekly_cost', 'monthly_cost', 'total_cost', 'promotion_budget', 'promotion_duration', 'banner_img_updated_on'));
        $srch->addOrder('', 'rand()');
        $bannerListing = $db->fetchAll($srch->getResultSet(), 'banner_id');
        foreach ($bannerListing as $banner) {
            foreach ($bannerLocation as $key => $location) {
                if ($location['blocation_id'] == $banner['banner_blocation_id']) {
                    $banners[$key]['banners'][] = $banner;
                }
            }
        }
        return $banners;
    }
}
