<?php

class TagsController extends SellerBaseController
{

    public function __construct($action)
    {
        parent::__construct($action);
    }

    public function index()
    {
        if (!Shop::isShopActive($this->userParentId, 0, true)) {
            FatApp::redirectUser(CommonHelper::generateUrl('Seller', 'shop'));
        }
        if (!UserPrivilege::isUserHasValidSubsription($this->userParentId)) {
            Message::addInfo(Labels::getLabel("MSG_Please_buy_subscription", $this->siteLangId));
            FatApp::redirectUser(CommonHelper::generateUrl('Seller', 'Packages'));
        }
        $searchForm = $this->searchForm();
        $this->set('searchForm', $searchForm);
        $this->_template->render(true, true);
    }

    public function search()
    {
        $userId = $this->userParentId;
        $searchForm = $this->searchForm();
        $post = $searchForm->getFormDataFromArray(FatApp::getPostedData());
        $page = FatApp::getPostedData('page', FatUtility::VAR_INT, 1);
        $pagesize = FatApp::getConfig('CONF_PAGE_SIZE', FatUtility::VAR_INT, 10);

        $srch = Tag::getSearchObject($this->siteLangId);


        $srch->addDirectCondition('tag_user_id = ' . $userId . ' OR (tag_admin_id != 0 AND tag_active = ' . AppConstants::YES . ')');

        $srch->addCondition('tag_deleted', '=', 0);

        $keyword = FatApp::getPostedData('keyword', FatUtility::VAR_STRING, '');
        if ($keyword != '') {
            $srch->addCondition('tag_name', 'like', '%' . $keyword . '%');
        }

        $tagType = FatApp::getPostedData('tag_type', FatUtility::VAR_STRING, '');
        $typeArr = Tag::getTypeArr();
        if ($tagType != '' && array_key_exists($tagType, $typeArr)) {
            $srch->addCondition('tag_type', '=', $tagType);
        }

        $srch->addCondition('tag_type', '>', 0);

        $srch->setPageNumber($page);
        $srch->setPageSize($pagesize);
        $srchRs = $srch->getResultSet();
        $records = FatApp::getDb()->fetchAll($srchRs);

        $this->set('arr_listing', $records);
        $this->set('siteLangId', $this->siteLangId);
        $this->set('pageCount', $srch->pages());
        $this->set('page', $page);
        $this->set('pageSize', $pagesize);
        $this->set('postedData', $post);
        $this->set('typeArr', $typeArr);

        $this->_template->render(false, false);
    }

    public function form(int $id = 0)
    {
        $userId = $this->userParentId;
        $tagData = array();
        if (0 < $id) {
            $tagData = Tag::getAttributesById($id);

            if (empty($tagData) || $tagData['tag_user_id'] != $userId) {
                FatUtility::exitWithErrorCode(404);
            }

            $tagLangData = Tag::getLangDataArr($id);

            if (!empty($tagLangData)) {
                foreach ($tagLangData as $langData) {
                    $tagData['tag_name'][$langData['taglang_lang_id']] = $langData['tag_name'];
                }
            }
        }

        $form = $this->getForm();
        $form->fill($tagData);

        $this->set('form', $form);
        $siteDefaultLangId = FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1);
        $this->set('siteDefaultLangId', $siteDefaultLangId);
        $languages = Language::getAllNames();
        unset($languages[$siteDefaultLangId]);
        $this->set('siteDefaultLangId', $siteDefaultLangId);
        $this->set('otherLanguages', $languages);
        $this->set('tagId', $id);
        $this->_template->render(true, true);
    }

    private function getForm()
    {
        $frm = new Form('tagForm', array('id' => 'tagForm'));

        $tagTypes = Tag::getTypeArr($this->siteLangId);
        $frm->addSelectBox(Labels::getLabel('LBL_Type', $this->siteLangId), 'tag_type', $tagTypes, '', array(), Labels::getLabel('LBL_Select', $this->siteLangId))->requirements()->setRequired(true);

        $siteDefaultLangId = FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1);

        $languages = Language::getAllNames();
        foreach ($languages as $langId => $lang) {
            if ($langId == $siteDefaultLangId) {
                $frm->addRequiredField(Labels::getLabel('LBL_Name', $this->siteLangId), 'tag_name[' . $langId . ']');
            } else {
                $frm->addTextBox(Labels::getLabel('LBL_Name', $this->siteLangId), 'tag_name[' . $langId . ']');
            }
        }

        $translatorSubscriptionKey = FatApp::getConfig('CONF_TRANSLATOR_SUBSCRIPTION_KEY', FatUtility::VAR_STRING, '');
        unset($languages[$siteDefaultLangId]);
        if (!empty($translatorSubscriptionKey) && count($languages) > 0) {
            $frm->addCheckBox(Labels::getLabel('LBL_Translate_To_Other_Languages', $this->siteLangId), 'auto_update_other_langs_data', 1, array(), false, 0);
        }

        $frm->addHiddenField('', 'tag_id');
        $frm->addSubmitButton('', 'btn_submit', Labels::getLabel('LBL_Save', $this->siteLangId));
        return $frm;
    }

    public function setup()
    {
        $frm = $this->getForm();
        $post = $frm->getFormDataFromArray(FatApp::getPostedData());
        if (false === $post) {
            Message::addErrorMessage($this->str_invalid_request);
            FatUtility::dieJsonError(Message::getHtml());
        }

        $siteDefaultLangId = FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1);

        $tagId = FatUtility::int($post['tag_id']);

        $data = array(
            'tag_identifier' => $post['tag_name'][$siteDefaultLangId],
            'tag_user_id' => $this->userParentId,
            'tag_type' => $post['tag_type'],
            'tag_active' => 1
        );

        $tagObj = new Tag($tagId);
        $tagObj->assignValues($data);

        if (!$tagObj->save()) {
			if(strpos(strtolower($tagObj->getError()), "for key 'tag_identifier'") > 0)
			{
				$message = "LBL_Tag_Already_Exists";
			}else{
				$message = $tagObj->getError();
			}
			
            Message::addErrorMessage(Labels::getLabel($message, $this->siteLangId));
            FatUtility::dieJsonError(Message::getHtml());
        }

        $tagId = $tagObj->getMainTableRecordId();

        $this->setupLangData($tagId, $post);

        $this->set('tag_id', $tagId);
        $this->set('msg', Labels::getLabel('LBL_Updated_Successfully', $this->siteLangId));
        $this->_template->render(false, false, 'json-success.php');
    }

    public function changeStatus()
    {
        $post = FatApp::getPostedData();
        $tagId = FatApp::getPostedData('tagId', FatUtility::VAR_INT, 0);
        if (empty($post) || 1 > $tagId || 0 > FatUtility::int($post['status'])) {
            Message::addErrorMessage(Labels::getLabel('MSG_Invalid_Request', $this->siteLangId));
            FatUtility::dieJsonError(Message::getHtml());
        }

        $tagData = Tag::getAttributesById($tagId, ['tag_user_id']);

        if (empty($tagData['tag_user_id']) || $tagData['tag_user_id'] != $this->userParentId) {
            Message::addErrorMessage(Labels::getLabel('MSG_Unauthorized_access', $this->siteLangId));
            FatUtility::dieJsonError(Message::getHtml());
        }

        $tagObj = new Tag($tagId);
        $response = $tagObj->changeStatus($post['status']);
        if (!$response) {
            Message::addErrorMessage($tagObj->getError());
            FatUtility::dieJsonError(Message::getHtml());
        }

        $msg = Labels::getLabel('MSG_Status_Updated_Successfully', $this->siteLangId);
        FatUtility::dieJsonSuccess($msg);
    }

    public function deleteItem()
    {
        $post = FatApp::getPostedData();
        $tagId = FatApp::getPostedData('tagId', FatUtility::VAR_INT, 0);
        if (empty($post) || 1 > $tagId) {
            Message::addErrorMessage(Labels::getLabel('MSG_Invalid_Request', $this->siteLangId));
            FatUtility::dieJsonError(Message::getHtml());
        }

        $tagData = Tag::getAttributesById($tagId, ['tag_user_id']);

        if (empty($tagData['tag_user_id']) || $tagData['tag_user_id'] != $this->userParentId) {
            Message::addErrorMessage(Labels::getLabel('MSG_Unauthorized_access', $this->siteLangId));
            FatUtility::dieJsonError(Message::getHtml());
        }

        $tagObj = new Tag($tagId);
        $response = $tagObj->deleteRecord(true);
        if (!$response) {
            Message::addErrorMessage($tagObj->getError());
            FatUtility::dieJsonError(Message::getHtml());
        }

        $rows = Product::getProductIdsByTagId($tagId);
        if (!empty($rows)) {
            FatApp::getDb()->deleteRecords(Product::DB_PRODUCT_TO_TAG, array( 'smt' => 'ptt_tag_id = ?', 'vals' => array( $tagId ) ));
            foreach ($rows as $row) {
                Tag::updateProductTagString($row['ptt_product_id']);
            }
        }
        
        $msg = Labels::getLabel('MSG_Record_Deleted_Successfully', $this->siteLangId);
        FatUtility::dieJsonSuccess($msg);
    }

    private function setupLangData(int $tagId, array $data)
    {
        $tagNames = (isset($data['tag_name'])) ? $data['tag_name'] : [];
        $autoUpdateOtherLangsData = isset($data['auto_update_other_langs_data']) ? FatUtility::int($data['auto_update_other_langs_data']) : 0;
        if (!empty($tagNames)) {

            $tagObj = new Tag($tagId);
            foreach ($tagNames as $langId => $tagName) {
                if (empty($tagName) && $autoUpdateOtherLangsData > 0) {
                    $tagObj->saveTranslatedProductLangData($langId);
                } else {
                    $tagData = array(
                        'taglang_tag_id' => $tagId,
                        'taglang_lang_id' => $langId,
                        'tag_name' => $tagName
                    );

                    if (!$tagObj->updateLangData($langId, $tagData)) {
                        Message::addErrorMessage(Labels::getLabel($tagObj->getError(), $this->siteLangId));
                        FatUtility::dieJsonError(Message::getHtml());
                    }
                }
            }
        }
    }

    private function searchForm()
    {
        $frm = new Form('frmSearchTags');
        $frm->addTextBox(Labels::getLabel('LBL_Search_By', $this->siteLangId), 'keyword');

        $tagTypes = Tag::getTypeArr($this->siteLangId);
        $frm->addSelectBox(Labels::getLabel('LBL_Type', $this->siteLangId), 'tag_type', $tagTypes);

        $frm->addSubmitButton('', 'btn_submit', Labels::getLabel('LBL_Submit', $this->siteLangId));
        $frm->addButton('', 'btn_clear', Labels::getLabel('LBL_Clear', $this->siteLangId));

        return $frm;
    }
}
