<?php

class ServicesController extends SellerBaseController
{

    public function __construct($action)
    {
        parent::__construct($action);
    }

    public function index()
    {
        if (!self::isShopActive($this->userParentId, 0, true)) {
            FatApp::redirectUser(CommonHelper::generateUrl('Seller', 'shop'));
        }
        if (!UserPrivilege::isUserHasValidSubsription($this->userParentId)) {
            Message::addInfo(Labels::getLabel("MSG_Please_buy_subscription", $this->siteLangId));
            FatApp::redirectUser(CommonHelper::generateUrl('Seller', 'Packages'));
        }
        $searchForm = $this->searchForm();
        $this->set('searchForm', $searchForm);
        $this->_template->render(true, true);
    }

    public static function isShopActive($userId, $shopId = 0, $returnResult = false)
    {
        return Shop::isShopActive($userId, $shopId, $returnResult);
    }

    public function search()
    {
        $userId = $this->userParentId;
        $searchForm = $this->searchForm();
        $post = $searchForm->getFormDataFromArray(FatApp::getPostedData());
        $page = FatApp::getPostedData('page', FatUtility::VAR_INT, 1);
        $pagesize = FatApp::getConfig('CONF_PAGE_SIZE', FatUtility::VAR_INT, 10);

        $srch = SellerProduct::getSearchObject($this->siteLangId);
        $srch->addCondition('selprod_user_id', '=', $userId);
        $srch->addCondition('selprod_deleted', '=', 0);
        $srch->addCondition('selprod_type', '=', SellerProduct::PRODUCT_TYPE_SERVICE);

        $keyword = FatApp::getPostedData('keyword', FatUtility::VAR_STRING, '');
        if ($keyword != '') {
            $srch->addCondition('selprod_title', 'like', '%' . $keyword . '%');
        }

        $serviceStatus = FatApp::getPostedData('service_active');

        if ($serviceStatus != '') {
            $srch->addCondition('selprod_active', '=', $serviceStatus);
        }

        $srch->setPageNumber($page);
        $srch->setPageSize($pagesize);
        $srchRs = $srch->getResultSet();
        $records = FatApp::getDb()->fetchAll($srchRs);

        $this->set('arr_listing', $records);
        $this->set('siteLangId', $this->siteLangId);
        $this->set('pageCount', $srch->pages());
        $this->set('page', $page);
        $this->set('pageSize', $pagesize);
        $this->set('postedData', $post);
        $this->_template->render(false, false);
    }

    public function form(int $id = 0)
    {
        $service = new Service($this->userParentId, $id);

        if (0 == $id && !$service->validateSubscriptionInventoryCount($this->siteLangId)) {
            Message::addErrorMessage($service->getError());
            FatApp::redirectUser(CommonHelper::generateUrl('Seller', 'Packages'));
        }

        $userId = $this->userParentId;
        $serviceData = array();
        if (0 < $id) {
            $serviceData = SellerProduct::getAttributesById($id, ['selprod_id as service_id', 'selprod_price as service_price', 'selprod_user_id as service_user_id', 'selprod_is_shipping_required as is_shipping_required', 'selprod_document_required as is_document_required']);
            $serviceLangData = SellerProduct::getLangDataArr($id);

            if (empty($serviceData) || $serviceData['service_user_id'] != $userId) {
                FatUtility::exitWithErrorCode(404);
            }

            unset($serviceData['service_user_id']);
            if (!empty($serviceLangData)) {
                foreach ($serviceLangData as $langData) {
                    $serviceData['service_title'][$langData['selprodlang_lang_id']] = $langData['selprod_title'];
                    $serviceData['service_description_' . $langData['selprodlang_lang_id']] = $langData['selprod_features'];
                }
            }

            $prod = new Product();
            $productCategories = $prod->getProductCategories($id, Product::PRODUCT_TO_CATEGORY_TYPE_SERVICE);
            if (!empty($productCategories)) {
                $selectedCat = array_keys($productCategories);
                $prodCat = new ProductCategory();
                $selectedCatName = $prodCat->getParentTreeStructure($selectedCat[0], 0, '', $this->siteLangId);
                $serviceData['category_name'] = html_entity_decode($selectedCatName);
                $serviceData['ptc_prodcat_id'] = $selectedCat[0];
            }

            /* [ TAX CATEGORY */
            $tax = Tax::getTaxCatObjByProductId($id, $this->siteLangId, SellerProduct::PRODUCT_TYPE_SERVICE);
            $tax->addCondition('ptt_seller_user_id', '=', $userId);
            $tax->addMultipleFields(array('ptt_taxcat_id'));
            $tax->doNotCalculateRecords();
            $tax->setPageSize(1);
            $tax->addOrder('ptt_seller_user_id', 'ASC');
            $rs = $tax->getResultSet();
            $taxData = FatApp::getDb()->fetch($rs);
            if (!empty($taxData)) {
                $serviceData['ptt_taxcat_id'] = $taxData['ptt_taxcat_id'];
            }
            /* ] */
        }
        $form = $this->getForm();
        $form->fill($serviceData);

        $this->set('form', $form);
        $this->set('includeEditor', true);
        $siteDefaultLangId = FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1);
        $this->set('siteDefaultLangId', $siteDefaultLangId);
        $languages = Language::getAllNames();
        unset($languages[$siteDefaultLangId]);
        $this->set('siteDefaultLangId', $siteDefaultLangId);
        $this->set('otherLanguages', $languages);
        $this->set('serviceId', $id);
        $this->set('isShippingRequired', (!empty($serviceData)) ? $serviceData['is_shipping_required'] : 0);
        $this->_template->render(true, true);
    }

    public function shippingForm(int $serviceId)
    {
        $userId = $this->userParentId;
        $serviceData = SellerProduct::getAttributesById($serviceId, ['selprod_user_id']);
        if (empty($serviceData) || $serviceData['selprod_user_id'] != $userId) {
            Message::addErrorMessage(
                    Labels::getLabel('MSG_INVALID_REQUEST', $this->siteLangId)
            );
            FatUtility::dieWithError(Message::getHtml());
        }
        $shipping_rates = array();
        $post = FatApp::getPostedData();

        //$shipping_rates = Products::getProductShippingRates();
        $this->set('siteLangId', $this->siteLangId);
        $shipping_rates = array();

        $shipping_rates = Product::getProductShippingRates($serviceId, $this->siteLangId, 0, $userId, 0, 0, 0, SellerProduct::PRODUCT_TYPE_SERVICE);
        $shippingDetails = Product::getProductShippingDetails($serviceId, $this->siteLangId, $userId, SellerProduct::PRODUCT_TYPE_SERVICE);
        if (isset($shippingDetails['ps_from_country_id']) && $shippingDetails['ps_from_country_id']) {
            $shippingDetails['shipping_country'] = Countries::getCountryById($shippingDetails['ps_from_country_id'], $this->siteLangId, 'country_name');
        }
        $shippingDetails['ps_product_id'] = $serviceId;
        $shippingFrm = $this->getShippingForm();
        $shippingFrm->fill($shippingDetails);
        $this->set('shippingFrm', $shippingFrm);

        $this->set('productDetails', $serviceData);
        $this->set('service_id', $serviceId);
        $this->set('shipping_rates', $shipping_rates);
        $this->_template->render(false, false);
    }

    public function getShippingForm()
    {
        $frm = new Form('frmCustomProduct');
        $fld = $frm->addTextBox(Labels::getLabel('LBL_Shipping_country', $this->siteLangId), 'shipping_country');

        /*$fld = $frm->addCheckBox(Labels::getLabel('LBL_Free_Shipping', $this->siteLangId), 'ps_free', 1); */
        $frm->addHtml('', '', '<div id="tab_shipping"></div>');

        $frm->addHiddenField('', 'ps_from_country_id');
        $frm->addHiddenField('', 'ps_type', SellerProduct::PRODUCT_TYPE_SERVICE);
        $frm->addHiddenField('', 'ps_product_id');
        $frm->addHtml('', '', '<div id="tab_shipping"></div>');
        $frm->addSubmitButton('', 'btn_submit', Labels::getLabel('LBL_Save_Changes', $this->siteLangId));
        $frm->addButton('', 'btn_cancel', Labels::getLabel('LBL_Cancel', $this->siteLangId));
        return $frm;
    }

    private function getForm(int $prodCatId = 0)
    {
        $frm = new Form('serviceForm', array('id' => 'serviceForm'));

        $priceFld = $frm->addFloatField(Labels::getLabel('LBL_price', $this->siteLangId) . ' [' . CommonHelper::getSystemDefaultCurrenyCode() . ']', 'service_price');
        $priceFld->requirements()->setRequired(true);
        $priceFld->requirements()->setFloatPositive();
        $priceFld->requirements()->setRange('0', '9999999999');
        $prodCatName = '';
        if ($prodCatId > 0) {
            $prodCat = new ProductCategory();
            $selectedCatName = $prodCat->getParentTreeStructure($prodCatId, 0, '', $this->siteLangId);
            $prodCatName = html_entity_decode($selectedCatName);
        }
        $frm->addRequiredField(Labels::getLabel('LBL_Service_Category', $this->siteLangId), 'category_name', $prodCatName);
        $taxCategories = Tax::getSaleTaxCatArr($this->siteLangId);
        $frm->addSelectBox(Labels::getLabel('LBL_Service_Tax_Category', $this->siteLangId), 'ptt_taxcat_id', $taxCategories, '', array(), Labels::getLabel('LBL_Select', $this->siteLangId))->requirements()->setRequired(true);
        $frm->addCheckBox(Labels::getLabel('LBL_Is_Shipping_Required', $this->siteLangId), 'is_shipping_required', 1, array(), false, 0);
        $frm->addCheckBox(Labels::getLabel('LBL_Is_Document_Required_from_Buyer', $this->siteLangId), 'is_document_required', 1, array(), false, 0);

        $siteDefaultLangId = FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1);
        $languages = Language::getAllNames();
        foreach ($languages as $langId => $lang) {
            if ($langId == $siteDefaultLangId) {
                $frm->addRequiredField(Labels::getLabel('LBL_Name', $this->siteLangId), 'service_title[' . $langId . ']');
            } else {
                $frm->addTextBox(Labels::getLabel('LBL_Name', $this->siteLangId), 'service_title[' . $langId . ']');
            }
            $frm->addHtmlEditor(Labels::getLabel('LBL_Description', $this->siteLangId), 'service_description_' . $langId);
        }

        $translatorSubscriptionKey = FatApp::getConfig('CONF_TRANSLATOR_SUBSCRIPTION_KEY', FatUtility::VAR_STRING, '');
        unset($languages[$siteDefaultLangId]);
        if (!empty($translatorSubscriptionKey) && count($languages) > 0) {
            $frm->addCheckBox(Labels::getLabel('LBL_Translate_To_Other_Languages', $this->siteLangId), 'auto_update_other_langs_data', 1, array(), false, 0);
        }

        $frm->addHiddenField('', 'service_id');
        $frm->addHiddenField('', 'ptc_prodcat_id', $prodCatId);
        $frm->addButton('', 'btn_discard', Labels::getLabel('LBL_Discard', $this->siteLangId));
        $frm->addSubmitButton('', 'btn_submit', Labels::getLabel('LBL_Save', $this->siteLangId));
        $this->_template->addJs(array('js/cropper.js', 'js/cropper-main.js'));
        return $frm;
    }

    public function setup()
    {
        $frm = $this->getForm();
        $post = $frm->getFormDataFromArray(FatApp::getPostedData());
        if (false === $post) {
            Message::addErrorMessage($this->str_invalid_request);
            FatUtility::dieJsonError(Message::getHtml());
        }

        if ($post['ptc_prodcat_id'] < 1) {
            Message::addErrorMessage(Labels::getLabel('MSG_Please_Choose_Category_From_List', $this->siteLangId));
            FatUtility::dieJsonError(Message::getHtml());
        }

        if ($post['ptc_prodcat_id'] < 1) {
            Message::addErrorMessage(Labels::getLabel('MSG_Please_Choose_Category_From_List', $this->siteLangId));
            FatUtility::dieJsonError(Message::getHtml());
        }

        $serviceId = FatUtility::int($post['service_id']);

        $service = new Service($this->userParentId, $serviceId);

        if (0 == $serviceId && !$service->validateSubscriptionInventoryCount($this->siteLangId)) {
            Message::addErrorMessage($service->getError());
            FatApp::redirectUser(CommonHelper::generateUrl('Seller', 'Packages'));
        }
        
        if (0 == $serviceId) {
            $servActive = AppConstants::ACTIVE;
        } else {
            $serviceInfo = Service::getAttributesById($serviceId, ['selprod_user_id', 'selprod_active']);
            $servActive = $serviceInfo['selprod_active'];
        }
        
        $data = array(
            'selprod_user_id' => $this->userParentId,
            'selprod_price' => $post['service_price'],
            'selprod_product_id' => SellerProduct::SERVICES_DEFAULT_CATALOG,
            'selprod_type' => SellerProduct::PRODUCT_TYPE_SERVICE,
            'selprod_stock' => 1,
            'selprod_min_order_qty' => 1,
            'selprod_subtract_stock' => 0,
            'selprod_condition' => Product::CONDITION_NEW,
            'selprod_active' => $servActive,
            'selprod_category_id' => $post['ptc_prodcat_id'],
            'selprod_is_shipping_required' => (isset($post['is_shipping_required'])) ? $post['is_shipping_required'] : 0,
            'selprod_document_required' => (isset($post['is_document_required'])) ? $post['is_document_required'] : 0
        );
        $newService = 0;
        if ($serviceId == 0) {
            $newService = 1;
            $data['selprod_added_on'] = date('Y-m-d H:i:s');
            $data['selprod_available_from'] = date('Y-m-d 00:00:00');
        }

        $sellerProdObj = new SellerProduct($serviceId);
        $sellerProdObj->assignValues($data);
        if (!$sellerProdObj->save()) {
            Message::addErrorMessage(Labels::getLabel($sellerProdObj->getError(), $this->siteLangId));
            FatUtility::dieJsonError(Message::getHtml());
        }

        $serviceId = $sellerProdObj->getMainTableRecordId();
        if ($newService) {
            $dataToUpdate = ['selprod_code' => 'SERVICE_' . $serviceId];
            $sellerProdObj->assignValues($dataToUpdate);
            if (!$sellerProdObj->save()) {
                Message::addErrorMessage(Labels::getLabel($sellerProdObj->getError(), $this->siteLangId));
                FatUtility::dieJsonError(Message::getHtml());
            }
        }


        $this->setupLangData($serviceId, $post);
        $siteDefaultLangId = FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1);
        $sellerProdObj->rewriteUrlProduct($post['service_title'][$siteDefaultLangId]);

        $prod = new Product($serviceId);
        if (!$prod->saveProductCategory($post['ptc_prodcat_id'], Product::PRODUCT_TO_CATEGORY_TYPE_SERVICE)) {
            Message::addErrorMessage($prod->getError());
            FatUtility::dieJsonError(Message::getHtml());
        }

        if (!$prod->saveProductTax($post['ptt_taxcat_id'], $this->userParentId, SellerProduct::PRODUCT_TYPE_SERVICE)) {
            Message::addErrorMessage($prod->getError());
            FatUtility::dieJsonError(Message::getHtml());
        }

        $this->set('service_id', $serviceId);
        $this->set('msg', Labels::getLabel('LBL_Updated_Successfully', $this->siteLangId));
        $this->_template->render(false, false, 'json-success.php');
    }

    private function setupLangData(int $serviceId, array $data)
    {

        /* Update seller product language data[ */
        $productNames = (isset($data['service_title'])) ? $data['service_title'] : [];
        $autoUpdateOtherLangsData = isset($data['auto_update_other_langs_data']) ? FatUtility::int($data['auto_update_other_langs_data']) : 0;
        if (!empty($productNames)) {
            $siteDefaultLangId = FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1);
            $sellerProdObj = new SellerProduct($serviceId);
            foreach ($productNames as $langId => $prodName) {
                if (/* empty($prodName) && */ $autoUpdateOtherLangsData > 0 && $langId != $siteDefaultLangId) {
                    $sellerProdObj->saveTranslatedProductLangData($langId);
                } else {
                    $selProdData = array(
                        'selprodlang_selprod_id' => $serviceId,
                        'selprodlang_lang_id' => $langId,
                        'selprod_title' => $prodName,
                        'selprod_features' => $data['service_description_' . $langId]
                    );

                    if (!$sellerProdObj->updateLangData($langId, $selProdData)) {
                        Message::addErrorMessage(Labels::getLabel($sellerProdObj->getError(), $this->siteLangId));
                        FatUtility::dieJsonError(Message::getHtml());
                    }
                }
            }
        }
        /* ] */
    }

    public function changeStatus()
    {
        $post = FatApp::getPostedData();
        $serviceId = FatApp::getPostedData('serviceId', FatUtility::VAR_INT, 0);
        if (empty($post) || 1 > $serviceId || 0 > FatUtility::int($post['status'])) {
            Message::addErrorMessage(Labels::getLabel('MSG_Invalid_Request', $this->siteLangId));
            FatUtility::dieJsonError(Message::getHtml());
        }

        if (AppConstants::ACTIVE == FatUtility::int($post['status'])) {
            $service = new Service($this->userParentId, $serviceId);

            if (!$service->validateSubscriptionInventoryCount($this->siteLangId)) {
                Message::addErrorMessage($service->getError());
                FatUtility::dieJsonError(Message::getHtml());
            }
        }

        $serviceData = SellerProduct::getAttributesById($serviceId, ['selprod_user_id']);

        if (empty($serviceData['selprod_user_id']) || $serviceData['selprod_user_id'] != $this->userParentId) {
            Message::addErrorMessage(Labels::getLabel('MSG_Unauthorized_access', $this->siteLangId));
            FatUtility::dieJsonError(Message::getHtml());
        }

        $serviceObj = new SellerProduct($serviceId);
        $resp = $serviceObj->changeStatus(FatUtility::int($post['status']));
        if (!$resp) {
            Message::addErrorMessage($serviceObj->getError());
            FatUtility::dieJsonError(Message::getHtml());
        }

        $msg = Labels::getLabel('MSG_Status_Updated_Successfully', $this->siteLangId);
        FatUtility::dieJsonSuccess($msg);
    }

    private function searchForm()
    {
        $frm = new Form('frmSearchService');
        $frm->addTextBox(Labels::getLabel('LBL_Search_By', $this->siteLangId), 'keyword');
        $frm->addSelectBox(Labels::getLabel('LBL_Status', $this->siteLangId), 'service_active', AppConstants::getActiveInactiveArr($this->siteLangId));
        $frm->addSubmitButton('', 'btn_submit', Labels::getLabel('LBL_Submit', $this->siteLangId));
        $frm->addButton('', 'btn_clear', Labels::getLabel('LBL_Clear', $this->siteLangId));
        $frm->addHiddenField('', 'page', 1);
        return $frm;
    }

    public function mediaForm()
    {
        $mediaForm = $this->getMediaForm();
        $this->set('mediaForm', $mediaForm);

        $this->_template->render(false, false);
    }

    private function getMediaForm()
    {

        $frm = new Form('imageFrm');
        $languagesAssocArr = Language::getAllNames();
        $frm->addSelectBox(Labels::getLabel('LBL_Language', $this->siteLangId), 'lang_id', array(0 => Labels::getLabel('LBL_All_Languages', $this->siteLangId)) + $languagesAssocArr, '', [], '');
        $fldImg = $frm->addFileUpload(Labels::getLabel('LBL_Photo(s)', $this->siteLangId), 'service_image', array('id' => 'prod_image'));
        $fldImg->htmlBeforeField = '<div class="filefield"><span class="filename"></span>';
        $fldImg->htmlAfterField = '<label class="filelabel">' . Labels::getLabel('LBL_Browse_File', $this->siteLangId) . '</label></div><small>' . Labels::getLabel('LBL_Please_keep_image_dimensions_greater_than_500_x_500', $this->siteLangId) . '</small>';
        $frm->addHiddenField('', 'min_width', 500);
        $frm->addHiddenField('', 'min_height', 500);
        return $frm;
    }

    public function setupImage()
    {
        $post = FatApp::getPostedData();
        if (empty($post)) {
            FatUtility::dieJsonError(Labels::getLabel('LBL_Invalid_Request_Or_File_not_supported', $this->siteLangId));
        }

        $serviceId = FatApp::getPostedData('service_id', FatUtility::VAR_INT, 0);
        $service = new Service($this->userParentId, $serviceId);

        $langId = FatApp::getPostedData('lang_id', FatUtility::VAR_INT, 0);

        $serviceData = SellerProduct::getAttributesById($serviceId, ['selprod_user_id']);
        if (empty($serviceData['selprod_user_id']) || $serviceData['selprod_user_id'] != $this->userParentId) {
            Message::addErrorMessage(Labels::getLabel('MSG_Unauthorized_access', $this->siteLangId));
            FatUtility::dieJsonError(Message::getHtml());
        }

        if (!is_uploaded_file($_FILES['cropped_image']['tmp_name'])) {
            Message::addErrorMessage(Labels::getLabel("MSG_Please_select_a_file", $this->siteLangId));
            FatUtility::dieJsonError(Message::getHtml());
        }

        $fileHandlerObj = new AttachedFile();
        /* if (!$fileHandlerObj->deleteFile(AttachedFile::FILETYPE_SERVICE_PRODUCT_IMAGE, $serviceId, 0, 0, $langId)) {
            FatUtility::dieJsonError($fileHandlerObj->getError());
        } */

        if (!$res = $fileHandlerObj->saveImage($_FILES['cropped_image']['tmp_name'], AttachedFile::FILETYPE_SERVICE_PRODUCT_IMAGE, $serviceId, 0, $_FILES['cropped_image']['name'], -1, $unique_record = false, $langId)
        ) {
            Message::addErrorMessage($fileHandlerObj->getError());
            FatUtility::dieJsonError(Message::getHtml());
        }

        Message::addMessage(Labels::getLabel("MSG_Image_Uploaded_Successfully", $this->siteLangId));
        FatUtility::dieJsonSuccess(Message::getHtml());
    }

    public function mediaListing()
    {
        $serviceId = FatApp::getPostedData('service_id', FatUtility::VAR_INT, 0);
        $serviceImages = AttachedFile::getMultipleAttachments(AttachedFile::FILETYPE_SERVICE_PRODUCT_IMAGE, $serviceId, 0, -1, false, 0, 0, true);
        $this->set('serviceImages', $serviceImages);
        $this->set('serviceId', $serviceId);
        $this->set('languages', Language::getAllNames());
        $this->_template->render(false, false);
    }

    public function deleteImage(int $serviceId, int $imageId)
    {
        $serviceData = SellerProduct::getAttributesById($serviceId, ['selprod_user_id']);

        if (empty($serviceData['selprod_user_id']) || $serviceData['selprod_user_id'] != $this->userParentId) {
            Message::addErrorMessage(Labels::getLabel('MSG_Unauthorized_access', $this->siteLangId));
            FatUtility::dieJsonError(Message::getHtml());
        }

        $fileHandlerObj = new AttachedFile();
        if (!$fileHandlerObj->deleteFile(AttachedFile::FILETYPE_SERVICE_PRODUCT_IMAGE, $serviceId, $imageId)) {
            FatUtility::dieJsonError($fileHandlerObj->getError());
        }

        FatUtility::dieJsonSuccess(Labels::getLabel('LBL_Image_removed_successfully.', $this->siteLangId));
    }

    public function linksAutocomplete()
    {
        $keyword = FatApp::getPostedData('keyword', FatUtility::VAR_STRING, '');
        $prodCatObj = new ProductCategory();
        $arr_options = $prodCatObj->getProdCatTreeStructureSearch(0, $this->siteLangId, $keyword, 0, '', true, true, false, true);
        
        $json = array();
        foreach ($arr_options as $key => $product) {
            if ($key != SellerProduct::SERVICES_ROOT_CATEGORY) {
                $json[] = array(
                    'id' => $key,
                    'name' => strip_tags(html_entity_decode($product, ENT_QUOTES, 'UTF-8'))
                );
            }
        }
        die(json_encode($json));
    }

    private function searchTagForm()
    {
        $frm = new Form('frmSearchService');
        $frm->addTextBox(Labels::getLabel('LBL_Search_By', $this->siteLangId), 'keyword');
        $frm->addSubmitButton('', 'btn_submit', Labels::getLabel('LBL_Submit', $this->siteLangId));
        $frm->addButton('', 'btn_clear', Labels::getLabel('LBL_Clear', $this->siteLangId));
        $frm->addHiddenField('', 'page', 1);
        return $frm;
    }

    public function attachTags()
    {
        $this->userPrivilege->canViewProductTags(UserAuthentication::getLoggedUserId());
        if (!$this->isShopActive($this->userParentId, 0, true)) {
            FatApp::redirectUser(CommonHelper::generateUrl('Seller', 'shop'));
        }

        if (!UserPrivilege::isUserHasValidSubsription($this->userParentId)) {
            Message::addInfo(Labels::getLabel("MSG_Please_buy_subscription", $this->siteLangId));
            FatApp::redirectUser(CommonHelper::generateUrl('Seller', 'Packages'));
        }

        $this->_template->addJs('js/tagify.min.js');
        $this->_template->addJs('js/tagify.polyfills.min.js');

        $searchForm = $this->searchTagForm();
        $this->set('searchForm', $searchForm);

        $this->_template->render(true, true);
    }

    public function searchForTags()
    {
        $userId = $this->userParentId;
        $searchForm = $this->searchForm();
        $post = $searchForm->getFormDataFromArray(FatApp::getPostedData());
        $page = FatApp::getPostedData('page', FatUtility::VAR_INT, 1);
        $pagesize = FatApp::getConfig('CONF_PAGE_SIZE', FatUtility::VAR_INT, 10);

        $srch = SellerProduct::getSearchObject($this->siteLangId);
        $srch->addCondition('selprod_user_id', '=', $userId);
        $srch->addCondition('selprod_deleted', '=', 0);
        $srch->addCondition('selprod_type', '=', SellerProduct::PRODUCT_TYPE_SERVICE);

        $keyword = FatApp::getPostedData('keyword', FatUtility::VAR_STRING, '');
        if ($keyword != '') {
            $srch->addCondition('selprod_title', 'like', '%' . $keyword . '%');
        }

        $serviceStatus = FatApp::getPostedData('service_active');

        if ($serviceStatus != '') {
            $srch->addCondition('selprod_active', '=', $serviceStatus);
        }

        $srch->setPageNumber($page);
        $srch->setPageSize($pagesize);
        $srchRs = $srch->getResultSet();
        $records = FatApp::getDb()->fetchAll($srchRs);

        $this->set('arr_listing', $records);
        $this->set('siteLangId', $this->siteLangId);
        $this->set('pageCount', $srch->pages());
        $this->set('page', $page);
        $this->set('pageSize', $pagesize);
        $this->set('postedData', $post);
        $this->set('canEdit', $this->userPrivilege->canEditProductTags(UserAuthentication::getLoggedUserId(), true));
        $this->_template->render(false, false);
    }
}
