<?php

class LoggedUserController extends MyAppController
{
    public $userParentId = 0 ;
    protected $user;
    public function __construct($action)
    {
        parent::__construct($action);
        UserAuthentication::checkLogin();
        $userObj = new User(UserAuthentication::getLoggedUserId());
        $this->user = $userObj->getUserInfo(array(), true, false, true);

        $parentUserObj = new User($this->user['user_parent']);
        $isParentActive = $parentUserObj->getUserInfo('credential_active', true, false, true);
        if (empty($this->user) || ($this->user['user_parent'] > 0 && $isParentActive == AppConstants::INACTIVE)) {
            if (FatUtility::isAjaxCall()) {
                $this->renderJsonError(Labels::getLabel('MSG_Session_seems_to_be_expired', CommonHelper::getLangId()));
            }
            FatApp::redirectUser(CommonHelper::generateUrl('GuestUser', 'logout'));
        }
        
        if (!isset($_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab'])) {
            $userPreferedDashboardType = ($this->user['user_preferred_dashboard']) ? $this->user['user_preferred_dashboard'] : $this->user['user_registered_initially_for'];
            switch ($userPreferedDashboardType) {
                case User::USER_TYPE_BUYER:
                    $_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab'] = 'B';
                    break;
                case User::USER_TYPE_SELLER:
                    $_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab'] = 'S';
                    break;
                case User::USER_TYPE_AFFILIATE:
                    $_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab'] = 'AFFILIATE';
                    break;
                case User::USER_TYPE_ADVERTISER:
                    $_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab'] = 'Ad';
                    break;
            }
        }

        if (!FatUtility::isAjaxCall()) {
            $this->setDefaultViews();
        }
        
        if ((!UserAuthentication::isGuestUserLogged() && $this->user['credential_verified'] != 1) && !($_SESSION[User::ADMIN_SESSION_ELEMENT_NAME] && $_SESSION[User::ADMIN_SESSION_ELEMENT_NAME] > 0)) {
            FatApp::redirectUser(CommonHelper::generateUrl('GuestUser', 'logout'));
        }

        /* Thease actions are used while configuring Phone from "Configure Email/Phone Page". */
        $allowedActions = ['getotp', 'resendotp', 'validateotp'];
        if (!in_array(strtolower($action), $allowedActions) && empty($this->user['user_phone']) && empty($this->user['credential_email'])) {
            $message = Labels::getLabel('MSG_PLEASE_CONFIGURE_YOUR_EMAIL', $this->siteLangId);
            if (true == SmsArchive::canSendSms()) {
                $message = Labels::getLabel('MSG_PLEASE_CONFIGURE_YOUR_EMAIL_OR_PHONE', $this->siteLangId);
            }
            if (API_CALL) {
                $this->renderJsonError($message);
            }
            Message::addErrorMessage($message);
            FatApp::redirectUser(CommonHelper::generateUrl('GuestUser', 'configureEmail'));
        }

        $this->userParentId = (0 < $this->user['user_parent']) ? $this->user['user_parent'] : UserAuthentication::getLoggedUserId();
        $this->initCommonValues();
    }

    private function setDefaultViews()
    {
        FatApp::setViewDataProvider('_partial/buyerDashboardNavigation.php', array('Navigation', 'buyerDashboardNavigation'));
        FatApp::setViewDataProvider('_partial/seller/sellerDashboardNavigation.php', array('Navigation', 'sellerDashboardNavigation'));
        FatApp::setViewDataProvider('_partial/affiliate/affiliateDashboardNavigation.php', array('Navigation', 'affiliateDashboardNavigation'));
        FatApp::setViewDataProvider('_partial/advertiser/advertiserDashboardNavigation.php', array('Navigation', 'advertiserDashboardNavigation'));
    }

    private function initCommonValues()
    {
        $this->set('isUserDashboard', true);
        $this->userPrivilege = UserPrivilege::getInstance();
        $this->set('userPrivilege', $this->userPrivilege);
    }

    protected function getOrderCancellationRequestsSearchForm($langId)
    {
        $frm = new Form('frmOrderCancellationRequest');
        $frm->addTextBox('', 'op_invoice_number');
        $frm->addSelectBox('', 'ocrequest_status', array( '-1' => Labels::getLabel('LBL_Status_Does_Not_Matter', $langId)  ) + OrderCancelRequest::getRequestStatusArr($langId), '', array(), '');
        $frm->addDateField('', 'ocrequest_date_from', '', array('readonly' => 'readonly'));
        $frm->addDateField('', 'ocrequest_date_to', '', array('readonly' => 'readonly'));
        $frm->addSubmitButton('', 'btn_submit', Labels::getLabel('LBL_Search', $langId));
        $frm->addButton("", "btn_clear", Labels::getLabel("LBL_Clear", $langId), array('onclick' => 'clearOrderCancelRequestSearch();'));
        $frm->addHiddenField('', 'page');
        return $frm;
    }

    protected function getOrderReturnRequestsSearchForm($langId)
    {
        $frm = new Form('frmOrderReturnRequest');
        $frm->addTextBox('', 'keyword');
        $frm->addSelectBox('', 'orrequest_status', array( '-1' => Labels::getLabel('LBL_Status_Does_Not_Matter', $langId) ) + OrderReturnRequest::getRequestStatusArr($langId), '', array(), '');
        $returnRquestArray = OrderReturnRequest::getRequestTypeArr($langId);
        if (count($returnRquestArray) > AppConstants::YES) {
            $frm->addSelectBox('', 'orrequest_type', array( '-1' => Labels::getLabel('LBL_Request_Type_Does_Not_Matter', $langId) ) + $returnRquestArray, '', array(), '');
        } else {
            $frm->addHiddenField('', 'orrequest_type', '-1');
        }
        $frm->addDateField('', 'orrequest_date_from', '', array('readonly' => 'readonly'));
        $frm->addDateField('', 'orrequest_date_to', '', array('readonly' => 'readonly'));
        $frm->addSubmitButton('', 'btn_submit', Labels::getLabel('LBL_Search', $langId));
        $frm->addButton("", "btn_clear", Labels::getLabel("LBL_Clear", $langId), array('onclick' => 'clearOrderReturnRequestSearch();'));
        $frm->addHiddenField('', 'page');
        return $frm;
    }

    protected function getOrderReturnRequestMessageSearchForm($langId)
    {
        $frm = new Form('frmOrderReturnRequestMsgsSrch');
        $frm->addHiddenField('', 'page');
        $frm->addHiddenField('', 'orrequest_id');
        return $frm;
    }

    protected function getOrderReturnRequestMessageForm($langId)
    {
        $frm = new Form('frmOrderReturnRequestMessge');
        $frm->setRequiredStarPosition('');
        $fld = $frm->addTextArea('', 'orrmsg_msg');
        $fld->requirements()->setRequired();
        $fld->requirements()->setCustomErrorMessage(Labels::getLabel('MSG_Message_is_mandatory', $langId));
        $frm->addHiddenField('', 'orrmsg_orrequest_id');
        $frm->addSubmitButton('', 'btn_submit', Labels::getLabel('LBL_Submit', $langId));
        return $frm;
    }
}
