<?php

class CategoryController extends MyAppController
{

    public function __construct($action)
    {
        parent::__construct($action);
    }

    public function index()
    {
        $categoriesArr = ProductCategory::getTreeArr($this->siteLangId, 0, true, false, false, '', true, true);
        $this->set('categoriesArr', $categoriesArr);
        $this->_template->render();
    }

    public function view($categoryId)
    {
        $categoryId = FatUtility::int($categoryId);

        ProductCategory::recordCategoryWeightage($categoryId);

        $db = FatApp::getDb();

        if (API_CALL) {
            $get = FatApp::getPostedData();
        } else {
            $get = Product::convertArrToSrchFiltersAssocArr(FatApp::getParameters());
        }

        $productCategorySearch = new ProductCategorySearch($this->siteLangId, true, true, false, false);
        $productCategorySearch->addCondition('prodcat_id', '=', $categoryId);

        /* to show searched category data[ */
        $productCategorySearch->addMultipleFields(array('prodcat_id', 'IFNULL(prodcat_name, prodcat_identifier) as prodcat_name', 'prodcat_content_block', 'prodcat_description', 'prodcat_code'));
        $productCategorySearch->setPageSize(1);
        $productCategorySearchRs = $productCategorySearch->getResultSet();
        $category = $db->fetch($productCategorySearchRs);

        if (false == $category) {
            if (API_CALL) {
                $message = Labels::getLabel('MSG_INVALID_REQUEST', $this->siteLangId);
                FatUtility::dieJsonError($message);
            }
            FatUtility::exitWithErrorCode(404);
        }

        $serviceRootCatCode = ProductCategory::getAttributesById(SellerProduct::SERVICES_ROOT_CATEGORY, 'prodcat_code');
        $bannerDetail = AttachedFile::getAttachment(AttachedFile::FILETYPE_CATEGORY_BANNER, $categoryId);
        $category['banner'] = empty($bannerDetail) ? (object) array() : $bannerDetail;
        /* ] */

        $userId = 0;
        if (UserAuthentication::isUserLogged()) {
            $userId = UserAuthentication::getLoggedUserId();
        }
        $popularAndDiscountInSort = true;

        if (strpos($category['prodcat_code'], $serviceRootCatCode) === 0) {
            $popularAndDiscountInSort = false;
        }

        $frm = $this->getProductSearchForm(false, $popularAndDiscountInSort, $popularAndDiscountInSort);
        $get['category'] = $categoryId;
        $get['join_price'] = 1;
        $frm->fill($get);

        if (strpos($category['prodcat_code'], $serviceRootCatCode) === 0) { // for services category
            $this->loadServicesData($get, $userId, $frm, $categoryId, $category);
            $this->_template->render(true, true, 'category/service-view.php');
        } else {
            $pageSize = FatApp::getConfig('CONF_ITEMS_PER_PAGE_CATALOG', FatUtility::VAR_INT, 10);
            if (array_key_exists('pageSize', $get)) {
                $pageSize = FatUtility::int($get['pageSize']);
                if (0 >= $pageSize) {
                    $pageSize = FatApp::getConfig('CONF_ITEMS_PER_PAGE_CATALOG', FatUtility::VAR_INT, 10);
                }
            }

            $page = 1;
            if (array_key_exists('page', $get)) {
                $page = FatUtility::int($get['page']);
                if ($page < 2) {
                    $page = 1;
                }
            }

            $srch = Product::getListingObj($get, $this->siteLangId, $userId);
            $srch->setPageNumber($page); 
            if ($pageSize) {
                $srch->setPageSize($pageSize);
            }

            $rs = $srch->getResultSet();
            $db = FatApp::getDb();
            $products = $db->fetchAll($rs);
			if($products) {
				foreach($products as $key=>$prod) {
					$products[$key]['shop_rating'] = SelProdRating::getSellerRating($prod['shop_user_id']);
					
					$currentPlanData = OrderSubscription::getUserCurrentActivePlanDetails($this->siteLangId, $prod['shop_user_id'], array('spackage_id'));
					$currentActivePackageId = FatUtility::int($currentPlanData['spackage_id']);
					$products[$key]['subscription_package_id'] = $currentActivePackageId;
					if ($currentActivePackageId > 0) {
						$packageMemberLabels = SellerPackages::getPackageMemberLabels($this->siteLangId);
						$products[$key]['subscription_package'] = (isset($packageMemberLabels[$currentActivePackageId])) ? $packageMemberLabels[$currentActivePackageId] : '';
					}	


					/* Get Product Specifications [ */
					$specSrchObj = new ProductSearch($this->siteLangId, null, null, false, false);
					$specSrchObj->doNotCalculateRecords();
					$specSrchObj->joinTable(Product::DB_PRODUCT_SPECIFICATION, 'LEFT OUTER JOIN', 'product_id = tcps.prodspec_product_id', 'tcps');
					$specSrchObj->joinTable(Product::DB_PRODUCT_LANG_SPECIFICATION, 'INNER JOIN', 'tcps.prodspec_id = tcpsl.prodspeclang_prodspec_id and   prodspeclang_lang_id  = ' . $this->siteLangId, 'tcpsl');
					$specSrchObj->addMultipleFields(array('prodspec_id', 'prodspec_name', 'prodspec_value'));
					$specSrchObj->addGroupBy('prodspec_id');
					$specSrchObj->setPageSize('3');
					$specSrchObj->addCondition('prodspec_product_id', '=', $prod['product_id']);
					$specSrchObjRs = $specSrchObj->getResultSet();
					$products[$key]['productSpecifications'] = FatApp::getDb()->fetchAll($specSrchObjRs);
					/* ] */
					
				}
			}

            
			
            $data = array(
                'frmProductSearch' => $frm,
                'category' => $category,
                'products' => $products,
                'page' => $page,
                'pageSize' => $pageSize,
                'categoryId' => $categoryId,
                'pageCount' => $srch->pages(),
                'postedData' => $get,
                'recordCount' => $srch->recordCount(),
                'pageTitle' => $category['prodcat_name'],
                'canonicalUrl' => CommonHelper::generateFullUrl('Category', 'view', array($categoryId)),
                'productSearchPageType' => SavedSearchProduct::PAGE_CATEGORY,
                'recordId' => $categoryId,
                'bannerListigUrl' => CommonHelper::generateFullUrl('Banner', 'categories'),
                'siteLangId' => $this->siteLangId,
                'showBreadcrumb' => true,
            );

            if (FatUtility::isAjaxCall()) {
                $this->set('products', $products);
                $this->set('page', $page);
                $this->set('pageCount', $srch->pages());
                $this->set('postedData', $get);
                $this->set('recordCount', $srch->recordCount());
                $this->set('siteLangId', $this->siteLangId);
                echo $this->_template->render(false, false, 'products/products-list.php', true);
                exit;
            }

            $this->set('data', $data);
            if (false === API_CALL) {
                $this->includeProductPageJsCss();
                $this->_template->addJs('js/slick.min.js');
            }
            $this->_template->render();
        }
    }

    private function loadServicesData(array $get, int $userId, $frm, int $categoryId, array $category)
    {
        $pageSize = FatApp::getConfig('CONF_ITEMS_PER_PAGE_CATALOG', FatUtility::VAR_INT, 10);
        if (array_key_exists('pageSize', $get)) {
            $pageSize = FatUtility::int($get['pageSize']);
            if (0 >= $pageSize) {
                $pageSize = FatApp::getConfig('CONF_ITEMS_PER_PAGE_CATALOG', FatUtility::VAR_INT, 10);
            }
        }

        $page = 1;
        if (array_key_exists('page', $get)) {
            $page = FatUtility::int($get['page']);
            if ($page < 2) {
                $page = 1;
            }
        }

        $srch = new ServiceSearch($this->siteLangId);
        $srch->joinSellers();
        $srch->joinShops($this->siteLangId);
		$srch->joinSellerSubscription();
        $srch->joinServiceCategory();

		$srch->joinTable(Product::DB_TBL, 'INNER JOIN', 'p.product_id = selprod_product_id', 'p');
		$srch->joinTable(Brand::DB_TBL, 'LEFT JOIN', 'b.brand_id = p.product_brand_id', 'b');
        $srch->joinTable(Brand::DB_TBL_LANG, 'LEFT JOIN', 'b_l.brandlang_brand_id = b.brand_id AND b_l.brandlang_lang_id = ' . $this->siteLangId, 'b_l');

        $subFld = [];
        if (FatApp::getConfig('CONF_ENABLE_SELLER_SUBSCRIPTION_MODULE')) {
            $subFld = array('spplan_spackage_id as subscription_package_id');
        }

        $genFlds = array(
            'shop_is_buy_now', 'IF(selprod_stock > 0, 1, 0) AS in_stock', 'shop_hide_price_for_guests', 'shop_hide_price_for_loginusers', 'prodcat_code', 'COALESCE(prodcat_name, prodcat_identifier) as prodcat_name',
            'selprod_id', 'selprod_user_id', 'selprod_code', 'selprod_price', 'selprod_title',
            'user_name', 'seller_user.user_is_verified as seller_verified',
            'seller_user.user_is_founding_member as is_founding_member',
            'rcountry.country_code as seller_country', 'shop_id', 'selprod_updated_on', 'prodcat_id','shop_user_id','selprod_product_id as product_id',
            'IFNULL(shop_name, shop_identifier) as shop_name', 'rcountrylang.country_name as shop_country_name', 'shop_state_l.state_name as shop_state_name','selprod_is_shipping_required','selprod_document_required', 
        );
        $flds = array_merge($subFld, $genFlds);
        $srch->addMultipleFields($flds);

        if (!empty($category) && isset($category['prodcat_code'])) {
            $srch->addCondition('c.prodcat_code', 'LIKE', $category['prodcat_code'] . '%', 'AND', true);
        }

        if (isset($get['price-min-range'])) {
            $minPriceRange = floor($get['price-min-range']);
            $currCurrencyId = isset($get['currency_id']) ? $get['currency_id'] : FatApp::getConfig('CONF_CURRENCY', FatUtility::VAR_INT, 1);
            $min_price_range_default_currency = CommonHelper::convertExistingToOtherCurrency($currCurrencyId, $minPriceRange, FatApp::getConfig('CONF_CURRENCY', FatUtility::VAR_INT, 1), false);
            $srch->addCondition('selprod.selprod_price', '>=', $min_price_range_default_currency, 'AND', true);
        }
        if (isset($get['price-max-range'])) {
            $minPriceRange = ceil($get['price-max-range']);
            $currCurrencyId = isset($get['currency_id']) ? $get['currency_id'] : FatApp::getConfig('CONF_CURRENCY', FatUtility::VAR_INT, 1);
            $max_price_range_default_currency = CommonHelper::convertExistingToOtherCurrency($currCurrencyId, $minPriceRange, FatApp::getConfig('CONF_CURRENCY', FatUtility::VAR_INT, 1), false);
            $srch->addCondition('selprod.selprod_price', '<=', $max_price_range_default_currency, 'AND', true);
        }

        if (isset($get['country']) && !empty($get['country'])) {
            $srch->addCondition('rcountry.country_id', 'IN', $get['country']);
        }

        if (array_key_exists('sortBy', $get)) {
            $sortByArr = explode("_", $get['sortBy']);
            $sortBy = isset($sortByArr[0]) ? $sortByArr[0] : $sortBy;
            $sortOrder = isset($sortByArr[1]) ? $sortByArr[1] : $sortOrder;
            if (!in_array($sortOrder, array('asc', 'desc'))) {
                $sortOrder = 'asc';
            }
            switch ($sortBy) {
                case 'price':
                    $srch->addOrder('selprod_price', $sortOrder);
                    break;
                default:
                    //$srch->addOrder('keyword_relevancy', 'DESC');
                    break;
            }
        } else {
            $srch->addOrder('selprod_price', 'ASC');
        }

        $srch->setPageNumber($page);
        if ($pageSize) {
            $srch->setPageSize($pageSize);
        }

        $rs = $srch->getResultSet();
        $db = FatApp::getDb();
        $products = $db->fetchAll($rs);


		if($products) {
			foreach($products as $key=>$prod) {
				$products[$key]['shop_rating'] = SelProdRating::getSellerRating($prod['shop_user_id']);
				
				$currentPlanData = OrderSubscription::getUserCurrentActivePlanDetails($this->siteLangId, $prod['shop_user_id'], array('spackage_id'));
				$currentActivePackageId = FatUtility::int($currentPlanData['spackage_id']);
				$products[$key]['subscription_package_id'] = $currentActivePackageId;
				if ($currentActivePackageId > 0) {
					$packageMemberLabels = SellerPackages::getPackageMemberLabels($this->siteLangId);
					$products[$key]['subscription_package'] = (isset($packageMemberLabels[$currentActivePackageId])) ? $packageMemberLabels[$currentActivePackageId] : '';
				}	
				
			}
		}

        $data = array(
            'frmProductSearch' => $frm,
            'category' => $category,
            'products' => $products,
            'page' => $page,
            'pageSize' => $pageSize,
            'categoryId' => $categoryId,
            'pageCount' => $srch->pages(),
            'postedData' => $get,
            'recordCount' => $srch->recordCount(),
            'pageTitle' => $category['prodcat_name'],
            'canonicalUrl' => CommonHelper::generateFullUrl('Category', 'view', array($categoryId)),
            'productSearchPageType' => SavedSearchProduct::PAGE_CATEGORY,
            'recordId' => $categoryId,
            'bannerListigUrl' => CommonHelper::generateFullUrl('Banner', 'categories'),
            'siteLangId' => $this->siteLangId,
            'showBreadcrumb' => true,
        );

        if (FatUtility::isAjaxCall()) {
            $this->set('products', $products);
            $this->set('page', $page);
            $this->set('pageCount', $srch->pages());
            $this->set('postedData', $get);
            $this->set('recordCount', $srch->recordCount());
            $this->set('siteLangId', $this->siteLangId);
            echo $this->_template->render(false, false, 'products/services-list.php', true);
            exit;
        }

        $this->set('data', $data);
        if (false === API_CALL) {
            $this->includeProductPageJsCss();
            $this->_template->addJs('js/slick.min.js');
        }
    }

    public function image($catId, $langId = 0, $sizeType = '')
    {
        $catId = FatUtility::int($catId);
        $langId = FatUtility::int($langId);
        $file_row = AttachedFile::getAttachment(AttachedFile::FILETYPE_CATEGORY_IMAGE, $catId, 0, $langId);
        $image_name = isset($file_row['afile_physical_path']) ? $file_row['afile_physical_path'] : '';

        switch (strtoupper($sizeType)) {
            case 'THUMB':
                $w = 100;
                $h = 100;
                AttachedFile::displayImage($image_name, $w, $h);
                break;
            case 'COLLECTION_PAGE':
                $w = 45;
                $h = 41;
                AttachedFile::displayImage($image_name, $w, $h);
                break;
            default:
                AttachedFile::displayOriginalImage($image_name);
                break;
        }
    }

    public function collectionimage($catId, $langId = 0, $sizeType = '')
    {
        $catId = FatUtility::int($catId);
        $langId = FatUtility::int($langId);
        $file_row = AttachedFile::getAttachment(AttachedFile::FILETYPE_CATEGORY_COLLECTION_IMAGE, $catId, 0, $langId);
        $image_name = isset($file_row['afile_physical_path']) ? $file_row['afile_physical_path'] : '';

        switch (strtoupper($sizeType)) {
            case 'THUMB':
                $w = 100;
                $h = 100;
                AttachedFile::displayImage($image_name, $w, $h);
                break;
            case 'COLLECTION_PAGE':
                $w = 400;
                $h = 300;
                AttachedFile::displayImage($image_name, $w, $h);
                break;
            default:
                AttachedFile::displayOriginalImage($image_name);
                break;
        }
    }

    public function icon($catId, $langId = 0, $sizeType = '')
    {
        $catId = FatUtility::int($catId);
        $langId = FatUtility::int($langId);
        $file_row = AttachedFile::getAttachment(AttachedFile::FILETYPE_CATEGORY_ICON, $catId, 0, $langId);
        $image_name = isset($file_row['afile_physical_path']) ? $file_row['afile_physical_path'] : '';

        switch (strtoupper($sizeType)) {
            case 'THUMB':
                $w = 32;
                $h = 32;
                AttachedFile::displayImage($image_name, $w, $h);
                break;
            case 'COLLECTION_PAGE':
                $w = 48;
                $h = 48;
                AttachedFile::displayImage($image_name, $w, $h);
                break;
            default:
                AttachedFile::displayOriginalImage($image_name);
                break;
        }
    }

    public function sellerBanner($shopId, $prodCatId, $langId = 0, $sizeType = '')
    {
        $shopId = FatUtility::int($shopId);
        $prodCatId = FatUtility::int($prodCatId);
        $langId = FatUtility::int($langId);

        $file_row = AttachedFile::getAttachment(AttachedFile::FILETYPE_CATEGORY_BANNER_SELLER, $shopId, $prodCatId, $langId);
        $image_name = isset($file_row['afile_physical_path']) ? $file_row['afile_physical_path'] : '';

        switch (strtoupper($sizeType)) {
            case 'THUMB':
                $w = 250;
                $h = 100;
                AttachedFile::displayImage($image_name, $w, $h);
                break;
            case 'WIDE':
                $w = 1320;
                $h = 320;
                AttachedFile::displayImage($image_name, $w, $h);
                break;
            default:
                AttachedFile::displayOriginalImage($image_name);
                break;
        }
    }

    public function banner($prodCatId, $langId = 0, $sizeType = '', $screen = 0, $displayUniversalImage = true)
    {
        $default_image = 'product_default_image.jpg';
        $prodCatId = FatUtility::int($prodCatId);
        $langId = FatUtility::int($langId);

        $file_row = AttachedFile::getAttachment(AttachedFile::FILETYPE_CATEGORY_BANNER, $prodCatId, 0, $langId, $displayUniversalImage, $screen);
        $image_name = isset($file_row['afile_physical_path']) ? $file_row['afile_physical_path'] : '';

        switch (strtoupper($sizeType)) {
            case 'THUMB':
                $w = 250;
                $h = 100;
                AttachedFile::displayImage($image_name, $w, $h, $default_image);
                break;
            case 'MEDIUM':
                $w = 600;
                $h = 150;
                AttachedFile::displayImage($image_name, $w, $h, $default_image);
                break;
            case 'COLLECTION':
                $w = 400;
                $h = 300;
                AttachedFile::displayImage($image_name, $w, $h, $default_image);
                break;
            case 'MOBILE':
                $w = 640;
                $h = 360;
                AttachedFile::displayImage($image_name, $w, $h);
                break;
            case 'TABLET':
                $w = 1024;
                $h = 360;
                AttachedFile::displayImage($image_name, $w, $h);
                break;
            case 'DESKTOP':
                $w = 2000;
                $h = 500;
                AttachedFile::displayImage($image_name, $w, $h);
                break;
            default:
                AttachedFile::displayOriginalImage($image_name, $default_image);
                break;
        }
    }

    public function getBreadcrumbNodes($action)
    {
        $nodes = array();
        $parameters = FatApp::getParameters();
        switch ($action) {
            case 'view':
                if (isset($parameters[0]) && $parameters[0] > 0) {
                    $parent = FatUtility::int($parameters[0]);
                    if ($parent > 0) {
                        $cntInc = 1;
                        $prodCateObj = new ProductCategory();
                        $category_structure = $prodCateObj->getCategoryStructure($parent, '', $this->siteLangId);
                        $category_structure = array_reverse($category_structure);
                        foreach ($category_structure as $catKey => $catVal) {
                            if ($cntInc < count($category_structure)) {
                                $nodes[] = array('title' => $catVal["prodcat_name"], 'href' => Commonhelper::generateUrl('category', 'view', array($catVal['prodcat_id'])));
                            } else {
                                $nodes[] = array('title' => $catVal["prodcat_name"]);
                            }
                            $cntInc++;
                        }
                    }
                }
                break;

            case 'form':
                break;
        }
        return $nodes;
    }

    private function resetKeyValues($arr, $langId)
    {
        $langId = FatUtility::int($langId);
        $result = array();
        foreach ($arr as $key => $val) {
            if (!array_key_exists('prodcat_id', $val)) {
                continue;
            }
            $result[$key] = $val;
            $isLastChildCategory = ProductCategory::isLastChildCategory($val['prodcat_id']);
            $result[$key]['isLastChildCategory'] = $isLastChildCategory ? 1 : 0;
            $result[$key]['icon'] = CommonHelper::generateFullFileUrl('Category', 'icon', array($val['prodcat_id'], $langId, 'COLLECTION_PAGE'));
            $result[$key]['image'] = CommonHelper::generateFullFileUrl('Category', 'banner', array($val['prodcat_id'], $langId, 'MOBILE', AppConstants::SCREEN_MOBILE));
            $childernArr = array();
            if (!empty($val['children'])) {
                $array = array_values($val['children']);
                $childernArr = $this->resetKeyValues($array, $langId);
            }
            $result[$key]['children'] = $childernArr;
        }
        return array_values($result);
    }

    public function structure()
    {
        $productCategory = new productCategory();

        $prodSrchObj = (API_CALL ? false : new ProductCategorySearch($this->siteLangId));
        $parentId = FatApp::getPostedData('parentId', FatUtility::VAR_INT, 0);
        $includeChild = true;
        if (API_CALL && 0 == $parentId) {
            $includeChild = false;
        }

        $categoriesArr = ProductCategory::getProdCatParentChildWiseArr($this->siteLangId, $parentId, $includeChild, false, false, $prodSrchObj, true);

        /*  if (true ===  API_CALL && 0 == $parentId) {
          foreach ($categoriesDataArr as $key => $value) {
          $categoriesDataArr[$key]['icon'] = CommonHelper::generateFullFileUrl('Category', 'icon', array($value['prodcat_id'], $this->siteLangId, 'COLLECTION_PAGE'));
          $categoriesDataArr[$key]['image'] = CommonHelper::generateFullFileUrl('Category', 'banner', array($value['prodcat_id'] , $this->siteLangId, 'MOBILE', AppConstants::SCREEN_MOBILE));
          }
          } else {
          if (false ===  API_CALL) {
          $categoriesDataArr = $productCategory->getCategoryTreeArr($this->siteLangId, $categoriesArr, array( 'prodcat_id', 'IFNULL(prodcat_name,prodcat_identifier ) as prodcat_name','substr(GETCATCODE(prodcat_id),1,6) AS prodrootcat_code', 'prodcat_content_block','prodcat_active','prodcat_parent','GETCATCODE(prodcat_id) as prodcat_code'));
          }
          } */
        if (false === API_CALL) {
            $categoriesArr = $productCategory->getCategoryTreeArr($this->siteLangId, $categoriesArr, array('prodcat_id', 'IFNULL(prodcat_name,prodcat_identifier ) as prodcat_name', 'substr(GETCATCODE(prodcat_id),1,6) AS prodrootcat_code', 'prodcat_content_block', 'prodcat_active', 'prodcat_parent', 'GETCATCODE(prodcat_id) as prodcat_code'));
        }

        $categoriesArr = $this->resetKeyValues(array_values($categoriesArr), $this->siteLangId);

        if (empty($categoriesArr)) {
            $categoriesArr = array();
        }

        $this->set('categoriesData', $categoriesArr);
        $this->_template->render();
    }

}
