<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
$arr_flds = array(
    'select_all' => Labels::getLabel('LBL_Select_all', $adminLangId),
    'listserial' => Labels::getLabel('LBL_S.No.', $adminLangId),
    'user' => Labels::getLabel('LBL_User', $adminLangId),
    'shop_name' => Labels::getLabel('LBL_Shop', $adminLangId),
    'type' => Labels::getLabel('LBL_User_Type', $adminLangId),
    'user_regdate' => Labels::getLabel('LBL_Reg._Date', $adminLangId),
    'credential_active' => Labels::getLabel('LBL_Status', $adminLangId),
    'credential_verified' => Labels::getLabel('LBL_email_verified', $adminLangId),
    'user_is_founding_member' => Labels::getLabel('LBL_Founding_Member', $adminLangId),
    'user_is_verified' => Labels::getLabel('LBL_Verified', $adminLangId),
    'action' => '',
);
if (!$canEdit) {
    unset($arr_flds['select_all']);
}
$tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table table-responsive'));
$th = $tbl->appendElement('thead')->appendElement('tr');

foreach ($arr_flds as $key => $val) {
    if ('select_all' == $key) {
        $th->appendElement('th')->appendElement('plaintext', array(), '<label class="checkbox"><input title="' . $val . '" type="checkbox" onclick="selectAll( $(this) )" class="selectAll-js"><i class="input-helper"></i></label>', true);
    } else {
        $e = $th->appendElement('th', array(), $val);
    }
}

$sr_no = $page == 1 ? 0 : $pageSize * ($page - 1);
foreach ($arr_listing as $sn => $row) {
    $sr_no++;
    $tr = $tbl->appendElement('tr', array());

    foreach ($arr_flds as $key => $val) {
        $td = $tr->appendElement('td');
        switch ($key) {
            case 'select_all':
                $td->appendElement('plaintext', array(), '<label class="checkbox"><input class="selectItem--js" type="checkbox" name="user_ids[]" value=' . $row['user_id'] . '><i class="input-helper"></i></label>', true);
                break;
            case 'listserial':
                $td->appendElement('plaintext', array(), $sr_no);
                break;
            case 'user':
                $userDetail = '<strong>' . Labels::getLabel('LBL_N:', $adminLangId) . ' </strong>' . $row['user_name'] . '<br/>';
                $userDetail .= '<strong>' . Labels::getLabel('LBL_UN:', $adminLangId) . ' </strong>' . $row['credential_username'] . '<br/>';
                $userDetail .= '<strong>' . Labels::getLabel('LBL_Email:', $adminLangId) . ' </strong>' . $row['credential_email'] . '<br/>';
                $userDetail .= '<strong>' . Labels::getLabel('LBL_User_ID:', $adminLangId) . ' </strong>' . $row['user_id'] . '<br/>';
                if ($row['seller_type'] > 0 && isset($sellerTypeArr[$row['seller_type']])) {
                    $userDetail .= '<strong>' . Labels::getLabel('LBL_Seller_Type:', $adminLangId) . ' </strong>' . $sellerTypeArr[$row['seller_type']] . '<br/>';
                }

                if (FatApp::getConfig('CONF_ENABLE_SELLER_SUBSCRIPTION_MODULE') && ( isset($row['subscription_package_id']) && $row['subscription_package_id'] > 0)) {
                    $userDetail .= '<strong>' . Labels::getLabel('LBL_Subscription_Package:', $adminLangId) . ' </strong>' . $row['spackage_name'] . '<br/>';
                    
                    
                    if ($row['subscription_package_id'] == 2) {
                        $userDetail .= '<ul class="tag-img mt-3"><li class="silver-member-icon"><i class="icn">
                                                <svg class="svg">
                                                <use xlink:href="' . CONF_WEBROOT_URL . 'images/retina/sprite.svg#silver-member" href="' . CONF_WEBROOT_URL . 'images/retina/sprite.svg#silver-member"></use>
                                                </svg>
                                            </i> ' . Labels::getLabel('LBL_Silver_Member', $adminLangId) . '
                                        </li></ul>';
                    } elseif ($row['subscription_package_id'] == 3) {
                        $userDetail .= '<ul class="tag-img mt-3"><li class="gold-member-icon">
                                            <i class="icn">
                                                <svg class="svg">
                                                <use xlink:href="' . CONF_WEBROOT_URL . 'images/retina/sprite.svg#gold-member" href="' . CONF_WEBROOT_URL . 'images/retina/sprite.svg#gold-member"></use>
                                                </svg>
                                            </i> ' . Labels::getLabel('LBL_Gold_Member', $adminLangId) . '
                                        </li></ul>';
                    } else {
                        $userDetail .= '<ul class="tag-img mt-3"><li class="free-member-icon">
                                            ' . Labels::getLabel('LBL_Free_Member', $adminLangId) . '
                                        </li></ul>';
                    }
                }

                $td->appendElement('plaintext', array(), $userDetail, true);
                break;
            case 'shop_name':
                if ($row[$key] != '') {
                    $img = '';
                    if ($row['r_country_code'] != '') {
                        $img = '<img src="' . CONF_WEBROOT_FRONT_URL . 'public/images/flags/' . strtolower($row['r_country_code']) . '.png" style="display:inline-block;" />';
                    }

                    $shopsUrl = CommonHelper::generateFullUrl('shops'); 

                    if ($canViewShops) {
                        $html = '<a href="javascript:void(0);" onClick="redirectfunc("' . $shopsUrl . '", ' . $row['shop_id'] . ');">' . $row[$key] . '</a> ' . $img;
                        $td->appendElement('plaintext', array(), $html, true);
                    } else {
                        $html = $row[$key] . ' ' . $img;
                        $td->appendElement('plaintext', array(), $html, true);
                    }
                } else {
                    $td->appendElement('plaintext', array(), Labels::getLabel('LBL_N/A', $adminLangId), true);
                }
                break;
            case 'credential_active':
                $active = "active";
                if (!$row['credential_active']) {
                    $active = '';
                }
                $statucAct = ($canEdit === true) ? 'toggleStatus(this)' : '';
                $str = '<label id="' . $row['user_id'] . '" class="statustab ' . $active . '" onclick="' . $statucAct . '">
                  <span data-off="' . Labels::getLabel('LBL_Active', $adminLangId) . '" data-on="' . Labels::getLabel('LBL_Inactive', $adminLangId) . '" class="switch-labels"></span>
                  <span class="switch-handles"></span>
                </label>';
                $td->appendElement('plaintext', array(), $str, true);
                break;
            case 'user_regdate':
                $td->appendElement('plaintext', array(), FatDate::format(
                                $row[$key], true, true, FatApp::getConfig('CONF_TIMEZONE', FatUtility::VAR_STRING, date_default_timezone_get())
                ));
                break;
            case 'type':
                $str = '';
                $arr = User::getUserTypesArr($adminLangId);
                if ($row['user_is_buyer']) {
                    $str .= $arr[User::USER_TYPE_BUYER] . '<br/>';
                }
                if ($row['user_is_supplier']) {
                    $str .= $arr[User::USER_TYPE_SELLER] . '<br/>';
                }
                if ($row['user_is_advertiser']) {
                    $str .= $arr[User::USER_TYPE_ADVERTISER] . '<br/>';
                }
                if ($row['user_is_affiliate']) {
                    $str .= $arr[User::USER_TYPE_AFFILIATE] . '<br/>';
                }

                if ($str == '' && $row['user_registered_initially_for'] != 0) {
                    $str = '<span class="label label-danger">Signing Up For: ' . User::getUserTypesArr($adminLangId)[$row['user_registered_initially_for']] . '</span>';
                }

                if (0 < $row['user_parent']) {
                    $str = Labels::getLabel('LBL_Sub_User', $adminLangId);
                }

                $td->appendElement('plaintext', array(), $str, true);

                break;
            case 'credential_verified':
                $yesNoArr = AppConstants::getYesNoArr($adminLangId);
                $str = isset($row[$key]) ? $yesNoArr[$row[$key]] : '';
                $td->appendElement('plaintext', array(), $str, true);
                break;
            case 'action':
                $ul = $td->appendElement("ul", array("class" => "actions actions--centered"));
                if ($canEdit) {
                    $li = $ul->appendElement("li", array('class' => 'droplink'));
                    $li->appendElement('a', array('href' => 'javascript:void(0)', 'class' => 'button small green', 'title' => Labels::getLabel('LBL_Edit', $adminLangId)), '<i class="ion-android-more-horizontal icon"></i>', true);
                    $innerDiv = $li->appendElement('div', array('class' => 'dropwrap'));
                    $innerUl = $innerDiv->appendElement('ul', array('class' => 'linksvertical'));

                    $innerLi = $innerUl->appendElement('li');
                    $innerLi->appendElement('a', array('href' => 'javascript:void(0)', 'class' => 'button small green', 'title' => Labels::getLabel('LBL_Edit', $adminLangId), "onclick" => "addUserForm(" . $row['user_id'] . ")"), Labels::getLabel('LBL_Edit', $adminLangId), true);

                    if (0 == $row['user_parent']) {
                        $innerLi = $innerUl->appendElement('li');
                        $innerLi->appendElement('a', array('href' => 'javascript:void(0)', 'class' => 'button small green', 'title' => Labels::getLabel('LBL_Rewards', $adminLangId), "onclick" => "rewards(" . $row['user_id'] . ")"), Labels::getLabel('LBL_Rewards', $adminLangId), true);

                        $innerLi = $innerUl->appendElement("li");
                        $innerLi->appendElement('a', array('href' => 'javascript:void(0)', 'class' => 'button small green',
                            'title' => Labels::getLabel('LBL_Transactions', $adminLangId), "onclick" => "transactions(" . $row['user_id'] . ")"), Labels::getLabel('LBL_Transactions', $adminLangId), true);
                    }
                    $innerLi = $innerUl->appendElement('li');
                    $innerLi->appendElement('a', array('href' => 'javascript:void(0)', 'class' => 'button small green', 'title' => Labels::getLabel('LBL_Change_Password', $adminLangId), "onclick" => "changePasswordForm(" . $row['user_id'] . ")"), Labels::getLabel('LBL_Change_Password', $adminLangId), true);

                    $innerLi = $innerUl->appendElement('li');
                    $innerLi->appendElement('a', array('href' => CommonHelper::generateUrl('Users', 'login', array($row['user_id'])), 'target' => '_blank', 'class' => 'button small green redirect--js', 'title' => Labels::getLabel('LBL_Login_to_user_profile', $adminLangId)), Labels::getLabel('LBL_Login_to_user_profile', $adminLangId), true);

                    $innerLi = $innerUl->appendElement('li');
                    $innerLi->appendElement('a', array('href' => 'javascript:void(0)', 'class' => 'button small green', 'title' => Labels::getLabel('LBL_Email_User', $adminLangId), "onclick" => "sendMailForm(" . $row['user_id'] . ")"), Labels::getLabel('LBL_Email_User', $adminLangId), true);

                    $innerLi = $innerUl->appendElement('li');
                    $innerLi->appendElement('a', array('href' => 'javascript:void(0)', 'class' => 'button small green', 'title' => Labels::getLabel('LBL_Delete_User', $adminLangId), "onclick" => "deleteUser(" . $row['user_id'] . ")"), Labels::getLabel('LBL_Delete_User', $adminLangId), true);
                }
                break;
            case 'user_is_founding_member':
                if ($row['user_is_supplier'] == AppConstants::YES || $row['user_is_buyer'] == AppConstants::YES) {
                    $isFoundingMember = "active";
                    $userStatus = AppConstants::NO;
                    //echo $row['user_is_founding_member'];
                    if ($row['user_is_founding_member'] == 0) {
                        $isFoundingMember = '';
                        $userStatus = AppConstants::YES;
                    }

                    $statucAct = ($canEdit === true) ? 'toggleTagStatus(this, ' . $userStatus . ', \'is_founding_member\')' : '';
                    $str = '<label id="' . $row['user_id'] . '" class="statustab ' . $isFoundingMember . '" onclick="' . $statucAct . '">
                  <span data-off="' . Labels::getLabel('LBL_Active', $adminLangId) . '" data-on="' . Labels::getLabel('LBL_Inactive', $adminLangId) . '" class="switch-labels"></span>
                  <span class="switch-handles"></span>
                </label>';
                } else {
                    $str = Labels::getLabel('LBL_N/A', $adminLangId);
                }

                $td->appendElement('plaintext', array(), $str, true);
                break;

            case 'user_is_verified':
                
                if ($row['user_is_supplier'] == AppConstants::YES && (isset($row['subscription_package_id']) && $row['subscription_package_id'] == SellerPackages::GOLD_PACKAGE)) {
                    $isVerified = "active";
                    $userStatus = AppConstants::NO;
                    //echo $row['user_is_founding_member'];
                    if ($row['user_is_verified'] == 0) {
                        $isVerified = '';
                        $userStatus = AppConstants::YES;
                    }

                    $statucAct = ($canEdit === true) ? 'toggleTagStatus(this, ' . $userStatus . ', \'is_verified\')' : '';
                    $str = '<label id="' . $row['user_id'] . '" class="statustab ' . $isVerified . '" onclick="' . $statucAct . '">
                  <span data-off="' . Labels::getLabel('LBL_Active', $adminLangId) . '" data-on="' . Labels::getLabel('LBL_Inactive', $adminLangId) . '" class="switch-labels"></span>
                  <span class="switch-handles"></span>
                </label>';
                } else {
                    $str = Labels::getLabel('LBL_N/A', $adminLangId);
                }

                $td->appendElement('plaintext', array(), $str, true);
                break;


            default:
                $td->appendElement('plaintext', array(), $row[$key], true);
                break;
        }
    }
}
if (count($arr_listing) == 0) {
    $tbl->appendElement('tr')->appendElement('td', array('colspan' => count($arr_flds)), Labels::getLabel('LBL_No_Records_Found', $adminLangId));
}
$frm = new Form('frmUsersListing', array('id' => 'frmUsersListing'));
$frm->setFormTagAttribute('class', 'web_form last_td_nowrap actionButtons-js');
$frm->setFormTagAttribute('onsubmit', 'formAction(this, reloadUserList ); return(false);');
$frm->setFormTagAttribute('action', CommonHelper::generateUrl('Users', 'toggleBulkStatuses'));
$frm->addHiddenField('', 'status');

echo $frm->getFormTag();
echo $frm->getFieldHtml('status');
echo $tbl->getHtml();
?>
</form>
<?php
$postedData['page'] = $page;
echo FatUtility::createHiddenFormFromData($postedData, array(
    'name' => 'frmUserSearchPaging'
));
$pagingArr = array('pageCount' => $pageCount, 'page' => $page, 'pageSize' => $pageSize, 'recordCount' => $recordCount, 'adminLangId' => $adminLangId);
$this->includeTemplate('_partial/pagination.php', $pagingArr, false);
