$(document).ready(function() {
    searchTags(document.frmSearchTags);
});

(function() {
    var currentPage = 1;
    var runningAjaxReq = false;

    goToSearchPage = function(page) {
        if (typeof page == undefined || page == null) {
            page = 1;
        }
        var frm = document.frmSearchPaging;
        $(frm.page).val(page);
        searchTags(frm);
    }

    reloadList = function() {
        var frm = document.frmSearchPaging;
        searchTags(frm);
    }
	
    addTagForm = function(id) {
        $.facebox(function() {
            TagForm(id);
        });
    };
	TagForm = function(id) {
        fcom.displayProcessing();
        fcom.resetEditorInstance();
        var frm = document.frmSearchPaging;

        fcom.ajax(fcom.makeUrl('Tags', 'form', [id]), '', function(t) {
            fcom.updateFaceboxContent(t);
        });
    };

    setupTag = function(frm) {
        if (!$(frm).validate()) return;
        var data = fcom.frmData(frm);
        fcom.updateWithAjax(fcom.makeUrl('Tags', 'setup'), data, function(t) {
            reloadList();
            $(document).trigger('close.facebox');
        });
    };

    searchTags = function(form) {
        var data = '';
        if (form) {
            data = fcom.frmData(form);
        }
        $("#listing").html('Loading....');
        fcom.ajax(fcom.makeUrl('Tags', 'search'), data, function(res) {
            $("#listing").html(res);
        });
    };

    deleteTag = function(id) {
        if (!confirm(langLbl.confirmDelete)) {
            return;
        }
        data = 'tagId=' + id;
        fcom.updateWithAjax(fcom.makeUrl('Tags', 'deleteItem'), data, function(res) {
            reloadList();
        });
    };

    clearSearch = function() {
        document.frmSearchTags.reset();
        searchTags(document.frmSearchTags);
    };
	
	toggleStatus = function( e,obj,canEdit ){
		if(canEdit == 0){
			e.preventDefault();
			return;
		}
		if(!confirm(langLbl.confirmUpdateStatus)){
			e.preventDefault();
			return;
		}
		var tagId = parseInt(obj.value);
		if( tagId < 1 ){
			$.mbsmessage(langLbl.invalidRequest,true,'alert--danger');
			return false;
		}
		data = 'tagId='+tagId;
		fcom.ajax(fcom.makeUrl('Tags','changeStatus'),data,function(res){
			var ans =$.parseJSON(res);
			if(ans.status == 1){
				$.mbsmessage(ans.msg,true,'alert--success');
				$(obj).toggleClass("active");
			}else{
				$.mbsmessage(ans.msg,true,'alert--danger');
			}
		});
	};

    changeStatus = function(tagId, status){
        var data = 'tagId=' + tagId + '&status=' + status;
        fcom.updateWithAjax(fcom.makeUrl('Tags', 'changeStatus'), data, function (t) {
            window.location.reload();
        });
    };
})();